/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class LWSTorrent
extends LogRelation
implements TOTorrent {
    private static TOTorrentAnnounceURLGroup announce_group = new TOTorrentAnnounceURLGroup(){
        private TOTorrentAnnounceURLSet[] sets = new TOTorrentAnnounceURLSet[0];

        @Override
        public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
            return this.sets;
        }

        @Override
        public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] _sets) {
            this.sets = _sets;
        }

        @Override
        public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] _urls) {
            return new TOTorrentAnnounceURLSet(_urls){
                private URL[] urls;
                {
                    this.urls = uRLArray;
                }

                @Override
                public URL[] getAnnounceURLs() {
                    return this.urls;
                }

                @Override
                public void setAnnounceURLs(URL[] _urls) {
                    this.urls = _urls;
                }
            };
        }
    };
    private LightWeightSeed lws;

    private static void notSupported() {
        Debug.out("Not Supported");
    }

    protected LWSTorrent(LightWeightSeed _lws) {
        this.lws = _lws;
    }

    protected TOTorrent getDelegate() {
        return this.lws.getTOTorrent(true);
    }

    @Override
    public byte[] getName() {
        return this.lws.getName().getBytes();
    }

    @Override
    public String getUTF8Name() {
        return this.lws.getName();
    }

    @Override
    public boolean isSimpleTorrent() {
        return this.getDelegate().isSimpleTorrent();
    }

    @Override
    public byte[] getComment() {
        return this.getDelegate().getComment();
    }

    @Override
    public void setComment(String comment) {
        this.getDelegate().setComment(comment);
    }

    @Override
    public long getCreationDate() {
        return this.getDelegate().getCreationDate();
    }

    @Override
    public boolean isDecentralised() {
        return this.getDelegate().isDecentralised();
    }

    @Override
    public void setCreationDate(long date) {
        this.getDelegate().setCreationDate(date);
    }

    @Override
    public byte[] getCreatedBy() {
        return this.getDelegate().getCreatedBy();
    }

    @Override
    public void setCreatedBy(byte[] cb) {
        this.getDelegate().setCreatedBy(cb);
    }

    @Override
    public boolean isCreated() {
        return true;
    }

    @Override
    public URL getAnnounceURL() {
        return this.lws.getAnnounceURL();
    }

    @Override
    public boolean setAnnounceURL(URL url) {
        LWSTorrent.notSupported();
        return false;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return announce_group;
    }

    @Override
    public byte[][] getPieces() throws TOTorrentException {
        return this.getDelegate().getPieces();
    }

    @Override
    public void setPieces(byte[][] pieces) throws TOTorrentException {
        this.getDelegate().setPieces(pieces);
    }

    @Override
    public long getPieceLength() {
        return this.getDelegate().getPieceLength();
    }

    @Override
    public int getNumberOfPieces() {
        return this.getDelegate().getNumberOfPieces();
    }

    @Override
    public long getSize() {
        return this.lws.getSize();
    }

    @Override
    public int getFileCount() {
        return this.getDelegate().getFileCount();
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return this.getDelegate().getFiles();
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.lws.getHash().getBytes();
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.lws.getHash();
    }

    @Override
    public void setHashOverride(byte[] hash) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    @Override
    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.getHash(), other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public void setPrivate(boolean _private) throws TOTorrentException {
        LWSTorrent.notSupported();
    }

    @Override
    public void setAdditionalStringProperty(String name, String value) {
        this.getDelegate().setAdditionalStringProperty(name, value);
    }

    @Override
    public String getAdditionalStringProperty(String name) {
        return this.getDelegate().getAdditionalStringProperty(name);
    }

    @Override
    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.getDelegate().setAdditionalByteArrayProperty(name, value);
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String name) {
        return this.getDelegate().getAdditionalByteArrayProperty(name);
    }

    @Override
    public void setAdditionalLongProperty(String name, Long value) {
        this.getDelegate().setAdditionalLongProperty(name, value);
    }

    @Override
    public Long getAdditionalLongProperty(String name) {
        return this.getDelegate().getAdditionalLongProperty(name);
    }

    @Override
    public void setAdditionalListProperty(String name, List value) {
        this.getDelegate().setAdditionalListProperty(name, value);
    }

    @Override
    public List getAdditionalListProperty(String name) {
        return this.getDelegate().getAdditionalListProperty(name);
    }

    @Override
    public void setAdditionalMapProperty(String name, Map value) {
        this.getDelegate().setAdditionalMapProperty(name, value);
    }

    @Override
    public Map getAdditionalMapProperty(String name) {
        return this.getDelegate().getAdditionalMapProperty(name);
    }

    @Override
    public Object getAdditionalProperty(String name) {
        if (name.equals("url-list") || name.equals("httpseeds")) {
            return null;
        }
        return this.getDelegate().getAdditionalProperty(name);
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.getDelegate().setAdditionalProperty(name, value);
    }

    @Override
    public void removeAdditionalProperty(String name) {
        this.getDelegate().removeAdditionalProperty(name);
    }

    @Override
    public void removeAdditionalProperties() {
        this.getDelegate().removeAdditionalProperties();
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToBEncodedFile(file);
    }

    @Override
    public void addListener(TOTorrentListener l) {
        this.getDelegate().addListener(l);
    }

    @Override
    public void removeListener(TOTorrentListener l) {
        this.getDelegate().removeListener(l);
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        return this.getDelegate().serialiseToMap();
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToXMLFile(file);
    }

    @Override
    public AEMonitor getMonitor() {
        return this.getDelegate().getMonitor();
    }

    @Override
    public void print() {
        this.getDelegate().print();
    }

    @Override
    public String getRelationText() {
        return "LWTorrent: '" + new String(this.getName()) + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.lws};
    }
}

