/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandler;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class DHTUDPPacketHandlerFactory {
    private static DHTUDPPacketHandlerFactory singleton = new DHTUDPPacketHandlerFactory();
    private Map port_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("DHTUDPPacketHandlerFactory");

    public static DHTUDPPacketHandler getHandler(DHTTransportUDPImpl transport, DHTUDPRequestHandler request_handler) throws DHTUDPPacketHandlerException {
        return singleton.getHandlerSupport(transport, request_handler);
    }

    protected DHTUDPPacketHandler getHandlerSupport(DHTTransportUDPImpl transport, DHTUDPRequestHandler request_handler) throws DHTUDPPacketHandlerException {
        try {
            Map network_map;
            Object[] network_details;
            this.this_mon.enter();
            int port = transport.getPort();
            int network = transport.getNetwork();
            Object[] port_details = (Object[])this.port_map.get(new Integer(port));
            if (port_details == null) {
                PRUDPPacketHandler packet_handler = PRUDPPacketHandlerFactory.getHandler(port, new DHTUDPPacketNetworkHandler(this, port));
                port_details = new Object[]{packet_handler, new HashMap()};
                this.port_map.put(new Integer(port), port_details);
            }
            if ((network_details = (Object[])(network_map = (Map)port_details[1]).get(new Integer(network))) != null) {
                throw new DHTUDPPacketHandlerException("Network already added");
            }
            DHTUDPPacketHandler ph = new DHTUDPPacketHandler(this, network, (PRUDPPacketHandler)port_details[0], request_handler);
            network_map.put(new Integer(network), new Object[]{transport, ph});
            DHTUDPPacketHandler dHTUDPPacketHandler = ph;
            return dHTUDPPacketHandler;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void destroy(DHTUDPPacketHandler handler) {
        PRUDPPacketHandler packet_handler = handler.getPacketHandler();
        int port = packet_handler.getPort();
        int network = handler.getNetwork();
        try {
            this.this_mon.enter();
            Object[] port_details = (Object[])this.port_map.get(new Integer(port));
            if (port_details == null) {
                return;
            }
            Map network_map = (Map)port_details[1];
            network_map.remove(new Integer(network));
            if (network_map.size() == 0) {
                this.port_map.remove(new Integer(port));
                try {
                    packet_handler.setRequestHandler(null);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void process(int port, DHTUDPPacketRequest request2) {
        try {
            int network = request2.getNetwork();
            Object[] port_details = (Object[])this.port_map.get(new Integer(port));
            if (port_details == null) {
                throw new IOException("Port '" + port + "' not registered");
            }
            Map network_map = (Map)port_details[1];
            Object[] network_details = (Object[])network_map.get(new Integer(network));
            if (network_details == null) {
                throw new IOException("Network '" + network + "' not registered");
            }
            DHTUDPPacketHandler res = (DHTUDPPacketHandler)network_details[1];
            res.receive(request2);
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
    }

    public DHTTransportUDPImpl getTransport(int port, int network) throws IOException {
        Object[] port_details = (Object[])this.port_map.get(new Integer(port));
        if (port_details == null) {
            throw new IOException("Port '" + port + "' not registered");
        }
        Map network_map = (Map)port_details[1];
        Object[] network_details = (Object[])network_map.get(new Integer(network));
        if (network_details == null) {
            throw new IOException("Network '" + network + "' not registered");
        }
        return (DHTTransportUDPImpl)network_details[0];
    }
}

