/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;

public class DHTUDPPacketReplyPing
extends DHTUDPPacketReply {
    private static final DHTTransportAlternativeContact[] EMPTY_CONTACTS = new DHTTransportAlternativeContact[0];
    private DHTTransportAlternativeContact[] alt_contacts = EMPTY_CONTACTS;

    public DHTUDPPacketReplyPing(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1025, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyPing(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1025, trans_id);
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.deserialiseVivaldi(this, is);
        }
        if (this.getProtocolVersion() >= 52) {
            this.alt_contacts = DHTUDPUtils.deserialiseAltContacts(is);
        }
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.serialiseVivaldi(this, os);
        }
        if (this.getProtocolVersion() >= 52) {
            DHTUDPUtils.serialiseAltContacts(os, this.alt_contacts);
        }
    }

    protected void setAltContacts(List<DHTTransportAlternativeContact> _contacts) {
        int MAX_CONTACTS = 16;
        if (_contacts.size() < 16) {
            this.alt_contacts = _contacts.toArray(new DHTTransportAlternativeContact[_contacts.size()]);
        } else {
            this.alt_contacts = new DHTTransportAlternativeContact[16];
            int i = 0;
            while (i < this.alt_contacts.length) {
                this.alt_contacts[i] = _contacts.get(i);
                ++i;
            }
        }
    }

    protected DHTTransportAlternativeContact[] getAltContacts() {
        return this.alt_contacts;
    }
}

