/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.secure.impl;

import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClient;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientAdapter;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientListener;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientMessage;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientHelper;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientMessageImpl;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class SecureMessageServiceClientImpl
implements SecureMessageServiceClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_LOGON_FAIL = 1;
    public static final int STATUS_INVALID_SEQUENCE = 2;
    public static final int STATUS_FAILED = 3;
    public static final int STATUS_ABORT = 4;
    public static final String SERVICE_NAME = "SecureMsgServ";
    private static final long MIN_RETRY_PERIOD = 300000L;
    private static final long MAX_RETRY_PERIOD = 0x6DDD00L;
    private String host;
    private int port;
    private int timeout_secs;
    private RSAPublicKey public_key;
    private SecureMessageServiceClientAdapter adapter;
    private long retry_millis = 300000L;
    private int connect_failure_count = 0;
    private AEMonitor message_mon;
    private AESemaphore message_sem;
    private String last_failed_user_pw = "";
    private long last_failed_user_pw_time;
    private List messages = new ArrayList();
    private List listeners = new ArrayList();

    public SecureMessageServiceClientImpl(String _host, int _port, int _timeout_secs, RSAPublicKey _key, SecureMessageServiceClientAdapter _adapter) {
        this.host = _host;
        this.port = _port;
        this.timeout_secs = _timeout_secs;
        this.public_key = _key;
        this.adapter = _adapter;
        this.message_mon = new AEMonitor("SecureService:messages");
        this.message_sem = new AESemaphore("SecureService:messages");
        new AEThread("SecureService::messageSender", true){

            @Override
            public void runSupport() {
                while (true) {
                    long time = SecureMessageServiceClientImpl.this.retry_millis;
                    if (SecureMessageServiceClientImpl.this.connect_failure_count > 0) {
                        int i = 0;
                        while (i < SecureMessageServiceClientImpl.this.connect_failure_count) {
                            if ((time += time) > 0x6DDD00L) {
                                time = 0x6DDD00L;
                                break;
                            }
                            ++i;
                        }
                    }
                    SecureMessageServiceClientImpl.this.message_sem.reserve(time);
                    try {
                        SecureMessageServiceClientImpl.this.sendMessagesSupport();
                        continue;
                    }
                    catch (Throwable e) {
                        SecureMessageServiceClientImpl.this.adapter.log("Request processing failed", e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void sendMessages() {
        this.message_sem.release();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessagesSupport() {
        user = this.adapter.getUser();
        password = this.adapter.getPassword();
        user_password = String.valueOf(user) + "/" + new String(password);
        if (user.length() == 0) {
            this.adapter.authenticationFailed();
            return;
        }
        if (user_password.equals(this.last_failed_user_pw) && (now = SystemTime.getCurrentTime()) > this.last_failed_user_pw_time && now - this.last_failed_user_pw_time < 60000L) {
            this.adapter.authenticationFailed();
            return;
        }
        try {
            this.message_mon.enter();
            outstanding_messages = new ArrayList<E>(this.messages);
        }
        finally {
            this.message_mon.exit();
        }
        if (outstanding_messages.size() == 0) {
            return;
        }
        complete_messages = new ArrayList<SecureMessageServiceClientMessageImpl>();
        failed = false;
        try {
            try {
                it = outstanding_messages.iterator();
                if (true) ** GOTO lbl154
                do {
                    message = (SecureMessageServiceClientMessageImpl)it.next();
                    retry = true;
                    retry_count = 0;
                    while (retry && !failed) {
                        retry = false;
                        message_service = null;
                        got_reply = false;
                        try {
                            try {
                                content = new HashMap<String, Object>();
                                sequence = this.adapter.getMessageSequence();
                                content.put("user", user);
                                content.put("password", password);
                                content.put("seq", new Long(sequence));
                                content.put("request", message.getRequest());
                                this.last_failed_user_pw = "";
                                message_service = SecureMessageServiceClientHelper.getServerService(this.host, this.port, this.timeout_secs, "SecureMsgServ", this.public_key);
                                message_service.sendMessage(content);
                                reply = message_service.receiveMessage();
                                got_reply = true;
                                status = (Long)reply.get("status");
                                new_retry = (Long)reply.get("retry");
                                if (new_retry != null) {
                                    this.retry_millis = new_retry;
                                    if (this.retry_millis < 300000L) {
                                        this.retry_millis = 300000L;
                                    }
                                    this.adapter.log("Server requested retry period of " + this.retry_millis / 1000L + " seconds");
                                } else {
                                    this.retry_millis = 300000L;
                                }
                                if (status == 0L) {
                                    message.setReply((Map)reply.get("reply"));
                                    this.adapter.log("Request successfully sent: " + message.getRequest() + "->" + message.getReply());
                                    this.adapter.setMessageSequence(sequence + 1L);
                                    this.adapter.serverOK();
                                    l_it = this.listeners.iterator();
                                    while (l_it.hasNext()) {
                                        try {
                                            ((SecureMessageServiceClientListener)l_it.next()).complete(message);
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    complete_messages.add(message);
                                } else if (status == 1L) {
                                    this.last_failed_user_pw = user_password;
                                    this.last_failed_user_pw_time = SystemTime.getCurrentTime();
                                    this.adapter.serverOK();
                                    this.adapter.authenticationFailed();
                                    failed = true;
                                } else if (status == 2L) {
                                    if (retry_count == 1) {
                                        this.adapter.serverFailed(new Exception("Sequence resynchronisation failed"));
                                        failed = true;
                                    } else {
                                        ++retry_count;
                                        retry = true;
                                        expected_sequence = (Long)reply.get("seq");
                                        this.adapter.log("Sequence resynchronise: local = " + sequence + ", remote = " + expected_sequence);
                                        this.adapter.setMessageSequence(expected_sequence);
                                    }
                                } else if (status == 3L) {
                                    this.adapter.serverFailed(new Exception(new String((byte[])reply.get("error"))));
                                    failed = true;
                                } else {
                                    this.adapter.serverFailed(new Exception("Server requested abort"));
                                    l_it = this.listeners.iterator();
                                    while (l_it.hasNext()) {
                                        try {
                                            ((SecureMessageServiceClientListener)l_it.next()).aborted(message, new String((byte[])reply.get("error")));
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    complete_messages.add(message);
                                }
                            }
                            catch (Throwable e) {
                                this.adapter.serverFailed(e);
                                failed = true;
                                if (got_reply) {
                                    this.connect_failure_count = 0;
                                } else {
                                    ++this.connect_failure_count;
                                    if (this.connect_failure_count > 1) {
                                        try {
                                            this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                if (message_service == null) continue;
                                message_service.close();
                                continue;
                            }
                        }
                        catch (Throwable var22_31) {
                            if (got_reply) {
                                this.connect_failure_count = 0;
                            } else {
                                ++this.connect_failure_count;
                                if (this.connect_failure_count > 1) {
                                    try {
                                        this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (message_service == null) throw var22_31;
                            message_service.close();
                            throw var22_31;
                        }
                        if (got_reply) {
                            this.connect_failure_count = 0;
                        } else {
                            ++this.connect_failure_count;
                            if (this.connect_failure_count > 1) {
                                try {
                                    this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (message_service == null) continue;
                        message_service.close();
                    }
lbl154:
                    // 2 sources

                    if (!it.hasNext()) return;
                } while (!failed);
                return;
            }
            catch (Throwable e) {
                this.adapter.serverFailed(e);
                try {
                    this.message_mon.enter();
                    this.messages.removeAll(complete_messages);
                    return;
                }
                finally {
                    this.message_mon.exit();
                }
            }
        }
        finally {
            try {
                this.message_mon.enter();
                this.messages.removeAll(complete_messages);
            }
            finally {
                this.message_mon.exit();
            }
        }
    }

    @Override
    public SecureMessageServiceClientMessage sendMessage(Map request2, Object data, String description) {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessageImpl res = new SecureMessageServiceClientMessageImpl(this, request2, data, description);
            this.messages.add(res);
            this.message_sem.release();
            SecureMessageServiceClientMessageImpl secureMessageServiceClientMessageImpl = res;
            return secureMessageServiceClientMessageImpl;
        }
        finally {
            this.message_mon.exit();
        }
    }

    protected void cancel(SecureMessageServiceClientMessage message) {
        boolean inform = false;
        try {
            this.message_mon.enter();
            if (this.messages.remove(message)) {
                inform = true;
            }
        }
        finally {
            this.message_mon.exit();
        }
        if (inform) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((SecureMessageServiceClientListener)it.next()).cancelled(message);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public SecureMessageServiceClientMessage[] getMessages() {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessage[] secureMessageServiceClientMessageArray = this.messages.toArray(new SecureMessageServiceClientMessage[this.messages.size()]);
            return secureMessageServiceClientMessageArray;
        }
        finally {
            this.message_mon.exit();
        }
    }

    @Override
    public void addListener(SecureMessageServiceClientListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(SecureMessageServiceClientListener l) {
        this.listeners.remove(l);
    }
}

