/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

// @generated by enums.py
// clang-format off
#pragma once

#include <cstdint>
#include <yoga/YGEnums.h>
#include <yoga/enums/YogaEnums.h>

namespace facebook::yoga {

enum class PrintOptions : uint32_t {
  Layout = YGPrintOptionsLayout,
  Style = YGPrintOptionsStyle,
  Children = YGPrintOptionsChildren,
};

YG_DEFINE_ENUM_FLAG_OPERATORS(PrintOptions)

template <>
constexpr inline int32_t ordinalCount<PrintOptions>() {
  return 3;
} 

template <>
constexpr inline int32_t bitCount<PrintOptions>() {
  return 2;
} 

constexpr inline PrintOptions scopedEnum(YGPrintOptions unscoped) {
  return static_cast<PrintOptions>(unscoped);
}

constexpr inline YGPrintOptions unscopedEnum(PrintOptions scoped) {
  return static_cast<YGPrintOptions>(scoped);
}

inline const char* toString(PrintOptions e) {
  return YGPrintOptionsToString(unscopedEnum(e));
}

} // namespace facebook::yoga
