'use strict';

import { isChromeDebugger, isFabric, isJest, shouldBeUseWeb } from '../PlatformChecker';
/**
 * Lets you synchronously call a command of a native component.
 *
 * @param animatedRef - An [animated ref](https://docs.swmansion.com/react-native-reanimated/docs/core/useAnimatedRef#returns) connected to the component you'd want to call the command on.
 * @param commandName - The name of the command to dispatch (e.g. `"focus"` or `"scrollToEnd"`).
 * @param args - An optional array of arguments for the command.
 * @see https://docs.swmansion.com/react-native-reanimated/docs/advanced/dispatchCommand
 */
export let dispatchCommand;
function dispatchCommandFabric(animatedRef, commandName) {
  'worklet';

  let args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  if (!_WORKLET) {
    return;
  }
  const shadowNodeWrapper = animatedRef();
  global._dispatchCommandFabric(shadowNodeWrapper, commandName, args);
}
function dispatchCommandPaper(animatedRef, commandName) {
  'worklet';

  let args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  if (!_WORKLET) {
    return;
  }
  const viewTag = animatedRef();
  global._dispatchCommandPaper(viewTag, commandName, args);
}
function dispatchCommandJest() {
  console.warn('[Reanimated] dispatchCommand() is not supported with Jest.');
}
function dispatchCommandChromeDebugger() {
  console.warn('[Reanimated] dispatchCommand() is not supported with Chrome Debugger.');
}
function dispatchCommandDefault() {
  console.warn('[Reanimated] dispatchCommand() is not supported on this configuration.');
}
if (!shouldBeUseWeb()) {
  // Those assertions are actually correct since on Native platforms `AnimatedRef` is
  // mapped as a different function in `shareableMappingCache` and
  // TypeScript is not able to infer that.
  if (isFabric()) {
    dispatchCommand = dispatchCommandFabric;
  } else {
    dispatchCommand = dispatchCommandPaper;
  }
} else if (isJest()) {
  dispatchCommand = dispatchCommandJest;
} else if (isChromeDebugger()) {
  dispatchCommand = dispatchCommandChromeDebugger;
} else {
  dispatchCommand = dispatchCommandDefault;
}
//# sourceMappingURL=dispatchCommand.js.map