<p align="center">
  <a href="https://reactnativeelements.com/">
    <img alt="react-native-elements" src="https://user-images.githubusercontent.com/5962998/65694309-a825f000-e043-11e9-8382-db0dba0851e3.png" width="200">
  </a>
</p>

<p align="center">
  Cross Platform <a href="https://reactnative.dev">React Native</a> UI Toolkit
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/@rneui/themed"><img src="https://img.shields.io/npm/v/@rneui/themed.svg?style=flat-square"></a>
   <a href="https://www.npmjs.com/package/@rneui/themed"><img src="https://img.shields.io/npm/dm/@rneui/themed.svg?style=flat-square"></a>
  <a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/license-MIT-blue.svg?style=flat-square&color=0089E3"></a>
  <a href="https://github.com/react-native-elements/react-native-elements"><img src="https://img.shields.io/github/stars/react-native-elements/react-native-elements?label=stars&logo&style=flat-square&color=0089E3"></a>
</p>

<div align="center">
   <a href="https://twitter.com/rn_elements"><img src="https://img.shields.io/twitter/follow/rn_elements?style=flat-square&label=Twitter&logo=TWITTER&color=0089E3"></a>
  <a href="https://github.com/react-native-elements/react-native-elements/discussions"><img src="https://img.shields.io/github/discussions/react-native-elements/react-native-elements?label=Discussions&logo=github&style=flat-square"></a>
  <a href="https://discord.com/invite/e9RBHjkKHa"><img src="https://img.shields.io/badge/Join-Discord-5865F2?style=flat-square&logo=discord&logoColor=FFFFFF"></a>

</div>

<p align="center">
  <a href="#backers"><img src="https://opencollective.com/react-native-elements/backers/badge.svg?style=flat-square&color=0089E3"></a>
  <a href="#sponsors"><img src="https://opencollective.com/react-native-elements/sponsors/badge.svg?style=flat-square&color=0089E3&logo=opencollective"></a>
  <a href="https://github.com/sponsors/react-native-elements"><img src="https://img.shields.io/github/sponsors/react-native-elements?label=Sponsor&logo=githubsponsors&style=flat-square"></a>
</p>

<br />

![React Native Elements UI Toolkit](https://user-images.githubusercontent.com/5962998/37248832-a7060286-24b1-11e8-94a8-847ab6ded4ec.png)

## Installation

```bash
npm install @rneui/themed
```

Follow
[these instructions](https://reactnativeelements.com/docs/)
to install React Native Elements!

## Usage

Start using the components or try it on Snack
[here](https://snack.expo.io/rJu6gJfBZ).

```js
import { Button } from '@rneui/themed';

<Button />;
```

## React Native Web support

As a cross platform UI Toolkit, you can now use RNE on the web & share your codebase between your React Native + React web apps. RNE components are rendered perfectly on browser. You can achieve this to target iOS, Android and Web by collaborating RNE and [React Native for Web](https://github.com/necolas/react-native-web).

Click [here](https://reactnativeelements.com/blog/2018/12/13/react-native-web) for a full walkthrough using React Native Elements + React Native Web.

## Expo demo app

Checkout the official
[React Native Elements App](https://expo.dev/@rn_elements/react-native-elements)
on Expo which uses all of the React Native Elements components.

If you are looking to contribute to the React Native Elements App, click
[here](https://github.com/react-native-elements/react-native-elements/tree/next/example) to
view the implementation & run the RNE expo app locally.

## VS Code Extension

Install the [React Native Elements VS Code Extension](https://marketplace.visualstudio.com/items?itemName=rne.snippets) to speed up development.

## Documentation

[View the full docs here](https://reactnativeelements.com/docs/overview)

## Contributing

Interested in contributing to this repo? Check out our
[Contributing Guide](https://reactnativeelements.com/docs/contributing)
and submit a PR for a new feature/bug fix.

A big shoutout to all our contributors! You could be here too!

<a href="https://github.com/react-native-elements/react-native-elements/graphs/contributors"><img src="https://opencollective.com/react-native-elements/contributors.svg?width=890&button=false" /></a>

### First Contributors

We encourage everyone to contribute & submit PR's especially first-time
contributors. Look for the label `Good First Issue` on the issues. Click
[here](https://github.com/react-native-elements/react-native-elements/labels/%F0%9F%91%B6%20Good%20First%20Issue)
to see them.

If there is something you's like to see or request a new feature, please submit
an
[issue](https://github.com/react-native-elements/react-native-elements/issues/new)
or a
[pull request](https://github.com/react-native-elements/react-native-elements/pulls).

### Core Contributors

We are currently looking for new core contributors that can help lead this project.

[Learn more here](https://github.com/react-native-elements/react-native-elements/issues/2222)

### Discord Community

In case you have any other question or would like to come say **Hi!** to the RNE
community, join our [Discord Server](https://discord.com/invite/e9RBHjkKHa).
See you on the other side! 👋😃

## Backers

[Become a backer](https://opencollective.com/react-native-elements#backer) and show your support for React Native Elements.

[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/0/avatar)](https://opencollective.com/react-native-elements/backer/0/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/1/avatar)](https://opencollective.com/react-native-elements/backer/1/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/2/avatar)](https://opencollective.com/react-native-elements/backer/2/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/3/avatar)](https://opencollective.com/react-native-elements/backer/3/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/4/avatar)](https://opencollective.com/react-native-elements/backer/4/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/5/avatar)](https://opencollective.com/react-native-elements/backer/5/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/6/avatar)](https://opencollective.com/react-native-elements/backer/6/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/7/avatar)](https://opencollective.com/react-native-elements/backer/7/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/8/avatar)](https://opencollective.com/react-native-elements/backer/8/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/9/avatar)](https://opencollective.com/react-native-elements/backer/9/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/10/avatar)](https://opencollective.com/react-native-elements/backer/10/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/11/avatar)](https://opencollective.com/react-native-elements/backer/11/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/12/avatar)](https://opencollective.com/react-native-elements/backer/12/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/13/avatar)](https://opencollective.com/react-native-elements/backer/13/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/14/avatar)](https://opencollective.com/react-native-elements/backer/14/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/15/avatar)](https://opencollective.com/react-native-elements/backer/15/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/16/avatar)](https://opencollective.com/react-native-elements/backer/16/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/17/avatar)](https://opencollective.com/react-native-elements/backer/17/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/18/avatar)](https://opencollective.com/react-native-elements/backer/18/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/19/avatar)](https://opencollective.com/react-native-elements/backer/19/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/20/avatar)](https://opencollective.com/react-native-elements/backer/20/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/21/avatar)](https://opencollective.com/react-native-elements/backer/21/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/22/avatar)](https://opencollective.com/react-native-elements/backer/22/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/23/avatar)](https://opencollective.com/react-native-elements/backer/23/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/24/avatar)](https://opencollective.com/react-native-elements/backer/24/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/25/avatar)](https://opencollective.com/react-native-elements/backer/25/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/26/avatar)](https://opencollective.com/react-native-elements/backer/26/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/27/avatar)](https://opencollective.com/react-native-elements/backer/27/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/28/avatar)](https://opencollective.com/react-native-elements/backer/28/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/backer/29/avatar)](https://opencollective.com/react-native-elements/backer/29/website)

## Sponsors

Do you use React Native Elements in production? If so, consider supporting this project as it will allow the maintainers to dedicate more time to maintaining this project and also building new features for everyone. Also, your app or company's logo will show [on GitHub](https://github.com/react-native-elements/react-native-elements#sponsors) and link to your website - who doesn't want a little extra exposure? [Here's the info](https://opencollective.com/react-native-elements#sponsor).

[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/0/avatar)](https://opencollective.com/react-native-elements/sponsor/0/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/1/avatar)](https://opencollective.com/react-native-elements/sponsor/1/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/2/avatar)](https://opencollective.com/react-native-elements/sponsor/2/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/3/avatar)](https://opencollective.com/react-native-elements/sponsor/3/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/4/avatar)](https://opencollective.com/react-native-elements/sponsor/4/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/5/avatar)](https://opencollective.com/react-native-elements/sponsor/5/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/6/avatar)](https://opencollective.com/react-native-elements/sponsor/6/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/7/avatar)](https://opencollective.com/react-native-elements/sponsor/7/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/8/avatar)](https://opencollective.com/react-native-elements/sponsor/8/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/9/avatar)](https://opencollective.com/react-native-elements/sponsor/9/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/10/avatar)](https://opencollective.com/react-native-elements/sponsor/10/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/11/avatar)](https://opencollective.com/react-native-elements/sponsor/11/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/12/avatar)](https://opencollective.com/react-native-elements/sponsor/12/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/13/avatar)](https://opencollective.com/react-native-elements/sponsor/13/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/14/avatar)](https://opencollective.com/react-native-elements/sponsor/14/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/15/avatar)](https://opencollective.com/react-native-elements/sponsor/15/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/16/avatar)](https://opencollective.com/react-native-elements/sponsor/16/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/17/avatar)](https://opencollective.com/react-native-elements/sponsor/17/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/18/avatar)](https://opencollective.com/react-native-elements/sponsor/18/website)
[![React Native Elements Backer](https://opencollective.com/react-native-elements/sponsor/19/avatar)](https://opencollective.com/react-native-elements/sponsor/19/website)
