/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.clean;

import java.io.File;
import org.cmc.music.util.FileComparator;
import org.cmc.music.util.FileFilter;

public abstract class RenamingFileFilter
implements FileFilter {
    protected boolean isMusicFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String s = file.getName().toLowerCase();
        return s.endsWith(".mp3") | s.endsWith(".ogg");
    }

    protected abstract String getNewName2(File var1, String var2);

    private void doRenaming(File file, String new_name) {
        System.out.println("renaming: '" + file.getName() + "' to '" + new_name + "' at: " + file.getParent());
        File file2 = new File(file.getParentFile(), new_name);
        if (file.getName().toLowerCase().equals(file2.getName().toLowerCase())) {
            try {
                File temp = new File(file.getParentFile(), String.valueOf(file.getName()) + ".tmp");
                if (!file.renameTo(temp)) {
                    System.out.println("rename failed file->temp: " + temp.getAbsolutePath());
                }
                if (!temp.renameTo(file2)) {
                    System.out.println("rename failed temp->file2: " + temp.getAbsolutePath());
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else if (file2.exists()) {
            System.out.println("could not rename: already exists");
            FileComparator fc = new FileComparator();
            boolean exact = fc.compare(file, file2);
            if (exact) {
                String[] options = new String[]{"Delete A", "Delete B", "Ignore"};
                String msg = "\nIdentical files found in same folder:\n\nA: '" + file.getAbsolutePath() + "'" + "\n" + "B: '" + file2.getAbsolutePath() + "'" + "\n" + "\n";
                boolean choice = false;
                if (!choice) {
                    System.out.println("delete left");
                    file.delete();
                } else if (choice) {
                    System.out.println("delete right");
                    file2.delete();
                }
            }
        } else {
            file.renameTo(file2);
        }
    }

    public boolean process(File file) {
        if (!file.isDirectory() && !this.isMusicFile(file)) {
            return false;
        }
        String name = file.getName();
        String name2 = null;
        if (file.isDirectory()) {
            name2 = this.getNewName2(file, name);
        } else {
            String ext = this.getExtension(name);
            String stripped = this.stripExtension(name);
            name2 = this.getNewName2(file, stripped);
            if (name2 != null) {
                name2 = String.valueOf(name2) + ext.toLowerCase();
            }
        }
        if (name2 != null && name2.length() > 0 && !name.equals(name2)) {
            this.doRenaming(file, name2);
            return true;
        }
        return false;
    }

    protected String getExtension(String s) {
        int index = s.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return s.substring(index);
    }

    protected String getExtensionNonNull(String s) {
        String result = this.getExtension(s);
        if (result == null) {
            return "";
        }
        return result;
    }

    protected String stripExtension(String s) {
        int index = s.lastIndexOf(46);
        if (index < 0) {
            return s;
        }
        return s.substring(0, index);
    }

    protected String toTitleCase(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) {
                if (i == 0) {
                    result.append(Character.toUpperCase(c));
                } else if (prev == '\'') {
                    if (i > 1 && Character.isLetter(s.charAt(i - 2))) {
                        result.append(Character.toLowerCase(c));
                    } else {
                        result.append(Character.toUpperCase(c));
                    }
                } else if (!Character.isLetter(prev)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(Character.toLowerCase(c));
                }
            } else {
                result.append(c);
            }
            prev = c;
            ++i;
        }
        return result.toString();
    }

    protected String insertSpacesBeforeCaps(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isLetter(c) && i > 0 && Character.isLetter(prev) && Character.isLowerCase(prev) && Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
            prev = c;
            ++i;
        }
        return result.toString();
    }
}

