/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.content.Context;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.internal.Maps;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import roboguice.application.RoboApplication;
import roboguice.inject.PreferenceMembersInjector;
import roboguice.inject.ViewMembersInjector;
import roboguice.util.Ln;
import roboguice.util.Strings;

public class ContextScope
implements Scope {
    protected WeakHashMap<Context, Map<Key<?>, Object>> values = new WeakHashMap();
    protected ThreadLocal<WeakActiveStack<Context>> contextStack = new ThreadLocal();
    protected ArrayList<ViewMembersInjector<?>> viewsForInjection = new ArrayList();
    protected ArrayList<PreferenceMembersInjector<?>> preferencesForInjection = new ArrayList();

    public ContextScope(RoboApplication app) {
        this.enter((Context)app);
    }

    public void registerViewForInjection(ViewMembersInjector<?> injector) {
        this.viewsForInjection.add(injector);
    }

    public void registerPreferenceForInjection(PreferenceMembersInjector<?> injector) {
        this.preferencesForInjection.add(injector);
    }

    public void injectViews() {
        for (int i = this.viewsForInjection.size() - 1; i >= 0; --i) {
            this.viewsForInjection.remove(i).reallyInjectMembers();
        }
    }

    public void injectPreferenceViews() {
        for (int i = this.preferencesForInjection.size() - 1; i >= 0; --i) {
            this.preferencesForInjection.remove(i).reallyInjectMembers();
        }
    }

    public void enter(Context context) {
        WeakHashMap<Context, Map<Key<?>, Object>> map;
        this.ensureContextStack();
        this.contextStack.get().push(context);
        Key key = Key.get(Context.class);
        this.getScopedObjectMap(key).put(key, context);
        if (Ln.isVerboseEnabled() && (map = this.values) != null) {
            Ln.v("Contexts in the %s scope map after inserting %s: %s", Thread.currentThread().getName(), context, Strings.join(", ", map.keySet()));
        }
    }

    public void exit(Context context) {
        this.ensureContextStack();
        this.contextStack.get().remove(context);
    }

    public void dispose(Context context) {
        WeakHashMap<Context, Map<Key<?>, Object>> map = this.values;
        if (map != null) {
            Map<Key<?>, Object> scopedObjects = map.remove(context);
            if (scopedObjects != null) {
                scopedObjects.clear();
            }
            if (Ln.isVerboseEnabled()) {
                Ln.v("Contexts in the %s scope map after removing %s: %s", Thread.currentThread().getName(), context, Strings.join(", ", map.keySet()));
            }
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopedObjects = ContextScope.this.getScopedObjectMap(key);
                Object current = scopedObjects.get(key);
                if (current == null && !scopedObjects.containsKey(key)) {
                    current = unscoped.get();
                    scopedObjects.put(key, current);
                }
                return current;
            }
        };
    }

    protected void ensureContextStack() {
        if (this.contextStack.get() == null) {
            this.contextStack.set(new WeakActiveStack());
        }
    }

    protected <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Context context = this.contextStack.get().peek();
        HashMap scopedObjects = this.values.get(context);
        if (scopedObjects == null) {
            scopedObjects = Maps.newHashMap();
            this.values.put(context, scopedObjects);
        }
        return scopedObjects;
    }

    public static class WeakActiveStack<T> {
        private Node<T> head;
        private Node<T> tail;

        public void push(T value) {
            if (this.head == null) {
                this.head = new Node<T>(value);
                this.tail = this.head;
            } else {
                Node<T> existingNode = this.findNode(value);
                if (existingNode == null) {
                    Node<T> newNode = new Node<T>(value);
                    newNode.next = this.head;
                    this.head.previous = newNode;
                    this.head = newNode;
                } else {
                    if (existingNode == this.head) {
                        return;
                    }
                    if (existingNode == this.tail) {
                        this.tail = existingNode.previous;
                        this.tail.next = null;
                    }
                    if (existingNode.previous != null) {
                        existingNode.previous.next = existingNode.next;
                    }
                    if (existingNode.next != null) {
                        existingNode.next.previous = existingNode.previous;
                    }
                    existingNode.next = this.head;
                    this.head.previous = existingNode;
                    this.head = existingNode;
                    this.head.previous = null;
                }
            }
        }

        public T pop() {
            Node<T> node = this.head;
            while (node != null) {
                Object value = node.value.get();
                if (value == null) {
                    node = this.disposeOfNode(node);
                    continue;
                }
                if (node.next != null) {
                    this.head = node.next;
                    node.previous = this.tail;
                    this.tail.next = node;
                    node.next = null;
                    this.head.previous = null;
                    this.tail = node;
                }
                return value;
            }
            return null;
        }

        public T peek() {
            Node<T> node = this.head;
            while (node != null) {
                Object value = node.value.get();
                if (value == null) {
                    node = this.disposeOfNode(node);
                    continue;
                }
                return value;
            }
            return null;
        }

        public void remove(T value) {
            Node<T> node = this.findNode(value);
            this.disposeOfNode(node);
        }

        protected Node<T> disposeOfNode(Node<T> node) {
            if (node == this.head) {
                this.head = node.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    this.head.previous = null;
                }
            }
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            if (node == this.tail) {
                this.tail = node.previous;
                this.tail.next = null;
            }
            return node.next;
        }

        protected Node<T> findNode(T value) {
            Node<T> node = this.head;
            while (node != null) {
                Object nodeValue = node.value.get();
                if (nodeValue == null) {
                    node = this.disposeOfNode(node);
                    continue;
                }
                if (nodeValue.equals(value)) {
                    return node;
                }
                node = node.next;
            }
            return null;
        }

        static class Node<T> {
            Node<T> previous;
            Node<T> next;
            WeakReference<T> value;

            public Node(T value) {
                this.value = new WeakReference<T>(value);
            }
        }
    }
}

