/*
 * Decompiled with CFR 0.152.
 */
package roboguice.config;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.PowerManager;
import android.os.Vibrator;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.matcher.Matchers;
import roboguice.inject.ActivityProvider;
import roboguice.inject.AssetManagerProvider;
import roboguice.inject.ContentResolverProvider;
import roboguice.inject.ContextScope;
import roboguice.inject.ContextScoped;
import roboguice.inject.ExtrasListener;
import roboguice.inject.PreferenceListener;
import roboguice.inject.ResourceListener;
import roboguice.inject.ResourcesProvider;
import roboguice.inject.SharedPreferencesProvider;
import roboguice.inject.SystemServiceProvider;
import roboguice.inject.ViewListener;
import roboguice.util.Ln;
import roboguice.util.RoboAsyncTask;
import roboguice.util.RoboThread;

public class RoboModule
extends AbstractModule {
    protected ContextScope contextScope;
    protected Provider<Context> throwingContextProvider;
    protected Provider<Context> contextProvider;
    protected ResourceListener resourceListener;
    protected ViewListener viewListener;
    protected ExtrasListener extrasListener;
    protected PreferenceListener preferenceListener;
    protected Application application;

    public RoboModule(ContextScope contextScope, Provider<Context> throwingContextProvider, Provider<Context> contextProvider, ResourceListener resourceListener, ViewListener viewListener, ExtrasListener extrasListener, PreferenceListener preferenceListener, Application application) {
        this.contextScope = contextScope;
        this.throwingContextProvider = throwingContextProvider;
        this.contextProvider = contextProvider;
        this.resourceListener = resourceListener;
        this.viewListener = viewListener;
        this.extrasListener = extrasListener;
        this.preferenceListener = preferenceListener;
        this.application = application;
    }

    protected void configure() {
        this.bindScope(ContextScoped.class, this.contextScope);
        this.bind(ContextScope.class).toInstance((Object)this.contextScope);
        this.bind(Context.class).toProvider(this.throwingContextProvider).in(ContextScoped.class);
        this.bind(Activity.class).toProvider(ActivityProvider.class);
        this.bind(AssetManager.class).toProvider(AssetManagerProvider.class);
        this.bind(SharedPreferences.class).toProvider(SharedPreferencesProvider.class);
        this.bind(Resources.class).toProvider(ResourcesProvider.class);
        this.bind(ContentResolver.class).toProvider(ContentResolverProvider.class);
        for (Class<?> c = this.application.getClass(); c != null && Application.class.isAssignableFrom(c); c = c.getSuperclass()) {
            this.bind(c).toInstance((Object)this.application);
        }
        this.bind(LocationManager.class).toProvider(new SystemServiceProvider("location"));
        this.bind(WindowManager.class).toProvider(new SystemServiceProvider("window"));
        this.bind(LayoutInflater.class).toProvider(new SystemServiceProvider("layout_inflater"));
        this.bind(ActivityManager.class).toProvider(new SystemServiceProvider("activity"));
        this.bind(PowerManager.class).toProvider(new SystemServiceProvider("power"));
        this.bind(AlarmManager.class).toProvider(new SystemServiceProvider("alarm"));
        this.bind(NotificationManager.class).toProvider(new SystemServiceProvider("notification"));
        this.bind(KeyguardManager.class).toProvider(new SystemServiceProvider("keyguard"));
        this.bind(SearchManager.class).toProvider(new SystemServiceProvider("search"));
        this.bind(Vibrator.class).toProvider(new SystemServiceProvider("vibrator"));
        this.bind(ConnectivityManager.class).toProvider(new SystemServiceProvider("connectivity"));
        this.bind(WifiManager.class).toProvider(new SystemServiceProvider("wifi"));
        this.bind(InputMethodManager.class).toProvider(new SystemServiceProvider("input_method"));
        this.bind(SensorManager.class).toProvider(new SystemServiceProvider("sensor"));
        this.bindListener(Matchers.any(), this.resourceListener);
        this.bindListener(Matchers.any(), this.extrasListener);
        this.bindListener(Matchers.any(), this.viewListener);
        if (this.preferenceListener != null) {
            this.bindListener(Matchers.any(), this.preferenceListener);
        }
        this.requestStaticInjection(new Class[]{Ln.class});
        this.requestStaticInjection(new Class[]{RoboThread.class});
        this.requestStaticInjection(new Class[]{RoboAsyncTask.class});
    }
}

