/*
 * Decompiled with CFR 0.152.
 */
package roboguice.application;

import android.app.Application;
import android.content.Context;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.List;
import roboguice.config.AbstractAndroidModule;
import roboguice.config.EventManagerModule;
import roboguice.config.RoboModule;
import roboguice.event.EventManager;
import roboguice.inject.ContextScope;
import roboguice.inject.ExtrasListener;
import roboguice.inject.InjectorProvider;
import roboguice.inject.PreferenceListener;
import roboguice.inject.ResourceListener;
import roboguice.inject.StaticTypeListener;
import roboguice.inject.ViewListener;

public class RoboApplication
extends Application
implements InjectorProvider {
    protected Injector guiceInjector;
    protected ContextScope contextScope;
    protected Provider<Context> throwingContextProvider;
    protected Provider<Context> contextProvider;
    protected ResourceListener resourceListener;
    protected ViewListener viewListener;
    protected ExtrasListener extrasListener;
    protected PreferenceListener preferenceListener;
    protected List<StaticTypeListener> staticTypeListeners;
    protected EventManager eventManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Injector getInjector() {
        if (this.guiceInjector == null) {
            RoboApplication roboApplication = this;
            synchronized (roboApplication) {
                if (this.guiceInjector == null) {
                    this.initInstanceMembers();
                    this.guiceInjector = this.createInjector();
                }
            }
        }
        return this.guiceInjector;
    }

    protected void initInstanceMembers() {
        this.contextScope = new ContextScope(this);
        this.throwingContextProvider = new Provider<Context>(){

            public Context get() {
                return RoboApplication.this;
            }
        };
        this.contextProvider = this.contextScope.scope(Key.get(Context.class), this.throwingContextProvider);
        this.resourceListener = new ResourceListener(this);
        this.viewListener = new ViewListener(this.contextProvider, this, this.contextScope);
        this.extrasListener = new ExtrasListener(this.contextProvider);
        EventManager eventManager = this.eventManager = this.allowContextObservers() ? new EventManager() : new EventManager.NullEventManager();
        if (this.allowPreferenceInjection()) {
            this.preferenceListener = new PreferenceListener(this.contextProvider, this, this.contextScope);
        }
        this.staticTypeListeners = new ArrayList<StaticTypeListener>();
        this.staticTypeListeners.add(this.resourceListener);
    }

    protected Injector createInjector() {
        ArrayList<Module> modules = new ArrayList<Module>();
        RoboModule roboguiceModule = new RoboModule(this.contextScope, this.throwingContextProvider, this.contextProvider, this.resourceListener, this.viewListener, this.extrasListener, this.preferenceListener, this);
        modules.add((Module)roboguiceModule);
        EventManagerModule eventManagerModule = new EventManagerModule(this.eventManager, this.contextProvider);
        modules.add((Module)eventManagerModule);
        this.addApplicationModules(modules);
        for (Module m : modules) {
            if (!(m instanceof AbstractAndroidModule)) continue;
            ((AbstractAndroidModule)m).setStaticTypeListeners(this.staticTypeListeners);
        }
        return Guice.createInjector((Stage)Stage.PRODUCTION, modules);
    }

    protected void addApplicationModules(List<Module> modules) {
    }

    protected boolean allowPreferenceInjection() {
        return true;
    }

    protected boolean allowContextObservers() {
        return true;
    }

    public List<StaticTypeListener> getStaticTypeListeners() {
        return this.staticTypeListeners;
    }
}

