package com.tss.android.prefs;

import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import com.tss.android.R;

public class StarPickerPreference extends DialogPreference {
    private static final String androidns = "http://schemas.android.com/apk/res/android";

    private final Context mContext;
    private int mValue, mDefault = 0;

    private RadioGroup radioGroup;
    private int id1, id2, id3;

    public StarPickerPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;

        mDefault = attrs.getAttributeIntValue(androidns, "defaultValue", 0);
    }

    @Override
    protected View onCreateDialogView() {
        LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View v = inflater.inflate(R.layout.starpicker, null);

        radioGroup = v.findViewById(R.id.starPicker);
        radioGroup.setSaveEnabled(true);

        RadioButton radio1 = v.findViewById(R.id.starRB1);
        RadioButton radio2 = v.findViewById(R.id.starRB2);
        RadioButton radio3 = v.findViewById(R.id.starRB3);

        id1 = radio1.getId();
        id2 = radio2.getId();
        id3 = radio3.getId();

        onSetInitialValue(mDefault);

        return v;

    }

    protected void onSetInitialValue(int defaultValue) {
        super.onSetInitialValue(true, defaultValue);
        mValue = shouldPersist() ? getPersistedInt(defaultValue) : defaultValue;

        switch (mValue) {
            case 0:
                radioGroup.check(id1);
                break;
            case 1:
                radioGroup.check(id2);
                break;
            case 2:
                radioGroup.check(id3);
                break;
        }
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            int id = radioGroup.getCheckedRadioButtonId();
            if (id == id1)
                mValue = 0;
            if (id == id2)
                mValue = 1;
            if (id == id3)
                mValue = 2;

            if (shouldPersist())
                persistInt(mValue);
            callChangeListener(mValue);
        }
    }

}