/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.nbody.core.graph;

import javax.microedition.khronos.opengles.GL10;

import com.nbody.core.geom.Vector2;

/**
 * Base class defining the core set of information necessary to render (and move
 * an object on the screen. This is an abstract type and must be derived to
 * add methods to actually draw (see CanvasSprite and GLSprite).
 */
public abstract class Renderable {
	// Position.
	public Vector2 pos;
	// Velocity.
	public Vector2 vel;

	public Renderable(Vector2 pos, Vector2 vel) {
		super();
		this.pos = pos;
		this.vel = vel;
	}

	public Renderable() {
		super();
	}

	public void reset() {
		pos = null;
		vel = null;
	}

	public abstract void draw(GL10 gl);

}
