package com.torrents_csv_android.ui.components

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.torrents_csv_android.APIService
import com.torrents_csv_android.Torrent
import kotlinx.coroutines.launch

class SearchViewModel : ViewModel() {
    var errorMessage by mutableStateOf("")

    var torrents: List<Torrent> by mutableStateOf(listOf())
        private set

    var next: Int? by mutableStateOf(null)

    var loading: Boolean by mutableStateOf(false)
        private set

    fun fetchTorrentList(search: String) {
        viewModelScope.launch {
            val apiService = APIService.getInstance()
            try {
                loading = true
                val res = apiService.getTorrents(search = search)
                torrents = res.torrents
                next = res.next
            } catch (e: Exception) {
                errorMessage = e.message.toString()
            } finally {
                loading = false
            }
        }
    }

    fun appendTorrents(search: String) {
        viewModelScope.launch {
            val apiService = APIService.getInstance()
            try {
                loading = true
                if (next !== null) {
                    val newRes = apiService.getTorrents(search = search, after = next)

                    val newTorrents = torrents.toMutableList()
                    newTorrents.addAll(newRes.torrents)
                    torrents = newTorrents
                    next = newRes.next
                }
            } catch (e: Exception) {
                errorMessage = e.message.toString()
            } finally {
                loading = false
            }
        }
    }
}
