package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun whatIbelieve(modifier: Modifier) {
    MarkdownText(
        markdown = whatIbelieveText,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val whatIbelieveText = """
    # Во что я верю
    · Во что я верю ·, титульная страница перепечатки Института Общей семантики

    * * *

    Я благодарю за предоставленную честь поучаствовать в симпозиуме ·_Вера, которой живу_·, который организовал Кришна М. Талджери, и внести вклад докладом, написанным для вдумчивой аудитории индийских читателей.¹ Мне впервые предоставили возможность написать ‘кредо’, в котором не придётся вдаваться в теоретические объяснения.

    Я воспитывался в семье земледельцев, математиков, солдатов, юристов, инженеров и т. д. К возрасту пяти лет мой отец, инженер, помог мне усвоить важнейшие мировые научные открытия девятнадцатого века, которые стали основой для научных достижений двадцатого века и остаются работоспособными сегодня. ·_Ощущение_· дифференциального исчисления, а также не-эвклидовых и четырёх-мерных геометрий, которое он мне тогда передал, задало будущие интересы, ориентирования в жизни и стало фундаментом всей моей работы.

    Мои наблюдения и теоретические исследования жизни и математики, оснований математики, многих научных дисциплин, истории, истории культур, антропологии, ‘философии’, ‘психологии’, ‘логики’, сравнительного религиоведения и т. д., убедили меня в том, что:

    1\. Человеческие оценки в отношении их самих осуществляются на мифологических или зоологических основаниях, или на сочетании тех и других; но  
    
    2\. Ни тот, ни другой подход не может дать нам базу, подходящую для работы, направленной на достижение понимания живых, уникально человеческих, крайне сложных (глубоко взаимо-относящихся) реакций Смита₁, Смита₂ и т. д., обобщённых в таких абстракциях высоких порядков как ‘разум’, или ‘интеллект’; и  
    
    3\. Функциональный анализ, свободный от старых мифологических и зоологических предположений, показал, что человек, с его самой высокоразвитой нервной системой, уникально характеризуется способностью индивидуума или поколения начинать там, где остановился предшественник. Я назвал эту жизненно важную способность «время-связывание». Такое может осуществлять только класс жизни, который пользуется символами в качестве средства время-связывания. Эта способность зависит от, и не обходится без ‘разумности’, средств коммуникации и т. д. На этом присуще человеческом уровне взаимозависимости время-связывание неизбежно ведёт к чувству ответственности и долга перед остальными и перед будущим и, следовательно, к этике какого-то толка, моральным устоям и подобным социальным или-и социо-культурным реакциям.

    В ориентировании время-связывания я принял эти характеристики как данные эмпирические результаты функционирования здоровой нервной системы человека.

    Мы допустили фундаментальную ошибку из-за старых оценок, постулировав ‘зло’, присущее ‘человеческой природе’. ‘Человеческая природа’ в значительной степени зависит от характера наших вероучений, рационализаций и т. д., потому что, в конечном счёте, на их основе мы строим свои социо-культурные и другие среды.

    Я пришёл к убеждённости, что наши подходы к человеческим проблемам не дают результатов, потому что примитивные методы оценки, по-прежнему часто преобладающие в наших взглядах, сводят их на нет. С осознанностью время-связывания мы устанавливаем свои критерии ценностей и, следовательно, поведения, по исследованию человеческих потенциалов, а не по статистическим средним значениям на уровне ·_homo homini lupus_·, выведенным из примитивных или-и не-здравых семантических (оценочных) реакций, которые мы тщательно задокументировали.

    Вместо того чтобы изучать элементалистические ‘мышление’, ‘ощущения’, ‘интеллект’, ‘эмоции’ и т. д., – заставляющий блуждать подход, предполагающий унаследованные архаичные, ·_искусственные_· разделения или шизофренические расщепления человеческих характеристик, которые на деле не разделить – я ·_изучал функционально и, следовательно, не-элементалистически психо-биологические механизмы время-связывания_· – то, как они работают.

    По индукции мы переходим о частностей к общему. Однако этому методу не хватает надёжности. Нам требуется построить дедуктивную систему и эмпирически проверять применимость общего к конечной случайной частности, что затем станет основой для прогнозируемости. В этом, в сущности, заключается главная цель всей науки.

    Наши ‘знания’ о ‘человеке’ до сих пор составляли индуктивно собранные статистические средние, из-за чего у нас складывалась довольно печальная, искажённая, едва ли не безнадёжная, человеческая картина мира. Человеческим пониманием время-связывания, как я его здесь объяснил, мы устанавливаем дедуктивное основание для полноценной ‘человеческой науки’, в которой задействуем как индуктивные, так и дедуктивные методы. Я считаю, что именно этим тезисом индуктивного и дедуктивного научных методов относительно человека мы ощутимо отмечаем чёткую разницу между детством и зрелостью человечности. Иными словами, мы пытаемся путём исследования индивидуума узнать об основных характеристиках ·_филума_· (человеческой расы). Теперь благодаря теории время-связывания впервые, насколько я знаю, накопив данные по индукции (статистические средние), мы можем начать с того, что узнали о ·_филуме_·, и проанализировать индивидуума с точки зрения человеческих потенциалов как ·_филум_·. Возможно, я ошибаюсь, но это может стать новой страницей человеческой истории.

    В дальнейших исследованиях я не мог применить более старый подход «организма-как-целого», и основывал свой анализ на гораздо более сложном «организме-как-целом-в-среде». Мне пришлось включить невро-языковые и невро-семантические (оценочные) среды как среды, а также учесть географические, физико-химические, экономические, политические, экологические, социо-культурные и т. д. условия как факторы, которые задают человеческие личности и, следовательно, даже групповое поведение. Этим я делаю всецело общее высказывание, применимое как к высоко цивилизованным, так и самым примитивным людям.

    Здравый смысл и простые наблюдения убедили меня, что средний, так называемый ‘нормальный человек’ представляет собой нечто настолько сложное, что не даёт себя полноценно анализировать. Поэтому мне пришлось сосредоточиться на изучении двух крайностей человеческих психо-логических реакций:

    a. реакций в их наилучших проявлениях за счёт их исключительной прогнозируемости, как в математике, основаниях математики, математической физике, точных науках и т. д., которые демонстрируют глубочайшие, строго человеческие психо-логические реакции, и  
    b. реакций в их наихудших проявлениях, примерами которых служат психиатрические пациенты.

    В ходе исследований я обнаружил, что мы можем применять физико-математические методы к своей повседневной жизни на всех уровнях, связывая науку с проблемами здравомыслия в смысле адаптации к ‘фактам’ и к ‘реальности’.

    Я выяснил, что человеческие реакции в диапазоне этих двух пределов отличаются не по какому-то овеществлённому ‘типу’, а только по психо-биологическим ‘степеням’, и что ‘нормальный человек’ находится где-то между этими двумя крайностями.

    Никто не ведёт себя так ‘безумно’, как картина, составленная из описаний в учебнике по психиатрии, и никто не ведёт себя так разумно, как таковая в учебнике по здравомыслию, включая автора. Мы видим, что механизмы время-связывания работают у большинства людей, исключая тех, кто страдает серьёзными психо-биологическими заболеваниями. Однако, некоторые ·_неприступные_· догматики во власти, особенно диктаторы всех мастей, усердно препятствуют реализации этого потенциала. Определённо, представителей полицейских режимов с запретами на гласность, которые скрывают от людей знания от мира и о мире, или манипулируют ими ради своих ‘железных занавесов’ и т. д., следует относить к саботажникам среди время-связующих, и точно не к социо-культурным участникам человеческой эволюции.

    Языковые и грамматические структуры также мешают нам понимать человеческие реакции. Например, мы пользовались и продолжаем пользоваться терминами «объективный» и «субъективный». Они оба вызывают сильнейшую путаницу. Так называемое ‘объективное’ следует рассматривать как построение, осуществляемое нашей нервной системой, а то, что мы называем субъективным, мы можем также считать ‘объективным’ по тем же причинам.

    Мой анализ показал, что события в мире вне нашей кожи и такие организменные психо-логические реакции под нашей кожей, которые мы называем «ощущения», «мышление», «эмоции», «любовь», «ненависть», «счастье», «недовольство», «злость», «страх», «обида», «боль», «удовольствие» и т. д. происходят только на ·_не-словесных_· или, как я их называю, ·_немых уровнях_·. Наши разговоры происходят на словесных уровнях, и мы можем говорить ·_о_·, но не ·_на_· немых или не-произносимых уровнях. Этим чётким и в основе естественным, но совершенно неортодоксальным различением между словесными и не-словесными уровнями мы автоматически избавляемся от бесполезных метафизических тысячелетних словесных споров о ‘природе вещей’, ‘природе человека’ и т. д. Множество тщетных метафизических словесных доводов, таких как солипсизм или ‘непостижимое’, возникают в результате отождествления словесных уровней с немыми уровнями событий, ‘ощущений’ и т. д., которые слова лишь представляют, но никогда не являются ‘реальностью’ под ними.

    Мы можем иметь дело с такими психо-логическими манифестациями, какие я упомянул выше, с помощью единой терминологии ·_оценки_·, что приведёт к возможности эмпирической общей теории значений ⁅ценностей⁆, или Общей семантике, и благодаря своим истокам в методах точных наук, она может послужить фундаментом для ·_человеческой науки_·. Изучением точных наук мы можем выявить факторы здравомыслия. Различные философские течения в таких дисциплинах как номинализм, реализм, феноменология, сигнифика, семиотика, логический позитивизм и т. д. тоже становятся едиными по методологии с международно применимыми техниками, которую я называю не-аристотелевой, потому что она включает, но при этом выходит за рамки и ·_актуализует_· цели и формулировки Аристотеля.

    Что бы мы ни ·_сказали_·, что-то есть, очевидно, ·_не есть_· это ‘что-то’ на немых уровнях. Витгенштейн писал:

    ⬩«⬩  
    То, что мы можем показать, мы не можем сказать.  
    ⬩»⬩

    На моём опыте оказалось практически невозможным передать способность отличать немые (не-произносимые) уровни от словесных, не попросив читателя или слушателя ущипнуть себя за палец. За счёт этого он организменно осознаёт, что прямой психо-логический опыт первого порядка не происходит словесно. Это высказывание обманчиво покажется простым, если мы не осознаем его подоплёки, потому что в своих живых реакциях большинство из нас отождествляют в значении два совершенно ·_разных_· уровня, что часто ведёт к катастрофическим последствиям.

    Обратите внимание на печальный характер красивого отрывка из работы Эддингтона на странице ⅼⅴ (⇩). Он, по-видимому расстроился, что немые уровни никак не могут стать словесными уровнями.

    Не служит ли это примером неоправданного ‘максимального ожидания’?

    Я твёрдо убедился, что ·_осознанность различий между этими уровнями абстракций_·, а именно немыми и словесными уровнями, служит ключом и, вероятно, первым шагом к решению человеческих проблем. Это убеждение я основываю на собственных наблюдениях и исследованиях бесчисленных наблюдений других исследователей.

    Существует огромная разница между словесным ‘мышлением’ и внутренне немым ‘созерцанием’ на не-словесных уровнях, и только затем поиском языковой структуры, подходящей предположительно выявленной структуре немых процессов, поиском которой мы занимаемся в современной науке. Если мы ‘мыслим’ ·_словесно_·, мы поступаем как предубеждённые наблюдатели и проецируем структуру языка, которым пользуемся, на немые уровни, из-за чего остаёмся в колее старых ориентирований. Разумные, нейтральные наблюдения и творческая работа становятся практически невозможными.

    И наоборот, когда мы ‘мыслим’ без слов, или в образах (формирующихся в связи со структурой и, следовательно, отношениями), нам удаётся выявить новые аспекты и связи на немых уровнях. Это позволяет нам приходить к важным теоретическим результатам в общем поиске схожести между немым и словесным уровнями. Практически все важные шаги в развитии совершаются этим способом.

    Сегодня единственное возможное звено, связующее эти два уровня, мы находим в рамках отношений, равно применимых к не-словесным и словесным уровням, таких как ‘порядок’ (рядовый, линейный, циклический, спиральный и т. д.), ‘промежуточность’, ‘пространство-время’, ‘равенство’ или ‘неравенство’, ‘до’, ‘после’, ‘больше, чем’, ‘меньше, чем’ и т. д.

    ·_Отношения как факторы структуры дают единственное содержимое всего человеческого знания_·.

    Говорят:

    ⬩‹⬩  
    Чтобы знать что-то, требуется знать всё.  
    ⬩›⬩

    Я назову это высказывание печально истинным, но возражу, что по ·_такой формулировке_· ‘знание’ представляется невозможным. Математики вышли из этого безнадёжного положения простым и эффективным способом. Они ввели методы постулатов, чем ·_ограничили_· ‘всё’, из которого вывели ·_ограниченное_· ‘что-либо’.

    Отождествление (спутывание) словесных уровней с немыми автоматически ведёт к неопределённо длинным рядам словесных «почему», ·_будто_· словесными уровнями как-то удастся охватить все факторы и цепи предшественников немых уровней, или будто они могут ‘·_быть_·’ немыми уровнями. Именно поэтому в научном методе мы ограничиваем своё «почему» имеющимися данными, чем избегаем неограниченных в отсутствие данных метафизических вопросов, на которые не удастся отыскать никакой ответ. Математики решили эти характерные дилеммы, открыто высказав свои неопределённые термины в своих системах постулатов – термины, которыми не обозначается ничего, кроме событий на немых уровнях.

    Метафизики разных вероучений с незапамятных времён пытались решить эти сложные вопросы постулированием всяческих ‘перводвигателей’ или ‘целевых причин’, за рамками которых дальнейшее «почему» исключается, потому что ведёт к ‘бесконечной регрессии’, на которую накладывают логическое ‘табу’.

    Религии начались политеистическими. Позднее, в попытке объединения, возможно, в целях укрепить власть духовенства, а также в силу развития человеческой способности обобщать, изобрели монотеизмы, что привело к самым жестоким религиозным войнам. Различные правители, диктаторы, ‘фюреры’ и т. д. следовали подобным психо-логическим сценариям с исторически известными разрушительными или созидательными результатами. Высказывания выше ограничиваются историческими контекстами.

    В нашем человеческом эволюционном развитии структуры религий и наук психо-логически не отличаются, потому что их сделал человек. Они все стоят на фундаменте предположений, гипотез и т. д., на котором мы пытаемся построить какое-то понимание или-и научиться обращаться с этим миром, включая нас самих. Некоторые из них мы строим на архаичных и ложных по фактам предположениях и т. д.; в других, таких как науки, мы берём за основу современные, потенциально проверяемые предположения и гипотезы. Поверхностно любую религию мы можем рассматривать как ‘примитивную науку’, призванную помочь ·_неосознанным_· организменным стремлениям, а современную науку можем рассматривать как ‘актуальную религию’, направленную на ·_осознанную_· помощь тем же человеческим ощущениям.

    Если мы не разделяем элементалистически ‘эмоции’ и ‘интеллект’, то нам следует принимать в расчёт организменные стремления, распределённые по континентам на протяжении тысячелетий, которые находят своё выражение в соответствии с датой конкретных человеческих событий, на данную дату.

    Как религии, так и науки представляют собой выражения нашего человеческого поиска надёжности и, следовательно, прогнозируемости, утешения, ориентиров, ощущений ‘принадлежности’ и т. д., чтобы достичь самореализации посредством общей ‘осознанности абстрагирования’ – главной цели моей работы.

    Прогресс современной науки, ·_включая новую науку человека как время-связующего_·, шёл благодаря исключительно свободе учёных в пересмотре своих ·_базовых предположений_·, терминологий, неопределённых терминов с присущими им скрытыми предположениями и т. д., которые лежат в основе наших рассуждений. Такой свободы не дают в ‘примитивных’ науках, как и в диктатурах, прошлых и настоящих.

    Что касается пространственно-временной проблемы ‘начала и конца мира’, я ‘решил’ её для себя с помощью убеждённости, что мы пока не эволюционировали достаточно и, следовательно, не созрели как люди, чтобы у нас получилось понять такие проблемы ·_на данную дату_·. Однако в научной практике, в осознанно ·_ограниченных_· условиях, я бы продолжил в поисках структуры спрашивать «почему». Вероятно, в будущем эта проблема окажется не-проблемой, а решение мы найдём в исчезновении проблемы. К этому времени научным методом уже удалось решить многие дилеммы, которые на первый взгляд казались неразрешимыми. Примером служит новая квантовая механика.

    Ещё один важный тезис, которым мы проясняем проблему ‘непостижимого’, религий и т. д., заключается в том, что человек обладает способностью ·_выведенного знания_·, которое основывается не на чувственных данных, а на заключениях о событиях, подвергавшихся наблюдениям.

    Все современные науки на субмикроскопических, эллектро-коллоидных и т. д. уровнях носят этот характер «будто бы». Кроме того, выведенные знания сегодня ведут к практическим проверкам в неожиданных областях, что говорит об их творческих потенциалах. Эпистемологически базовые теории следует разрабатывать в точках сплетения исследований, а если они не сплетаются, это стоит рассматривать как показатель дефектности теорий, и пересматривать их.

    Сегодня в науке выведенные знания дают гораздо больше надёжности, чем чувственные данные, которые нас часто обманывают. В религиях мы тоже переводим ·_пока непознанное_· в выведенное ‘познанное’, которое становится вероучениями, основанными, однако, на примитивных или до-научных предположениях. Самые примитивные религии, в которые верит дикарь, или более обобщённые и организованные религии, в которые верит ‘человек с улицы’, не-элементалистически представляют ·_выведенное_· ‘знание’ этих людей; выведенное в связи с их ‘ощущениями’, желаниями, потребностями, страхами и прочим подобным, сосуществующими неделимо в живых реакциях с их ‘интеллектом’.

    Я твёрдо убедился, что поныне преобладающие архаичные, расщепляющие, шизофренические ориентирования в отношении нас самих, которых в отсутствие современной человеческой науки практически не представляется возможным избежать, в крайней степени затрудняют любые попытки понять потенциалы ‘человеческой природы’. Взглядами, унаследованными от «детства человечности», которые остаются при нас за счёт языка, мы крепко держимся своими человеческими реакциями и тем самым своими культурами за неоправданно низкие уровни, и от них же пытаемся освободиться насилием, убийством, бунтами и другими, более крупными выражениями массовых страданий – революциями и войнами. Стоит увидеть, как резко это отличается от мирного прогресса в науке, где мы свободно анализируем свои базовые предположения и применяем язык подходящей структуры.

    Я твёрдо убедился, что значительной составляющей основы человеческой адаптации к немым уровням событий, ‘ощущений’ и т. д. служит адекватная структура языка. Благодаря ей не-элементалистическое ·_пространство-время_· Эйнштейна-Минковского, пришедшее на смену элементалистическим ньютоновым ‘пространству’ ·_и_· ‘времени’, привели к революции в физике.

    Сменив элементалистические ‘психологию’ ·_и_· ‘биологию’ не-элементалистической ·_психо-биологией_·, Адольф Мейер провёл чёткую разницу между людьми и животными. Благодаря не-элементалистическим разработкам ·_психо-соматики_·, сменившим устаревшие понятия ‘сознания’ ⁅‘psyche’⁆ ·и· ‘тела’ ⁅‘soma’⁆, удалось произвести революцию во всей медицине, избавив её от статуса переоценённой ветеринарии. И т. д., и т. п.

    Я привожу эти конкретные примеры, чтобы указать на общую практическую ценность структурных языковых инноваций, вводимых с целью выразить и передать другим наши новые структурные взгляды.

    Теоретические соображения и эмпирические данные глубоко убедили меня, что новая (насколько я знаю, исторически первая) формулировка время-связывания помогает нам гораздо яснее увидеть и понять ‘человеческую природу’ и поможет сформулировать новые перспективы на будущее время-связующих. Это новое функциональное определение человека как время-связующего, а не только ‘пространство-связующего’ влечёт за собой далеко идущие научные, психо-логические, моральные и этические последствия, которые часто остаются надолго, что на сегодня тысячи раз проверяли на практике. Оно также служит объяснением тому, как мы, люди, и только люди, смогли создать науки и цивилизации, что делает нас неизбежно ·_взаимо_·зависимыми строителями собственных судеб.

    Всю историю человек на ощупь искал своё место в иерархии жизни, пытаясь узнать, так сказать, о своей роли в ‘природе вещей’. Для этого ему следует найти себя и свою ‘природу’ прежде, чем он сможет полностью себя реализовать, и только затем, возможно, наши цивилизации смогут мирной эволюцией перейти от своего детства к зрелости человечности.

    Меня радует, что понятия цикличности и само-рефлексивности человеческого знания, выраженные другими авторами, приживаются в наших ориентированиях. В 1942 году в предисловии к Монографиям Ⅲ, изданным Институтом общей семантики я и М. Кендиг написали:

    ⬩«⬩  
    Следует заметить, что в человеческой жизни само-рефлексивность ведёт даже к «материальным» последствиям, что создаёт серьёзные трудности. Профессор Кассий Дж. Кайзер выражает это очень уместным образом:

    ⬩„⬩  
    Стоит нам указать, как становится очевидным факт, что характер человеческой истории, характер человеческого поведения и характер человеческих институтов зависят от того, что человек ·_есть_· и, в равной степени, от того, что, как мы, люди, ·_думаем_·, человек есть.  
    ⬩“⬩

    Я считаю это глубоко правдивым.

    Профессор Артур С. Эддингтон описывает эту же проблему следующими словами:

    ⬩„⬩  
    И тем не менее, говоря о природе вещей, это знание представляет собой лишь пустую оболочку – форму из символов; знание структурной формы, а не знание содержимого. Всюду по физическому миру течёт это неизвестное содержимое, которое, скорее всего, представляет собой нечто из нашего сознания. Здесь мы находим подсказку об аспектах глубокого мира физики, которых, однако, не удастся достичь методами физики. К тому же, мы выявили, что в тех областях, где наука зашла дальше всего, разум лишь вернул у природы то, что он же в неё вложил.

    Мы обнаружили странный след на побережье неизвестности. Мы разрабатывали сложные теории, одну за другой, чтобы объяснить его происхождение. Наконец, нам удалось воссоздать образ существа, которое оставило след. Оказалось, что его оставили мы сами.  
    ⬩“⬩

    Доктор Алексис Каррель сформулировал эту проблему по-другому, но не менее подходящим образом:

    ⬩„⬩  
    Чтобы развиваться дальше, человеку придётся себя переделать. Это не обойдётся без страданий, потому что человек выступает как мрамором, так и скульптором.  
    ⬩“⬩  
    ⬩»⬩

    Эти само-рефлексивные и циклические механизмы проявляются ·_уникально человеческими реакциями_·, которые сделали наши человеческие достижения возможными. Благодаря новым формулировкам мы теперь можем общим образом передавать осознанность этой особой способности с её глубокими подоплёками на всех уровнях, в том числе необразованным людям и детям, и эта осознанность может ознаменовать новый период нашей эволюции.

    История, антропология и Общая семантика позволяют заключить, что подавляющее большинство человечества жили и продолжают жить на животном биологическом уровне простого существования, не имея возможности осознать свои потенциалы. Время-связующие представляют собой не просто биологические, а психо-биологические организмы, что создаёт невероятные сложности, справляться с которыми мы пока не знаем как. Старые понятия о ‘человеке’ до сих пор в общем вели к больному и растерянному обществу. Мы не можем вести себя как конструктивные время-связующие, придерживаясь психо-логического изоляционизма, иначе мы неминуемо увязнем в асоциальной пучине конфликтов.

    Теория время-связывания и экстенсиональные методы Общей семантики подвергались практической проверке во многих научных, образовательных и административных областях. Они применялись даже на полях сражений Второй мировой войны американскими врачами, офицерами и солдатами в тысячах случаев ‘утомления боем’ ⁅посттравматического стрессового расстройства⁆ с показательными результатами. Сегодня новые методы преподают во многих школах и университетах, а учебные группы собираются на всех континентах.

    В заключение я процитирую фрагмент предисловия из третьего издания ·_Науки и здравомыслия_·:

    ⬩«⬩  
    Мы ·_можем больше не_· ослеплять себя старыми догмами: „Человеческую природу не изменить“, – потому что выяснили, что ·_можем её изменить_· \[если знаем как\]. Нам как людям следует начать осознавать свои потенциалы, и только тогда мы сможем идти к будущему с какой-то надеждой. Мы можем разделить чувства Галилея, когда он, отвергнув теорию Коперника, топнул ногой перед священной инквизицией: „·_Eppur si muove!_·“ Эволюцию человека, возможно, удастся замедлить, но остановить её не получится».  
    ⬩»⬩

    Альфред Коржибски  
    ·_Лэйквил, шт. Коннектикут, США_·  
    ·_апрель 1949 г._·

    Библиографическая справка
    -------------------------

    Я впервые выдвинул теорию время-связывания в своей книге ·_Зрелость человечности, наука и искусство Человеческой инженерии_·, опубликованной E. P. Dutton, New York, 1921; 2-е издание готовится к публикации в 1950 году издательством The International Non-aristotelian Library Publishing Company при Институте Общей семантики. Я дополнил и расширил её своей статьёй «Судьба и свобода» в журнале ·_Mathematics Teacher_·, май 1923 года, которую затем перепечатали в книге Ирвина Дж. Ли ·_Язык мудрости и глупости_· от издательства Harper, New York, 1949, статьёй «Братство Доктрин» в журнале ·_The Builder_·, апрель 1924, своими докладами, которые я прочёл на Международном съезде по математике в Торонто в 1924 году, на собрании Вашингтонского сообщества по нервным и психическим заболеваниям в 1925 года и на собрании Вашингтонского сообщества по психопатии в 1926 году, когда проводил исследования в больнице Святой Элизабет в Вашингтона.

    После длительных, обширных исследований механизмов время-связывания, эта теория достигла кульминации в книге ·_Наука и здравомыслие, введение в не-аристотелевы системы и Общую семантику_·, опубликованной издательством The International Non-aristotelian Library Publishing Company; первая публикация состоялась в 1933 году, второе издание вышло в 1941, третье в 1948; экземпляры распространял Институт Общей семантики. В этой книге я с физико-математическим подходом впервые представил новую надлежащую научную методологию для теории время-связывания, которую назвал экстенсиональным методом с очень простыми принципами.

    А. К.

    Сноски
    ------

    * * *

    1\. ⇧Я написал эту работу в 1948 году по приглашению от мистера Кришна Мангеш Талджери, м. г. н., 26, Atul Grove, New Delhi, India, в качестве вклада для симпозиума под названием ·_Вера, которой живу_·. Сборник докладов вскоре опубликуют. В него входят работы таких международных деятелей как Ганди, Неру, Монтессори, Джон Холмс, Радхакришнан и других. Без приглашения мистера Талджери и помощи мисс Шарлот Шушарт, которую я хочу поблагодарить, я бы не взялся за тяжёлую задачу формулировать такое сжатое резюме жизненных исследований и опытов, необходимое для ‘кредо.’

    * * *
""".trimIndent()