package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun prefaceToTheFirstEdition(modifier: Modifier) {
    MarkdownText(
        markdown = prefaceToTheFirstEditionText,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val prefaceToTheFirstEditionText = """
    # Предисловие к первому изданию
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    В этой книге я прежде всего провожу исследование Человека и охватываю все выдающиеся качества и проблемы Человека. Я принимаю во внимание ·_все_· характеристики, которые делают Человека тем, что он есть.

    Некоторые читатели заметят, что я не пользуюсь определёнными, знакомыми им выражениями. Это не означает, что я не испытываю чувств или не мыслю как другие люди – отнюдь. Однако в этой книге я подошёл к проблемам человека с научно-математической точки зрения и с этой целю ·_избегал_· употребления недостаточно определённых слов или слов с большим количеством значений. Я постарался как мог пользоваться такими словами, которые передают только то, что я имею в виду, и к некоторым словам, например, «духовный», я добавил «так называемый». Я это сделал не потому что верю или не верю в такие явления; я не вижу потребности в ·_вере_·, потому что подобные явления существуют, и то, что мы о них думаем, или как их называем, не имеет значения. Однако мы не определяем слово «духовный» чётко, и каждый индивидуум понимает и пользуется им ·_личным_· образом. Чтобы остаться ·_без_·личным ⁅беспристрастным⁆, мне пришлось добавить «так называемый».

    Я повторю, что следует рассматривать эту книгу не как «материалистическую» или «духовную», а как исследование «Человека», которое, следовательно, включает, как и ·_должно_· включать, как материалистические, так и духовные явления, потому что только комплекс этих явлений составляет комплекс Человека.

    Я подошёл к проблеме, исходя не из какой-либо личной доктрины или вероучения, а с математической, инженерной, нейтральной и беспристрастной точки зрения. Я считаю очевидным, что говорить о великих делах Человека – его духовных, моральных, физических, экономических, социальных и политических статусах – получится, только выяснив, что Человек собой представляет – из чего складывается его природа и по каким законам она работает. Если мы успешно выявим законы человеческой природы, остальное станет сравнительно простой задачей: этические, социальные, экономические и политические статусы Человека должны согласовываться с законами его природы. Только после, но не до, этого цивилизацию удастся сделать человеческой цивилизацией – устойчивой и мирной.

    Я не вижу смысла рассуждать о том, происходит электричество от чего-то «естественного», «·_сверх_·ъестественного», «материального» или «духовного». На деле мы не задаём таких вопросов, когда изучаем электричество, а пытаемся выявить естественные законы, управляющие им. Обращаясь с проводами под напряжением, мы не спорим и не строим о них догадки, а пользуемся изоляционными перчатками и т. д. Подобным образом дела обстоят с Человеком и его великими делами. Нам прежде всего следует узнать, что Человек есть.

    Несмотря на то, что я тщательно избегал слов или терминов с размытыми значениями, и на то, что читателю может показаться, что я сухо и прохладно критикую всё метафизическое, я не писал эту книгу с равнодушием к великому, возможно, величайшему, стремлению человека искать духовные истины, потенциалы того, что мы называем «разум», «душа» и «дух». Я писал эту книгу с глубоким желанием отыскать источник этих качеств, их научную значимость и научное обоснование, чтобы их могли рассмотреть и изучить лучшие умы мира без отклонений и ошибочных толкований, вызванных влиянием и путаницей личных эмоций. Если читатель прочтёт книгу внимательно, он увидит, что, несмотря на то, что я воспользовался проясняющим определением классов жизни за его глубокую ёмкость в ·_практическом_· мире, больше всего оно поможет в исследовании, правильной оценке и особенно в применении высших человеческих способностей.

    В этой книге я не только выдвинул новые идеи и новые методы анализа, но также писал на новом для себя языке. Оригинальная рукопись вышла сырой и малопонятной. Я благодарю своих друзей за терпение и доброту в работе над исправлением ошибок моего английского.

    Я благодарю Вальтера Полякова, доктора технических наук, за его полезные идеи. Он не только помог мне своей критикой с точки зрения инженера, но также вложил усилия в организацию первого Клуба время-связывания, где мы занимались обсуждениями и критикой релевантных вопросов, которые привели к отличным практическим результатам.

    За прочтение, критику и иную помощь с рукописью я благодарю профессоров

    Элиакима Гастингса Мура,  
    Кассия Джексона Кайзера,  
    Джеймса Харви Робинсона,  
    Бёрджеса Джонсона,  
    Эдварда Олзворта Роса,  
    Александра Петрункевича;

    докторов

    Дж. Гроув-Корски,  
    Чарльза Протеуса Штейнмеца,  
    Джеймся Питера Уорбаса;

    Роберта Б. Вулфа, вице-президента Американского общества инженеров-механиков;

    Чэмплина Л. Райли, вице-президента Американского общества инженеров в сфере отопления и кондиционирования воздуха;

    мисс Джосефин Озборн;

    авторов

    Луиса Брэндайса,  
    Эдвина Конклина,  
    Кассия Джексона Кайзера,  
    Жака Лёба,  
    Э. С. Мида,  
    Харви О’Хигинса,  
    Вальтера Полякова,  
    Джеймса Харви Робинсона,  
    Роберта Б. Вулфа;

    за разрешение их цитировать я выражаю свою искреннюю признательность.

    Я также хочу выразить глубочайшую признательность своей жене, в девичестве Майре Эджерли. Она нашла в открытии естественного закона человеческого класса жизни цель своих жизненных поисков и, проявив интерес к моей работе, оказала мне неоценимую помощь и привела ценную критику. Без её упорной работы и ·_её времени, которым она сберегла моё время_· я бы не смог написать эту книгу за такое сравнительно короткое время.

    Мистер Вальтер Поляков, промышленный консультант и инженер в Нью-Йорке, согласился представлять меня и принимать вопросы в моё отсутствие в Америке.

    Я благодарю всех остальных друзей, которые помогли мне лично. Я также хочу поблагодарить Джона Макрэя, вице-президента издательства E. P. Dutton & Co., за его исключительное отношение к публикации этой книги.

    А. К.  
    ·_17 января, 1921 г._·  
    ·_г. Нью-Йорк_·

    * * *
""".trimIndent()