package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun preface(modifier: Modifier) {
    MarkdownText(
        markdown = prefaceText,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val prefaceText = """
    # Предисловие
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Я с радостью напишу краткое предисловие к новому изданию ·_Зрелости человечности_·.

    С каждым днём проектирование и построение мира во всём мире становится всё более насущной задачей, в свете чего я считаю новое освещение идей Коржибски вместе с наглядными пояснениями Кайзера особенно востребованными.

    В основе этой книги лежит положение, что человек, существующий так же ‘естественно’ как животное, отличается в размерности. Подобно тому, как округлые сфера и окружность отличаются в своей сущности, человек отличается от животного способностью связывать не только пространство, но и время. Внушённый с детства зоологический взгляд на собственную природу склоняет человека принимать неизбежными алчность, эгоизм и соперничество.

    Изложенные взгляды этих двух одарённых проницательным умом, добрыми намерениями и широкими гуманистическими интересами мыслителей, Коржибски и Кайзера, позволяют нам обрести столь необходимое понимание сути одной из главных причин войны. Они вдохновляют и направляют наши усердные непрерывные поиски решений повсеместных остро стоящих, но с трудом постижимых проблем человеческого блага. Они оказывают нам поистине неоценимую услугу.

    Эдвард Казнер  
    ·_Колумбийский университет_·  
    ·_г. Нью-Йорк_·

    * * *
""".trimIndent()