package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun memoirs(modifier: Modifier) {
    MarkdownText(
        markdown = memoirsText,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val memoirsText = """
    # Мемуары, Альфред Коржибски и его работа
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    ·_Каждое научное открытие в некотором смысле представляет собой автобиографию человека, его осуществившего_·.

    Альфред Коржибски прибыл в Америку в декабре 1915 года. Он написал эту книгу в 1920 году, в возрасте 41 года. Насколько я знаю, она стала его первым письменным трудом, опубликованным или не опубликованным на каком-либо языке. Мне это всегда казалось значимым в отношении творческого подхода, неугасающей энергии, человеческой простоты, честности, глубины и полезности его работы и методов. За годы наблюдения за ним и его методом работы – зрительным представлением, размеренным, постепенным сведением сложнейших проблем к их базовым структурным составляющим на приземлённых, жизненных примерах – я всё меньше сомневалась в его словах:

    ⬩«⬩  
    Я молчал с младенчества. Мне нечего было сказать.  
    ⬩»⬩

    – подразумевая период перед тем, как он прибыл в Америку, сделал английский ·_своим_· языком и сформулировал своё функциональное определение человека в этой книге.

    Всю свою жизнь он смотрел на мир с широко раскрытыми глазами, размышлял над тем, что видел, спрашивал, как, почему. Он, казалось, вёл себя как одержимый страстью постигать. Он жил, изучая людей на польской земле, в европейских городах, на полях сражений восточного фронта. Он изучал историю людей по книгам и в университетах; узнавал об успехах и трагедиях цивилизаций, созданных человеком. Он спрашивал, почему так происходит и как мы можем справиться лучше в наше время.

    Он любил жизнь, музыку, поэзию чувств. Он любил математику и инженерное дело. Они сходились с фактами жизни. Пользуясь ими, избегая животных проб и ошибок, люди могли прогнозировать последствия, передавать результаты и развивать свою способность контролировать не-человеческие вещи.

    Почему так не происходило в человеческих отношениях?

    Он сформулировал своё не-словесное ‘мышление’ под впечатлениями от опыта в Первой мировой войне, в свете прибытия в эту новую страну и открытое общество, благодаря усвоению нового, подходящего для формулировки языка и под воздействием других факторов. Он по-новому сфокусировал учения и вопросы своей жизни, увидел значимость и подоплёки очевидного. Он словесно представил очевидное в своём ·_функциональном определении человека как время-связующего класса жизни_·: не того, что люди ·_есть_·, а того, что люди ·_делают_· как экспоненциальная функция времени. Он прорабатывал подоплёки очевидных характеристик человека и уникальных человеческих сред символизма и оценок всю жизнь в своих работах ·_Время-связывание, общая теория_· (1924–1926),¹ ·_Наука и здравомыслие_· (1933),² в своих поздних письменных трудах, на своих семинарах и в работе со студентами.

    Новых тиражей этой книги не печатали одиннадцать лет. В эти годы Коржибски активно занимался преподаванием в Институте Общей семантики, а число читателей ·_Науки и здравомыслия_· тем временем росло: 12 ·_сотен_· экземпляров приобрели с 1933 по 1938 год; с тех пор – 17 ·_тысяч_·. Очень многие из тех, кто прочёл ·_Науку и здравомыслие_· и изучал Общую семантику с ним в Институте, я подозреваю, никогда не держали в руках экземпляр ·_Зрелости человечности_·. Их первым знакомством с Коржибски стала ·_Наука и здравомыслие_· или чей-то ещё письменный труд об Общей семантике, и мало из них имеют понятие, что представляет термин «время-связывание» и его подоплёки. Некоторые из этих людей различным образом выражали едва заметное смущение и неспокойствие, будто их методологии не хватало важной социо-культурной составляющей, которую они ощущали, но ясное выражение которой не могли отыскать в ·_Науке и здравомыслии_·. Сам Коржибски так изобиловал значимостью время-связывания и социальными ощущениями в связи с этим новым «образом человека», что мне не верится, что он увидел эту потребность до недавних лет.

    Тем временем, запросы повторно опубликовать его первую книгу устойчиво накапливались. Он размышлял над новым введением больше трёх лет, и к своей смерти не закончил над ним работать. Как указано в части «От редактора», планирование издания завершилось, и этому второму изданию придётся выйти без его введения. К счастью, в недавнем докладе, «Во что я верю» (1948),³ Коржибски резюмировал работу своей жизни, подчеркнув ключевую роль своего определения человека как время-связующего. Этот доклад и главу профессора Кайзера о «Концепции человека Коржибски» (1922) мы уже запланировали включить. Они служат введениями, ретроспективами и современниками этой книги. Редактор, мой друг и коллега Шарлот Шушарт попросила меня добавить вступительных слов, прежде чем книга уйдёт в печать.

    Я знала Альфреда Коржибски и работала с ним пятнадцать лет, сначала в школе, где работала директором, и затем в Институте, который он учредил, и которым я имею привилегию сейчас руководить. Я многому у него училась и применяла его методологию в школе. Он переобучил меня, а я смогла составить представление о множестве аспектов его жизни, его ощущений и методов. Я также наблюдала за большинством из 1800 человек, изучавших Общую семантику с ним на Институтских семинарах.

    С годами Альфред Коржибски, его жизнь, его письменные труды, работа, которой он занимался стали для меня единым неделимым. В этих кратких мемуарах мне хочется передать какую-то часть этого уникального комплекса человека-жизни-работы и рассказать о подходе, которым, как я обнаружила, удаётся прояснить, как ‘видеть’ его работу как целое.

    Я представляю потенциальных читателей людьми в большинстве читавшими ·_Науку и здравомыслие_· и другие письменные работы о непосредственно Общей семантике. Чтобы передать кратко то, что я хочу передать этим читателям, мне придётся воспользоваться формулировками и терминологией Коржибски без объяснений. Других читателей я прошу отнестись к этому снисходительно.

    Мне кажется важным следующее: в своём определении время-связывания Коржибски провёл чёткое различие между людьми и животными, но подчеркнул ·_отличия_·, не умалив значимости схожестей (не либо-либо) – не нарушив целостность размерностной иерархии жизни. По шкале возрастающих порядков сложности амёба₁ …… Смит₁-в-западной-цивилизации⁻сегодня⁻ представляют естественные явления; отличаются не типом, а степенью сложности – рядом факторов, которые следует учитывать.

    С помощью теории время-связывания он сделал из человека, достижений людей, успехов и трагедий человеческих историй и культур что-то постижимое. Он свёл человеческие проявления к чему-то уже известному, наглядному. Он помог творческому учёному в его стремлении к объединению и упрощению положений (экономия мышления по Маху). Он сформулировал базовую теорию для основания ·_естественной_· человеческой науки, охватывающей не только биологическую, но и психо-символическую природу человека вместе с его достижениями (например, математикой, точными науками, гуманитарными науками, этикой и т. д.). Учтя требования к любой новой теории, время-связыванием Коржибски охватил все старые предположения, включил и объяснил новые или оставленные без внимания факторы, с помощью этой теории выявил и включил в неё новые факторы.

    Скептик может усомниться в этом, сказав:

    ⬩⸗⬩  
    Это не наука, а вера в чудеса.  
    ⬩⸗⬩

    Это стоит признать – возможно. Научная теория, по-видимому, может пройти испытание на ценность результатами процесса её ‘методо-логической’ разработки и эмпирической демонстрацией работоспособности выведенных из неё принципов и методов.

    Теория время-связывания неизбежно привела Коржибски к формулировке первой не-аристотелевой системы на очень простых положениях, и к формулировке ·_образа действий_· по этой системе. Этот комплекс ко-ординированных ⁅упорядоченных⁆ положений, доктрин, принципов и т. д., а также методологических процедур и техник, направленных на изменение наших невро-символических реакций с целью согласовать их с предполагаемым миром динамических процессов он назвал Общей семантикой. Он описал эту целую дисциплину как эмпирическую естественную науку и экстенсиональный метод как обобщение физико-математического ‘способа мышления’, применимого ко всем человеческим оценкам.

    Остаток жизни Коржибски провёл, занимаясь практической проверкой ценности своих формулировок и гипотез для человека.

    Удалось бы практикой Общей семантики освободить человеческие время-связующие энергии, привести к более адекватным оценкам, повысить эффективность прогнозируемости и тем самым поспособствовать здравомыслию в жизнях индивидуумов, в их ведении человеческих отношений, и, в конечном счёте, воздействию науки на общество, что привело бы к сокращению разрыва между этими темпами развития?

    До готовности опубликовать ·_Науку и здравомыслие_· он потратил на формулировки двенадцать лет. Он изучал человеческие оценки в науке и математике, и в психиатрии – «их лучшие и худшие проявления», как он это выражал – с точки зрения прогнозируемости и человеческого выживания. Он написал первый черновик ·_Науки и здравомыслия_· в 1927–28 годах; опубликовал его в 1933 году, после неустанной сверки данных, необходимых для методологического синтеза современных наук и практической проверки структурных подоплёк терминологии, которой он составил свои формулировки. Как сказал Пуанкаре:

    ⬩«⬩  
    Учёный преобразует факт, создавая язык, которым его озвучивает.  
    ⬩»⬩

    Изменения, которые Коржибски внёс в словесные формы первой книги, чтобы воспользоваться ими в ·_Науке и здравомыслии_·, представляют предмет увлекательного исследования развития его языкового ригоризма. Он назвал такую практическую проверку структурных подоплёк терминов (и формулировок) языковой совестью.

    Мало кто знает, что Коржибски собирался назвать свой главный труд ·_Время-связывание_·, но сменил название на ·_Наука и здравомыслие_· почти накануне публикации, потому что счёл, что ему следовало подчеркнуть это взаимоотношение. Он сохранил словесную последовательность от ·_Зрелости_· к ·_Науке и здравомыслию_· в названии Части Ⅶ «О механизме время-связывания». На тех страницах, 369–561, он развивает свою не-аристотелеву систему и Общую семантику. Многие читатели, видимо, упускают эту последовательность.

    По этой книге и по его ранним докладам с набросками общей теории время-связывания читатель, знакомый с ·_Наукой и здравомыслием_·, может отследить процесс методо-логической разработки с 1921 по 1933 годы. Он может увидеть, что не-аристотелева система и Общая семантика последовали из теории время-связывания так же неизбежно, как теоремы из геометрических постулатов.⁴ Он увидит, как структурный дифференциал, принцип осознанности абстрагирования, экстенсиональный метод, приёмы и т. д. вышли из теории и связанных исследований механизмов время-связывания. Он увидит, помимо иных, истоки формулировки Коржибски невро-языковых и невро-семантических сред как уникальной неотъемлемой среды, задающей реакции человека-организма-как-целого в любой культуре в любое время – инвариантное отношение.

    Формулировка невро-языковых и невро-семантических сред (и задействованных неврологических механизмов) видится мне одним из значительных и самых полезных обобщений высоких порядков Коржибски, прямо выведенных из теории время-связывания. Она служит обобщением «психо-культурного подхода» (Лоренс К. Франк, и др.) более высокого порядка. Благодаря этой формулировке мне и многим другим ученикам открылся доступ к пониманию механизмов культурной обусловленности. Я считаю, что с её помощью со временем удастся объединить и упростить положения культурной антропологии, психиатрии, психологии Павлова и Левина, эмпирические социальные науки и т. д.

    Если читатель изучил ·_Науку и здравомыслие_·, натренировал свою нервную систему с помощью техник не-аристотелевой дисциплины Общей семантики, применил её в своей жизни и работе, то он провёл собственную не-словесную демонстрацию эмпирической работоспособности системы. Он может испытать ценности, большие и малые для него, того, что вышло из теории время-связывания Коржибски, и сравнить свои оценки с тем, что сообщили другие, кто с разными степенями компетентности применяли её во множестве областей.⁵

    Если читатель только читал ·_Науку и здравомыслие_·, ‘знает’ её словесно, даже если он может слово в слово повторить все принципы и терминологию, он не сформировал твёрдых критериев своих оценок. Он может почерпнуть или не почерпнуть что-то из того, что сообщили другие, иными словами, принять их оценки, продемонстрированные на практике.

    Если ему нравится скептицизм, он в целом может без конца оспаривать как достоверность этих сообщений, так и теорий Коржибски. Он научился так поступать по аристотелевой традиции: уравнивать слова и опыт, неосознанно предполагая, что, если он знает слова, то знает ‘всё’; любое утверждение получится доказать или опровергнуть разговорами и т. д., и т. п.

    Если он обучился какой-нибудь научной специальности, в рамках которой может, или считает, что может, свести свои проблемы к двум управляемым переменным, то он может отказаться ‘принимать’ эмпирическую ценность чего-либо, в чём приходится учитывать множество переменных человеческой жизни, из-за чего у него не получится вписать это в свои формулы.

    Некоторые отзываются о работе Коржибски как «ничего нового». Другие считают её «слишком радикальной» (или слишком «ненаучной»), чтобы серьёзно «рассматривать её научно». В истории науки о новом и ни на что не похожем так отзывались нередко. ‘Философским’ или ‘научным’ скептикам, которые хотели рассуждать о его работе ·_априори_·, Коржибски любил отвечать:

    ⬩«⬩  
    Не болтай. Делай. (Это делается строго эмпирически.)  
    ⬩»⬩

    Это кратчайшим образом передаёт не-словесный характер рабочих механизмов дисциплины, его силу и трудности, с которыми Коржибски пришлось столкнуться в своей новаторской работе.

    ⬩«⬩  
    Я не знаю, давайте посмотрим!  
    ⬩»⬩

    – любил говорить он, когда сталкивался с чем-то новым. Таким взглядом он, инженер, смотрел на свои формулировки. Он относился к себе скептически как никто другой. Он знал, например, об опасностях принятия ‘логичности’ без учёта жизненных реакций. Он оставался ‘скептиком’ многие годы до тех пор, пока не ·_увидел_· (получил эмпирические свидетельства, которые его устроили⁶), что формулировки, словесные и не-словесные техники экстенсионального метода, который он разработал и продемонстрировал на своих семинарах по Общей семантике, подходили для обучения и работы – и на деле стали надлежащей научной методологией для теории время-связывания и общего образования в целях реализации человеческих время-связующих потенциалов.

    Коржибски учредил Институт в июне 1938 года. В сентябре Чемберлен посетил Мюнхен. ·_Словами_· говорили о «мире в наше время» за счёт «демократичной политики умиротворения», а по ·_фактам_· мы получили войну и больше диктатуры – что Коржибски с прискорбием спрогнозировал на своём семинаре той осенью. Доклады, которые он написал в следующие семь лет, свидетельствуют о его впечатлениях и реакциях на Вторую мировую войну в рамках его формулировок, а также о смене направления его работы. Только те, кто знал его и близко с ним сотрудничал, знают о глубине его социальных ощущений и о том, как он всей своей человечностью страдал из-за войны. Ежедневный хаос сегодняшнего дня туманит наши воспоминания о том, через что ему – и нам всем – пришлось тогда пройти.⁷

    Он основал Институт в возрасте 59 лет. Работа, которой он планировал там заниматься радикально поменяла его образ жизни. Он совершил подвиг физиологической выносливости, ‘умственной’ силы и упорства: масштабный методологический синтез, который он охватил в ·_Науке и здравомыслии_·. Изящная простота его формулировок может казаться обманчивой в оценке того, чего они ему стоили как организму.

    Впереди ждали другие подвиги выносливости. Новые условия не совсем подходили его состоянию. Помимо прочего, он больше не мог проводить длительные периоды в молчании и одиночестве, служившие обязательными условиями его творческой работы, которой он жаждал и в которой нуждался, как все мы нуждаемся в физическом комфорте. Следующие одиннадцать лет его окружали люди и давящие обстоятельства.

    Вначале в своём руководстве он уделял внимание мельчайшим составляющим работы Института. Ему приходилось непрерывно вести семинары и работать индивидуально со студентами. Он вёл горы переписки. Количество письменных работ, которые ему удалось написать в таких обстоятельствах, удивляет всех, кто знает, с какой заботой он относился ко всему, что писал для публикаций. Многие годы его не покидала надежда написать ещё одну книгу, представив не-аристотелеву систему и Общую семантику дедуктивно, как он это делал на своих семинарах.

    Ему постоянно не давали покоя недостаток денег и надёжного подспорья для продолжения работы Института, а также аномалии ситуации, в которых он не мог одобрить или принять некоторые благожелательные предложения и попытки помочь нам получить признание и поддержку.

    Например, некоторые люди хотели, чтобы он популяризовал свою работу, а именно, переписал ·_Науку и здравомыслие_· для ‘человека с улицы’ и т. д. Другие хотели, чтобы он умерил прямоту своей подачи, поменял свою теоретическую позицию и тем самым согласился на компромисс с текущими академическими и научными традициями, чтобы добиться признания в университетах и поддержки учреждениями. Ему бы пришлось слишком дорого заплатить, нарушив целостность дисциплины, чем исключить возможности продемонстрировать человеческие, научные ценности методологии Общей семантики чётко обозначенными применениями и впоследствии сопоставить их с результатами преобладающих методов.

    Ему пришлось работать вне институциональной ‘зоны безопасности’, понимая, что этим он ставил себя в невыгодное положение. Люди, которых, по-видимому, не волновала научная целостность дисциплины, выбирали пути полегче и не понимали его позицию; они называли её мономанией, сектантством, завистью и т. д. Его это печалило и раздражало. Ему своя позиция казалась настолько простой, что её удалось бы свести к высказыванию:

      
    ⬩⸗⬩  
    Давайте придерживаться своих положений. Если мы вознамерились решить задачу с помощью не-эвклидовой геометрии, то мы не переходим на эвклидовы постулаты. Так мы лишь устроим бардак. Нам следует поступать честно, придерживаться метода, с которого начали, а затем сверять результаты. Какой из них лучше сходится с фактами, какой даёт больше прогнозируемости в том, чем собрались заниматься?  
    ⬩⸗⬩

    Институт служил Коржибски школой и лабораторией. На семинарах он как обучал, так и изучал студентов. Он погружался в практическую проверку своей работы с не меньшим пристрастием, чем в её формулировку. Каждый семинар включал от 30 до 50 часов активных лекций; на некоторых интенсивных курсах этим приходилось заниматься по восемь часов в день. Семинар также включал часы персональной работы с каждым из 40-50 студентов. Он проводил семинар за семинаром, год за годом. Его выносливость казалась неиссякаемой. Результаты, которые он видел в жизни и работе сотен этих студентов, и в их докладах за эти годы, служили не только эмпирическими свидетельствами тому, что его формулировки действительно работали, но и поводом для радости в эти тяжёлые Институтские годы.

    Он вёл лекции в своём особенном стиле – нелинейным методом раскрывая не-аристотелевы ориентирования, описывая витки расширяющейся спирали, останавливаясь, чтобы рассмотреть пример, который он привёл в начале, чтобы показать механизм на следующих лекциях. Он приводил шокирующие примеры из своих исследований в психиатрических больницах, из материалов по психиатрии, из собственного опыта с серьёзно дезадаптированными людьми, преступниками и т. д., чтобы (как он говорил) «забраться под кожу» учащимся, встряхнуть их. Он приводил примеры из повседневной жизни, из истории науки, из математики. Иногда он говорил красиво, вкрадчиво – иногда шутил и резко менял темы. Нередко лицом и руками он передавал не меньше, чем словами и диаграммами.

    Один работник образования назвал его самым способным и эффективным преподавателем, из тех, что он знал, мастером педагогики. Другой называл его худшим и говорил, что ему стоит изучать педагогику. Люди редко реагировали нейтрально на него, на то, что он делал и на то, как он это делал. Чем больше он расшатывал их самоуверенность, вызывал дискомфорт, «втирая» метод, тем больше они учились. Он уверял, что на семинар мог записаться любой желающий,

    ⬩«⬩  
    Потому общий метод оценки должен работать для всех, во всякой человеческой деятельности, иначе он не годится.  
    ⬩»⬩

    Профессора, доктора, психиатры, артисты, учёные, молодые студенты колледжей, бизнесмены, социальные работники, разнорабочие и т. д. – все сидели в одном классе. Звучит хаотично, но работало это эффективно.

    На личных собеседованиях он показывал индивидуумам, как применять методологию в анализе и пере-оценке своей личной жизни и проблем; он учил их постоянно подвергать сомнению свои рационализации и т. д. Эти личные применения, как он настаивал, следует ставить в высший приоритет. Студенту следует строго, на постоянной основе применять экстенсиональный метод в своей личной жизни, и только так он выработает твёрдую основу для успешной работы с «безличными» ⁅беспристрастными⁆ проблемами – человеческими отношениями, методологическими проблемами в своей работе в любой области, будь то наука, искусство, медицина, образование, бизнес и т. д.

    Один психиатр сказал:

    ⬩«⬩  
    Коржибски в своей работе выявляет „культурное бессознательное“ и делает его сознательным. \[Иными словами, он меняет не-осознанные предположения о мире, о человеке, привносимые в структуру языка, взгляды, оценочные суждения, ‘режимы мышления’, выученные в наших невро-языковых и невро-семантических средах.\] В психотерапии мы делаем ‘то же’ с личным бессознательным – особым случаем культурного.  
    ⬩«⬩

    Некоторым нравится называть эти семинары школой мудрости.

    ⬩«⬩  
    Возможно,  
    ⬩»⬩

    – говорил Коржибски, –

    ⬩«⬩  
    но мудрости не хватает.

    Огромное её количество существует в этом мире тысячелетиями, и что?

    Одна только мудрость не работает. Вам не обойтись без метода её постоянного применения.  
    ⬩»⬩

    Значительное число тех, кто провёл около 56 семинаров с Коржибски, извлекли и продолжают извлекать пользу разной степени из этого обучения.

    Он испытывал и неудачи.

    ⬩«⬩  
    Десять процентов каждого класса ничего не получили. Некоторые из них стали мне врагами пожизненно.  
    ⬩»⬩

    (Когда кто-то затрагивает базовые словесные формы, по которым индивидуум составляет свой жизненный сценарий, прямой взгляд на них может вызывать слишком сильное беспокойство.)

    Некоторые ‘ухватили’ дисциплину так же легко, как откатились обратно к старым привычкам мышления-ощущения. Они пользуются словами, но не методом.

    ⬩«⬩  
    Они ‘отказались’ над собой работать.  
    ⬩»⬩

    Те, кто усвоили Общую семантику ‘интеллектуально’ (словесно, ‘корой’), знали все принципы, терминологию и техники, но не могли их собственно применять, менять свои оценки, живые реакции. Другим дисциплина ‘давалась’ медленно, годами. Она, по-видимому, не произвела никакого эффекта на их жизни, работу, но потом – что-то случилось. Для меня это много что показывает, поэтому я хочу процитировать письмо, которое Коржибски в апреле 1950 года написал один психиатр-исследователь, которому на тот момент ещё не сообщили о его смерти:

    ⬩«⬩  
    Уважаемый Граф Альфред,

    Я думаю, мне следует принести вам свои извинения, поблагодарить вас и объясниться. Как вы помните, я впервые узнал об Общей семантике летом 1939 года. Тогда ваш и мой хороший друг доктор \_\_\_\_\_\_ \[покойный\] … привёл меня на ваш семинар. У меня получилось ‘ухватить’ корковый аспект \[словесный\], но по каким-то причинам таламическая часть \[изменения в жизни, ощущениях\], по-видимому, прошла мимо. Однако за последний месяц что-то произошло. Я впервые начинаю ‘ощущать’, что Общая семантика даёт мне что-то нужное и полезное. Объяснить я это не могу; я лишь могу предложить вам ответ своего сынишки (почти три года отроду) на вопрос, почему он делает то или это; он просто говорит: „Ну, я это сделал“.

    Я просто хотел дать вам знать, что иногда требуется некоторое время, чтобы что-то усвоилось.

    С семантически уважением  
    ⬩»⬩

    Коржибски провёл свой последний семинар с 27-го декабря по 4 января 1950 года. Большой запас физиологической выносливости иссякал. Он уже не ходил по платформе, помахивая своей тростью. Он вёл лекцию всё так же бодро и ‘мыслил’ так же творчески. В январе и феврале он написал свой последний научный доклад для Симпозиума по клинической психологии о восприятии в Техасском университете.⁸

    Так случилось, что обстоятельства его смерти стали символическими относительно его жизни и работы. Он демонстрировал удивительную способность интересоваться любым индивидуальным образцом человечности перед ним. Он постоянно поддерживал осознанность, что какая-нибудь инфантильная оценка, которую он пытался изменить в индивидууме, отражала симптом социального синдрома. Он провёл последние несколько часов жизни за своим столом, работая над одной из таких проблем.

    По его не-элементалистическому ориентированию, индивидуума ·_и_· общество отделяли друг от друга только для удобства. Эмпирически их удалось бы разделить не легче, чем пространство ·_и_· время, сознание ·_и_· тело, наследственность ·_и_· среду и т. д.

    Он не считал никакие человеческие проблемы ‘незначительными’. Отсюда и упорство, теплота социальных ощущений, щедрая, даже расточительная, трата сил. Он умер первого марта в три часа утра, прожив 70 лет, 7 месяцев и 29 дней.

    В одном смысле, мы можем сказать, что он ‘закончил’ свою работу. В другом, едва начал. Он закончил её в том смысле, что выполнил требования, которые, вероятно, сам себе установил, когда написал эту книгу в 1921 году, с точки зрения теории, индуктивного и дедуктивного методов и эмпирической проверки до значимой степени (страница ⅹⅼⅳ).

    Наша будущая работа требует больше совместных усилий. С методологическим синтезом, необходимым для развития наших знаний о человеке-как-целом-в-его-средах, для их применения в науке и образовании, исследованиях и практике, справился один мозг. Ценность его применения продемонстрировал сам Коржибски и достаточное число индивидуумов, обученных не-аристотелевой дисциплине. Вместе эти люди представляют срез человеческой деятельности и проблем – теорию и практику в точных и гуманитарных науках, образовании, промышленности, общественной жизни и т. д. На данную дату их усилия обладают общими характеристиками. Их предприняли храбрые индивидуумы как индивидуумы, которые выработали навыки взаимодействия с индивидуальными ситуациями. Этих индивидуумов отделяли друг от друга расстояния и менее осязаемые факторы. Прокладывать пути дисциплины вынужденно пришлось в аморфной атмосфере. Чтобы двигаться вперёд, нам потребуется объединить усилия. Нам требуется не меньше спонтанности, а больше согласованности относительно основ, направлений. Нам требуется взаимо-дисциплинированное сотрудничество и механизм для работы в группах. Поддержание такого направления развития теперь становится функцией и целью Института как центра не-аристотелева обучения и работы. За счёт этого время-связующие усилия продолжат жить и расти.

    За свою жизнь он написал две книги и 22 короткие работы. Сложенные вместе они составляют ровно 4½ дюйма экстра-неврального пространства. На данную дату я сомневаюсь, что кого-то интересует мера работы Коржибски, его влияние и диапазон в наше время. Те, кто знают эти работы, могут согласиться со мной в том, что редко, если вообще, в человеческой истории так мало представляло так много для человеческого понимания и развития.

    Переиздание этой книги с включением раннего отзыва профессора Кайзера о значимости время-связывания, а также трёх недавних работ Коржибски может стать первым шагом к выпутыванию значений его работы как научной дисциплины из клубка узких пониманий и недо-пониманий, сложившихся в силу некоторых методологических неизбежностей, уклонов и случайностей в истории её развития.

    Эти и другие факторы привели к тому, что его имя связали с языком и коммуникацией, исключив другие аспекты его работы в научных и образовательных кругах, а также со словом «семантика» в его нынешней популярной практике употребления. Так возникают искусственные препятствия, которые вкупе с присущей трудностью перехода к новым положениям, не-аристотелевым ориентированиям и т. д., не дают ‘увидеть’ его работу как-целое в должной перспективе.

    По моим ощущениям, «климат мнений» в культурной антропологии, психосоматической медицине, психологиях, гуманитарных науках и т. д. постепенно меняется в не-аристотелеву сторону, к не-элементалистическим ‘концепциям’ человека в обществе. Возможно, теперь некоторые деятели этих дисциплин подошли к тому, чтобы взглянуть на работу Коржибски как на целое, принять его смелые гипотезы и методологию для дальнейшей проверки. Все его письменные труды стали доступны, и студенты могут отследить развитие его рассуждений в исторической последовательности. Их скромный объём может поспособствовать исследованиям, – и повторным исследованиям – особенно, я надеюсь, обществоведами и работниками образования.

    В труде, следующем за этими мемуарами, который Коржибски написал в 1947 и 1948 годах, он кратко передал работу своей жизни, свои выводы и надежды весьма уникальным образом. На этих страницах читается «завещание» Коржибски – напутствие труженикам всех наук и искусств ⁅ремёсел⁆, которых волнует человеческое благополучие. Я смотрю на него как на задачу и программу для будущих деятелей, одарённых творческим воображением, которые воспользуются основами, оставленными нам Коржибски во время-связывании, не-аристотелевой системой и Общей семантикой, переформулируют теории и практики своих специальностей, обобщат их в «науку науки» высокого порядка, – или, если хотите, в междисциплинарную дисциплину – чтобы охватить целое человеческой жизни и потенциалы время-связывания. Я заглядываю очень далеко вперёд – на двадцать пять, возможно, на пятьдесят лет.

    Чтение этой книги в первый раз будто бы позволяет ясно взглянуть на человека и человеческую историю, впервые за всю жизнь сняв очки с кривыми линзами. Ощущается снятие прежде не-осознанных напряжений. Появляется надежда. Смелость и простота подхода Коржибски, которым он прокладывал путь через вековые проблемы к свежему, новому способу смотреть на ‘человека’, поражают больше, а не меньше, по прошествии времени. Мы так много узнали о ‘человеке’ и ‘обществе’ – и так мало с ними сделали – с тех пор как он написал эту книгу. Если не обращать внимания на упоминания событий, которые ставят эту книгу в социо-экономически-научный контекст послевоенного 1920 года, может показаться, что её написали в прошлом году.

    Сказать, что этот человек опередил своё время, не требует труда и оригинальности. Мне, тем не менее, кажется, что только сейчас, тридцать лет спустя, мы можем с готовностью принять значимость этой книги.

    Марджери Кендиг  
    ·_Институт общей семантики_·  
    ·_Лэйквил, шт. Коннектикут_·  
    ·_11 мая 1950 г._·

    Сноски
    ------

    1\. ⇧·_Время-связывание, общая теория_·, 1924 и ·_Время-связывание, общая теория (второй доклад)_·, 1926 опубликованы в сборнике ·_Альфред Коржибски, Собрание письменных трудов, 1920–1950_·.

    2\. ⇧·_Наука и здравомыслие, введение в не-аристотелевы системы и Общую семантику_·, 1933.

    3\. ⇧Следует по оглавлению.

    4\. ⇧Подробнее об этих разработках вы можете узнать из двух докладов профессора Оливера Л. Райзера ⁅Oliver L. Reiser⁆ “Historical-Cultural Significance of Non-Aristotelian Movement and the Methodological Contributions of Korzybski” (сс. 3–10) и “From Classical Physical to Modern Scientific Assumptions” (сс. 67–78) в сборнике ·_Доклады со второго американского съезда по Общей семантике_· под редакцией М. Кендиг (Чикаго: Институт общей семантики, 1943).

    5\. ⇧См., например, ·_Доклады со второго американского съезда по Общей семантике_·, указ. соч; доклады в списке публикаций Института общей семантики; другие доклады для «Членов Института» и недавно учреждённый журнал ·_General Semantics Bulletin_·, публикуемый Институтов для его членов.

    6\. ⇧В большинстве вопросов уникально человеческой значимости нам приходится довольствоваться наблюдениями явлений, которые не получается численно измерить на 1950 год.

    7\. ⇧Знаменитые ·_слова_· о годах военных сражений пробуждают во мне ясные воспоминания. Я говорю о записи ⁅военной хроники⁆ “I Can Hear It Now”. За полчаса записи чуткий читатель может пережить события, в окружении которых Коржибски занимался работой первые шесть лет существования Института. “I Can Hear It Now”, Volume 1, edited by Edward R. Murrow (Columbia Masterworks ML4095, Long Playing; also on standard records).

    8\. ⇧Clinical Psychology Symposium 1949–50 on ·_Perception: An Approach to Personality_·, организованный кафедрой психологии в Техасском университете под руководством доктора Роберта Р. Блэйка и доктора Глена В. Рэмзи. Планируется публикация изданием Ronald Press, New York. Название доклада Коржибски: “Functional Determinants of Perceptual Processes: Language; a) The Effect on Perceptual Processes of the Language System, b) Aristotelian and Non-aristotelian Language Systems.”

    * * *
""".trimIndent()