package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun lection(modifier: Modifier) {
    MarkdownText(
        markdown = lection_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val lection_text = """
    # Лекция XX
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    КАССИЙ ДЖЕКСОН КАЙЗЕР  
    ЛЕКЦИЯ ⅩⅩ  
    из книги  
    ⬩**МАТЕМАТИЧЕСКАЯ ФИЛОСОФИЯ**⬩[¹](https://teletype.in/@czoc/GN-d8mumEti#TETg)  
    1922  
    КОНЦЕПЦИЯ ЧЕЛОВЕКА КОРЖИБСКИ

    ⬩**ЛЕКЦИЯ ⅩⅩ**⬩  
    Концепция Человека Коржибски[²](https://teletype.in/@czoc/GN-d8mumEti#zn3R)

    ЧТО ОЗНАЧАЕТ ВРЕМЯ-СВЯЗЫВАНИЕ — РАЗМЕРНОСТЬ И МАТЕМАТИЧЕСКАЯ ТЕОРИЯ ЛОГИЧЕСКИХ ТИПОВ — ЕСТЕСТВЕННЫЙ ЗАКОН ЦИВИЛИЗАЦИИ КАК РАСТУЩАЯ ЭКСПОНЕНЦИАЛЬНАЯ ФУНКЦИЯ ВРЕМЕНИ — ЧЕЛОВЕЧЕСКАЯ ЭТИКА КАК ВРЕМЯ-СВЯЗУЮЩАЯ ЭТИКА, НЕЖЕЛИ ПРОСТРАНСТВО-СВЯЗУЮЩАЯ ЭТИКА ЖИВОТНЫХ.

    Несколько лет назад наши жизни окружила цивилизация настолько богатая и удобная в многообразии аспектов, настолько вездесущая и переплетённая со всей нашей средой, что мы о ней не задумывались, а привычно принимали как данное, как мы это делаем с великими дарами Природы – с землёй и морем, светом, небом и воздухом. Мы едва ли осознавали, что Цивилизация буквально представляет собой результат человеческого труда и ·_времени_·. Мы не думали глубоко о принципах её происхождения и не брались основательно искать законы её развития. Нас не учили размышлять о том, что мы – те, кто пользуется ей – не произвели её и не заслужили её блага. Мы не уяснили, что принимаем её практически полностью как дар времени и труда ушедших поколений. Мы не научились испытывать важнейшую ответственность за это великое наследие, которую несём как потомки умерших и как предки ещё не рождённых. Мы родились посреди великой цивилизации, жили, размножались в ней и благодаря ей как бабочки в цветочном саду, если не сказать «как личинки в куске сыра».

    С тех пор настали перемены. Первая мировая война, грубо, но действенно, пробудила нас. Теперь всюду мужчины и женщины размышляют как не размышляли никогда о положении дел, потому что знают, что иного способа решить проблемы, одолевшие мир, нет. Они также узнали, что больше остального имеет значение Человек, в связи с чем те мужчины и женщины повсеместно задают вопросы именно о Человеке: вопросы этики, социальных организаций, образования, экономики, философии, промышленных методов, политики и управления. Эти вопросы ведут к любопытным результатам: к тревожным доктринам, пугающим предложениям; мы склонны называть их радикальными, революционными, красными.

    Действительно мы размышляем слишком радикально?

    Этот вопрос заставил бы Платона улыбнуться – Платона, который видел, как его уважаемому учителю желали смерти за радикальную критику. Нет; в должном смысле этого весьма опошленного термина, мы размышляем недостаточно радикально. Мы охотно задаём множество разных вопросов, но не углубляемся в них. Мы делаем это пристрастно и смело, но поверхностно. Если бы мы делали это глубоко, то не смогли бы не спросить о том, о чём спросить не смогли:

    Что очеловечивает людей?  
    Какое место занимает человеческое существо в иерархии жизни этого мира?  
    Что ·_есть_· Человек?

    Я называл этот вопрос фундаментальным, и он действительно фундаментален, – мы придаём высшую важность правильному ответу – потому что ясно видим по указанию на факт, что характер человеческой истории, человеческого поведения и всех человеческих организаций зависит от того, что человек ·_есть_· и в равной или большей мере от того, что мы люди ·_думаем_·, человек есть.

    Почему же тогда мы не задали этот вопрос?

    Несомненно, потому что мы осознанно или неосознанно принимали как данное то, что всегда знали ответ.

    Зачем спрашивать, когда мы уверены, что знаем?

    А знаем ли мы?  
    Оправдано ли предполагаем, что знаем?  
    Действительно ли мы знали и знаем ли сейчас, в чём заключается особенность человеческого класса жизни?  
    Знаем ли мы критически, что мы, человеческие представители, на деле собой представляем?

    Здесь необходимо прояснить, о каком знании мы говорим. Существует инстинктивное знание – прямое внутреннее знание, происходящее инстинктивно. Такое знание мы имеем в виду, когда говорим, что знаем, как шевелить руками, или что рыба знает, как плавать, или птица знает, как летать. Я не сомневаюсь, что в этом смысле знания мы знаем, что есть человек. Подобным знанием рыба знает, что есть рыбы, а птица знает, что есть птицы.

    Существует, однако, другое знание – научное; знание об объектах посредством их анализа; объективное знание по концепциям ⁅представлениям⁆; концептуальное знание об объектах. Такое знание мы имеем в виду, когда говорим, что знаем или не знаем, что есть растение, или что есть число.

    Мы не предполагаем, что рыба обладает знаниями такого толка. Мы не предполагаем, что птица может составить правильную, или вообще какую-либо, концепцию того, что есть птица. Мы говорим о концепциях, и вопрос по теме у нас следующий:

    Есть ли у нас, людей, правильная концепция Человека?

    Если есть, то мы разумно можем предположить, что унаследовали её, потому что такая важная вещь – если она появилась в наше время – стала бы серьёзным открытием, несомненно, давшем о себе услышать. Если у нас есть правильная концепция человека, она бы снизошла на нас вплетённой в наши унаследованные и впитанные из общей атмосферы мнения.

    Если мы обнаружим, что никогда не составляли правильной концепции человека, нам не стоит сильно удивляться, потому что трудность такой задачи представляется уникальной. Человек здесь оказывается как познающим, так и познаваемым. Для того чтобы вывести правильную концепцию того, что есть объект, познающему придётся себя объективировать.

    Говоря с перспективы нашего времени о том, что мы не задавали этого важного вопроса, я укажу на одно важное исключение – насколько я знаю, единственное существующее.[³](https://teletype.in/@czoc/GN-d8mumEti#mZhZ) Я говорю о графе Альфреде Коржибски, польском инженере. В своей эпохальной книге (·_Зрелость человечности, наука и искусство Человеческой инженерии_·[⁴](https://teletype.in/@czoc/GN-d8mumEti#vKsO)) он не только вынес вопрос на обсуждение, но и предложил ответ, заслуживающий серьёзного внимания любого серьёзно настроенного студента, независимо от его области исследований. В этой лекции я ставлю цель представить этот ответ и рассмотреть его с помощью теории логических типов, теории классов и близкого автору понятия «измерений».

    Я скажу сразу, что вдумчивому читателю следует подготовиться, чтобы совладать с центральной ·_концепцией_· – концепцией, роль которой среди других идей в этой работе я могу сравнить с таковой солнца в солнечной системе. Поэтому читатели этой книги – как любой другой, написанной вокруг центральной концепции – скорее всего окажутся в одном из трёх взаимоисключающих классов:

    Ⅰ · Класс тех, кто ·_упускают_· центральную концепцию – как один мой знакомый просвещённый историк – не от недостатка благожелательности, а из-за нехватки навыков концептуального мышления, кроме тех, которыми владеет большинство.

    Ⅱ · Класс тех, кто, ·_по-видимому_·, схватывают центральную концепцию, после чего своеобразием своего разговора демонстрируют, что её не ухватили, а в лучшем случае зацепили из неё несколько слов. Интеллектуально такие читатели напоминают знакомый нам тип студента, который «заваливает» экзамен по математике, но может кое как со второй попытки пересдать, поэтому после дополнительных занятий ему разрешают попробовать ещё раз.

    Ⅲ · Класс тех, кто хорошо понимают центральную концепцию и, поразмышляв над ней, видят яснее и яснее широченный охват её подоплёк. Если бы не этот класс, в мире бы не существовало ни науки, ни настоящей философии.

    Представители двух других классов не осознают, что занимаются попросту болтовнёй. К таким людям правомерно применимы формулировки школы «бихевиористов», потому что в психологии классов Ⅰ и Ⅱ глава «Мыслительные процессы» не требуется – хватит главы о «Языковой привычке».

    В чём заключается эта центральная концепция?  
    В чём заключается концепция Человека Коржибски?

    Я хочу представить её настолько ясно, насколько могу. В этой концепции мы определяем человека с точки зрения Времени. «Человечество», – говорит автор, – «представляет собой ·_время-связующий_· класс жизни».

    Что он имеет в виду под этими словами?  
    Что он имеет в виду под «время-связыванием» или «связыванием времени»?

    Значение – поистине эпохальное – станет яснее. Нам стоит немного поразмыслить, чтобы к этому подготовиться.

    Давным давно на Земле появились – неважно как – первые представители человечества.

    В каких условиях они существовали?

    Чтобы это представить, потребуется применить воображение. Знаниями – в смысле, в котором мы, люди, употребляем этот термин – они не обладали совсем. У них не было ни науки, ни философии, ни ремёсел, ни религии. Они не знали, что собой представляли и где находились. Они ничего не знали о прошлом, потому что не прошли никакую историю и не нажили традиций. Они не умели прогнозировать будущее, потому что ничего не знали о законах природы. У них не было капитала, – материального или духовного блага – не было наследия, созданного временем и трудом ушедших поколений. Они жили без инструментов, без прецедентов, без заветов, без речи и без какого-либо света человеческого опыта. Их невежество – при том, как мы понимаем этот термин – близилось к абсолютному.

    И тем не менее, в сравнении со зверями, они представляли собой чудеса гения, потому что им удалось осуществить самое удивительное на нашей Земле – они ·_привели в действие_· творческое движение, которое их далёкие потомки называют цивилизацией.

    Как?  
    В чём секрет?  
    Вы когда-нибудь пытались выяснить?

    Секрет состоит в том, что наши похожие на животных предки стали существами ·_нового вида_· в мире. Нового за счёт своего странного дара – странной новой ·_энергии_·, которая действует в мире сегодня.

    Что это?

    Мы знаем частично благодаря её эффектам и частично, потому что ощущаем её внутри себя. Все мы, люди, Человеческие представители, обладаем ей в какой-то мере. Этой энергией мы изобретаем – производим инструменты, идеи, учреждения и доктрины. Этой же энергией мы по изобретению критикуем, после чего снова изобретаем, только ·_лучше_·, чем совершенствуемся от одного творения к другому без конца. Поразмыслите и поразмыслите снова над значимостью этих простых слов:

    изобретаем; по изобретению критикуем; снова изобретаем, но лучше; тем совершенствуемся творческой деятельностью от одной вехи к другой без конца.

    Они звучат знакомо, но какой смысл мы им придаём?

    Здесь обязательно следует прерваться, уединиться и в тишине глубоко подумать над их значением. Эти слова не описывают жизнь зверей. Они характеризуют Человека.

    Мы говорим об особенной, ·_цивилизующей_·, странной, знакомой энергии, которая делает возможным и действительным великое творческое движение, которое мы называем человеческим ·_Прогрессом_·, о коем говорим постоянно, но не думаем почти никогда. Нам следует рассмотреть её внимательнее – обнажить её характерное отношение ко Времени, потому её отношение ко Времени – это отношение Времени к жизни, характерной для Человека.

    Сравните представителя животного мира, например, бобра, с представителем человека. Рассмотрите их достижения и способы таковых. Бобр строит плотину, человек строит мост или приходит к научному открытию, например аналитической геометрии, печати, законам движения небесных тел или атомному строению материи. Эти два достижения – одно бобра, другое человека – представляют собой следствия трёх факторов: времени, труда и сырого материала, где последний означает, в случае чисто научного достижения, данные чувств, из которых наука выросла. Оба достижения ·_выживают_·, что может длиться некоторое время – как в случае плотины или моста – или одно из них может выживать вечно – как в случае научного открытия.

    Что происходит в следующем поколении?

    Следующий бобр начинает там, где начинал его предшественник и заканчивает там, где он закончил – плотина остаётся плотиной, едва отличимой от старой. Старая плотина, тем временем, остаётся там, где следующий бобр может увидеть, поразмышлять над ней и улучшить, но она не вызывает у него никаких импульсов изобретательности или творческих порывов; улучшений – прогресса – не следует.

    Почему нет?

    Ответ очевиден: бобровый «разум» работает ·_так_·, ·_что_· наличие достижения прошлого ·_не способствует_· его способности достигать. Время следующего бобра пересекается частично или полностью со временем его предшественника. Прежнее время присутствует как неотъемлемый фактор прежней плотины, но этот фактор прежнего времени, невзирая на своё присутствие, подобно мёртвому капиталу ·_ничего не производит_·.

    Вот так «разум» бобра – ·_животный_· разум – относится ко времени.

    А как обстоят дела у следующего ·_человека_·?  
    Что ·_он делает_·?

    То, что он делает, зависит, конечно, от достижений его предшественника. Если предшественник построил мост, последователь строит мост лучше или изобретает судно. Если предшественник разработал аналитическую геометрию, последователь расширяет её или изобретает математический анализ. Если предшественник изобрёл печать, последователь изобретает книгопечатный станок. Если предшественник выявил законы движения небесных тел, последователь выводит закон притяжения. Если предшественник открывает атомное строение материи, последователь открывает электронное строение атома.

    Так идёт знакомая нам история – ·_совершенствование_· старого, ·_изобретение_· нового – ·_Прогресс_·.

    Каким образом?

    Ответ, вновь, очевиден: разум человека, в отличие от животного «разума», работает ·_так_·, ·_что_· достижения прошлого ·_способствуют_· его способности достигать. Как в случае бобра, так и человека, время последователя пересекается со временем предшественника, потому что последнее продолжает присутствовать как неотъемлемый фактор прежнего достижения, которое выживает. Однако – и в этом суть – в случае человека, в отличие от бобра, фактор прежнего ·_времени_· не просто присутствует – он ·_работает_·. Он не существует как мёртвый капитал, который не приносит накопительной пользы и, в конечном счёте, увядает. Этот капитал живёт, приносит пользу, которая постоянно накапливается растущими темпами. Растёт благо – материальное и духовное; не только физические удобства, а инструменты возможностей, понимания, разума, знаний и навыков, прекрасных искусств, науки, философии, мудрости, свободы – одним словом, Цивилизации.

    Этот великий процесс, – в котором действует какая-то пока непонятная нам изощрённая алхимия – за счёт которого фактор ·_времени_·, воплощённый в осуществлениях, постоянно и по нарастающей способствует потенциалу достижений человеческого разума; процесс, которым таинственное Время непрерывно и по нарастающей множит цивилизующую энергию мира; процесс, в связи с которым эволюция цивилизации зависит от спирального накопления времени – этот грандиозный процесс Коржибски обозначает термином «время-связывание».

    Я продолжу пользоваться этим термином часто в этом обсуждении, поэтому рекомендую задержать внимание на его значении, как я его привёл, до тех пор пока вы его чётко не уясните. Время-связующую способность мы видим не только как уникально человеческую, но и, среди его других отличительных признаков, вне всякого сравнения, как самую значимую. Именно поэтому автор ·_определяет_· человечество как «время-связующий класс жизни».

    Так Коржибски отвечает на важнейший из всех вопрос:

    Что есть Человек?

    Не забывайте, что мы здесь имеем дело с ·_концепцией_·, и что по ней мы определяем человека тем, в каком отношении он состоит со временем. Называя это отношение характерно человеческим, я имею в виду, что среди классов жизни в нём состоит человек и только человек. Животные в нём не состоят или, если и состоят и обладают за счёт него время-связующими способностями, то реализуют его в настолько малозначительной степени, что мы можем им пренебречь, как математики пренебрегают инфинитезимальными высоких порядков.

    К такому ответу мир не привык.

    Если последовать мысли прошедших веков или философиям, царствующим в наше время, к какому ответу мы придём?

    К одному или другому:

    1 · К ·_зоологическому_· ответу – человек есть животное; разновидность животного, ·_bête humaine_· ⁅зверь в человеческом обличии⁆.  
    2 · К ·мифологическому· ответу – человек есть таинственное сочетание или ·_единство_· животного (чего-то естественного) с чем-то «сверхъестественным».

    Такие две концепции конкурируют в мире сегодня. Некоторые из нас придерживаются первой, некоторые второй, и некоторые, несомненно, придерживаются обеих, потому что, их несовместимость не мешает им крепко усваиваться в одном мозге.

    Концепция человека Коржибски верна и важна – всецело верна и неизмеримо важна. Поразмыслив над ней, я не нашёл причин в этом сомневаться. Автор, однако, не довольствуется одним лишь представлением этой концепции, а идёт значительно дальше. Он открыто отвергает зоологическую концепцию и её векового конкурента мифологическую концепцию, высказываясь против них как ложных по фактам и зловредных по своим эффектам.

    Почему ложных?  
    В чём?

    Давайте сначала разберёмся с зоологической или биологической концепцией.

    Природные явления следует постигать и определять согласно фактам, выявленным наблюдениями и анализом. Автор рассматривает явления, которые называет классами жизни мира: растения, животные и люди. Он задаёт вопрос:

    Какие значимые факты мы у них наблюдаем; какие самые заметные отношения, отличительные признаки, положительные и отрицательные?

    На него он даёт следующий ответ:

    Растения больше всего положительно выдаются своей способностью «связывать» базовые энергии мира – вбирать, преобразовывать и усваивать энергии солнца, почвы, воды и воздуха. У них, однако, отсутствует ·_автономная_· способность передвигаться в пространстве, что мы относим к отрицательному признаку растений. Растения мы называем химио-связующим классом жизни. В этом ·_названии_· подразумевается только положительный признак, но следует обязательно учесть, что ·_определение_· класса основывается на положительном и отрицательном признаках вместе.

    Как обстоят дела у животных?

    Они, как растения, вбирают, преобразуют и усваивают базовые энергии солнца, почвы, воды и воздуха, принимая их значительной частью уже преобразованными растениями. Однако эта способность животных связывать базовые энергии – положительный из двух отличительный признак растений – не служит ·_определяющим_· признаком животных. ·_Положительный_· определяющий признак животных мы видим в их автономной способности передвигаться[⁵](https://teletype.in/@czoc/GN-d8mumEti#Xk2y) в пространстве, – ползать, бегать, летать, плавать – которая позволяет им освобождать одно место, чтобы занять другое, за счёт чего собирать природные плоды разных местностей. Этот положительный признак составляет отношение животных к ·_пространству_·. Их отношение ко ·_времени_· мы относим к отрицательным признакам – у животных отсутствует способность связывать время. По положительному признаку мы называем животных пространство-связующим классом жизни, но следует, вновь, заметить, что определение выводится при учёте положительного и отрицательного признака в сочетании.

    Наконец, как обстоят дела у человека?

    Мы уже узнали ответ. Человечество представляет время-связующий класс жизни. Для ясности, нам стоит резюмировать эти концепции, или определения:

    Растение представляет собой живое существо, обладающее способностью связывать базовые энергии, и не имеющее автономной способности передвигаться в пространстве.

    Животное представляет собой живое существо, обладающее автономной способностью передвигаться в пространстве, и не имеющее способности связывать время.

    Человек представляет собой живое существо, обладающее время-связующей способностью.

    Заметим, что по этой формулировке классы жизни мира образуют иерархию по принципу, который Коржибски называет жизне-измерениями или размерностью, следующим образом:

    Растения, связующие базовые энергии, относятся к низшему уровню или типу жизни и составляют жизне-измерение ·_Ⅰ_·.

    Животные, или пространство-связующие, относятся к следующему более высокому уровню или типу жизни и составляют жизне-измерение ·_Ⅱ_·.

    Люди, или время-связующие, относятся к ещё более высокому уровню или типу жизни и составляют жизне-измерение ·_Ⅲ_·.

    Существует ли ещё более высокий класс жизни, мы не знаем, и поэтому не можем указать на отрицательный признак в концепции человека.

    Мы, конечно, ясно видим, что по вышеприведённым концепциям, или определениям, старая зоологическая концепция получается ложной, как отстаивает автор.

    Однако не можем ли мы допустить, что в этом он попросту играет словами?  
    Не рассматриваем ли мы здесь вопрос не более чем произвольного определения?  
    Не определил ли он намеренно по собственной причуде и воле термин «животное» так, чтобы исключить людей из так определённого класса?

    Ответ, несомненно, ·_Нет_·.

    Бесспорно, мы можем, если ·_предпочтём_·, определить слово «животное», или любое другое имя существительное, чтобы оно обозначало “класс” растений, слонов, людей, бармаглотов и газет. Однако мы этого делать не предпочитаем.

    Почему нет?

    Потому что мы хотим, чтобы наши определения ·_служили целям_·, приносили пользу, способствовали рациональному мышлению. Мы хотим, иными словами, чтобы они согласовывались с фактами. Давайте ненадолго отложим слово и взглянем на факты.

    Мы наблюдаем факт существования класса существ, обладающих пространство-связующей способностью, но не время-связующей способностью. Мы наблюдаем факт существования другого класса существ, обладающих обеими способностями. Факт: отличие между этими двумя классами – конкретно, способность связывать время – не только вне сравнения выдаётся как самый значимый признак, уникальный для человека, но и как самое значимое и ценнейшее явление в мире. Следовательно, факт: нам не следует мешать вместе два так бесконечно отличных друг от друга по ·_типу_· способностей класса в своём мышлении и дискурсе не только в интересах разумной этики, но и в интересах науки. Факт: употребление одного и того же термина «животное» для обозначения представителей обоих классов – людей и зверей – постоянно, незаметно, но эффективно ведёт к умственному и моральному затмению. Следовательно, факт: автор в своём осуждении зоологической концепции как ложной по фактам стоит на твердейших основаниях.

    Человек обладает некоторыми животными органами, осуществляет некоторые животные функции и проявляет животные наклонности, но говорить в связи с этим, что люди ·_есть_· животные, означает допускать такую же грубейшую логическую ошибку, какую мы бы допускали, называя животных или людей растениями в связи с их схожими органами, функциями и наклонностями. Подобная ошибка фундаментальна; такие в математике называют спутыванием типов или классов; Коржибски называет их смешиванием измерений. Говорить, что люди есть животные, потому что они проявляют некоторые животные наклонности, мы можем логически наравне с утверждениями, что геометрические объёмы есть поверхности, потому что они обладают некоторыми свойствами поверхности, или что дроби есть целые числа, потому что обладают некоторыми свойствами целых чисел.

    Почему первое знакомство с категорическим отвержением убеждения в том, что человек представляет собой разновидность животного, повергает людей в шок?  
    Они оценивают это как нападок на их человеческое достоинство?  
    Как нападок на животную основу их пространство-связующей этики?  
    Как противоречие их хорошо обоснованному научному взгляду?

    Я думаю, в шок их повергает не столько что-то из перечисленного, сколько то, что их старому, не подвергнутому сомнениям, не оспоренному вероучению о великой мудрости – Здравом Смысле – бросают вызов. Руководствуясь здравым смыслом, мы ясно видим, – сквозь пелену чувственного восприятия – что человек обладает определёнными животными органами и испытывает то, что испытывают животные: он рождается, питается и растёт, имеет нижние конечности и волосы, ещё умирает – всё как у животных.

    Его время-связующая способность, однако, такой очевидной не представляется. Она воплощается не ощутимым ·_органом_·, а не ощутимой ·_функцией_·, неявной как дух. Здравый смысл, привычно ведомый не подвергнутым сомнениям свидетельствам чувств и ложным предположением, что всё, обладающее животными органами и проявляющее животные наклонности, есть животное, заключает, что наш человеческий род есть род животный. В этом вопросе, как во многих других, старая мудрость ведёт к ошибкам. Животные живут свою жизнь в пространстве; люди – во времени.

    А что такого важного в каких-то концепциях? Нам говорят, что мы ведём наши жизни не по концепциям, а по импульсам, инстинктам, желаниям, пристрастиям, потребностям.

    Потому что у человека не существует просто «каких-то» концепций; они состоят в жизненно важной связи с импульсами, инстинктами, желаниями, пристрастиями и потребностями. Концепции служат средствами, которыми Разум выполняет свою работу, направляя к процветанию или катастрофе, в зависимости от истинности или ложности концепций.

    Я сказал, что с древности и по сей день зоологическая концепция конкурирует с мифологической концепцией, согласно которой человек представляет собой таинственное сочетание или гибрид естественного (животного) и сверхъестественного. Сегодня к этой концепции относятся не многим иначе, чем к ней относились вчера. Например, Платон (в Тимее[⁶](https://teletype.in/@czoc/GN-d8mumEti#Tj8Q)):

    ⬩«⬩  
    Мы должны принять традиции людей прежних времён, кто утвердили себя потомками богов. Так они сказали, и наверняка знали своих предков. Как мы можем сомневаться в словах детей богов? Невзирая на то, что они не приводят доказательств своим заявлениям о том, что происходило в их семье, мы должны следовать традиции и верить им.  
    ⬩»⬩

    Подход греческого философа заметно отличается от подхода польского инженера, который глубоко серьёзно, прямо и смело утверждает, что мифологическая концепция человека ложна и опасна. В ней допускается грубая логическая ошибка, подобная ошибке в зоологической концепции – критическое спутывание типов, или смешение измерений. Говоря, что человек создан настолько непостижимо, что его следует считать частично естественным (животным) и частично сверхъестественным (божественным), мы по той же ·_логике_· можем сказать, что геометрический объём представляет собой такую удивительную вещь, что он точно должен быть поверхностью, которой коснулось какое-то таинственное воздействие извне вселенной пространства. Среди классов жизни мира человек относится ко время-связующему классу, и Коржибски подчёркивает снова и снова важность распознания, что время-связующая энергия и все её явления всецело ·_естественны_· – что, например, Ньютон, или Конфуций, были так же естественны как орёл или дуб.

    Что он имеет в виду, называя что-то естественным?

    Конкретно он не сообщил, – во всяком случае, не сообщил открыто – и это упущение, несомненно, стоит восполнить в будущем издании книги.

    Вы знаете, что термины «естественный» ⁅natural⁆ и «природа» ⁅nature⁆ сегодня употребляют в широком многообразии смыслов, в большинстве случаев настолько размытых, что они подходят только для “литературно” образованных людей, но не для серьёзного применения людьми науки.

    Что нам следует подразумевать под термином «естественный» в таком обсуждении, в котором мы сейчас участвуем? Мне кажется, этот вопрос заслуживает краткого удовлетворительного ответа.

    Каждый знает, что всё, что нормальный человек встречает на пути своего опыта, отличается степенью (не)определённости. Что-то мы относим к фактам, настолько обычным, настолько чётко установленным и бесспорным, что полагаемся на них во всех практических делах жизни. Мы называем их известными фактами и знаем, что пренебрежение ими приведёт к гибели, достойной идиота или имбецила.

    Такие факты мы можем разделить на два вида:

    1\. Факты чувственных восприятий и памяти, и  
    2\. Факты чисто мысленные

    Первые мы знаем по знакомой жизни мира – рождение, рост, смерть, день, ночь, земля, вода, небо, смена сезонов и так далее. Факты чисто мысленные такими очевидными не кажутся, но они существуют. Например: «Если некое ·_S_· обладает свойством ·_P_·, и что угодно, что обладает ·_P_·, обладает свойством ·_P_·, то ·_S_· обладает ·_P_·». Все такие факты существуют ·_совместимо_· – каждый из них, как мы говорим, подходит всем остальным. Следовательно, я полагаю, что под «естественным» нам следует подразумевать следующее:

    ·_Природа (или естественное) состоит из и всего и только такого, что существует совместимо (согласуется) с наилучшим образом установленными фактами чувств и мыслей._·

    Если под «естественным» Коржибски имеет в виду это, – и мне кажется, скорее всего, именно это – то я полностью соглашаюсь с ним в том, что люди есть всецело естественные существа, с тем, что время-связующая энергия есть естественная энергия, и с его возражениями против зоологической и мифологической концепций. Если бы вопрос сводился к биологическим данным, то математики, как и другие разумные люди, прислушались бы ко мнению биологов. Вопрос, однако, не сводится к биологическим данным; о них спорить не приходится. Это вопрос логической значимости таких данных. Из уважения к вопросу логики, даже биологи, – не менее разумные люди – скорее всего, признали бы, что инженеры и математики заслуживают быть услышанными.

    В связи с этим я хочу обратить внимание на то, что Коржибски называет смешением измерений. Значение термина «измерения» в том, как он его употребляет, узнаётся безошибочно, однако он не развернул абстрактную теорию этой идеи. Такая доработка, как мне кажется, показала бы что эту идею удастся свести или почти свести к идее теории логических типов, которую я кратко разобрал в предыдущей лекции, и которую полностью обрисовали Уайтхед и Рассел в книге ·_Principia Mathematica_·.[⁷](https://teletype.in/@czoc/GN-d8mumEti#yViN)

    Эта идея, кроме того, стоит рядом, если не в сущности совпадает, с доктриной «категорий» профессора Дж. С. Холдэйна, которую он представил в своей впечатляющей и вдохновляющей книге ·_Mechanism, Life, and Personality_·[⁸](https://teletype.in/@czoc/GN-d8mumEti#OS03) (от издательства E. P. Dutton & Co.). В ней выдающийся физиолог утверждает, что механизм, жизнь и личность относятся к разным категориям, составляя настоящую иерархию, в которой высшее нельзя свести к низшему; что, например, жизнь не получится понять с точки зрения механизма, или личность с точки зрения жизни. Порядок идей сходится с тезисом Коржибски о том, что человека не получится объяснить более должно с точки зрения животных, чем животных с точки зрения растений, или растения с точки зрения минералов. Этот порядок идей видится работоспособным, потому что его подкрепляют подобные соображения о том, что нельзя свести геометрию к арифметике, динамику к геометрии, физику к динамике, психологию к физике. На мой взгляд, для науки и философии было бы полезно показать, что существует иерархия категорий, и что для понимания высших категорий низшие необходимы, но их не хватает.

    Не существует ли некоторого важного смысла, в котором явления высших категорий в той же мере объясняют явления низших категорий, в которой вторые объясняют первые?  
    Кто мог бы отрицать, что, например, динамикой удаётся осветить геометрию в не меньшей мере, в которой удаётся осветить геометрией динамику?

    Свой “обвинительный акт” зоологической и мифологической концепций человека Коржибски составил из ·_двух_· пунктов: он отвергает истинность концепций и осуждает их за зловредность их эффектов, утверждая, что, главным образом, они вызывают бедственные обстоятельства в человеческой истории и нынешнее плачевное положение вещей в мире.

    О первом пункте я поговорил. В отношении второго я испытываю следующие убеждения:

    1 · Если человечество не есть всецело естественный класс жизни согласно вышеприведённому определению слова «естественный», то мы чётко видим, что системы человеческой этики, понимаемой и принимаемой по естественному закону, никогда не существовало и никогда существовать не может, что по этой гипотезе означает, что никогда не существовало и никогда не может существовать этическая система, «совместимая с наилучшим образом установленными фактами чувств и мыслей».

    2 · Если, несмотря на то, что человечество действительно есть всецело естественный класс, но мы продолжим ·_думать_·, что это ·_не_· так, результат едва ли изменится – наша этика продолжит нас путать и омрачать нашу жизнь за счёт мифологических элементов в ней.

    3 · Однако, покуда мы продолжим считать человека животным, социальная жизнь мира во всех отношениях продолжит отражать трагичное ложное понимание, и этика наша останется такой, какой она в значительной мере всегда была – животной этикой, пространство-связующей этикой, этикой силы, жестокой конкуренции, насилия, борьбы и войны.

    В связи с чем я так подчёркиваю этику?

    В связи с тем, что этика не существует отдельно как интерес в порядке с другими интересами; она проникает во все интересы. Этика представляет собой своего рода социальный эфир, которым, хорошим или плохим, разумным или неразумным, истинным или ложным, пропитывается жизнь, частная и общественная, во всех измерениях и формах. Поэтому, если этику подрывают в основе ложные концепции человеческой природы, этот вирус не удаётся локализовать, и он распространяется на органы управления, что воздействует на характер всей деятельности и учреждений – на образование, науку, искусство, философию, экономику, промышленный метод, политику, правительство – на всё поведение и жизнь рода, государства, народа или мира.

    Едва ли имеет смысл напоминать о том, как совсем недавно ценные учреждения цивилизации оказались под угрозой уничтожения могущественным государством, построенным, развившимся и контролируемым животной этикой – пространство-связующей этикой зверей. Это послужило незабываемой демонстрацией выше отмеченного факта: характер человеческой истории, поведения и учреждений зависит не только от того, что человек уникально есть, но и в значительной, даже решающей мере от того, что мы люди ·_думаем_·, человек есть. Если человек или государство оценивает человека как разновидность животного, то от этого человека стоит ожидать звериного поведения, оправдания которому они найдут в зоологической философии человеческой природы.

    В свете этих соображений, мы с радостью можем обратиться к превосходной и, как мы убедились, несомненно правильной концепции человека Коржибски. Мы не найдём ничего важнее.

    Каковы последствия?  
    Каковы прогнозы?

    Сразу их уяснить не получится – необходимы размышления, и, если вы поразмыслите над концепцией, вы заметите, что масштабы её последствий рисуются всё больше, а диапазон прогнозов ширится и проясняется. Мы можем сказать о ней то же, что Томас Карлайл сказал о книге ·_Годы учения Вильгельма Мейстера_·:

    ⬩«⬩  
    Она стремиться к бесконечности во всех направлениях.  
    ⬩»⬩

    Нам следует о ней задуматься. Мы увидим, что человеческая история, её философия, нынешнее состояние мира, будущее благополучие человечества – все в ней повязаны.

    Центральная концепция состоит в том, что человек составляет время-связующий класс жизни. Иными словами, в нашем мире действует особенная энергия, – время-связующая энергия – а человек служит её органом – единственным инструментом.

    Что из этого следует, и что мы можем прогнозировать?

    Одно мы уже отметили. Несмотря на то, что человек не есть разновидность животного, он есть ·_естественное_· существо. Человек в той же мере естественно связывает время, в которой рыба плавает, птица летает, растение живёт жизнью растения. Человек настолько же естественно достигает средств бóльших достижений, насколько животное этого естественно ·_не_· делает.

    Этот факт фундаментален. Другой, тоже фундаментальный, факт заключается в следующем: время-связующая способность – характеризующая человечность – это не следствие цивилизации, а её причина. Это не цивилизованная энергия, а энергия, которая ·_цивилизует_·. Это не результат богатства, материального или духовного, а создатель богатства, как материального, так и духовного.

    Я подхожу к самому серьёзному соображению. Поскольку время-связующая способность составляет характерную черту – уникальную особенность – нашего человеческого рода, из этого следует, что изучать и понимать человека означает изучать и понимать природу человеческих время-связующих энергий. Законы человеческой природы есть законы – естественные законы – этих энергий. Изучение время-связующих явлений, – явлений цивилизации – выявление их законов и сообщение о них миру составляет высший долг учёных. Мы ясно видим, что на естественных законах время-связывания следует основывать будущую науку и искусство человеческой жизни и человеческого блага.

    Один из законов мы знаем сейчас. Мы не знаем его в точности, но достаточно хорошо, чтобы сказать, что знаем его общий тип, и он заслуживает всего нашего внимания. Я говорю о законе прогресса во время-связывании – цивилизацио-строении.

    Мы отметили, что каждое последующее поколение (например) бобров или пчёл начинает там, где начало предыдущее и заканчивает там, где оно закончило. Так происходит по закону животных, пространство-связующих – не происходит развития, время-связывания. Бобровая плотина есть бобровая плотина, медовый сот есть медовый сот. Мы знаем, что человек, наоборот, изобретает, первооткрывает, творит. Мы знаем, что изобретения ведут к новым изобретениям, открытия к новым открытиям, творения к новым творениям. Мы знаем, что таким прогрессивным размножением потомки знаний, ремёсел и мудрости не только продолжают свой род всё более широкими семьями, но и бесконечно создают новые, более высокие роды. Мы знаем, что в этом время-связующем процессе, которым ·_прошлое_·, воплощённое одним из факторов труда в долговечных достижениях, переживает умерших и служит живым благим капиталом для потомков, заключается секрет прогрессивного цивилизацио-строения.

    Вопрос следующий:

    Какой во всём этом действует закон?

    Его общий тип схватывается легко. Этот закон походит не быстро растущую ·_геометрическую_· прогрессию. Если прогресс, достигнутый в данном поколении, для удобства названном первым, обозначить ·_P_·, а знаменатель совершенствования обозначить ·_R_·, то прогресс достигнутый во втором поколении составит ·_PR_·, в третьем ·_PR²_·, а в одном поколении ·_T_· – ·_PRᵀ⁻¹_·.

    Следует заметить, что ·_R_· обозначает большое число, – насколько большое, мы не знаем – и что время ·_T_· входит в экспоненту, поэтому выражение ·_PRᵀ⁻¹_· мы называем ·_экспоненциальной функцией Времени_·. За счёт этого мы видим чётко спиральность времени в жизни человека.

    Это удивительная функция, что заметит любой изучающий математический анализ. По мере роста значения ·_T_·, которое растёт постоянно, функция не просто растёт, но и делает это с растущей скоростью, следуя подобному закону; скорость роста скорости роста тоже растёт подобным образом, и так далее к бесконечности. Это поражает всякое воображение. И тем не менее, так, приблизительно, работает закон – естественный закон – развития Цивилизации, бессмертного отпрыска духовного брака Времени и человеческого Труда.

    Я говорю «приблизительно», потому что вышеприведённое не описывает естественный закон прогресса цивилизации в полной мере адекватно. Ошибка состоит не в захождении в крайность, а в дефекте. Если внимательно посмотреть и подумать, мы заметим, что ·_R_·, знаменатель совершенствования, это не константа, как мы могли предположить выше, а переменная, значение которой растёт с ростом времени так, что функция ·_PRᵀ⁻¹_· растёт не только потому что с током времени растёт экспонента, но и потому что сам ·_R_· служит растущей функцией времени. Мы, тем не менее, можем удобно для себя, не заходя в крайности, говорить о вышеупомянутом законе, невзирая на его неадекватность, как о ·_естественном_· законе прогресса время-связывания или цивилизацио-творения.

    Из этого вытекает один из самых важных вопросов:

    Всегда ли цивилизация развивалась согласно этому закону?  
    Если нет, то в связи с чем нет?

    Время-связующие энергии человечества действуют уже давно – от 300,000 до 500,000 лет согласно гипотезам антропологов и палеонтологов. Если бы прогресс шёл по этому закону на протяжении этого длительного периода, наш мир дорос бы до цивилизации такой богатой и великой, какая сегодня не придёт нам в догадках или даже сновидениях.

    Что нам всё это время мешало?

    Здесь концепция человека Коржибски ведёт нас к новой интерпретации истории – к новой философии истории. Фундаментальным принципом новой интерпретации должен служить факт, который я высказал уже дважды – конкретно, то, что человек сделал и делает, зависело и зависит как от того, что человек отличительно есть, так и в значительной мере от того, что представители расы ·_думали_· и ·_думают_· человек есть.

    Мы смотрим на два определяющих фактора:

    Что человек ·_есть_· и  
    Что мы, люди, ·_думаем_· человек есть.

    Социологу или философскому историку следует рассматривать и объяснять совместный результат этих двух факторов. В свете второго фактора, который мы едва ли замечали и которому никогда не придавали должной важности, Коржибски в ответ на наш вопрос отстаивает, что ·_главными_· препятствиями прогрессу цивилизации согласно её естественному закону роста служат человеческие непонимания человека. Всего ценного в нынешней цивилизации мы достигли, невзирая на непонимания, за счёт первого фактора – тем, что человек есть – особенный орган цивилизующих энергий мира. Проблемы возникли в связи со вторым фактором.

    На протяжении долгого периода детства нашей расы, который ещё не для всех прошёл, время-связующим энергиям мешали ложные убеждения, что человек есть разновидность животного или что он есть чудесная смесь естественного и сверхъестественного. Это концепции пещерных людей. О великих достижениях, которых они ·_лишили_· мир, мы можем никогда не узнать, но не всем заметные последствия их ·_положительных_· зол мы можем отследить тысячью способов. Отслеживанием должны заниматься не только профессиональные историки, а вы и я. Любому взявшемуся придётся ужаснуться открытиям тех зол, – зол «магии и мифов», пространство-связующей «этики», зоологической «праведности», веками растущих и набирающих обороты – которыми мы пришли к мировой войне, ставшей для нас кровавой демонстрацией человеческого невежества о человеческой природе.

    Мы рассматриваем здесь некоторые из главных последствий и перспектив новой концепции человека. Эта задача требует толстого тома с подробным разбором отношений время-связывания к каждому вопросу первой значимости в жизни индивидуума и общества: к этике, образованию, экономике, медицине, праву, политическим наукам, управлению, промышленности, науке, искусству, философии, религии. Возможно, вы напишите такую работу или работы.

    В завершение этой лекции я не могу сделать больше, чем добавить к сказанному несколько общих вопросов и подсказок.

    Коржибски считает, что великая война ознаменовала конец длительного периода человеческого детства и начало человеческой зрелости. Второй период, как он считает, начинается, следует и характеризуется правильным пониманием уникальной природы Человека.

    Оправдан ли его энтузиазм?

    Я не знаю. Время покажет. Я надеюсь, что он не ошибается. Если не ошибается, то нас ждёт много изменений и преобразований.

    Я уже поговорил об этике и должен вернуться к ней снова, потому что этика, плохая или хорошая, оказывает самое сильное и широкое влияние; она проникает, задаёт, формирует и контролирует все закономерности, направления и учреждения человеческого мира.

    К какой этике мы придём в человеческой зрелости?

    · Не к этике, основанной на ·_зоологической_· концепции человека;  
    · Не к животной, пространство-связующей этике зверей, борющихся за «место под солнцем»;  
    · Не к этике власти, толпы и вражды;  
    · Ни к «капиталистической» этике с её алчностью ·_накопления_· для себя, ни к «пролетарской» этике с её жаждой ·_получать_· для себя;  
    · Не к этике с золотым правилом по закону дикарей, согласно, которому «самый приспособленныё» означает «сильнейший»;  
    · Не к этике, основанной на ·_мифологической_· концепции человека – не к беззаконной этике, хитро выдуманной для торговли магией и мифами.

    Мы придём к естественной ⁅природной⁆ этике, основанной на отличительной природе человечества как время-связующего – цивилизацио-строящего – класса жизни; иными словами, к научной этике с пониманием и решающей ролью естественного закона. Она станет воплощением, живым выражением законов – естественных законов – время-связующих энергий человека. Человеческая свобода станет свободой жить согласно этим законам, а праведность станет качеством жизни человека, который их не нарушает.

    Таким образом, в человеческой зрелости мы придём к естественной этике, совместимой с наилучшим образом установленными фактами чувств и мыслей. Мы придём ко время-связующей этике, и она будет расти в гармонии и ясности, разворачиваясь масштабнее по мере научных ·_открытий_· законов время-связывания – законов роста цивилизации – и ·_обучения_· им мира.

    С этим я подхожу к нескольким словам об образовании. В человеческой зрелости образование – дома, в школе, в церкви – понесёт долг учить молодое поколение отличительной природе человека и тому, что они как участники и представители человеческой расы собой представляют, чтобы всюду в мире мужчины и женщины понимали по обучению с рождения, что такое время-связывание, что их должное достоинство как людей составляет их достойная время-связующая жизнь, что для человека практика пространство-связующей этики означает утрату данных по рождению человеческих прав за падение к уровню зверей.[⁹](https://teletype.in/@czoc/GN-d8mumEti#CKwN)

    Мы часто слышим, что этика – это что-то такое, чему невозможно ·_научить_·, тогда как дела обстоят с точностью до наоборот – этике невозможно ·_не_· научить, потому что мы передаём её во всех своих учениях, осознанно или нет, через «философию человеческой природы» обучающего. Всякий дом или школу, где практикуют зоологическую философию, намеренно или невольно, превращают в питомник животной этики. Всякий дом или школа, где преобладает мифологическая философия человеческой природы, намеренно или невольно, превращается в храм беззаконной этики мифа и магии.

    С незапамятных времён мир испытывал такие учения этики большей частью неосознанно. Мы видели, что, когда такие учения становятся осознанными, намеренными и организованными, целые народы настолько преисполняются как пространство-связующей, так и мифической этикой ·_Gott mit uns_·, что их Государство бросается на своих соседей, подобно освирепевшему зверю.

    Почему бы нам не усвоить болезненно преподанный великой войной урок о поистине колоссальной силе образования?

    Если за многие века накопленную цивилизацию удаётся подвергнуть опасности с помощью этических учений, основанных на ложных философиях человеческой природы, то кто может указать на предел блага, которого мы можем ожидать от осознанных, намеренных, организованных, упорных совместных усилий домов, школ и средств информации, направленных на обучение этике, основанной на истинной концепции человека как действующего органа время-связующей, цивилизующей энергии мира?

    Я не могу продолжить свой разбор. В заключение я задам несколько общих вопросов, – довольно очевидных – чтобы указать предположительный курс дальнейшего исследования.

    Что несёт новая концепция человека так называемым наукам экономики, политики и управления?

    Можем ли мы этой новой концепцией преобразовать эти стародавние псевдо-науки в настоящие науки, основанные на научном понимании человеческой природы и подходящие, чтобы направлять и оберегать человеческое благополучие?

    В свете радикальных отличий природы человека от природы животных, какими мы можем представить себе отличия

    Правительства Пространство-связующих, созданные Пространство-связующими для пространство-связующих

    [¹⁰](https://teletype.in/@czoc/GN-d8mumEti#NOPD)

    от

    Правительств Время-связующих, созданных Время-связующими для Время-связующих?

    Какой из этих двух классов правительств лучше подходит социальному режиму автократов, или плутократов, и рабов, а какой политическому равенству и демократической свободе?

    Какой из них способствует процветанию корыстного коварства, а какой производительным навыкам?

    Какой из них больше поощряет ·_производителей_· блага, а какой ·_болтунов_· о нём?

    В каком из них приветствуют начальнические репрессии, а в каком обеспечивают условия для интеллектуального самовыражения?

    В каком из них больше полагаются на власть и войну, а в каком на право и мир?

    Если время-связующая энергия человека, которая произвела всё богатство мира, как материальное, так и духовное, действует ·_естественно_·, и, если, как мы знаем на деле, имеющееся на данный момент богатство практически всецело существует как результат времени и труда ушедших поколений, то кому оно по праву принадлежит?

    ·_Некоторым_· из живущих?  
    ·_Всем_· живущим?  
    Или всем живущим и ещё не рождённым?

    Становится ли унаследованное богатство как естественный ⁅природный⁆ результат естественной энергии и времени (которое естественно) тем, что мы называем природным ресурсом, подобным, например, солнечному свету, источникам пресной воды, новой земле?

    Если нет, то почему нет?  
    В чём принципиальная разница?

    Относятся ли «право завоевания» и «право на суверенность» ко время-связующим правам?

    Или же они относятся к «правам» пространство-связующим, одобренным животной «этикой» в зоологической философии человеческой природы?

    К чему ведёт новая концепция человека в теории и практике медицины?

    Человек, хоть и не есть животное, обладает животными органами и функциями, но все ли человеческие болезни проявляются как таковые у животных, или же некоторые из них относятся к ·_человеческим_· болезням и расстройствам, воздействующим на отличительный характер человека как время-связующего?

    Может ли психоанализ или психиатрия пролить свет на этот вопрос?

    А как обстоят дела с силой, претендующей на праведность?

    Религия, по всей видимости, размещается своим авторитетом во время-связующем двойном отношении благодетели, в котором живущие одновременно приходятся потомками умершим и предками ещё не рождённым, в первой роли наследуя живущим капиталом богатство цивилизации от времени и труда ушедших поколений, а во второй владея наследием до передачи для развития будущими людьми.

    Напоследок: в приведённой доктрине заложено предположение – когда мужчин и женщин везде станут воспитывать, чтобы они понимали отличительную природу нашего человеческого рода, время-связующие энергии человека освободятся от оков, и цивилизация сможет быстро и бесконечно развиваться согласно своему естественному закону в мире без войн. Если это предположение ложно, то виновата великая Природа, и мир продолжит бороться. Проверить его получится только одним способом – экспериментом, испытанием. Это предположение видится единственной научной основой надежды для мира.

    Не стоит ли каждому благомыслящему человеку преисполниться пристрастным желанием проверить это предположение?

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#XUZz)Cassius J. Keyser, ·_Mathematical Phylosophy: a Study of Fate and Freedom, Lectures for Educated Laymen_·, 1922.

    2\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#HFJg)Часть этой лекции приводится в обращении к сообществу Фи Бета Каппа о ·_Природе человека_· (Science, 9 сентября 1921 г.) и некоторые части в моей статье для The Pacific Review, декабрь 1921 г.

    3\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#WFrB)Со времени написания следующего далее я нашёл компетентное обсуждение этого вопроса профессором Уильямом Риттером в статье ·_Science and Organized Civilization_· из журнала Scientific Monthly за авг. 1917. Профессор Риттер определяет человека как ·_вид животного_·, однако, он приводит настолько важные ·_отличительные_· признаки вида, что хочется спросить, почему он вовсе не избавился от «животного» в своём определении.

    4\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#WFrB)Издательство E. P. Dutton & Company.

    5\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#DiN2)Можем ли мы отнести животных, ведущих прикреплённый образ жизни к исключениям? Мне кажется, мы можем показать, что они относятся к пространство-связующим в смысле Коржибски.

    6\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#3f8c)По переводу Б. Джоуитта.

    7\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#zaMv)A. N. Whitehead, B. Russel, ·_Principia Mathematica_·.

    8\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#fwxB)J. S. Haldane, ·Mechanism, Life, and Personality·, 1923.

    9\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#ujI4)В недавнем бюллетене Института творческого образования Коры Л. Уильямс, мисс Уильямс проницательно написала, что «время-связывание следует сделать основой всех образовательных программ, а ·_Зрелость человечности_· учебником в каждом колледже мира».

    10\. [⇧](https://teletype.in/@czoc/GN-d8mumEti#nz7K)Аллюзия на Геттисбергское обращение А. Линкольна, 1863 г.
    
""".trimIndent()