package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun fromTheEditor(modifier: Modifier) {
    MarkdownText(
        markdown = fromTheEditorText,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val fromTheEditorText = """
    # От редактора
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    ·_„Пришла пора новым надеждам вселиться в человечество Забрезжить свету новому …“_·  
    — Роберт Браунинг

    С этой цитаты Коржибски собирался начать введение ко второму изданию этой книги. В один весенний день 1949 года, когда я помогала ему редактировать то введение, он начал в шутку (или пророчески?) надиктовывать мне:

    ⬩«⬩  
    Это новое введение Коржибски редактировала я, потому что его не удалось закончить….  
    ⬩»⬩

    Теперь по-другому не получится. Из-за объёма работы с той даты, введение он, как планировал, так и не закончил, а 1 марта 1950 года неожиданно умер. Над рукописями, над которыми он работал, предстоит провести редактуру и включить в последующие издания этой книги. Мы также отдельно предложим новый материал владельцам экземпляров настоящего издания.

    Он планировал написать о некоторых опытах в своей жизни, которые повлияли на формулировки его работы.

    ⬩«⬩  
    Эта книга стала прямым результатом Первой мировой войны. Мой военный опыт позволил мне очень серьёзно взглянуть на характер нескончаемых исторических катастроф, которые человечество терпит с незапамятных времён, и обострил моё понимание безнадёжности старых оценок. Я начал искать истоки таких вновь и вновь приходящих катастроф, и до меня, наконец, дошло, что человечеству всё это время не хватало ‘правильного понимания’ ‘природы человека’. Практически с детства меня волновал вопрос о том, как разумно говорить о разных манифестациях жизни, какими мы наблюдаем их у животных и у человека, и как при этом между ними не путаться.  
    ⬩»⬩

    Его опыты детства в семейном поместье неподалёку от Варшавы, в Польше, наблюдения за работой на ферме, обучение научному и математическому ориентированиям у своего отца, образование инженера и т. д. стали другими факторами, сформировавшими его взгляды.

    Коржибски казалось, что новое функциональное определение ‘человека’ как время-связующего класса жизни, впервые данное в первом издании этой книги, сегодня стало важнее, чем когда-либо. Плодоносность этой ‘зачаточной идеи’ удалось убедительно продемонстрировать развитием его собственной работы; начали ощущаться её потенциалы для будущей работы других людей. Он писал:

    ⬩«⬩  
    Все человеческие достижения, созидательные или разрушительные, реализуются человеком, и чтобы оценить их должным образом, нам придётся понять, как работает механизм характерной деятельности человека \[время-связывание\]. Мы положили начало такому пониманию, указав на работоспособность новых методов. Мы, тем не менее, пока не достигли широкого осознания степени пересмотра в своих ориентированиях, которого требует новое понятие человека как время-связующего. Функциональное определение не получится отрицать; однако, стоит его принять, – не только словесно, а как жизненное ориентирование – как оно автоматически ведёт к становлению человеческой науки за счёт применения актуальных научных (физико-математических) методов.  
    ⬩»⬩

    Это привело его к формулировке первой не-аристотелевой системы – Общей семантики – и первой теории здравомыслия, которые он представил в 1933 году, в своей книге ·_Наука и здравомыслие; введение в не-аристотелевы системы и общую семантику_·.

    В новом введении он также рассмотрел электро-коллоидный характер нервной системы, указав на потенциал исследований эффектов непрерывной бомбардировки космическими лучами в наших жизненных процессах, предположительно, включающих медленное высвобождение атомной энергии радиоактивным углеродом, из которого состоит вся жизнь.

    Его особенно волновали нынешние международные проблемы: с советской диктатурой и т. д.

    ⬩«⬩  
    Споры в рамках ‘капитализма’, ‘коммунизма’ и т. д. ни к чему не ведут. И под тем, и под другим подразумевается некая экономическая теория, о работоспособности которой получится судить только по эмпирическим результатам, а с теоретической стороны по нашему пониманию ‘человеческой природы’. Очевидно, никакая система, в которой мы игнорируем ‘человеческую природу’ или идём против неё, не может выжить во времени, независимо от того, сколько ещё войн и революций мы можем устроить. Нам следует внимательно и разумно проанализировать проблему ·_диктатуры_·, говорим мы о диктатуре „Уолл-стрит“ или „Пролетариата“; и одна, и вторая противостоят нашим время-связующим потенциалам, и поэтому в конечном счёте не обеспечат человеческих потребностей. В будущем здравомыслящем обществе индивидуумы должны обладать свободой пересматривать свои базовые положения, что при сдерживающем абсолютизме и диктаторской упёртости они делать не могут.  
    ⬩»⬩

    Он также писал о символизме как о форме человеческого поведения.

    ⬩«⬩  
    Здесь мне стоит упомянуть хорошо известные манифестации под названием „интеллектуальная честность“ и „языковая совесть“. Мы, люди, не рождаемся с осознанностью символизма как такового и не пониманием его важности и механизмов, предполагающих ·_ответственность_·. Эти вопросы следует прояснять и внедрять их в обучение с помощью накопления опыта прошлого и теоретических исследований.  
    ⬩»⬩

    Приложения Ⅰ, Ⅱ и Ⅲ публиковались в первом издании этой книги; два другие приложения мы добавили к этому второму изданию, как планировал Коржибски.

    В Приложении Ⅳ, «Некоторые не-аристотелевы данные об эффективности человеческой адаптации», он рассматривает примеры из нашей повседневной жизни, в которых фигурируют экспоненциальные функции. Он объясняет, что некоторые сложные жизненные структуры складываются не-аддитивно и развиваются по экспоненте. Он приводит выдержки из исследований Грайкунаса и Уруика в области основ управления промышленностью, бизнесом и военной организацией. В своей работе они показывают, что на ряд отдельных факторов, с которыми человеческая нервная система может справляться одновременно без нарушений своей работы, накладываются строгие ограничения.

    В Приложении Ⅴ, «·_Наука и здравомыслие, Избранные материалы_·, заметка автора», Коржибски приводит краткую историю термина «общая семантика», который не следует путать с «семантикой». Общая семантика началась с этой книги в 1921 году, но в ходе её написания, он планировал, как читатель увидит, назвать свою работу Человеческой инженерией. Почему он сменил название и ввёл термин «общая семантика», он объяснил в этом приложении.

    Следующую цитату я привожу из рукописи, которую он подготавливал для этой книги:

    ⬩«⬩  
    Перечитывая то, что я написал в этой книге в 1921 году, я не нашёл слов, которые счёл нужным взять обратно. Рассмотренные в ней проблемы обострились как никогда. Исправить пришлось только несколько опечаток. Читатель заметит, что в своих ранних работах я пользовался другой пунктуацией, в сравнении с недавними, в частности в двух последних приложениях и в ·_Во что я верю_·, где я следовал стилю пунктуации не-аристотелевой библиотеки. Терминологии в них тоже местами отличаются. Я счёл целесообразным не менять эти мелкие расхождения, потому что они не мешают обсуждению более основательных вопросов.

    Я также специально оставил части, в которых рассматриваю проблемы и научные знания, актуальные на 1921 год, на которые сегодня стоит смотреть в историческом контексте. Внимательный читатель поразится экспоненциальному характеру нашего время-связующего процесса в этом примере, который демонстрирует, насколько наши знания о мире и о самих себе приумножились всего за двадцать девять лет.

    Наш человеческий прогресс представляет собой экспоненциальную функцию времени, и я не могу сделать лучшего, чем направить читателя к Главе ⅩⅩ, воспроизведённой здесь из позднего труда профессора Кассия Джексона Кайзера ·_Математическая философия_·. Я считаю её исключительно глубоким и прекрасно написанным размышлением. Только Кайзер, математик, выдающийся исследователь человечности, философ и, можно сказать, поэт, мог написать такую вдохновляющую главу. В ней он рассматривает применение экспоненциальной функции времени к себя-развивающему и живому организму под названием „человечество“ и показывает потенциалы время-связующего класса жизни осуществлять скачки вперёд по экспоненциальной функции времени.

    Мне следует, наконец-то, выразить свою признательность, которую профессор Кайзер не пожелал, чтобы я выразил, когда эта книга впервые появилась. Мой дорогой друг и наставник, понимая важность этой новой теории время-связывания, безвозмездно отдал своё время, чтобы помочь мне с первоначальной рукописью, которую я тогда писал на новом для себя языке. Он не только очень помог мне с редактурой, но в некоторых случаях практически переписал мои весьма нескладные выражения.

    Я также благодарю за оказанную поддержку Жака Лёба. Он убедил меня остаться в этой стране и продолжать заниматься здесь своей работой, благодаря чему я не вернулся в Польшу, как планировал после Первой мировой войны.  
    ⬩»⬩

    Выдающийся математик профессор Эдвард Казнер выразил ключевые идеи, связанные с возвращением основной работы Коржибски в предисловии этого нового издания.

    В статье «Мемуары: Альфред Коржибски и его работа» мисс М. Кендиг дала нам представить Коржибски как живого человека и поспособствовала более глубокому пониманию его работы как целого. Мисс Кендиг работала руководителем по обучению персонала в Институте Общей семантики с его основания Коржибски в 1938 году в качестве центра обучения его дисциплине. Она занимала должность помощника директора с 1942 года. Сейчас программу Института реализуют под её руководством.

    Кратко описать жизнь Коржибски, пожалуй, не получится выразительнее, чем это сделал он в своём «кредо» ·_Во что я верю_·, которое написал в 1948 году для симпозиума под названием «Вера, которой живу». Его тоже включили в этот том.

    Шарлот Шушарт  
    ·_Лэйквил, шт. Коннектикут_·  
    ·_апрель 1950 г._·

    * * *
""".trimIndent()