package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_9(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp).padding(top = 0.dp)
    ) {
        item {
            MarkdownText(
                markdown = chapter_9_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.formula_5),
                contentDescription = "формула5",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_9_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
    }
}
val chapter_9_text_1 = """
    # Глава Ⅸ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    В предыдущей главе я сказал, что мировая война знаменует конец одного длинного периода в жизни человечества и начало другого. Она знаменует конец человеческого детства и начало человеческой зрелости.

    Наше человеческое прошлое представляет собой грандиозный факт нашего мира. Многие факты отличаются нестабильностью, непостоянством и быстротечностью. Сегодня они здесь, а завтра их нет. С нашим человеческим прошлым дела обстоят иначе. Наше прошлое остаётся.

    ⬩«⬩  
    Оно перманентно. Мы можем на него рассчитывать. Оно почти вечно, как человеческая раса. Из этого прошлого пришли мы. В него мы постоянно возвращаемся. Тем временем, в наших жизнях оно играет важнейшую роль. В нём лежат ·корни· всего того, что мы есть, и всей нашей мудрости, науки, философии, искусства, юриспруденции, обычаев и институтов. В нём содержаться записи всех удавшихся и неудавшихся экспериментов, которые человек провёл за четверть или половину миллиона лет в искусстве жить в этом мире.  
    ⬩»⬩  
    Кассий Дж. Кайзер ·_Human Worth of Rigorous Thinking_·, с. 167

    В нашем отношении к прошлому мы находим три лёгких способа вести себя как дураки. Одним из этих способов мы игнорируем прошлое – остаёмся начисто невежественными о ·_своём_· прошлом и, следовательно, о том, как мы бредём по жизни, куда глаза глядят, подобно животным, не учитывая опыт ушедших поколений. Дураков такого типа мы можем назвать бродящими дураками или бродягами.

    Другим способом – очень заманчивым – мы ведём себя как дураки, когда фальсифицируем прошлое, ·_идеализуя_· его – глупо игнорируя его пороки, невзгоды, невежество, праздность и безрассудство, и глупо же раздувая его добродетель, счастье, знание, достижения и мудрость. Этот способ любят самодовольные люди – те, кто нашли комфортное место и возможность процветать, из-за чего теперь противятся переменам. Они говорят, что прошлое было мудрым, потому что произвело настоящее, а в настоящем у них всё сложилось хорошо, поэтому они просят оставить их в покое. Дураков этого типа мы можем назвать идолопоклонниками, потому что они поклоняются прошлому; или статичными дураками, довольствующимися настоящим; или трусливыми дураками, испытывающими страх перед будущим.

    Третьим способом – не менее заманчивым – мы ведём себя как дураки, когда поступаем противоположно предыдущему способу – когда презрительно пренебрегаем его добродетелью, счастьем, знанием, великими достижениями и мудростью, и глупо или неискренне преувеличиваем его пороки, невзгоды, невежество, праздность и безрассудство. Этот способ предпочитают опечаленные, несостоятельные, отчаявшиеся – особенно, когда они хотят сбежать от скуки рутинной жизни к увлекательным моментам неспокойствия, волнений и перемен. В прошлом, говорят они, всё было неправильно, потому что оно произвело настоящее, а настоящее всецело плохо, так давайте уничтожим его целиком. Дураков этого типа мы можем назвать презрительными дураками, поскольку они презирают прошлое; или разрушителями, разрушающими настоящее; или динамическими дураками, потому что они получают удовольствие от волнующих перемен.

    Так мы получаем потомков безрассудства:

    1\. бродящих дураков, игнорирующих прошлое, пренебрегающих расовым опытом, бездумно плывущих по сменяющимся течениям человеческих отношений;  
    2\. статичных дураков, идеализующих прошлое, смиренно любящих настоящее и враждебно относящихся к будущему;  
    3\. динамических дураков, презирающих прошлое, ненавидящих настоящее и стремящихся уничтожить работу покойников – самых ·_скромных_· из всех дураков, каждый из которых говорит:

    ⬩‹⬩  
    Всё должное начинается с ·_Меня_·; я превращу этот мир в рай. Однако гений мой должен быть свободен, а ·_сейчас_· ему мешает работа прошлого. Я её уничтожу. Я затею хаос. Нам нужен свет, – солнце отбрасывает тени – и я начну с того, что перекрою солнце. И тогда настанет славный мир – свет моего гения.  
    ⬩›⬩

    В тяжёлый противовес этим трём видам безрассудства существует один совет мудрости, единый с советом здравого смысла.

    Что это за совет?  
    Что представляет собой единый совет мудрости и здравого смысла относительно прошлого?

    Ответить, как и понять, не составит труда. Совет следует:

    Не игнорируй прошлое, но усердно изучай его как самый значительный фактор среди всех великих факторов нашего человеческого мира. Стремись смотреть на прошлое справедливо, размышлять о нём каким оно было и есть, видеть его ·_целостно_· – видеть его в истинной перспективе – не преувеличивая ни его добро, ни зло, ни его знание, ни невежество, ни его предприимчивость, ни праздность, ни его достижения, ни поражения.

    Установив значимые факты, стремись их учитывать, искать их происхождение, условия их возникновения, объяснять факты, понимать их, всегда применяя вопрос: ·_В связи с чем?_·

    Вековые жестокие предрассудки – В связи с чем?

    Вековое незнание естественного закона – В связи с чем?

    Вековые ошибочные концепции человеческой природы – В связи с чем?

    Непомерные растраты и разрушения богатства – В связи с чем?

    Бесконечные циклы усилий, застоев и распадов – В связи с чем?

    Нескончаемые перепады с мира на войну, с порабощений на освобождения – В связи с чем?

    Эпоха за эпохой мирового поклонения рукотворным богам, восседающих на престолах глупых дикарей благодаря мифам и магии, чествованных поэзией и своевольными догадками невежественных «мудрецов» – В связи с чем?

    Эпоха за эпохой медлительной разработки полезных изобретений, развития ремесла, торговли и искусства – В связи с чем?

    Эпохи импульсивных поисков до запоздалого открытия разума, за коим следовали века веры в достаток логических размышлений без сопутствующих систематических наблюдений и экспериментов – В связи с чем?

    Наконец, восход научного метода и науки, прирост естественного знания, неизмеримое расширение вселенной ·_во времени_· и в ·_пространстве_·, вера в законность природы, нарастающая эксплуатация естественных сил человеком, растущая вера в безграничность прогресса человеческого знания и безграничность совершенствования человеческого блага – В связи с чем?

    Многообразию народов, связанных научным прогрессом приходится жить вместе одним обществом на значительно потерявшей в размере земле, тогда как существующая этика, право, философия, экономика, политика и правительство не готовят нас отвечать новым нуждам – В связи с чем?

    Таким я принимаю совет мудрости – простой мудрости здравого смысла. Установить значимые факты нашего необъятного прошлого и объяснить их с точки зрения происхождения и условий представляется непростой задачей. Над ней предстоит трудиться многим людям многих поколений, но это придётся сделать, потому что это единственная соразмерная задача, позволяющая нам понимать наше человеческое настоящее за счёт познавания великих фактов нашего человеческого прошлого и их условий, ведь прошлое порождает настоящее. Это единственная соразмерная задача, позволяющая познавать настоящее, с тем чтобы смотреть в будущее уверенно и компетентно. Прошлое, настоящее, будущее – их не получится понять по-отдельности – вместе они составляют неделимое ·_целое_·.

    Период человеческого детства продлился долго – от 300.000 до 500.000 лет согласно свидетельствам человеческих следов, руин и записей. Промежуток такой длины едва ли удастся ухватить нашим воображением. Из этой необозримой череды эпох, не считая мизерную долю нашего времени, у нас, должно говоря, нет истории. У нас есть лишь грубое, неразборчивое, неполное очертание.

    Геродот, которого мы зовём истинным отцом истории, жил меньше 2500 лет назад.

    Что составляют 2500 лет в сравнении со всем промежутком человеческого времени?

    Нам стоит признать, что отец человеческой истории жил лишь вчера, и живущие сегодня могут обоснованно назвать его своим современником. Человечество скиталось в поисках по этой земле, возможно, 400.000 лет, прежде чем появились первые писания того, что мы называем историей.

    Если рассматривать историю как своего рода ·_расовую память_·, то что мы можем сказать о своей памяти?

    Наша память походит на таковую человека двадцати лет от роду, который помнит не более трёх последних месяцев своей жизни, или шестидесятилетнего, который не может вспомнить ни одного события, произошедшего в первые 59 лет его жизни. Благодаря работе геологов, палеонтологов, этнологов и их коллег, история доисторического человека продолжит расти, подобно тому как растут наши знания о жизни человечества во времена Геродота. Сегодня мы знаем о ней больше, чем знал сам Геродот. Тем временем, нам следует извлечь максимальную пользу из исторических знаний о человеке, коими мы располагаем сейчас.

    Даже если бы записи всей истории человеческого детства хранились в библиотеках мира, у меня бы не получилось изложить историю кратчайшим образом в этой скромной работе. Исключая недавние события, мы знаем эту историю, как я отметил, только как грубый, неразборчивый и неполный набросок, но в настоящих целях этого хватит. Бесчисленные множества подробностей мы утратили – большинство из них, несомненно, навсегда. Нам, однако, не стоит отчаиваться. Действительно значимые факты нашего расового детства – масштабные, главенствующие, очевидные факты – мы видим чётко, чтобы сориентироваться по ним в наших нынешних инициативах.

    Что же мы знаем?

    Мы знаем, что период нашего человеческого детства длился непостижимо долго.

    Мы знаем, что в далёком прошлом первые человеческие особи – начинатели время-связующей расы – не знали ничего о враждебном мире, в котором оказались.

    Мы знаем, что они не имели концепции того, что собой представляли.

    Мы знаем, что у них не было ни речи, ни философии, ни религии, ни науки, ни инструментов, ни человеческой истории, ни человеческой традиции.

    Мы знаем, – невзирая на то, что сегодня мы едва ли можем себе представить – что ·_единственным_· оснащением для ·_инициации_· деятельности человеческой расы им служила особенная очеловечивающая их способность – способность связывать время.

    Мы знаем, что им пришлось работать над инициацией без руководства, образцов, аксиом и прецедентов.

    Мы знаем, что им удавалось это делать, просто потому что мощь инициации – способность давать начало – заключается во время связующей мощи.

    Что ещё мы знаем о самом раннем периоде человеческого детства?

    Мы знаем, что в ту далёкую эпоху наши предки, будучи не животными, а человеческими существами, не только ·_начали_· жить в человеческом измерении жизни, – навсегда выше уровня животных – но и ·_продолжили_· в нём жить, делая первый, второй, третий и так далее шаги неограниченно.

    Мы знаем, иными словами, что они свойственно себе развивались – осуществляли свой прогресс ·_естественно_· для себя; настолько же естественно, насколько естественно плавают рыбы или летают птицы. Они это делали по импульсу и по способности развиваться – совершенствоваться, совершать более великие поступки за счёт уже совершённых поступков. В этом заключается сама природа время-связующей способности, очеловечивающей человека.

    Мы знаем, что время-связующая способность – способность накопления расового опыта, его наращивания и передачи для будущего расширения – представляет собой характерную мощь, особенную энергию, определяющую природу и признак человека.

    Мы знаем, что умственная мощь – время-связующая способность наших доисторических предков, если не по степени, то по ·_типу_·, не отличалась от нашей.

    Мы знаем, что этой способностью – высшей деятельностью, известной в природе – мы естественно производим идеи, изобретения, наработки, доктрины, знание и другие формы богатства.

    Мы знаем, что прогресс в том, что мы зовём цивилизацией, который сводится к прогрессу в производстве и правильном применении материальных и духовных богатств, может осуществляться и осуществляется, попросту и лишь потому что результаты время-связующей работы не просто ·_выживают_·, а естественно множатся – идеи порождают идеи, изобретения ведут к другим изобретениям, знание плодит знание.

    Мы, следовательно, знаем, что количество прогресса, который может осуществить одно поколение, – если ему хватает сырья и не препятствуют враждебные обстоятельства – зависит не только от его исходной способности связывать время, но и от общего прогресса предыдущих поколений – от унаследованных плодов время-связующего труда покойников.

    Соответственно, мы знаем, что количество прогресса, который может таким образом осуществить одно поколение, представляет собой то, что математики называют возрастающей функцией времени; и, не просто возрастающей функцией, а возрастающей ·_экспоненциальной_· функцией времени – такой функцией как ·_PRᵀ_·, как мы уже объяснили. Мы также знаем, что общий прогресс, который могут таким образом осуществить ·_T_· поколений, составляет:
    
""".trimIndent()

val chapter_9_text_2 = """

    что тоже работает как возрастающая функция времени.

    Мы знаем из дифференциального исчисления, что эти функции – которые представляют естественные законы, законы человеческой ·_природы_·, законы время-связующих энергий человека – возрастают со временем не только величиной, но и ·_темпами_· роста; темпы их роста тоже представляют собой экспоненциальные функции времени, поэтому темпы сами возрастают темпами, которые, вновь, представляют собой экспоненциальные функции, и так далее без предела.

    Я считаю это поразительным фактом – фактом неизмеримой значимости для всех нас. Это означает, что, если время-связующей мощи человека позволить действовать естественно, то цивилизация – производство и правильное применение материальных и духовных богатств – не только продолжит расти в бесконечность (как говорят математики), но и, таким образом, продолжит расти со ·_скоростью_· не постоянной, а нарастающей в бесконечность, и нарастание, вновь, не останется постоянным, а тоже продолжит расти согласно тому же закону, до бесконечности. Таким образом, хорошо поразмыслив, мы увидим, что свою должную жизнь человек ·_по-человечески_· живёт не в пространстве, как животное, а во времени.

    За счёт этого мы видим, что в уникально человеческой жизни – в жизни, проживаемой человеком по-человечески – прошлое есть настоящее, покойники продолжают жить, чтобы принять и благословить ещё не рождённые поколения. Время – связанное время – буквально представляет собой ядро цивилизации. Так происходит со времён начала человечности.

    Мы знаем, что общий прогресс, достигнутый за длительный период человеческого детства, невзирая на его величину, следует рассматривать как относительно незначительный.

    Мы знаем, что, в сравнении с никакой цивилизацией, наша нынешняя цивилизация представляется обширной и во многом богатой.

    Мы, тем не менее, знаем, что если бы время-связующие энергии человечности могли всё это время действовать без препятствий, создаваемых враждебными обстоятельствами, то к этому моменту они бы уже давно произвели такую цивилизацию, в сравнении с которой наша текущая показалась бы неразвитой, бедной и дикой.

    Мы знаем же, что этим особенным энергиям – цивилизаци-образующими энергиям человека – ·_никогда_· не давали действовать по законам их природы; им всегда препятствовали и продолжают препятствовать по сей день враждебные обстоятельства. Если мы должно поразмыслим, то узнаем, какие враждебные обстоятельства им препятствовали и продолжают это делать.

    Мы знаем, что в начале человеческого детства, – в его младенчестве – как мы уже отметили, не существовало какого-либо начального «капитала»: ни материальных богатств, ни духовных богатств в форме знаний о мире или природе человека, никаких результатов труда покойников, никакого связанного времени – ничего, кроме дикой среды и сырого материла, который ещё предстояло открыть и изучить. Даже сейчас, в связи с тем, что мы унаследовали так много связанного времени, и с тем, что не дисциплинировали должным образом своё воображение, чтобы понимать реальность, мы едва ли можем себе представить действительные условия той далёкой от нас поры человеческого младенчества. Ещё меньше мы понимаем, что нынешней цивилизации предстоит пройти длинный путь развития, прежде чем, мы сможем назвать её цивилизацией просвещённого человека.

    Мы, помимо этого, знаем, что время-связующие энергии наших далёких предков подвергались сдерживанию и вмешательству в мере, слишком широкой для нашего воображения – масштабными геологическими и климатическими переменами, как внезапными, так и регулярными, непредвиденными и непреодолимыми: землетрясениями, бурями, сезонами наводнений, морозов, пекла и засухи длительностью в эпоху, которые уничтожали не только природные ресурсы и копотливо накопленные результаты ушедших поколений, но и самих людей вместе с центрами и окраинами неподготовленных цивилизаций.

    Однако из всех враждебных обстоятельств и причин, которые действовали на протяжении долгого периода человеческого детства, не давая цивилизации и человеческому благу развиваться в полной мере согласно естественным законам время-связующих энергий, остаётся упомянуть самую значительную и самую чудовищную, действующую поныне повсеместно.

    Я говорю о человеческом невежестве. Я не имею в виду незнание физических фактов и законов физической природы; такое невежество в немалой мере становится следствием причины, о которой я говорю. Я имею в виду гораздо более основательное невежество, обладающее значительно большим потенциалом. Я говорю о человеческом незнании ·_Человеческой Природы_·: о незнании о том, что человек есть, о ложных концепциях места, по праву принадлежащего человеку в укладе жизни и порядке мира.

    Я уже указал на эти ложные концепции. Их две:

    *   концепция, согласно которой люди есть животные; и
    *   концепция о том, что люди не имеют своего места в Природе, а представляют собой гибридов естественного и ·_сверх_·ъестественного – животных в сочетании с чем-то «божественным».

    Обе эти концепции характеризуют детство человечности; в обеих мы заблуждаемся; обеими наносим бесконечный ущерб тысячами способов.

    Кого нам винить?

    В глубоком смысле, винить некого. Человек начинал без капитала, – без знания – не располагая ничем, кроме физической силы и естественного стремления связывать время; и так ему приходилось вести свои поиски. Нам не стоит считать странным, что ему пришлось испытывать недоумение. Нам также не стоит удивляться тому, что он счёл себя животным, ведь он проявлял животные наклонности, подобно кубу, обладающему поверхностями. Его животные наклонности заслоняли обзор своей очевидностью для физических чувств. Человек рождался, рос, ходил, обрастал волосами, ел, бегал, спал, умирал, – всё как у животных – тогда как его отличительный признак, его время-связующая способность, оставалась едва заметной, духовной. Она была не ·_видимым органом_·, а ·_невидимой функцией_· – энергией, называемой интеллектом или разумом, которую физические чувства не распознают. Поэтому я говорю, что не стоит видеть в этом что-то странное – скорее, печальное и жалкое. Мы можем понять, почему человек счёл себя животным.

    То же касается альтернативного убеждения – убеждения о том, что человек есть ни что-то естественное, ни сверхъестественное, а и то и другое одновременно – и животный и божественный, гибридный отпрыск зверя и бога. Это чудовищное убеждение, жалкое и печальное, однако его происхождение не составляет труда понять. Когда его выдумали, оно стало эффективным инструментом в руках злых людей, самозванцев, но придумали его не они; это убеждение стало ошибочным результатом искренних попыток понять и объяснить.

    Из очевидных фактов сложилась трудная головоломка: с одной стороны, мужчины, женщины и дети – охотники на животных и добыча животных – несомненно походили на животных физически по сотне безошибочных признаков; с другой стороны, становилось всё яснее, что те же похожие на животных люди, могли делать множество вещей, которые животные не делали и не могли делать никогда. В этом заключалась головоломка, загадка. Время-связующее любопытство взывало к объяснениям.

    Как это пришлось объяснять?

    Естественная наука ещё не развилась; критическая концепция, при которой не спутываются измерения, пребывала в немощном состоянии младенчества. Мы легко можем понять, к какому ответу пришлось прийти – к детскому и мифическому. Так и получилось, что людей стали считать ни животными, ни богами, ни естественными, ни ·_сверх_·ъестественными, а и тем и другим, смесью, таинственным сочетанием животного с чем-то «божественным».

    Такие два альтернативных ответа человечество в своих долгих поисках в собственном детстве дало на важнейший из всех вопросов:

    Что есть человек?

    Я говорю, что ответы, невзирая на свою искренность в их поисках, мы дали ошибочные, ложные по фактам и чудовищные. Я сказал и повторю, что неверные концепции, лежащие в этих ответах, в ходе прошедших веков мешали больше и больше мешают сегодня, чем другие препятствующие обстоятельства, ·_естественным_· образом действовать время-связующим энергиям человека, чем задерживают ·_естественный_· прогресс цивилизации. Их изучение следует считать не привилегией, а своим высшим, святым долгом.

    Выполнить этот долг представляется нелёгкой задачей. Ошибочные концепции живут с нами с древних времён; всё это время они не формировались отдельно и чётко определённо, а ·_спутывались_· в клубок традиционных мнений и вероучений, которые составляют вульгарную «философию» – затуманенное сознание – нашего времени. Если мы хотим исполнить этот долг, нам, прежде всего, следует выявить эти концепции, выпутать их из клубка унаследованных убеждений и представить их подходящими словами. Затем нам следует дать себе тщательно и чётко осознать, что эти концепции, истинные или ложные, на деле лежат в сердцевине социальной философии мира. После этого нам следует распознать базовый характер допущенных в них грубых ошибок – чётко и непредвзято рассмотреть, где мы ошиблись и в связи с чем. Наконец, нам следует по-возможности отследить их фатальные эффекты, как в ходе человеческой истории, так и в настоящем состоянии нашего человеческого мира.

    Задачу выпутывания этих двух чудовищных ошибочных концепций из клубка унаследованных убеждений и представления их словами я уже неоднократно выполнил. Вспомним результаты:

    1\. люди – мужчины, женщины и дети – есть животные (следовательно, они естественны);  
    2\. люди не есть ни естественны, ни ·_сверх_·ъестественны, ни полностью животные, ни всецело «божественные», а ·_одновременно_· естественны и ·_сверх_·ъестественны – таинственные гибриды, сочетающие в себе звериное и божественное.

    Второй шаг нашей задачи – которую читателю следует решать не в меньшей мере, чем мне – не представляется настолько простым, и мы понимаем, в связи с чем. Вот с чем: ложные вероучения под рассмотрением – лежащие в их основе фатальные ошибочные концепции – стали нам настолько ·_знакомыми_·, настолько глубоко укоренились в нашем мышлении, речи и ведении жизни, настолько в нас ·_воспитались_· семьёй, школой, церковью и государством, что мы ·_привычно_· и ·_неосознанно_· принимаем их как данное, а чтобы это осознать, нам приходится усердием толкать себя в осознанность того, что мы в действительности придерживаемся и практикуем их, и что они на деле главенствуют сегодня по всему миру, как главенствовали с незапамятных времён. Нам нужно как следует себя ·_встряхнуть_·, чтобы проснуться и увидеть истину.

    Я предполагаю, что читатель мыслит трезво, рационально, и что его интересует человеческое благополучие. Если нет, то он бы не «читал» эту книгу. Он, следовательно, знает, что третий шаг нашей задачи – распознавание и рассмотрение базовой ошибки в концепциях под вопросом – становится самым важным.

    В чем заключается ошибка?

    Как я сказал, ошибка заключается в логике. Логические ошибки, однако, друг от друга отличаются – их существует множество типов.

    К какому типу отнести ·_эту_·?

    Ошибка этого типа характеризуется тем, что математики называют «спутыванием типов», или «смешиванием измерений». Яснее или выразительнее ответа не дать, потому что его важность в критике ·_всего_· нашего мышления видится выше всякой меры. Существуют миллионы примеров, которыми удастся прояснить эту проблему. Я приведу простейший; настолько простой, что его поймёт даже ребёнок – математический, как и дóлжно, потому что весь вопрос логических типов, или измерений, относится к математическим. Я прошу читателя не смущаться и не уклоняться от слова «математический»; несмотря на то, что большинство из нас владеет скудными математическими ·_знаниями_·, все мы носим математический ·_дух_·, иначе мы не были бы людьми – все мы ·_сердцем_· математики.

    Перейдём к нашему примеру. Возьмём ·_поверхность_·, например, ·_плоскую_· поверхность с длиной и шириной – она обладает, как мы говорим, ·_двумя_· измерениями. Далее возьмём ·_объём_·, например, ·_куб_·. Он обладает длиной, шириной и толщиной – следовательно, ·_он_· имеет, как мы говорим, ·_три_· измерения. Теперь заметим, что куб ·_обладает_· поверхностями и, следовательно, ·_имеет некоторые свойства поверхности_·.

    Говорим ли мы, следуя из этого, что объём ·_есть_· поверхность?  
    Что куб относится к классу поверхностей?

    Если мы так говорим, то мы дураки – типо-путающие и измерение-смешивающие дураки. Это очевидно.

    Подобным образом, предположим, мы замечаем, что объёмы обладают некоторыми свойствами ·_поверхности_· и некоторыми свойствами, которыми поверхности ·_не_· обладают. Предположим, мы говорим, что ·_поверхностные_· свойства объёмов ·_естественны_·, а другие свойства настолько таинственны, что они, должно быть, «·_сверх_·ъестественны», или каким-то образом «божественны». Предположим, что, исходя из этого, мы заключаем, что объёмы представляют собой объединения, смеси, сочетания или гибриды поверхностей и чего-то божественного или ·_сверх_·ъестественного.

    Вам не кажется очевидным, что если бы мы так поступали, мы бы, вновь, оказались дураками?  
    Типо-путающими дураками?  
    Измерение-смешивающими дураками?

    Любой видит, что именно так бы и случилось.

    Теперь давайте рассмотрим животных и людей, и взглянем на факты честно и прямо. Для начала задумайтесь на секунду о растениях. Растения живут; они принимают, преобразуют и приспосабливают энергии солнца, почвы и воздуха, но не обладают автономной способностью перемещаться в пространстве. Мы можем сказать, что растения составляют низший порядок, класс, тип или измерение жизни – измерение ·_один_·. Мы видим, что растения связывают базовые энергии мира.

    Что мы можем сказать о животных?

    Подобно растениям, животные тоже принимают, преобразуют и приспосабливают энергии солнца, почвы и воздуха, однако, принимают они их большей частью в приготовленной растениями форме. В ·_отличие_· от растений животные обладают ·_автономной_· способностью перемещаться в пространстве – ползать, бегать, плавать или летать. В связи с этим становится очевидно, что, по сравнению с растениями, животные относятся к более высокому порядку, классу, типу или измерению жизни. Мы можем сообразно сказать, что тип животной жизни представляет собой тип ·_двух_· измерений – двухмерный тип. Я называю их пространство-связующими, потому что они отличаются своей автономной способностью перемещаться в пространстве – покидать одно место и занимать другое, чем приспосабливать естественные плоды многих местностей. Таким образом, жизнь животных представляет собой жизнь-в-пространстве, в смысле, не применимом к растениям.

    Теперь, что мы можем сказать о ·_Человеке?_· Подобно животным, люди, несомненно, обладают способностью передвигаться, – автономной способностью перемещаться, способностью связывать пространство – и мы ясно видим, что если бы они не обладали способностью более высокого порядка, мужчины, женщины и дети, несомненно же, были бы животными.

    Однако как обстоят дела по фактам?

    Факты – если мы на них посмотрим и над ними подумаем – свидетельствуют, что человеческую природу от животной отделяет больший промежуток, чем тот, что отделяет животную жизнь от жизни растений.

    Человек совершенствуется – животные нет;  
    человек развивается – животные нет;  
    человек изобретает всё более сложные инструменты – животные нет;  
    человек создаёт материальные и духовные богатства – животные нет;  
    человек строит цивилизацию – животные нет;  
    человек заставляет ·_прошлое жить в настоящем, а настоящее в будущем_· – животные нет;  
    человек, следовательно, ·_связывает время_· – животные нет.

    В свете этих соображений – если только мы осознаем их высокую значимость – мы увидим настолько ясно, насколько можем, что жизнь человека – время-связующего – радикально отличается от жизни животных, – пространство-связующих – подобно тому, как животная жизнь отличается от жизни растений, или подобно тому как природа объёма отличается от таковой поверхности, или природа поверхности от природы линии. Следовательно, становится несомненным, что, когда мы считаем людей животными или смесями животной природы с чем-то таинственно ·_сверх_·ъестественным, мы допускаем грубую ошибку того же ·_типа_·, какую совершали бы, принимая животных за растения или за растения с «божественной» составляющей, или принимая объём за поверхность, или за поверхность чудесным образом преобразованную каким-то таинственным влиянием из вне вселенной пространства. Мы чётко видим, что проблема возникает из-за ·_фундаментальной_· грубой ошибки спутывания типов, смешения измерений.

    Ничего чудовищнее представить не получится.

    Что случилось бы вследствие такой ошибки?

    Читателю следует задуматься. Он знает, что, если бы наши предки допустили подобную ошибку в отношении линий, поверхностей и объёмов, сегодня не существовало бы геометрии. Читатель знает, что, если бы мы не разработали геометрию, то в мире не существовало бы архитектуры, геологии, железных дорог, астрономии, гидрографии, пароходов, инженерии и вообще ничего ныне знакомого нам во всём мире, что появилось благодаря научному завоеванию пространства.

    Я повторю, читателю следует задуматься, потому что если он этого не сделает, он упустит значимость истины исключительной важности. Он легко увидит в предполагаемом примере, какими ужасными оказались бы последствия, если бы на протяжении периода человеческого детства, происходило определённое спутывание типов, или некоторое смешивание измерений. Он ·_может_· это увидеть, потому что, к счастью, эту ошибку ·_не_· допустили, или, если допустили, то не понесли дальше, ведь если бы это случилось, то знакомые великие вещи, которых она бы лишила мир, не были сегодня здесь. У нас бы сейчас не получилось их даже вообразить и, следовательно, не удалось бы оценить масштабы катастрофических последствий этой ошибки.

    Читателю не стоит здесь робеть, колебаться или медлить; ему следует взять на плечо ношу этого довода и донести её до цели. Он хорошо понимает поистине ужасающие последствия, которые ·_бы_· неминуемо сложились в свете ошибки спутывания типов – ошибки смешивания измерений – в задачах линий, поверхностей и объёмов, ·_если бы_· эту ошибку допустили и понесли веками далее. Он ·_может_· распознать эти последствия, попросту потому что эту ошибку ·_не_· допустили, и, следовательно, великие вещи, которых она бы лишила мир, сегодня пребывают здесь, а он может сказать:

    ⬩⸗⬩  
    Посмотрите на эти прекрасные вещи – наука геометрия в её многообразии применений сияет всюду в человеческих делах. Представьте себе мир, в котором их никогда не существовало, и вы увидите степень последствий нарушения закона типов, закона измерений в задачах линий, поверхностей и объёмов.  
    ⬩⸗⬩

    Однако сейчас со в точности такой же ошибкой в отношении природы человека сложилась обратная ситуация, потому что эта ошибка, в отличие от вышеописанной, не ограничивается гипотезой. Мы убедились, что действительно её совершили и несём её с незапамятных времён. Не годами, не десятилетиями, не веками, а ·_веками веков_· и по сей день она преграждает путь человеческого прогресса. Эпоху за эпохой она тормозит и мешает естественной деятельности время-связующих энергий – цивилизаци-образующих энергий – человечества.

    Как нам оценить последствия?

    Читателю стоит учитывать, что ошибку мы допустили фундаментальную – ошибку спутывания типов (подобную ошибке с геометрическими объектами). Ему также стоит подумать, что она сказывается не на одной важной сфере человеческой деятельности, а на ·_всех_·, потому что ошибка создаёт проблему ·_посреди_· всех них – проблему понимания ·_природы_· человека. Поразмыслив над этим, он узнает, как может узнать что-либо ещё, о высшей важности и серьёзности последствий этой вековой ошибки.

    У нас никак не получится их измерить, адекватно описать, очертить их масштабы, потому что на деле мы не можем их вообразить. Тому есть простая причина: тех примеров развития цивилизации, тех прибавлений материального и духовного богатства, прекрасных достижений, которых эта трагичная грубая ошибка лишила мир, здесь нет. Их не произвели. Мы не можем, как в ином случае, сказать:

    ⬩⸗⬩  
    Взгляните на все эти великолепные сокровища связанного времени. Представьте, что их не существует, и вы сможете оценить меру ужасающей потери.  
    ⬩⸗⬩

    Мы ясно видим, что блага, которых человечество лишилось из-за ошибочных концепций человеческой природы, останутся надолго – возможно, навсегда – в области несбывшихся надежд на лучшее.

    Я сказал, что долг изучения ошибочных концепций возлагает на нас четыре задачи. Три из них мы уже выполнили: мы выпутали убеждения под вопросом из клубка стародавних мнений; мы выявили необходимость вытянуть себя в осознанность того, что мы действительно принимали их как истинные, и что с незапамятных времён они плодили паразитов в основаниях этики, экономики, политики и правительства во всём мире; мы убедились не только в ложности этих убеждений, но и в том, что ложность их обусловливается грубой ошибкой самого фундаментального типа – ошибкой смешивания измерений или спутывания типов.

    Как мы уже сказали, четвёртая задача состоит в том, чтобы по-возможности отследить фатальные эффекты этой ошибки как в человеческой истории, так и в настоящем состоянии мира. Мы только что пришли к заключению, что эту задачу не удастся выполнить ·_в полной мере_·, потому что, несомненно, как мы видели, если бы ошибку не совершали и не несли её дальше, то в мире сейчас существовала бы настолько продвинутая цивилизация, настолько богатая духовными плодами времени и труда, что для нас ныне она становится попросту непостижимой и невообразимой.

    Невзирая на то, что мы не можем выполнить эту задачу в полной мере, не стоит считать наше положение безнадёжным. Мировая война побудила нас начать мыслить, как мы раньше никогда не мыслили. Она заставила нас думать о реальных вещах, особенно о высшей реальности – реальности человека. Именно поэтому эта великая катастрофа знаменует окончание человеческого детства. Этот период продлился долго, и заканчивается он памятно – внезапной, пылающей, разрушительной демонстрацией всему миру фундаментального невежества – человеческого незнания человеческой природы. Именно эта трагическая ·_демонстрация_·, неожиданная как землетрясение и безжалостная как масштабный голод, даёт основание для надежды на будущее. Она вынудила нас думать о реальности, и именно мышление о реальности вылечит мир. Поэтому я говорю, что в эти дни, несмотря на весь страх и мрак, мы начинаем вести новый порядок в человеческих отношениях – порядок постоянного мира и скорого развития человеческого блага.

    Мы хорошо знаем, что собой представляют люди, и можем передать это знание мужчинам, женщинам и детям через семью, школу, церковь и средства массовой информации по всему миру.

    Мы хорошо знаем и можем научить мир, что человек не есть ни животное, ни волшебная смесь ангела со зверем.

    Мы хорошо знаем и можем научить, что на протяжении веков эти чудовищные ошибочные концепции заставляли миллионы страдать и продолжают это делать сегодня, потому что, несмотря на то, что мы не можем должно оценить «благо», которого они ·_лишили_· человечество, мы можем отследить мрачные последствия их положительного ·_зла_· тысячами способов.

    Мы хорошо знаем и можем научить, что человек, хоть он и не есть животное, представляет собой естественное существо со своим местом, своим рангом в иерархии естественной жизни.

    Мы хорошо знаем и можем научить мир, что человеческий класс жизни ·_характеризуется_· – ·_очеловечивается_· – способностью создавать материальное и духовное богатство: – порождать свет разумного понимания – производить цивилизацию благодаря своей уникальной способности связывать время, сводить прошлое, настоящее и будущее в ·_единую растущую реальность_·, питаемую живущими творениями покойников, продуктивным трудом живущих и правами и надеждами ещё не рождённых.

    Мы хорошо знаем и можем научить, что ·_естественные_· темпы человеческого прогресса представляются быстрорастущей экспоненциальной функцией времени.

    Мы знаем и можем научить, что благо в ·_нынешней_· цивилизации – всё ценное и святое в ней – составляет результат время-связующего труда и векового смещения вечной стены незнания о человеческой природе.

    Мы хорошо знаем, можем научить, и мир поймёт, что, когда мы избавимся от чудовищных заблуждений о человеческой природе в нашей этике и социальной философии, время-связующие энергии человечности начнут развивать цивилизацию согласно их естественному закону ·_PRᵀ_· – стремительной функции времени.

    Такое знание и такое учение положит начало периоду человеческой зрелости, который может стать периодом скорого развития истинной цивилизации. Всё должно развиваться из истинной концепции человека как время-связующего класса жизни, поэтому работу следует начинать с образовательной кампании, достаточно широкой, чтобы охватить мир. Потребуется задействовать в сотрудничестве все образовательные факторы, – семью, школу, церковь, средства массовой информации – чтобы возвестить о фундаментальной истине человеческой природы, сделав её путеводным ·_светом_· и ·_привычкой_· мужчин, женщин и детей всюду. Преобразования пойдут постепенно, но окажут глубокое влияние на человеческие дела; в первую очередь в так называемых науках этики, экономики, политики и управления.

    В своей зрелости человечество не станет руководствоваться ни «животной» этикой, ни «·_сверх_·ъестественной», а естественной – основанной на знании законов человеческой природы. Такая этика уже не будет относится к разделу зоологии, этике клыка и когтя, этике наживы, этике пространство-связующих зверей, борющихся за «место под солнцем». Она станет разделом человековедения, разделом Человеческой инженерии – время-связующей этикой, этикой всецело естественных цивилизаци-образующих энергий человечности. Всё, что согласуется с естественной деятельностью этих энергий, станет ·_правильным_· и ·_благим_·.

    «Выживание самого приспособленного» в смысле ·_сильнейшего_· останется пространство-связующим стандартом – стандартом звериной этики. В зрелой человеческой этике выживание самого приспособленного приобретёт значение ·_лучшего_· в конкуренции за совершенствование, а «совершенствование» станет означать время-связующее совершенствование – совершенствование в производстве и правильном применении материальных и духовных богатств; совершенствование в науке, искусстве, мудрости, справедливости, в содействии благополучию и защите прав как живущих, так и не рождённых.

    Этика, возникшая в мрачный период человеческого детства от концепции человеческих существ как таинственных сочетаний животности и божественности, породило два отвратительных движения: движение обращения с людьми как с животными и порабощения, и движение «сверхъестественного» – продаже индульгенций, развлечений в той или иной форме и «божественной мудрости» невежественных священников. Разумеется, в естественной зрелой человеческой этике таким коммерческим движениям места не найдётся.

    А что мы скажем в частности об экономике, о «промышленности», «безразличном бизнесе» и «финансовой сфере» в этой «нормальности»?

    Передо мной лежит именитый справочник ·_Corporation Finance_· авторства мистера Эдварда Шервуда Мида (издательство Appleton, N. Y.), который ставит цель не отрицательно критиковать, а показать общепринятые, «разумные» основы для ведения процветающего бизнеса. Ничего лучше, чем попросить читателя рассмотреть несколько отрывков из этой работы, демонстрирующей зарекомендовавшие себя, удивительные теории, я сделать не могу. Мне остаётся только сказать, что в период человеческой зрелости на моральную слепоту таких «принципов», их пространство-связующий дух расчётливого эгоизма и алчности мы станем смотреть с отвращением, как мы сегодня смотрим на рабство. Взгляните на эту картину (с. 62):

    (Курсивом фрагменты выделил автор.)

    ⬩«⬩  
    Учитывая, что держателя облигации интересует только гарантия регулярной выплаты его процентов, а также то, что как гарантия, так и проценты зависят о постоянного дохода, то при прочих равных условиях, компании с самой стабильной выручкой или рынком … благоприятствуют самым надёжным гарантиям для выпуска и покупки облигаций.

    Стабильность выручки зависит от (1) владения монополией…. ·_Монополией называется эксклюзивный или преобладающий контроль над рынком. Чем полнее этот контроль, тем ценнее монополия_·. Преимущество монополии заключается в том, что цены на услуги или товары контролируются производителями (·_подразумеваются владельцы – Автор_·), нежели потребителем….

    Монополии имеют разное происхождение. Среди наиболее знакомых мы можем выделить (1) франшизы, дающие право пользоваться ·_общественной собственностью_· в ·_личных целях_·, например, обеспечение светом, водой и транспортом, (2) ·_контроль над источниками сырья_·…, (3) патенты, …, (4) высокая стоимость строительства типовых заводов….

    Например, в отраслях серийного производства предприятия, ·_производящие сырьё_· и ·_предметы первой необходимости_· имеют более стабильный спрос….

    Железнодорожное обеспечение служит, пожалуй, наилучшей основой для выпуска и покупки облигаций в силу стабильности спроса на транспортные услуги… высокая стоимость организации типового железнодорожного производства, … позволяет им устанавливать постоянные цены на грузовые и пассажирские перевозки….

    Гарантии кредиторам обеспечивает прибыльность бизнеса, ·который осуществляется на производстве·. К тому же, бизнес не представляет собой совокупность реальной собственности, а состоит из реальной собственности: зданий, котлов, станков. К этому добавляются промышленные возможности, а также организации и способность управлять бизнесом.  
    ⬩»⬩

    Здесь мы видим животные стандарты в их изученном совершенстве. Комментарии излишни.

    В период человеческой зрелости так называемая «наука» экономика и «баспросветная наука» политическая экономика станут настоящей наукой, основанной на законах время-связующих энергий человечности. Она станет светом Человеческой инженерии, поддерживающим, хранящим и направляющим человеческое благо. С её помощью мы выявим и научим, что ·_человеческая_· жизнь, время-связующая жизнь, представляет собой жизнь не просто ·_цивилизованную_·, но и ·_цивилизующую_·.

    Мы узнаем и научим, что цивилизующую жизнь мы посвящаем производству потенциальных и кинетических практических ценностей – созданию материальных и духовных богатств.

    Мы узнаем и научим, что богатство – как материальное, так и духовное – представляет собой естественное ⁅природное⁆ явление – результат взаимодействия времени и человеческого труда.

    Мы узнаем и научим, что богатство в мире в любой данный момент практически всецело представляет ·_унаследованный_· результат времени и труда покойников. В связи с этим мы спросим:

    Кому по праву принадлежит это наследие?  
    Принадлежит ли оно по праву Смиту и Брауну?[¹](https://teletype.in/@czoc/7CtxyENhCWf#VKgZ)  
    Если принадлежит, то ·_в связи с чем_·?  
    Или же оно по праву принадлежит человеку – человечеству?  
    Если принадлежит, то ·_в связи с чем_·?  
    И, что включает «человечество»?  
    Только живущих, которых наберётся относительно мало, или как живущих, так и не рождённых?

    В зрелой человеческой экономике мы не только зададим эти вопросы, но и ответим на них – ответим правильно. В поисках ответов мы выявим некоторые очевидные истины, и в связи с этим многие старые слова приобретут новые значения, согласованные с время-связующей природой человека. Мы выявим и научим, что время-связующие данного поколения есть одновременно ·_потомки_· и ·_предки_· – потомки покойников, предки всех грядущих поколений.

    Мы выявим и научим, что в этом двойном отношении, сводящем прошлое и будущее в единую, живую, растущую реальность, лежит долг время-связующей этики и находится место её авторитета. В экономике мы узнаем и научим, что ·_человеческие_· потомки – время-связующие потомки – не могут унаследовать результаты времени и труда покойников как ·_животные наследуют дикие плоды земли, борются за них и поглощают их_·, а только как ·_доверенные_· представители грядущих поколений.

    Мы узнаем и научим, что «капиталистическое» пристрастие ·_накапливать_· для ⬩**себя**⬩ и «пролетарское» пристрастие ·_получать_· для ⬩**себя**⬩ относятся к ·_пространство-связующим_· – животным – пристрастиям, ниже уровня время-связующей жизни.

    В зрелой человеческой экономике мы узнаем и научим, что характерные энергии человека как человека по своей ·_природе_· позволяют нам цивилизовать, производить богатства, связывать время мирно и изобретательно, накапливать знание, понимание, навыки и свет.

    Мы узнаем и научим, что этих энергий существующих людей, объединённых с одним миллиардом и шестьюстами миллионами имеющихся «солнце-человеческих» мощей, объединённых с десятью миллиардами живущих «рабочих сил покойников», – если их не растратят из-за невежества, эгоизма, конфликтов и вражды, характерных для зверей – более чем хватает, чтобы произвести высокий порядок растущего процветания по всему миру.

    В экономике периода человеческой зрелости мы выявим и научим, что всеобщее сотрудничество – не борьба человека против человека, а мирное сотрудничество – становится ·_необходимым_· и достаточным условием мирового процветания.

    Мы узнаем и научим, что такое сотрудничество требует ·_научного_· руководства и общей ·_цели_·. Мы, однако, узнаем и научим, учтя ясный урок Германии, что научного знания и общей цели не хватает.

    Мы узнаем и научим, и все поймут, что ставить общей целью, объединяющим принципом, основой сотрудничества следует благополучие не семьи, не провинции, не государства, не расы, а благополучие ·_всего_· человечества, процветание человечности, благо мира – мирное производство богатств без разрушительных войн.

    В человеческой зрелости патриотизм – любовь к стране – не исчезнет; – отнюдь – он вырастет до того, что охватит мир, потому что вашей страной, как и моей, мир станет. Ваше и моё «государство» станет человеческим государством – скоординированным человеческим содружеством; демократией по факту, а не только по имени. Оно станет естественным органическим воплощением цивилизующих энергий, – благо-производящих энергий – характерных для человеческого класса жизни. Его крупные дела направит наука и искусство Человеческой инженерии – не невежественные, продажные «политики», а учёные – честные, ·_знающие_· люди.

    Мы размечтались?

    Да, но наши мечты сбудутся. Мы мечтаем научно и наукой их воплотим.

    Как это сделать?

    Всех подробностей предвидеть никто не сможет, но в общих чертах этот процесс мы видим чётко. Насилия следует избегать. Следует ожидать переходного периода – периода корректировок и привыкания. Первым естественным шагом видится учреждение органа, который мы могли бы назвать динамическим департаментом, департаментом координации или департаментом сотрудничества – название не играет особой роли; такой орган стал бы ·_ядром_· новой цивилизации. Он бы выполнял функции поддержки, помощи и защиты людей в таких совместных предприятиях как агрокультура, производство, финансы и распределение.

    Департамент сотрудничества должен включать различные подразделения; например:

    ⬩**1**⬩ ·_Подразделение математической социологии или человековедения_·, состоящее из, по меньшей мере, одного социолога, одного биолога, одного инженера-механика и одного математика. Их работа заключалась бы в разработке человеческой инженерии и математической социологии, или человековедения, поддержке развития науки, составлении и контроле учебных программ по теории ценностей и базовым знаниям человековедения для начальных школ и широкой общественности. ·_Участники этого подразделения определялись бы надлежащими научными сообществами на ими же определённый срок_·.

    ⬩**2**⬩ ·_Подразделение математического законодательства_·, состоящее из (скажем) одного юриста, одного математика, одного инженера-механика, назначенных как описано выше. В их задачи входило бы предлагать законы, предоставлять средства исключения «законничества» из правовой теории и практики, и приводить юриспруденцию в согласованность с законами время-связующей человеческой природой и меняющимися потребностями человеческого общества. Их законопроекты, в случае одобрения на совместном совете подразделений ⬩**1**⬩ и ⬩**2**⬩, передавались бы надлежащим законодательным органам.

    ⬩**3**⬩ ·_Образовательное подразделение_·, состоящее из двух или трёх преподавателей, одного социолога, одного инженера-механика, одного математика, назначенных как описано выше. Они бы занимались проработкой образовательных проектов и пересмотром школьных методов и учебников. Их решения рассматривались бы совместным советом подразделений ⬩**1**⬩, ⬩**2**⬩ и ⬩**3**⬩.

    ⬩**4**⬩ ·_Подразделение сотрудничества_·, состоящее из инженеров-механиков, экспертов в бухгалтерии, управляющих делами, юристов и других специалистов в своих обязанностях. Это подразделение стало бы промышленным красным крестом» (Чарльз Фергюсон), предоставляющим профессиональные консультации любым сотрудничающим сообществам.

    ⬩**5**⬩ ·_Подразделение банковской службы_·, состоящее из экспертов по финансовым вопросам, социологов и математиков. Оно бы помогало консультациями новым кооперативным банкам.

    ⬩**6**⬩ ·_Подразделение содействия_·, состоящее из инженеров, в чьи задачи входило бы изучать все актуальные научные факты, собирать данные и разрабатывать планы, которые бы затем публиковали и законно разрешали пользоваться ими только сотрудничающим сообществам, но не частным лицам. Это подразделение занималось бы изучением и консультированием в отношении общих условий рынка, потребностей в различных отраслях производства, а также осуществляло бы контроль над организацией типового производства.

    ⬩**7**⬩ ·_Фермерское подразделение_· специалистов по научной и кооперативной агрокультуре.

    ⬩**8**⬩ ·_Международное подразделение·_ ведения сотрудничества в международных отношениях.

    ⬩**9**⬩ ·_Коммерческое подразделение_·  
    ⬩_10_⬩ ·_Новостное подразделение_· для редакции большой ежедневной газеты, содержащей ·_правдивые_·, ·_не приукрашенные_· новости с приложением о прогрессе в работе Человеческой инженерии. В этой газете печатали бы ежедневные новости обо всём движении сотрудничества, рынках и т. д., и т. п.

    На эти места следует отбирать лучших людей среди народа. Им следует хорошо платить, чтобы они могли направить всю свою энергию и время на свои обязанности. Отбор для этой работы следует осуществлять по выше обозначенным критериям – по проверенным заслугам, а не за острый язык. Такие назначения следует определить как высшую честь, которой страна может удостоить своих граждан. Каждое назначение должно служить демонстрацией того, что выбранный человек заслужил это место самыми высокими достижениями в сфере своей работы.

    Мы лишь сделали примерный набросок этого плана; пока он представляет лишь предложение. Его основная цель состоит в том, чтобы выделить необходимость учреждения народной время-связующей службы – динамического департамента для продвижения, направления и защиты цивилизующих энергий, благо-производящих энергий, время-связующих энергий за счёт того, что человек ведёт себя по-человечески. Тогда и только тогда человеческое благополучие, не сдерживаемое чудовищными заблуждениями о человеческой природе – порочной этикой, экономикой и политикой – начнёт двигаться вперёд мирно, безостановочно и стремительно под руководством Человеческой инженерии, счастливо и без страха, согласно экспоненциальному закону – ·_естественному_· закону – время-связующих энергий человека.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/7CtxyENhCWf#oIvr)Смит, Браун и подобные фамилии употребляются как эквиваленты таких русских фамилий как Иванов, Петров и т. д.

    * * *

""".trimIndent()
