package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_8(modifier: Modifier) {
    MarkdownText(
        markdown = chapter_8_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val chapter_8_text = """
    # Глава Ⅷ
    · Зрелость человечности ·, 2-е издание, А. Коржибски
    
    * * *
    
    В мировой войне Германия продемонстрировала грандиозную ·_мощь_·. Давайте, сдержав эмоции, возьмёмся проанализировать эту мощь с математической беспристрастностью.
    
    Почему Германия продемонстрировала больше мощи, чем любой другой народ?
    
    Потому что в построении своей «этики», политической системы и экономической структуры Германия извлекла больше пользы из научных достижений и научных методов.
    
    Многие ошибочно и очень губительно для себя полагают, что войну устроил какой-то «военачальник». Всякая идея или движение, несомненно, исходит от кого-то, но вокруг таких «начал» и инициаций складываются благоприятные условия, силы и побуждения. Жизнь и время готовят сцену; входит актёр и начинается спектакль. В рассматриваемом случае сцену подготовила вся наша современная система цивилизации. Военачальники стали Deus ex machina – получился настоящий спектакль – трагедия.
    
    Истинные начала этой войны следует искать в сфере экономики. Наша экономическая система стала очень сложным результатом всех наших вероучений, философий и социальных обычаев. В связи с этим не удастся понять, как работают экономические силы, если сначала не составить чёткое представление о фундаменте, на котором силы этой системы формируются. Я привёл список материалов на эту тему в конце этой книги. Здесь нам хватит честного высказывания.
    
    Германия доверилась политике неограниченного промышленного расширения. Это искусственное расширение достигло своих пределов. Страна оказалась на грани банкротства. Национальной катастрофы удалось бы избежать только победоносной войной. Германия пустила в ход свой последний козырь и проиграла, невзирая на свою колоссальную мощь, величайшую среди остальных наций. Сильнейшие европейские государства долгое время не могли её превзойти. Я пишу это не из намерения оправдывать Германию, и тем более не из намерения хвалить страну или её военачальников. Страна поставила себе в корне национально узкие и эгоистичные цели, и задействовала бесчеловечные методы, но демонстрировала мощь – мощь, без понимания которой никак не получится построить Человеческую инженерию.
    
    Возможно, виной тому мой военный опыт, но мне кажется, что точка зрения «генштаба» заслуживает принятия не меньше, чем любая другая среди множества трактовок истории – возможно, даже больше. Главная цель генштаба состоит не в том чтобы «сражаться» – отнюдь. Главной целью они ставят «победу», и тем успешнее выйдет победа, чем меньше придётся сражаться. Стратегия, умственный труд, интеллект, знание фактов – они служат основным оружием; жестокие сражения остаются крайней мерой. Следует обязательно иметь это в виду. Солдаты и инженеры не спорят – они действуют. Германия служит первым примером философии или общества, поставившего себе главной целью производство мощи, чтобы «делать», поэтому видится разумным проанализировать историю войны с точки зрения инженера, которая в данном случае совпадает с военной.
    
    Следует чётко понять, что современная военная точка зрения, или точка зрения генштаба, не имеет почти или вовсе никакого отношения к романтике или поэзии войны. Сегодня война представляет собой страшный бизнес, и тем не менее, «бизнес» прежде, чем что-либо другое. Приходится мобилизовать все ресурсы страны и производить предельную мощь. Сегодня войны ведутся технологически – в них обязательно приходится применять инженерные методы. Для того чтобы разрушить препятствие, требуется гигантский молот; чем большей массы его изготовить, и чем больше силы к нему приложить, тем сильнее получится удар.
    
    До мировой войны технологию не мобилизовали так масштабно и для таких грандиозных задач. Мобилизованная технология позволила увидеть возможность производить практически неограниченную мощь, и показала нам, как это делать. Одновременно с этим она продемонстрировала безмерный потенциал инженерии и нашу беспомощность в её отсутствие. Технология как наука появилась относительно недавно; некоторые называют её полу-наукой, потому что в ней мы имеем дело с применением науки к практическим задачам. Когда возникла потребность «делать», пришлось звать инженера, генштаб вынужденно подстроился под его взгляд, а все остальные практики и традиции адаптировали к его идеям.
    
    Я уже несколько раз отмечал, что прогресс технологии следует закону, подобному быстро растущей геометрической прогрессии, и подчеркнул опасность пренебрежения явлениями, силами или движениями, которые подчиняются такому закону. Нам хватит вспомнить рассказ о простом, но очень жадном фермере, который заключил договор с рабочим на месяц работы с оплатой один цент на первый день, в два раза больше на второй, чем на первый, затем в два раза больше на третий, чем на второй и так далее до конца месяца. Счёт за месяц составил миллионы долларов, и фермер разорился. В этом заключается смертельный секрет геометрической прогрессии. Насильственные перестройки ожидают любое общество, которое не поспевает за развитием инженерии.
    
    Инженеры благодаря своим талантам могут, пользуясь результатами научных исследований, подчинять или высвобождать скрытые мощи природы. Главнейшим фактором в этом становится применение разума – экспоненциальной функции времени – время-связующей энергии человека. С него нам следует начинать, потому что из него человек черпает мощь.
    
    Немецкая философия как целое занимает определённое место в истории философии. В первую очередь стоит учесть тех писателей-философов, которые внесли прямой или косвенный вклад в построение немецкой мощи. Значительное влияние на немецкий разум оказал Гегель – каким бы странным это не казалось. Однако на Гегеля существенно повлияла работа Фихте, а на Фихте, в свою очередь, работы Спинозы. Все они формулировали свои методы и философии в некоторой степени – настолько, насколько могли в своё время – математически. Я сказал «странным», потому что считаю значимым, что именно за счёт математической части их работы удалось построить немецкую мощь. Однако, всмотревшись глубже, мы увидим мало странного.
    
    Этого следовало ожидать, потому что мощь получается понять и сформировать только математическими и механическими методами. В 1805 году Гегель вёл лекции по истории философии, чистой математике и естественно-правовой теории. Лучшего сочетания для философии мощи не удалось бы подыскать. Именно такая философия и получилась. Она повлияла не только на немецкую философию, но даже на немецкую теологию, и по этим каналам она дотекла и глубоко осела в народном сознании. Она сказалась на каждом этапе жизни. Вырос громадный культ дисциплин, каждая из которых внесла что-то в эту философию мощи.
    
    Одним из самых примечательных представителей этого движения мы можем назвать профессора Освалда, который в своих ·_Монистических проповедях_· дал известный совет:
    
    ⬩«⬩  
    Не расходуйте энергию; придайте ей значение.  
    ⬩»⬩
    
    Немецкое понимание значения и великой ценности технологии дало применить этот принцип к их философии, праву, этике, политике и так далее.
    
    С ростом населения растёт и неотложность проблемы государства. О государстве существует множество теорий. В текущих целях следует осознать, что государство представляет собой центр управления скоплением людей – время-связующих энергий, растущих экспоненциальных функций времени. Эти энергии сходятся типом, но отличаются но отличаются по степени и по индивидуальности. Для объединения в целое им требуется общая цель; их следует свести к одному основанию. Мы не можем объединить и вычислить целое, сложив экспоненты ·_Xᵐ_·, ·_Yⁿ_·, ·_Zᵖ_· и так далее. Однако, если дать им общее основание, – общую цель или назначение – мы сможем легко представить величины составляемого ими целого.
    
    Если взять ·_X_· в качестве общей цели или основания, то, если ·_Y=aX_·, ·_Z=bX_· и так далее, мы получим:
    
    Xᵐ · Yⁿ · Zᵖ…=Xᵐ · aⁿ · Xⁿ · bᵖ · Xᵖ… = (aⁿ · bᵖ…)Xᵐ⁺ⁿ⁺ᵖ…
    
    Последнее выражение, где коэффициент в скобках означает продукт индивидуальностей, представляет все объединённые мощи по ·_X_· – общему основанию, назначению или цели.
    
    Взглянем на этот вопрос по-другому. Одна механическая «лошадиная сила» составляет меньше, чем мощность одной живой лошади. Одна живая лошадь может выполнить больше работы, чем одна механическая лошадиная сила, но применяя более одной живой лошади одновременно, мы получаем меньше работы, чем если бы применяли то же число механических лошадиных сил; так происходит по очевидной причине. Механические лошадиные силы не отличаются по типу, и мы применяем их как равные и постоянные, тогда как живые лошади отличаются по характеру; мы не можем применять их как равных – каждую мы рассматриваем как переменную. Следовательно, мы можем складывать и умножать механические лошадиные силы арифметически, но не можем делать то же с живыми лошадьми, кроме как очень приблизительно. Живые лошади в группе друг другу мешают; они не работают сообща, из-за чего мы теряем энергию.
    
    Немецкая математическая философия или теория государства находила своё выражение не только в этом. Германия объединила мощи живущих мужчин, женщин и детей, что дало им общее основание – один общий «социальный» настрой и цель для сплочения ради того, что называется государством. Они учились и преподавали для государства. Они работали, жили и умирали ради государства. Государство служило им идолом, королём и богом.
    
    В этом состояла цель немецкой философии, теологии, права и науки. Установление ⬩**одной цели**⬩ для всех послужило решающим фактором. Очевидно, если мы хотим вдохновить 60 миллионов индивидуумов одной целью, мы не можем выбирать её среди личных. Нам нужны более высокие цели, коллективные, общие, не-личные, которые бы каким-то образом объединяли и включали все личные цели. Я назову это просто ·_коллективной_· целью.
    
    Коллективные цели, однако, могут значительно отличаться по типу. Из личных или эгоистичных целей растут цели коллективные, мера обобщённости которых возрастает:
    
    1\. семейные цели;  
    2\. цели ассоциации, конгрегации, сообществ;  
    3\. классовые или профессиональные цели;  
    4\. народные или расовые цели и наконец;  
    5\. ⬩**человеческие цели**⬩ – естественные цели время-связующего класса жизни.
    
    Фатальной ошибкой немецкой политической философии стала ошибка в цели; они поставили слишком низкую, слишком узкую цель – благо государства, вместо блага Человечества.
    
    Германия приравняла народную цель к государственной. Немецкая философия сравняла «государство» с «благом» и с «мощью». Стоило ожидать, что такая философия повлияет на всю народную жизнь. Впоследствии Германия провозгласила себя первой мировой нацией, что вскоре переросло в план по завоеванию мира. Немецкий генштаб как учреждение поставил себе целью и первой задачей «мощь», «сосредоточение мощи» и «эффективность». Для этого потребовалось вести все сферы жизни и промышленности.
    
    Милитаризм и индустриализм почти не отличаются с точки зрения механики; и то и другое представляет мощь. При обоих приходится применять те же научные методы. В ·_настоящих_· условиях в мире они друг от друга зависят, потому что войну не удастся вести без сильных промышленностей. Здесь нам приходится взглянуть в лицо факту, что геометрически прогрессирующая промышленность не может выжить без новых рынков, которые в данных условиях массово приобретались, прямо или косвенно, силами армии; и так это происходило в Германии. Если мы проклинаем Германию за то, что она стала «военной нацией», мы можем не менее справедливо, проклинать её за то, что она стала ·_полностью_· «промышленно развитой страной». Добавив к этому её национально эгоистичную и узкую национальную цель, мы легко поймём этот «мировой персик». Пробовавшие его знают кое-что о его сладости.
    
    Нам не понадобится углубляться в подробности. Данные приводят в специальных книгах. Нас интересует беспристрастный факт, что ·_сила_· и ·_мощь_· Германии служит наилучшим наглядным примером того, чего удаётся достичь наукой и в некоторой мере математической философией, даже когда их направляют не на благо человечества, а на благо сравнительно небольшой группы людей.
    
    Вышеописанные политические философии оказали значительное влияние на Маркса. Среди направлений в социализме существует так называемый государственный социализм. Государственные социалисты, как мы можем заключить по названию, считают, что государству следует выполнять важнейшие функции в обществе. Мы ясно видим, что в монархических странах, где государство представляют «богоизбранные» правители, такую теорию поприветствовали бы, потому что она даёт правителям возможность показывать своего рода «продвинутый либерализм», который служит укреплению их власти.
    
    Проницательного Бисмарка не приходится подозревать в прогрессивных взглядах в современном смысле, но в силу влияния немецкой культуры и философии все его идеалы сводились к сильному государству. Он получил известность как сторонник государственного социализма. По меньшей мере, с 1879 года Бисмарка считали практически передовым сторонником отечественного государственного социализма. Он верил и продвигал близкие отношения государства с железными дорогами, поддерживая основательную национализацию, которую он в итоге осуществил. Это позволило избавиться от коррупции в общественной жизни Германии, которая возникает из-за частного владения железными дорогами, на которые жизненно полагается любая страна.
    
    Резюмируем: Германия применила наиболее научные методы, чтобы сформировать свою национальную мощь. Она поняла стихии «мощи», потому что их удалось выявить благодаря её науке и философии. Она применила технологические методы к каждой части общественной жизни, и за счёт этого нарастила свою колоссальную мощь. Её промышленная жизнь пошла по военному пути; её военную силу удалось набрать промышленной мощью.
    
    Получается порочный круг. Германия приняла ·_коллективную_· цель вместо личной, индивидуалистической, и за счёт этой более широкой цели ей удалось мобилизовать и поддерживать мобилизацию моральной, политической и промышленной мощей долгие годы до войны. Прямым эффектом этой системы устойчивой мобилизации стало перепроизводство. Из-за этого ей понадобились новые рынки. Дешевле и быстрее всего их удалось получить, или перехватить, с помощью победоносной войны. Её планы следовали программе полностью, исключая победу на поле сражений.
    
    Эта война стала бедствием беспрецедентной величины для мира, поэтому мы должны изучать её беспристрастно и усваивать её уроки, если не хотим оставаться моральными пособниками этого великого преступления современности, позволяя миру катиться к катастрофе похуже. Нам следует выйти из привычной колеи, докопаться до сути этой проблемы и безжалостно её проанализировать, нравится нам это или нет. Мы должны ценить «десятерых священно погибших», по меньшей мере, так же как мы ценим одного убитого в научной лаборатории кролика. Мы должны серьёзно обдумать и учесть урок готовности к повторению мировой бойни.
    
    Если бы Человеческую инженерию учредили давно, наша социальная система отличалась бы от сегодняшней, наша цивилизация развилась бы гораздо выше, а этой войны удалось бы избежать. Нам следует прекратить себя обманывать. Мировая война случилась в результате плохо сбалансированных социальных и экономических сил. Миру требуются другие «балансы мощей», которые не устанавливают юристы и политики из своих единоличных или групповых эгоистичных интересов. Человечеству следует обратиться к науке и искусству человеческого направления, основанного на правильном понимании человеческой природы.
    
    * * *

""".trimIndent()