package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_7(modifier: Modifier) {
    MarkdownText(
        markdown = chapter_7_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val chapter_7_text = """
    # Глава Ⅶ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Человечество представляет собой динамическое отношение; возможно, самое динамическое из известных, потому что оно может направлять базовые энергии. Там, где производится энергия, для неё должен быть выход. Энергия неминуемо должна выражать себя в какой-то форме. Электричество, сформировавшееся в небе, спускается иной раз катастрофическим образом. Электричество, произведённое целесообразно, даёт работать нашим железным дорогам. Тем же образом огромную мощь, произведённую человечеством, следует применять целесообразно, конструктивно, иначе она взорвётся восстаниями, революциями и войнами.

    До сего времени нас направляли безосновательные науки, построенные на мифологических идеях об энергии – на идеях, сформированных по личным амбициям, личным интересам или попросту по невежеству. Периодически нам приходится иметь дело со всеми типами зол, возникающих от недостатка общей цели и научного направления. Власть держат «богоизбранные» или «хитрейшие»; редко «самые приспособленные» – самые способные «делать». Те, кто говорят о «выживании самых приспособленных», ссылаясь на животную теорию Дарвина, гавкают на животном языке. Это правило действует естественно только в жизни растений и животных, и мы не можем говорить о нём уместно, кроме как в контексте обсуждения более низких форм физической жизни. Говорить о нём применимо ко время-связующему классу жизни мы можем, только в корне поменяв его значение, иначе мы рискуем устроить катастрофу.

    Сегодня мы оправдываем накопление богатства на личные цели доводом о «выживании самого приспособленного». Там, где приходится «выживать», стоит ожидать жертв; там, где мы находим жертв, происходила борьба.

    Это имеют в виду люди, которые пользуются этим доводом?

    Подобно королям, они ведут переговоры о мире, чтобы начать войну. Такой подход не отличается новизной. Мир к нему давно привык.

    Я считаю, что большинство знатоков надуманных полу-наук, таких как экономика, право, этика, политика и управление честно верят в свои убеждения и догадки. Правильные люди верят в неправильные вещи. Если им показать правильные пути из этого бардака, они прекратят препятствовать прогрессу и начнут приносить пользу миру, построенному человеческими инженерами, где человеческие способности, экспоненциальные функции времени, станут работать естественно, а экономика, право, этика, политика и управление из ·_статических_· преобразуются в ·_динамические_·. Между этими словами пролегает целый мир отличий.

    Первостепенной задачей этой книги я ставлю показать, как направлять время-связующие мощи человечества на всеобщее благо. Человеческой технологии, как науки и искусства, пока не существует. Для основания такой науки потребовались некоторые базовые принципы. Особенно необходимо понадобилось установить ·_человеческий_· стандарт, чтобы чётко и ясно утвердить, что «пространство-связующие» – представители ·_животного_· мира – находятся «вне человеческого закона» – вне естественных законов человеческого класса жизни.

    Ситуация с нынешней цивилизацией представляется очень сложной. Невзирая на то, что со многими нашими социальными проблемами мы справляемся очень плохо, резко положение дел поменять не получится, не подвергая благополучие и жизни всех классов общества опасности. Изменения, тем не менее, следует обязательно внести, потому что мир не сможет продолжать жить долго в предвоенных условиях. Мы подверглись фактам достаточно, чтобы не позволять себе снова слепо вестись.

    В мировой войне человечеству пришлось пройти тяжелейшее испытание и несколько лет находиться под давлением широкой кампании мобилизации. Необходимость наращивания мощей стала очевидной, как и необходимость установить общую цель. В этом случае мы нашли общую цель в «военном патриотизме». Общая цель дала возможность всем государствам свести индивидуальные мощи и максимально эффективно ·_коллективизовать_· единую мощь. Я пользуюсь этим словом не только в социальном смысле, но и в математическом. Высокие идеалы, подаваемые Urbi et orbi тысячами речей и миллионами пропагандистских листовок, сыграли гораздо более важную роль в образовании, чем знает большинство людей. Люди пробудились и выработали вкус к высшим целям, о которых раньше знало лишь меньшинство.

    Пало много старых, потрёпанных идолов, идей и идеалов, но что придёт им на смену?

    Мы наблюдаем неспокойствие, которое не прекратится, пока мы не сделаем что-то необходимое, чтобы его уладить. Спокойствие часто предвещает грядущую бурю. Грядущую бурю не затевает какой-то «плохой» человек; она происходит как следствие «плохой системы». Если мы прячем головы в песок, думая, что так нам ничего не угрожает, мы подвергаем себя опасности.

    «Выживание самого приспособленного» в расхожем животном смысле не служит никакой теорией или принципом для «время-связующего» существа. Эта теория работает только применимо к физическим телам животных; на человечество она производит пагубный, деградирующий эффект (см. Приложение Ⅱ).

    Мы видим этот принцип в работе всюду вокруг нас: в преступной эксплуатации и корысти. Применение это животного принципа к человеческим отношениям на протяжении веков привело к глубочайшему моральному упадку человечества. Алчность и эгоизм открыто практикуются как главные принципы поведения, а мы в молчаливом согласии пожимаем плечами, объявляя алчность и эгоизм основой человеческой природы; мы принимаем их как данное и легко их допускаем. Мы так сильно деградировали, что даже капиталистический пророк Адам Смит в своём знаменитом ·_Богатстве народов_· формулирует законы богатства, исходя не из явления богатства, не из статистических докладов, а из явления эгоизма. Это показывает пугающе глубокое влияние на всё человечество теории о том, что человек есть «животное».

    Мы можем этому не удивляться. В предшествующих главах мы выяснили, что имеем дело с ошибочной теорией; ошибочной, не только в силу её печальных эффектов, но и потому что она даёт неверное представление о характерной природе человека. Человеческая природа, эта время-связующая мощь, не только несёт особую функцию непрерывного прогресса, но и, далеко за гранью всех животных наклонностей, она обладает определёнными качествами, которые делают её уникальным измерением или типом жизни. Мы не только стремимся к высоким идеалам, но даже наши покойники ·_отдают_· нам богатое наследие, материальное и духовное, всех своих трудов. Не стоит видеть в этом ничего мистического. Тот, кто называет ⬩**такой**⬩ класс ·_естественно_· эгоистичным, несёт бред и совершает насилие.

    Эта предрасположенность к высоким идеалам не возникает в связи с каким-то «·_сверх_·ъестественным» фактором; она ·_не_· формируется извне, а осуществляется как выражение нашей время-связующей ·_первоосновы_·, независимо от нашей «воли»; мы получаем её от рождения как ·_дар_· природы. Мы попросту получились именно такими, а не какими-то другими.

    Мы можем, тем не менее, если захотим, применять выражение «выживание самого приспособленного» к деятельности время-связующих энергий человека. Мы располагаем способностью выживать с помощью собственных поступков, и мы ей пользуемся – мы выживаем поступками, которые совершаем, чем обеспечиваем «выживание во времени» всё более и более высоких идеалов. Как только мы видим человека в его должном измерении – действующим во ⬩**времени**⬩ – всё становится простым, огромным и красивым.

    ⬩«⬩  
    Обратите внимание на характер грядущего преобразования. Мы больше не посмотрим на мир как на нечто чуждое, глазами, которые ему не принадлежат. Концепция целого примет ·_нас_· как ·_часть_· действительно, буквально, осознанно замыкающим событием в развивающейся последовательности, восхождением на высшую точку постоянно растущей иерархии бытия, но продолжит, как возникло, возникать ·_natura naturata_· из какого-то наступательного источника.

    Я понимаю, что менять точку зрения приходится с трудом, – старые привычки подобно каменным стенам сдерживают приливы сознания в старых каналах – но этого получится добиться, устойчиво прилагая усилия на протяжении времени. Этим воссоединением целое восстанавливается, а часть сохраняется….

    Во всей вселенной событий, никакое не происходит более чудесным образом, чем рождение изумления; ничего любопытнее самого любопытства; ничего сравнимого с рассветом сознания в древнем тёмном, постепенном развитии душевной жизни и с просветлением обширного космоса, который до этого лишь ·_был_·. Вечность слепых поступков, преобразований, неосознанного существования, долгих предположений, к рождению смысла и разума, без потерь и прерываний последовательности, верной формой уходящего времени.  
    ⬩»⬩  
    Кассий Дж. Кайзер, ук. соч.

    Следует подчеркнуть, что развитие высоких идеалов осуществляется благодаря ·_естественной_· способности человечества; импульс представляет собой время-связующий импульс. Как мы увидели из анализа функций разных классов жизни, каждый класс жизни испытывает импульс реализовать свою особенную способность или функцию. Азот не вступает в сложные соединения, а если вступает, то быстро вырывается из них.

    У птиц есть крылья – они летают.  
    У животных есть ноги – они бегают.  
    Человек обладает время-связующей способностью – он связывает время.

    Понимаем мы «саму суть» этого явления или нет, имеет не больше значения, чем в вопросах понимания «сути» электричества или любой другой «сути».

    Жизнь показывает, что человек обладает время-связующей способностью и испытывает естественную потребность её применять. Одним из лучших примеров служит продолжение рода. Мы совершенно не понимаем явление «сути» зачатия, но, обладая способностью продолжать род, мы применяем её, не утруждая себя рассуждениями о её «сути». К этому, ни в жизни, ни в науке мы не беспокоимся о «сутях» – мы оставляем «сути» в области метафизики, которая не есть ни жизнь, ни наука. В наших целях хватает понять, что идеализация работает как естественный процесс время-связующей человеческой энергии. Какую бы несовершенную этику мы не практиковали из-за преобладания животных стандартов, она как показатель служит свидетельством естественному присутствию «идеализации» во время-связующей человеческой жизни.

    ⬩«⬩  
    Таким, образом мы видим, что идеалы не есть то, над чем стоит разглагольствовать или вздыхать и предаваться чувствам. Они не есть что-то, что останется, если избавиться от физической реальности. Идеалы есть сама твердь реальности; прекрасная, драгоценная, без которой не существовало бы ни величия, ни надежды, ни света. Однако на их аспект стоит смотреть не как на сентиментальное и мягкое, а как на твёрдое, холодное, разумное, логичное, строгое. Идеализация заключается в концепции или интуиции идеалов и стремлении к ним.

    Идеалы я поделил на два вида. Давайте тщательнее рассмотрим отличия между ними.

    Всякая человеческая деятельность – ковка лошадей, хирургия брюшной полости, рисование портретов – предполагает уникальный тип совершенствования. Ни в какой деятельности не удастся сбежать от собственного типа, но в его пределах человек может неограниченно развиваться. При каждом типе фигурирует идеал – представление о совершенстве – недостижимый предел бесконечной последовательности потенциальных улучшений в рамках типа и на его уровне. Представления о таких недостижимых совершенствах не поддаются исчислению, как и типы совершенствования, к которым они относятся. Вместе они составляют знакомый мир наших человеческих идеалов. Делиться в этом мире – испытывать притягательность совершенствования, как бы ни слабо – означает быть человеком. Не испытывать этого, означает быть недочеловеком. Однако этот расхожий вид идеализации, невзирая на его важность и ценность, не ведёт к великим событиям в жизни человечества.

    К ним ведёт вид идеализации, который согласуется с тем, что мы назвали математическим прототипом, предело-рождённое обобщение – вид идеализации, свойственный творческому гению, который не довольствуется стремлением к идеалам среди существующих типов совершенствования, а создаёт новые типы в науке, искусстве, философии, литературе, этике, образовании, общественном порядке, во всех сферах и формах духовной жизни человека.  
    ⬩»⬩  
    Цитировано из рукописи готовящейся к публикации книги ·Математическая философия· Кассия Дж. Кайзера.

    «Выживание самого приспособленного» реализуется по-разному у разных классов жизни. Применение животных стандартов ко время-связующим существам не отличается от попыток дюймами измерить вес. На деле мы не можем поднять один класс к более высокому, кроме как добавив к первому совершенно новую функцию; мы можем лишь улучшить их низший статус. Применив обратный метод, мы можем низвести человеческие стандарты до животных.

    Животные стандарты относятся к классу жизни, способность которых не составляет ·_экспоненциальную_· функцию ·_времени_·, и в этом факте нет ничего теологического или сентиментального; это просто математическая истина.

    Применение теории «выживания самого приспособленного» в одинаковом смысле к двум радикально разным классам жизни ведёт к вымиранию. «Выживание самого приспособленного» у животных – у пространство-связующих – сводится к выживанию в пространстве, что означает жестокую борьбу. «Выживание самого приспособленного» у человека ·_как такового_· – у ·_время-связующего_· – осуществляется выживанием ·_во времени_·, что означает умственную или духовную конкуренцию, борьбу за совершенствование – выживает тот, кто производит ·_наилучшее благо_·. Самые приспособленные во времени вносят самый большой вклад в производство ценностей для всего человечества, включая ·_потомство_·. Это составляет основу естественной этики – этики, от которой не удастся уклониться или сбежать.

    Следовательно, время-связующие не могут применять «·_животную_·» логику, не деградируя со своего человеческого статуса, определённого природой. «Животная» логика ведёт к «животной» этике и «животной» экономике; она неизбежно ведёт к бесчеловечной промышленной системе, где коварство отбирает у живущих плоды трудов покойников.

    ·_Человеческая_· логика указывает нам путь к человеческой этике и человеческой экономике. Она ведёт нас к очеловеченной промышленности, где конкуренция ведётся в науке, в искусстве, в справедливости: конкуренция и борьба за совершенствование человеческой жизни. Время-связующая способность, которая осуществляется черпанием из ⬩**прошлого**⬩ через ⬩**настоящее**⬩ для ⬩**будущего**⬩, даёт людям средства обретения драгоценного бессмертия. Она позволяет им соблюсти закон их собственного класса жизни и выживать бесконечно благодаря плодам их труда, что ведёт к постоянному счастью нескончаемых поколений человеческих детей. Эту истину мы признаём, когда называем великих людей бессмертными. Мы говорим, что они совершили поступки, которые выживают во времени и поддерживают человеческое благо.

    Человеческая логика – математическая логика, логика, ·_естественная_· для человека – покажет нам, что понятия «хорошо», «справедливо» и «правильно» обретают свои значения и понимаются всецело в рамках человеческой ·_природы_·. Человеческая – а не животная – природа станет основой и направляющей Человеческой инженерии. Основанной и направленной Человеческой инженерией мы избавимся от аферистов, мошенников и «политиков». С её помощью мы положим конец промышленному насилию, забастовкам, восстаниям, войнам и революциям.

    Сегодняшнюю систему социальной жизни мы строим преимущественно на недопониманиях и ошибочных представлениях. Для всякой работы нам требуется человеческий мозг, человеческая время-связующая мощь, однако, мы продолжаем называть это «ручной труд» и обращаться с ним как с таковым. Даже в механике мы выражаемся некорректным термином «лошадиная сила».

    Как эта «лошадь» выглядит на деле?

    Давайте проанализируем эту «лошадь». Всю науку, все механические приспособления произвёл «человек» и только человек. Всё, чем мы владеем, составляет работу либо мёртвого, либо живущего человека. Эксплуатация солнечной энергии представляет собой чисто человеческое изобретение как в теории, так и на практике. Следовательно, всё, что у нас есть, очевидно, составляет результат время-связывания. Называя исключительно человеческое достижение лошадиной силой, мы несём абсолютную чепуху.

    Конечно, математически, как мы называем единицу мощности, не играет роли; мы можем назвать её «Зевс» или «Зебра». Однако, применяя название животного для обозначения чисто человеческого продукта, мы несём дурную подоплёку. Всё в нашей цивилизации произвёл ⬩**человек**⬩. Видится разумным, что единицу мощности – прямой результат работы человека – следует корректно называть его именем. Это произведёт глубокий, благотворный образовательный эффект. Так мы станем регулярно подчеркивать человеческую ценность и прививать уважение к человеческой работе со школьного возраста. Эта «лошадиная сила» заставляет нас забывать человеческое участие и низводить человеческую работу до уровня товара. Это служит примером деградирующего влияния ложных концепций и неподходящего языка. Я сказал «образовательный», потому что это повлияет даже на наш подсознательный разум. (см. Приложение Ⅱ.)

    Человеческая инженерия не помешает никаким научным исследованиям; напротив, она им во многом поспособствует. Взрослые люди, стоит надеяться, прекратят заниматься бредовым смешиванием измерений, за которое мы наказываем детей. Мы допускаем грубую ошибку, подобную той, когда смешиваем явления – измеряем «бога» по человеческим стандартам, или человека по животным стандартам. Отношения – если таковые существуют – между этими явлениями или пересечения разных классов представляют интерес, и мы можем придавать им важность, но наша ошибка становится роковой, когда, изучая такие отношения классов, мы смешиваем их. Если мы исследуем отношения между поверхностями и объёмами и принимаем объёмы за поверхности, мы знаем, что ошибаемся грубейшим образом. В точности то же самое происходит, когда мы по своей глупости путаем людей с животными.

    В жизненной действительности нас интересует только сами значения функции явления, и чтобы прийти к правильным заключениям, нам приходится пользоваться единицами, которые явлению подходят. Смешивая единицы, мы складываем ошибочную концепцию значений каждого явления; мы получаем неправильные результаты вычислений и в итоге приходим к неверному представлению о процессе человеческой жизни. Осознав этот факт, мы прекратим применять животные меры к человеку; даже в теологии избавятся от этой ужасной привычки.

    Животные единицы и стандарты следует применять к животным; человеческие стандарты к людям; «божественные» к «богу».

    В тёмные времена, при полном непонимании науки, «почему» происходящего объяснялось «кем-то», его творящим. Человека считали ·_homo sapiens_·, а homo sapiens = животное × искра сверхъестественного. Эту формулу принимали как истину в конечной инстанции – как ответ на вопрос:

    Что есть человек?

    В руках церкви и государства такой ответ стал эффективным инструментом удержания людей в подчинении.

    Склонность толпы позволять другим думать за них в действительности ·_не естественна_· – совсем наоборот. Привычка не думать самостоятельно выработалась в результате тысяч лет подчинения. Власти в целом удаётся своими навыками не давать людям мыслить. Многих людей мы считаем и часто называем «тупыми», потому что с ними разговаривают на языке догадок, который они инстинктивно не любят и которому не доверяют. Мы даже иногда говорим, что речь изобрели, чтобы скрывать истину. Тому, что они производят впечатление «тупых», удивляться не приходится; удивиться стоит тому, что они не «отупели» ещё сильнее. В действительности они окажутся гораздо умнее, если к ним обратиться на естественном языке поддающихся констатации фактов. Я строю всю свою теорию в гармонии с естественными человеческими ощущениями. Предложенные концепции я основываю на человеческой ·_природе_·. Естественный язык – такой отличный от речи метафизических догадок – приведёт к взаимопониманию и позволит прекратить деление на враждующие лагеря.

    ⬩«⬩  
    Поговорка уместно учит, что разум начинается с умения различать. Этот первый разумный поступок ведёт к первому разумному результату – ·_числовому_·: умение различать производит ·_два_· – простейший из возможных пример множественности. Открытие, или, лучше, произведение, или, ещё лучше, создание, множественности с её коррелятом, числом, представляется самым примитивным достижением или проявлением разума….

    Нам следует положиться на базовый арифметический инстинкт, потому что инструменты мышления, обращённые в область числа, не подведут нас.  
    ⬩»⬩  
    К. Дж. Кайзер, указ. соч.

    Представители мыслящего меньшинства знали о силе «мышления». Они воспользовались им себе в преимущество. Мы это видим в создании общественных школ. Вера в более низкое положение толпы стала неписанным законом «привилегированных классов». Церковь и государство навязали и вбили её в подсознание толпы, а толпа «порядком ниже» смиренно и молча приняла её как свою «судьбу». Невежество провозгласили блаженством.

    Со временем «коэффициент невежества» стал настолько полезным для некоторых людей и некоторых классов людей, что они не жалели усилий на то, чтобы поддерживать мир в неведении. Это привело к законнической свободе заключать в тюрьму, сжигать и вешать людей за выражение мнений, которые не нравились правящим классам. Преподавателей и профессоров, которые посмели подать пример или побудить смелые исследования и свободу слова, стали выгонять из школ, университетов и церквей. В нашем поколении такое случается реже, но свободу ещё предстоит отвоёвывать.

    В свободе, если её правильно понимать, заключается цель Человеческой инженерии. Свобода не есть своеволие; свобода не есть вседозволенность. Свобода заключается в жизни по ·_законам_· – в жизни по законам человеческой ·_природы_·, по ·_естественным_· законам человека. Растение остаётся свободным, когда ему не мешают жить и расти по естественным законам растительной жизни. Животное остаётся свободным, когда ему не мешают жить по естественным законам животной жизни. Человек остаётся свободным тогда и только тогда, когда ему не мешают жить по естественным законам человеческой жизни. Я говорю «когда не мешают», потому что люди заживут ·_естественно_· и, следовательно, свободно, когда им прекратят мешать так жить невежеством о человеческой природе и искусственными социальными системами, которые такое невежество основывают, поддерживают и защищают.

    Человеческая свобода заключается в осуществлении время-связующих энергий человека согласно естественным законам таких естественных энергий. Таким образом, в человеческой свободе состоит цель Человеческой инженерии, потому что Человеческая инженерия представляет собой науку человеческой природы и искусство ведения человеческих отношений по законам человеческой природы. Выживание самого приспособленного, при котором «самый приспособленный» означает ·_сильнейший_·, служит ·_естественным_· законом для зверья, для животных, для класса ·_пространство_·-связующих. Выживание самого приспособленного, при котором «самый приспособленный» означает ·_наилучший_· в науке, искусстве и мудрости, служит ·_естественным_· законом для человечества – время-связующего класса жизни.

    * * *

""".trimIndent()