package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_6(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp)
    ) {
        item {
            MarkdownText(
                markdown = chapter_6_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Spacer(modifier = Modifier.height(20.dp))
            Image(
                painter = painterResource(R.drawable.table1),
                contentDescription = "таблица",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_6_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
    }
}

val chapter_6_text_1 = """
    # Глава Ⅵ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Декарт, Ньютон и Лейбниц своим бессмертным трудом открыли действенные методы для математики – единственно языка, подходящего для выражения законов природы.

    Человеческая инженерия станет наукой, с помощью которой удастся решить великие проблемы общества. Впервые с первого дня существования человека, он сможет действительно понять собственную природу и статус. Он научится направлять научно живые и неживые силы, чтобы строить и предотвращать разрушение и растраты.

    Это может показаться странным, но в действительности время-связующие экспоненциальные мощи под названием «люди» не умирают – умирают их тела, но их достижения живут вечно и служат перманентным источником энергии. Все наши ценности – наука, сформированная опытом, накопленное богатство во всех сферах жизни – представляют собой кинетические и потенциальные практические ценности, созданные и оставленные ушедшими поколениями. Эти сокровища, хранимые человечеством для применения, произвели большей частью в прошлом благодаря особой вримя-связующей мощи или функции человека. Естественное течение жизни и развитие этой сокровищницы часто сдерживают, отклоняют от курса или отталкивают назад в связи с невежеством человеческой природы, метафизическими догадками и софизмом. Тех, кто, намеренно или нет, удерживают темпы умственного развития человечества на уровне арифметической прогрессии, следует считать настоящими врагами общества, потому что они заставляют жизне-регулирующие «науки» и институты отставать от самой жизни. В результате мы получаем периодическое социальное насилие – войны и революции.

    Давайте проведём более подробный анализ потенциальных и кинетических практических ценностей. Все потенциальные практические ценности, оставленные нам покойниками, ограничиваются временем и отличаются по применимости. Многие потенциальные практические ценности находятся в музеях; они несут очень ограниченную ценность в практической жизни. Однако некоторые дороги и искусственные водоёмы, построенные древними предками, обладают практической ценностью по сей день.

    Почти бесконечное множество современных потенциальных практических ценностей, таких как здания, благоустроенные территории, железнодорожные пути, некоторые механизмы и инструменты, несут или продолжат нести практическую ценность ещё долго. Практическая ценность некоторых подобных предметов материального богатства сохранится дольше одного поколения. Кинетические практические ценности остаются перманентными по характеру, потому что, несмотря на то, что они могут устареть, они служат основой для разработок, которые их превосходят, поэтому они продолжают жить в том, к чему они ведут.

    Теперь обратим внимание на одну из наиболее важных кинетических и потенциальных практических ценностей, произведённых человеком – изобретение парового двигателя. С помощью этого изобретения человечество извлекло пользу не только из живущих результатов труда покойников, но также из непостижимо больших количеств солнечной энергии и времени, связанного в росте растительной жизни, хранимых для применения в форме угля и других горючих веществ растительного происхождения. Это изобретение привело к революциям в нашей жизни, идущим во множестве направлений. Для краткости я проанализирую только самые выдающиеся эффекты.

    Человеческая инженерия никогда не существовала, кроме как в зародышевой форме. В старину концепция и знание естественного закона отсутствовали или почти не распознавались. До изобретения парового двигателя люди полагались большей частью на человеческие силы – на «живущие силы»; на силы живущих людей и на живущие результаты труда покойников. Даже тогда приходилось испытывать множество сложностей.

    Изобретение парового двигателя позволило человеку пользоваться новой мощью колоссальной величины – хранимой мощью солнечной энергии и веков времени. Нам следует обратить внимание, что мы сегодня имеем возможность пользоваться этой новой мощью связанной солнечной энергии и времени с помощью человеческого изобретения – продукта от покойников.

    Над значимостью последнего высказывания стоит задуматься. Ныне покойный изобретатель парового двигателя не смог бы произвести своё гениальное изобретение, если бы не воспользовался живущими мощами других покойных людей – если бы не воспользовался материальными и духовными или умственными богатствами, созданными теми, кто жил до этого. В умственном багаже изобретателя лежала кинетическая практическая ценность «связанного времени», что позволило ему открыть законы тепла, воды и пара. Он задействовал как потенциальную, так и кинетическую практические ценности механических инструментов, методов работы и научных знаний своего времени и поколения – практические ценности богатства, созданного гением и трудом ушедших поколений. Это изобретение не произвели, скажем, 6000 лет назад, потому что цивилизация тогда ещё не продвинулась достаточно. С математической точки зрения, производству этой великой практической ценности пришлось ждать, пока за шесть тысяч лет накопится работа человеческой изобретательности и труда. Мы можем рассматривать паровой двигатель как кинетическую практическую ценность, в которой фактор времени составляет около 6000 лет, или приблизительно 200 поколений.

    Мы ясно видим, что за одну жизнь, даже самый способный гений не смог бы в туземных условиях – незнания ни о чём, даже о железе – изобрести и построить паровой двигатель. Если бы тот же изобретатель мог прожить несколько тысяч лет, следя за всеми процессами, которым не препятствовали предрассудки тех времён, и смог бы создать все эти изобретения сам, он бы олицетворял весь прогресс цивилизации.

    По этому примеру мы видим глубокое значение слов «живые мощи покойников». Мы видим жизненную важность фактора ⬩**времени**⬩ в человеческой жизни. Мы лицезреем значимость время-связующей мощи человека. Нам следует увидеть паровой двигатель по-новому – как, главным образом, накопленное произведение работы покойников. Одно поколение проживает короткую жизнь, и, если человек не обладал способностью наследовать материальные и духовные плоды труда покойников, дорабатывать их за свою скоротечную жизнь и передавать их потомкам, то процесс цивилизации не мог происходить, и сейчас мы бы жили в туземных условиях. Цивилизация представляет собой творение, сотворить которое удалось благодаря время-связующей мощи человека. Животные ей не обладают, потому что относятся к более низкому типу или измерению жизни.

    Софизм нам ничего не даёт. Если ребёнка оставить в лесу, он не разовьётся выше дикаря, не превосходящего по умственным способностям гориллу. Он станет цивилизованным человеком только за счёт накопления и ознакомления с работой покойников, потому что так и только так он может начать с того, на чём остановилось предыдущее поколение. Этой способностью обладают только люди; я не могу повторить это достаточно раз.

    Мы не можем истинно сказать, что ·_А_· начал свою жизнь при содействии достижений только (скажем) своего отца, потому что достижения его отца зависели от достижений ·_его_· ближайших предшественников и так далее назад через всю жизнь человечества. Этот факт высшей этической важности касается ·_всех_· нас. Никто из нас не может говорить или вести себя так, будто материальное и духовное богатство, которым мы обладаем, произвели мы сами. Если нам хватает ума, мы видим, что то, что мы называем ·_нашим_· богатством, ·_нашей_· цивилизацией, всё, чем мы пользуемся и всё, что имеем, представляет собой результат труда ныне покойных людей – рабов и «владельцев» рабов. Металлическая ложка или нож, которыми мы пользуемся каждый день представляет собой продукт работы многих поколений, включая те, которые открыли металл, нашли ему применение и изобрели ложку.

    Здесь возникает важный вопрос:

    Если богатство мира, главным образом, составляет свободный дар прошлого, – результат работы покойников – то кому оно по праву принадлежит?

    От этого вопроса не получится уклониться.

    Можем ли мы считать существующую монополию великих унаследованных сокровищ, созданных трудом покойников, нормальной и естественной эволюцией, или же стоит рассматривать её как искусственный статус, навязанный меньшинством большинству?

    В этом заключается загвоздка современных дискуссий.

    Большинство знает, что изобретение парового двигателя и других двигателей внутреннего сгорания, которые высвобождают солнечную энергию для механического применения, произвели революцию в экономической системе. Конструирование двигателей в масштабах современных нужд требует собирать большие числа живущих людей в одном месте, строить заводы, налаживать работу оборудования, применяемого в сборке двигателей, и всё это, в свою очередь, требует большого количества денег. Именно поэтому эту эру называют капиталистической.

    Нам, однако, следует остановиться и проанализировать факторы ценности изготовления двигателя и денег, потраченных на применение накопленных энергий солнца.

    Мы узнали, что своей значительной частью двигатель и все факторы, связанные с его производством, представляет собой собранную мощность труда покойников.

    Мы узнали, что богатство или капитал и его символ, деньги, тоже главным образом составляют связанную мощность труда покойников. Поэтому иначе чем применять результат труда покойников, не получится извлекать пользу из высвобождения солнечной энергии.

    Мы видим далее, что только люди или организации, которые собирают самые крупные суммы денег, представляющих работу покойников, могут наиболее полноценно применять накопленные энергии времени и древнего солнца. Таким образом, монополия накопленных энергий солнца возникает от монополизации накопленных результатов труда покойников. Эти проблемы в будущем станут вопросами на рассмотрение в рамках науки и искусства Человеческой инженерии.

    Давайте взглянем на эти проблемы под другим углом.

    Мощность, вырабатываемая при сгорании одного фунта угля теоретически составляет 11.580.000 футо-фунтов. Однако мы своими несовершенными методами применения извлекаем не более 1.500.000 футо-фунтов. Это приблизительно составляет количество физической энергии, приложенной человеком средней силы за день работы. Отсюда 300 фунтов угля представляют труд человека за один год. Сегодня в мире добывается приблизительно 500.000.000 тонн (1906 год). Если предположить, что только половина этого угля тратится на механическое применение, это даст нам примерно 1.600.000.000 единиц рабочей силы производителей – не потребителей.

    Взглянем на ресурсы ещё шире. Мы имеем около 1.600.000.000 живущих человек (учтя все переписи, доступные за период с 1902 по 1906 годы); богатство в размере примерно ${'$'}357.000.000.000 (·_Social Progress_·, 1906, страница 221), которое в нашем анализе относится к работе покойников, и солнечная энергия, равная, в работе, работе всего живущего населения, или равная 1.600.000.000 единиц солнечной рабочей силы. Взяв для простоты ${'$'}35.70 в качестве средних трат за год каждым, кто составляет ·_мировое_· население, мы получим:

    1\. 1.600.000.000 живущих человек.  
    2\. 10.000.000.000 живущих единиц рабочей силы покойников.  
    3\. 1.600.000.000 единиц солнечной рабочей силы.

    Над такой классификацией следует задуматься: человек присуще реализует нарастающую экспоненциальную мощность и всегда производит две практические ценности – потенциальную и кинетическую. Все живущие люди в некоторой степени обладают этим типом мощности; они ·_могут направлять и применять базовые энергии_·.

    Таким образом, мы видим, что этот мир населяют три разных населения – все динамические и активные, а именно

    1.600.000.000 живущих человек;  
    10.000.000.000 живущих единиц рабочей силы покойников;  
    1.600.000.000 единиц солнечной рабочей силы.

    Таким образом, становится бесспорно очевидно, ·_что это дополнительное производящее, но не потребляющее_· население появилось главным образом за счёт работы всех прошлых поколений; «главным образом», потому что, если бы мы жили как первое поколение, мы бы жили просто туземными дикарями, ничего не имея и развиваясь очень медленно. То, что мы развиваемся очень быстро на этом этапе цивилизации, наглядно объясняется математическим законом геометрической прогрессии: с постоянно нарастающим числом членов, величина членов постоянно возрастает с большей скоростью.[¹](https://teletype.in/@czoc/NPRfw59gVdj#MN5n)

    В этом заключается причина, по которой старая, ненаучная, искусственная социальная система требует глубоких преобразований. Человеческий прогресс зашёл так далеко в стольких направлениях, что социальные институты более не могут продолжать отставать. Статическую этику, статическую юриспруденцию, статическую экономику и всё остальное следует преобразовать в динамические. Если они не продолжат развиваться мирно согласно закону научного прогресса, их сдвинут насильственные перестройки, происходящие с нарастающей частотой.

    Мы имеем дело с проблемой огромной важности и величины. Чтобы отвечать нуждам 1.600.000.000 живущих людей, мы располагаем 11.600.000.000 единиц рабочей силы и всеми солнечными рабочими силами – ⬩**по семь служащих единиц на каждого живущего мужчину, женщину и ребёнка**⬩. Это выглядит как пришествие, и мы бы это так и назвали, если бы применяли всю эту мощь конструктивно, без растрат, противоречий и всех остальных факторов, препятствующих производству и прогрессу. В нашей нынешней экономической системе мы не видим даже очертаний этой истины и значительности результатов, которых удастся достичь, преобразовав её. Эту проблему мы решим Человеческой инженерией, чем установим правильное понимание ценностей и продемонстрируем, как работать с мировыми проблемами научно. Мы сможем заложить научный фундамент политической экономики и преобразуем «научный цех» в «научный мир».[²](https://teletype.in/@czoc/NPRfw59gVdj#vS7L)

    Мы наблюдаем раскол между «капиталом» и «трудом», однако, природа не знает ни «капитала», ни «труда». Природа знает материю, энергию, «пространство», «время», потенциальные и кинетические практические ценности, силы во всех их прямых и косвенных выражениях, энергии живущих людей, живущие мощи умерших людей и связанные мощи времени и древнего солнца. Природа сделала человека нарастающей экспоненциальной функцией времени, время-связующим, мощью, способной преобразовывать базовые мощи.

    Иногда нам нравится лицемерно себя обманывать, когда обман приходится выгодным. Мы называем человеческую работу «физическим трудом» и притворяемся, что нам требуется труженик, работающий мышцами. Мы говорим неразумно, глупо и неискренне. На деле в работнике нас интересует его способность ·_контролировать_· свои мышцы. Механическую работу мы заменяем, или можем заменить, практически полностью механизмами. Мы никогда не сможем заменить машинами человека, потому что он относится к более высокому уровню измерения – выше машин.

    Движущая сила, солнечная рабочая сила и капитал – большей частью работа покойников – относятся к неодушевлённым; они становятся продуктивными, только когда их одушевляют время-связующими энергиями живущие мужчины и женщины. Только благодаря этому мы получаем результаты, пропорциональные постоянно нарастающей величине экспоненциальной мощи. В экономике природы время-связующие представляют разумные силы. Больше мы никого не знаем, и, с инженерной точки зрения, Эдисон и простой труженик, Смит или Джонс,[³](https://teletype.in/@czoc/NPRfw59gVdj#xCNX) в основе не отличаются. Их мощи или способности осуществляются экспоненциально; они отличаются степенями, но относятся к одному типу.

    Это может показаться неуместно оптимистичным, потому что среди инженеров никого, кроме оптимистов вы не встретите. Они работают только с фактами и истиной. Если они допускают ошибки, – если обрушиваются их мосты – какими бы изощрёнными софизмами они не оправдывались, их судят как преступников. Подобное отношение следует сделать практикой и правилом в отношении всех тех, кто контролирует институты и великие отношения в человеческом обществе. Периодические распады следует предотвращать. Ответственность за это должны нести инженеры, как сегодня инженеры-строители отвечают за мосты.

    Вещи часто оказываются проще, чем они кажутся на первый взгляд. В печи, полной угля, может гореть огонь, но она не греет, потому что огонь плохо горит. Инженер может избавиться от естественных причин препятствий естественным процессам; даже просто убрав пепел, он может решить проблему. Это видится простым. Истина часто оказывается простой и незатейливой; если бы только её не скрывали и не усложняли софизмом.

    «Капиталистические» доводы, «социалистические» доводы – ничего этого природа не знает. Природа руководствуется одним «доводом» во всех своих функциях. Противоречия возникают, когда мы пытаемся изобретать собственные законы природы. Социализм существует как ·_изм_·, потому что капитализм существует как ·_изм_·; их столкновение представляет собой не более, чем выражение вечного закона действия и противодействия.

    Мы живём в мире богатства, в мире, обогащённом многими поколениями труда покойников. Между пристрастием одного ·_копить_· и пристрастием другого ·_получать_·, много выбрать не получится. В таком соперничестве пристрастий против пристрастий мы видим ·_недо_·человечность – животность, зоологическую этику, праведность клыка и когтя, стоящие ниже человеческих измерений жизни, совершенно недостойные творческой энергии – время-связующей способности – человечества.

    При социализме мы остро чувствуем и смутно видим, что человеческие отношения не ведутся согласно естественным законам. При капитализме мы как не чувствуем, так не видим этого. Ни при том ни при другом мы не возьмёмся исследовать естественные законы – законы человеческой природы – научно. При обоих мы пользуемся одинаковыми методами догадок в своих доводах и не решаем никакую проблему. На всякий старомодный довод, построенный на догадках, всегда найдётся на догадках же построенный ответ. При обоих мы говорим об истине, но не можем её отыскать своими методами или выразить своим языком. Мы говорим о «справедливости», о «правильном» и о прочем, не зная, что концепции этих терминов стоят на ошибочном понимании ценностей. Средством решения видится только одно: применение научного метода к исследованию предмета. Разумные рассуждения, если их допустить, захлестнут человечество, подобно тому как зеленеют поля по весне. Оно поможет избавиться от растрат энергии и от разногласий. Оно привлечёт все силы к строительству и эксплуатации природы на общее благо.

    В этом мире живут капиталисты и капиталисты, социалисты и социалисты. Среди капиталистов мы находим тех, кто хочет присваивать богатство – преимущественно плоды труда покойников – себе. Среди социалистов встречаются – традиционные социалисты – желающие его рассеять. Первые не понимают, что продукт труда покойных покоится, если не приводить его в движение энергиями живущих людей. Вторые не понимают накопленную пользу для человечества за счёт аккумуляции богатства, если им ·_правильно пользоваться_·.

    Считаем мы себя капиталистами или социалистами, или ни теми, ни другими, нам следует усвоить, что погоня за сокровищами от покойников составляет жизнь не человека, а ·_вурдалака_·. Законнический титул – документарное владение – не меняет факта, как и пристрастие к нему.

    Выработав правильную концепцию того, что собой представляет человек, мы уйдём от римской концепции, согласно которой человек есть ·_instrumentum vocale_· ⁅·_звучащий инструмент_·⁆, животное ·_instrumentum semivocale_· ⁅·_полу-звучащий инструмент_·⁆ и орудие ·_instrumentum mutum_· ⁅·_беззвучный инструмент_·⁆. Тот, кто считает людей орудиями – инструментами – для применения другими людьми, поступает не просто ненаучно, но и отвратительно, тупо и слепо. Орудия создаёт человек; они не имеют автономии своего создателя – не обладают время-связующей способностью инициации, само-направления и само-развития. По своей природе, орудия, инструменты, механизмы относятся к измерению гораздо ниже человеческого.

    Не стоит считать, что, говоря об измерениях или размерности, мы несём какой-то теоретический бред. Правильное понимание измерений играет роль жизни и смерти в практической жизни. Смешивание измерений ведёт к ошибочным выводам в нашем мышлении, а ошибочные выводы приводят к катастрофам.

    Рассмотрим классы жизни, представив их тремя измерениями (как я объяснил в одной из предшествующих глав). Человеческое производство относится в сущности к человеческому или, как я его называю, третьему измерению. Начиная, например, с 5, в третьем измерении мы производим результат 125 единиц; поэтому, когда людям платят 25 единиц по стандартам второго измерения (животных), человечество лишают 100 единиц пользы от произведённого богатства. Это служит примером того, какую роль играют измерения в практической жизни. Читатель может сам проанализировать, какой эффект такие правила производят, если их выразить и применить в человеческом «время-связующем» измерении, где время служит решающей проверкой. Следующая таблица производит зрительный шок:
    
""".trimIndent()

val chapter_6_text_2 = """
    Это объясняет, почему смешение измерений становится источником великого зла.

    Кто теперь может утверждать, что проблема измерений относится лишь к теории?

    Мы говорим не столько об ограничениях разума, сколько об ограничениях зрения – неспособности видеть неоспоримые отличия между законами развития первого, второго и третьего измерений.

    Доллары, или фунты стерлингов, или иные денежные единицы, следуют одинаковым правилам: сила и собственно источник мощи современного капитализма заключается в разнице между измерениями – в разнице между тем, что дают и что берут, разнице между тем, сколько зарабатывают и тем, сколько «делают». Следовательно, проблема измерений становится ключом, открывающим мощь капитализма и дверь в новую цивилизацию, в которой понимание измерений приведёт к порядку из хаоса.

    Мы увидели, что кинетическая и потенциальная практические ценности, произведённые покойниками, связываются с богатством, которое мы измеряем и обозначаем деньгами. Соответственно, деньги служат символом мощности, проделанной работы, связанного времени.

    ·_Пространство_·-связующий ·_животный_· стандарт недо-цивилизации завёл нас в тупик, просто потому что пространства не осталось. Практически все пригодные для жизни земли и почти все природные ресурсы уже разделили между собой частные законнические владельцы.

    Какая надежда остаётся для постоянно растущего населения?

    Мы располагаем

    1.600.000.000 живущих людей,  
    10.000.000.000 живущих единиц человеческой рабочей силы покойников и  
    1.600.000.000 единиц солнечной рабочей силы,

    что составляет огромную мощность, которая позволила бы ⬩**произвести богатство для всех, если её разумно направить**⬩. Однако сегодня мы направляем её невежественно и до стыда неразумно, потому что обращаемся с людьми не по их природе – как с время-связующим классом жизни.

    Мы можем добиться гораздо большего, устойчиво и целесообразно эксплуатируя природу , – полностью мобилизуя наши живые, мёртвые и солнечные мощи – нежели настойчиво эксплуатируя человека и лишь иногда и частично природу.

    Эгоизм и невежество – они ли не дают нам полностью мобилизовать мировые производственные мощи?

    Те, кто вносят самый большой вклад в человеческий прогресс и человеческое просвещение, – такие люди как Гутенберг, Коперник, Ньютон, Лейбниц, Уоттс, Франклин, Менделеев, Пастер, Склодовская-Кюри, Эдисон, Штейнмец, Лёб, Дьюи, Кайзер, Уайтхед, Рассел, Пуанкаре, Уильям Бенжамин Смит, Гиббс, Эйнштейн и многие другие – потребляют не больше своих собратьев простых людей. Более того, они редко живут в достатке.

    Сколько гениев исчезло, не сказав ни слова, из-за того, что они не выдержали тяжких социальных условий, где преобладают животные стандарты, а «выживание самого приспособленного» означает не выживание «самого приспособленного в своей время-связующей способности», а выживание самого сильного, беспощадного и коварного – в пространство-связующей конкуренции?

    Богатство производят те, кто работает руками и мозгом, и никто другой. Значительную массу богатства мира произвели ушедшие поколения. Мы знаем, что величайшие богатства всегда производили и производят люди от науки – первооткрыватели и изобретатели. Если за несколько лет изобретение становится общественной собственностью, то и богатство, произведённое ·_применением_· этого изобретения тоже должно стать общественной собственностью за то же количество лет после его производства. На это утверждение софизмом не ответишь.

    Одну из величайших мощей современности представляет пресса. Она направляет ресурсы пространства и времени и тысячей тонких способов формирует наше мышление. Она контролирует новостной обмен во всём мире. К сожалению, прессу контролируют эксплуататоры «живущих мощей покойников», и то, что они называют новостями, они представляют настолько искажённо, ограниченно и приукрашено под стать своим корыстным интересам, что превращают это в ложь под видом правды. Честные, независимые издательства часто умерщвляют перекрытием ресурсов по сговору. От этого пресса – продукт главным образом труда покойников – превращается в средство обмана и эксплуатации живущих. Словами Вольтера:

    ⬩«⬩  
    Бог создал человека по собственному образу и подобию, но как часто человек пытается оказать такую услугу Богу?  
    ⬩»⬩

    Тех, кто хочет иметь такую «Бого-подобную» власть над миром, мы можем считать современными Неронами, которые в своих пороках и безумии возомнили своё божественное происхождение. Обман, эксплуатация с помощью обмана, лишение и порабощение живущих мужчин и женщин, проституция живущих мощей, созданных покойниками, представляет работу не людей, а · безумцев · – алчных, невежественных и слепых.

    Как это решить?  
    Революцией?

    Революции происходят в том же безумстве. Единственным решением видится просвещение – знание, знание природы, знание человеческой природы, научное образование, применение науки ко всем человеческим отношениям – наука и искусство Человеческой инженерии.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/NPRfw59gVdj#yX7n)Геометрическая прогрессия не представляет ·_в точности_· закон человеческой прогрессии. Мы воспользовались ей здесь как знакомым и подходящим математическим средством демонстрации того, как ·_приблизительно_· идёт человеческий прогресс. Главными элементами прогрессии служат первый член · P ·, знаменатель · R · и число членов · T ·.  
    В человеческой прогрессии · PR¹, PR², PR³, … PRᵀ · · P · выражает начальный статус первого поколения, · R · – особую способность человека связывать время, · свободный дар и закон природы ·, которые следует признать и принять как таковые, · T · – время, или количество поколений. Мы видим, что величина · PRᵀ ·, полностью зависит от величин · PR · и · T ·. Существование · R · и · T · не зависит от людей, потому что · R · реализуется как закон природы, · T · как дар от природы, а · P · как начальный статус изначального поколения.  
    Если бы · P=0 · или · R=0 ·, ПРОГРЕССА или прогрессии совсем НЕ ПРОИСХОДИЛО БЫ; каждый член в случае человеческой прогрессии главным образом зависит от времени и работы, проделанной покойниками. · R · и · T · существуют полностью вне человеческого контроля. Люди могут контролировать только ВЕЛИЧИНУ этих элементов с помощью образования.  
    Здесь становится видимой огромная ответственность в образовании. Богатого воображения не требуется, чтобы увидеть, что, если бы человечество всегда получало должное образование, наукой удалось бы давно выявить естественные силы и неотъемлемые законы человеческого благополучия; тогда человечеству не пришлось бы страдать, как оно страдает сегодня.

    2\. [⇧](https://teletype.in/@czoc/NPRfw59gVdj#ghbi)См. Приложение Ⅲ.

    3\. [⇧](https://teletype.in/@czoc/NPRfw59gVdj#cVN9)⁅Распространённые в США., фамилии, родственные русским «Кузнецов» и «Иванов».⁆

    * * *
""".trimIndent()
