package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_5(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp)
    ) {
        item {
            MarkdownText(
                markdown = chapter_5_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Spacer(modifier = Modifier.height(20.dp))
            Image(
                painter = painterResource(R.drawable.formula_1),
                contentDescription = "формула1",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_5_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Spacer(modifier = Modifier.height(20.dp))
            Image(
                painter = painterResource(R.drawable.formula_2),
                contentDescription = "формула2",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_5_text_3,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Spacer(modifier = Modifier.height(20.dp))
            Image(
                painter = painterResource(R.drawable.formula_4),
                contentDescription = "формула4",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_5_text_4,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
    }
}

val chapter_5_text_1 = """
    # Глава Ⅴ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Я начну эту главу с предупреждения. Мы можем условно разделить критику – под которой я имею в виду мышление – на три вида:

    *   чисто деструктивную,
    *   чисто конструктивную и
    *   одновременно деструктивную и конструктивную.

    Чисто деструктивная критика иногда приносит много пользы. Если старая идея или система старых идей оказывается ложной и, следовательно, пагубной, мы делаем что-то полезное, уничтожая её, даже если не предлагаем ничего на замену. Мы делаем что-то полезное, когда уничтожаем гремучую змею, ползущую по тропе, где ходят люди, даже если не предлагаем что-то ей на замену.

    Тем не менее, какую бы пользу мы ни несли, критиковать деструктивно приходится нелегко, потому что идеи, сколь бы ни ложные и вредные, защищают в силу привычек и врождённого консерватизма многие умы. Привычки на деле оказываются весьма полезными, даже незаменимыми в эффективном образе жизни, потому что дают нам делать многие полезные вещи автоматически и, следовательно, проще, без осознанного мышления, экономя умственную энергию, чтобы тратить её на другую работу.

    Однако по той же причине привычки могут приносить немалый вред. Они заставляют нас защищать ложные идеи автоматически, и, когда деструктивный критик пытается уничтожить такие идеи, обсуждая их с нами, он обнаруживает, что пытается разговаривать с автоматами. В этом состоит главная трудность, с которой деструктивному критику приходится сталкиваться.

    Чисто конструктивной критикой – чисто конструктивным мышлением – мы предлагаем новые идеи; такие, которые, хотя бы видимо, не мешают старым.

    Легко ли получается заниматься такой критикой?

    Отнюдь.

    Трудности возникают, когда приходится показывать людям, довольным своим текущим набором старых идей, в чём мы видим интерес или важность новых идей. Нелегко приходится также подавать ·_новые_· идеи ясно и доступно. Умение изъясняться так, чтобы нас чётко понимали, вырабатывается и практикуется с большим трудом.

    Критикой – мышлением – третьего вида – одновременно деструктивной и конструктивной – мы преследуем две цели: уничтожить старые, ложные идеи и заменить их новыми, правильными. Этот вид критики представляется самым трудным из всех, потому что при нём приходится преодолевать трудности как деструктивной, так и конструктивной критики.

    Читатель, поразмыслив над этими соображениями, сможет оценить серьёзные трудности написания этой небольшой книги, потому что заметит, что эта работа относится к третьему виду критического мышления, и, что, важнее, я ставлю цель уничтожить основательные, масштабные и старые идеи, и предложить им на замену не менее основательные новые идеи. Эту трудность, которую я испытывал на ·_каждом_· этапе написания книги, я обоснованно объясню и особенно чётко передам в этой главе. В связи с этим я прошу читателя посодействовать мне открытостью новым идеям, беспристрастностью и критическим вниманием. Я считаю необходимым устойчиво учитывать характер нашей инициативы как целого – указание пути к науке и искусству Человеческой инженерии и строительство их фундамента.

    Мы убедились, что Человеческая инженерия, если её развивать, становится наукой и искусством такого направления человеческих энергий и мощей, чтобы они наиболее эффективно способствовали развитию человеческого благополучия.

    Мы убедились, что эту науку и искусство следует основывать на должной концепции человеческой природы – адекватной концепции того, что человек на деле собой представляет, и его естественного места в совокупности мира.

    Мы убедились, что вековые и до сих пор преобладающие концепции человека – зоологическая и мифологическая концепции, согласно которым людей относят либо к животным, либо к гибридам животных и богов – в существенной мере обусловливают катастрофические события в человеческой истории.

    Мы убедились, что человек, представляет собой всецело естественное существо, характеризуемое определённой способностью – способностью связывать время.

    Мы убедились, что о человечестве следует составить адекватное представление и определить его научно как время-связующий класс жизни.

    Мы убедились, что законы время-связующих энергий и время-связующих явлений действуют как законы человеческой природы.

    Мы убедились, что эта концепция человека – основная концепция, базовый принцип, постоянная направляющая и регулятор Человеческой инженерии – неизбежно ведёт к глубоким преобразованиям во всех наших взглядах на человеческие отношения, в частности в так называемых социальных «науках», – жизне-регулирующих «науках» этики, социологии, экономики, политики и управления – двигая их вперёд от нынешнего псевдонаучного уровня к уровню настоящих наук и технологизуя их, чтобы они служили человечеству.

    Я называю их жизне-регулирующими, не потому что они играют более важную роль в человеческих отношениях, чем настоящие науки, – математика, физика, химия, астрономия, биология – а потому что мы яснее видим их более непосредственное влияние и эффекты. Эти жизне-регулирующие науки не строятся независимо. Они зависят от возможностей, света и направления настоящих наук. Здесь я, однако, имею в виду, что они бесчисленным множеством способов соприкасаются, пересекаются и зависят друг от друга. Чтобы показать ·_подробно_·, как эти так называемые науки удастся преобразовать, чтобы они работали согласно правильной концепции человека, понадобится написать большой том, или даже тома.

    В этой вступительной работе я не могу в полной мере разобрать одну из этих наук или привести подходящее резюме каждой по-отдельности. Мне придётся довольствоваться очень кратким обзором одной из них с примерами и предложениями.

    Какую стоит выбрать?

    Среди этих жизне-регулирующих «наук» одна выделяется важностью своего предмета, своей центральной ролью по отношению к остальным и значимостью, которую ей придаёт общественность. Я говорю об экономике – «беспросветной науке»[¹](https://teletype.in/@czoc/aPByBb3nTpC#eiOa) политической экономики.

    В этой главе я разберу её три основных термина:

    *   «богатство»,
    *   «капитал» и
    *   «деньги»,

    с целью показать, что нынешние значения и толкования этих знакомых терминов следует углубить, расширить и возвысить, если мы хотим согласовать их с фактами человеческой природы и сделать так называемую «науку», в которой их применяем, настоящей наукой – дисциплиной Человеческой инженерии.

    Я покажу, что значения, которые ныне присваивают данным терминам политические экономисты и другие деятели, относятся к тому, что я назвал периодом человеческого детства, тогда как новые значения, которые следует им присвоить, относятся к периоду человеческой зрелости. Читатель увидит, что новые значения отличаются от старых настолько радикально, что в целях ясности следовало бы сменить и названия. Я считаю это научно предпочтительным, но непрактичным в связи с тем, насколько привычно мы пользуемся старыми терминами.

    Здесь начинает вырисовываться особенная трудность, – выше я на неё уже намекнул – из-за которой я попросил читателя посодействовать мне в этой главе. Трудность эта состоит не просто в том, чтобы уничтожить старые идеи и заменить их новыми адекватными идеями, а в том, что люди привычно связывают новые, адекватные значения с терминами, которые они так давно, повсеместно и единообразно связывают с неадекватными значениями.

    Секрет философии, по словам Лейбница, заключается в том, чтобы обращаться со знакомыми вещами как с незнакомыми. Под секретом «философии» Лейбниц имел в виду секрет того, что мы называем наукой.

    Давайте применим эту здравую максиму к нашему исследованию.

    Давайте, насколько можем, отнесёмся к знакомым терминам «богатство», «капитал» и «деньги» как к незнакомым – по-новому.

    Давайте непредубеждённо рассмотрим факты, – явления – значения которых нам следует этим терминам придавать в настоящей науке человеческой экономики.

    Изучите «факты», – изучите «явления» – потому что подстраивая факты под теории, мы подвергаем себя опасности, тогда как подстраивая теории под факты, мы занимаемся чем-то неотъемлемым от науки и от мирного развития общества.

    Человек всегда имел некоторое чувство ценностей – какое-то восприятие или познание ценностей. Для того чтобы выражать или измерять ценности, потребовалось создать единицы измерения, или единицы обмена. Люди начали измерять ценности с помощью агрокультурных и других продуктов, таких как скот. Латинское слово, обозначающее скот, – ·_pecus_· – и слово ·_pecunia_·, которым обозначали деньги, дало значение знакомому нам слову pecuniary ⁅финансовый⁆. Самые ранние единицы измерения быстро перестали годиться для применения в растущей торговле, «бизнесе» и транспорте. В конечном счёте мы внедрили единицу под названием «деньги», основой для которой стала ценность определённого веса золота. Таким образом мы видим, что деньги означают лишь принятые единицы измерения, которые представляют ценности богатства.

    Однако что есть богатство?

    Я уже сказал, что старые концепции богатства, капитала и денег, которые по-прежнему преобладают в мире, относятся к периоду человеческого детства; и я называю их детскими концепциями. Их следует заменить научными концепциями – концепциями, подходящими человеческой зрелости. В концепции этих значительных терминов придётся внести колоссальные изменения. В связи с этим нам следует обязательно проанализировать нынешние концепции богатства, капитала и денег, – их детские концепции – чтобы пролить свет на их ошибочность, глупость и недальновидность.

    Чтобы это сделать, нам придётся зайти в область политической экономики – область, осаждённую особенными трудностями и опасностями. Здесь обитают всевозможные бесы личных интересов. Это производит впечатление, будто почти никто или вообще никто по-настоящему не хочет прийти к истинной концепции – научной концепции – богатства. Большинство, по-видимому, предпочитает эмоциональное определение – определение собственной любви к богатству или ненависти к нему. Множество определений богатства, капитала и денег удастся найти в современных книгах по политической экономике; эти определения и книги относятся к детству человечества. Относительно целей данной работы, все они выглядят похожими – они в достаточной мере согласуются – все они детские.

    Милль, например, говорит, что богатство составляют

    ⬩«⬩  
    полезные или пригодные вещи, обладающие обменоспособной ценностью.  
    ⬩»⬩

    Из простых определений капитала мы можем привести такое:

    ⬩«⬩  
    Капитал представляет собой ту часть богатства, которой мы пользуемся, чтобы получать больше богатства.  
    ⬩»⬩

    Уокер (в своей книге ·_Money, Trade and Industry_· ⁅·_Деньги, торговля и промышленность_·⁆) определяет деньги следующим образом:

    ⬩«⬩  
    Деньги представляют собой то, что свободно передаётся из рук в руки в обществе в качестве полной выплаты долгов и полной оплаты товаров; их принимают равно без указания на характер или честь человека, который их предлагает и без намерения человека, который их получает, употребить их, обладать ими или применить их как-либо иначе, чем в свою очередь, предлагать их другим в качестве выплаты долгов или оплаты товаров.  
    ⬩»⬩

    В политической экономике найдётся много направлений и методов классификации. Они руководствуются в основном надуманными, метафизическими и законническими соображениями и зоологической этикой, основанной на зоологической концепции человека как животного. Они не применяют естественную ⁅природную⁆ логику и этику. Их изощрённые идеи на тему политической экономики попросту не соответствуют фактам.

    Наш примитивный предок в джунглях умер бы от голода, холода, жары, заражения крови или от нападений диких животных, если бы не применил свой мозг и мышцы, чтобы взять камень или палку и сбить плод с дерева, убить зверя, чтобы воспользоваться его шкурой в качестве одежды и употребить его мясо в пищу, или чтобы соорудить из дерева кров и изготовить орудия для самозащиты и охоты.

    ⬩«⬩  
    В первом камне, который он (дикарь) бросает в дикое животное, за которым гонится, в первой палке, которую он берёт в руки, чтобы сбить плод, висящий ему недосягаемо, мы видим назначение одного предмета с целью поспособствовать получению другого, и таким образом, мы выявляем истоки капитала.  
    ⬩»⬩  
    Роберт Торренс, ·_An Essay on the Production of Wealth_· ⁅·_Эссе о производстве богатства_·⁆.

    Наш примитивный предок познакомился с огнём, вероятно, с помощью молнии. Он открыл – скорее всего, случайно – возможность разводить огонь трением двух деревяшек друг о друга и ударом друг о друга двух камней. Он установил один из первых технологических фактов. Он испытал тёплое воздействие огня и узнал о пользе от приготовления пищи, найдя зажаренное в огне животное. Так природа открыла ему один из своих великих даров – энергию солнца, хранимую в растительности и пользу от её применения. Он уже умел связывать время; эволюция вывела его на этот уровень. Как результат природы, он раздумывал над её естественными законами, которые относятся к его классу жизни. Он прекратил пребывать в статике; он стал динамическим; склонность к развитию попала ему в кровь. Он стоял выше животного царства.

    Мы также видим, что примитивный человек создал ценные продукты, приобрёл опыт, провёл наблюдения, и что некоторые продукты несли практическую ценность другим людям и оставались пригодными для применения даже после его смерти.

    Произведённые продукты создавались из сырого материла, безвозмездно данного природой, некоторой умственной работой, позволившей создать представление о том, что делать с объектом и некоторой физической работой, за счёт которой продукт обретал форму. Весь этот умственный и физический труд занимал время. Очевидно, без всех этих составляющих не удалось бы обойтись в создании чего-либо ценного, или практически ценного. Ребёнок человека не только получал часть произведённой им практической ценности, но и участвовал во всех его опытах и наблюдениях. (Как мы знаем, мощность, по определению механики, означает отношение проделанной работы и затраченного на неё время.)

    Всё перечисленное представляет собой явления время-связывания, произведённое благодаря время-связующей мощи человека. Человек, однако, ·_не_· знает об ·_этой мощи_· как о своём ·_определяющем признаке_·. Нам следует заметить странный факт, что с инженерной точки зрения, несмотря на то, что мы очень высоко развились в одних отношениях, мы остаёмся по-детски неразвитыми в других.

    Человечество строит свои представления и говорит о мире, в котором живёт, как о таковом обладающем тремя измерениями, но даже в самых своих смелых фантазиях оно не может ощутимо себе представить ·_четвёртое_· измерение; человечество не научилось усваивать настоящие значения базовых или фундаментальных вещей. Мы строим все свои представления сравнительно и относительно. Мы основываем их на том, что пока не понимаем. Например, мы говорим о времени, электричестве, гравитации и так далее, но никто пока не смог определить их с точки зрения чувственных данных. Тем не менее, – этому факту стоит придать высочайшую важность – мы учимся применять множество вещей, которые до конца не понимаем и пока не можем определить.

    В политической экономике скудность нашего понимания выдаётся особенно. Мы всё ещё не усвоили очевидный факт, – факт неизмеримой важности для всех социальных наук – что за малым числом исключений, богатство и капитал, которым обладает данное поколение, появились не за счёт их тяжкого труда, а унаследовались благодаря тяжкому труду людей, которые уже умерли – безвозмездным даром из прошлого. Нам ещё предстоит выучить и начать применять урок, что не только наше материальное богатство и капитал, но и наши наука, искусства ⁅ремёсла⁆, образование и знания – всё, что составляет нашу цивилизацию – сложились не нашим трудом, а время-связующими энергиями прошлых поколений.

    Примитивный человек применял естественные законы, не зная и не понимая их, но мог дать природе выражать себя благодаря открытию способа высвобождать накопленную природную энергию. Работая мозгом, дающим направление его мышцам, он узнавал, что некоторые его приспособления оказывались непригодными. Он изготавливал новые, и за счёт этого по-началу медленно двигал прогресс человечества. Я не стану вдаваться в подробности истории развития цивилизации; её уже описали во множестве книг.

    В самые ранние времена религии, философские, правовые и этические системы ещё не изобрели. Мораль в то время складывалась естественно. Люди знали, что не создавали природу. Они не считали «должным» «экспроприировать создателя» и юридически присваивать землю и её сокровища себе. Они считали, по своей нехитрой морали, что, придя в жизнь, они обладали естественным правом существовать и свободно пользоваться дарами природы для поддержания своей жизни; этим они и занимались.

    После смерти человека от него оставались некоторые объекты которые он произвёл, такие как оружие, инструменты для рыбалки, или пещеры, приспособленные для жизни. Родителям приходилось растить ребёнка несколько лет, чтобы он не умер. Эти факты имели важные последствия. Предметами, произведёнными кем-то с какой-то конкретной целью, мог пользоваться кто-то другой, даже после смерти одного или более последующих пользователей. Вновь, опыту, приобретённому одним членом семьи или группы людей, учили примерами или наставлениями других представителей того же и следующего поколений.

    Такие простые факты лежат краеугольными камнями всей нашей цивилизации, и заложить их удалось в прямом результате применения ⬩**человеческой способности время-связывания**⬩.

    Сегодня в мире наблюдается засилье противоречий о богатстве, капитале и деньгах, а из-за того, что человечество с помощью своей время-связующей силы всё интенсивнее связывает стихию под названием «время», противоречия усугубляются всё сильнее.

    Цивилизация как процесс представляет собой процесс связывания времени. Прогресс осуществляется тем, что каждое поколение прибавляет к материальному и духовному богатству, которое унаследовало. Таким образом, достижения прошлого – плоды ушедшего времени – живут в настоящем, преобразуются в настоящем и передаются в будущее; процесс продолжается. Время, неотъемлемая составляющая, выполняет такую функцию, что, несмотря на его арифметический рост, его плоды – цивилизация – развиваются геометрически.

    Стоит, однако, обратить внимание на ещё одну особенность богатства и денег. Если деревянный или железный «дюйм» оставить гнить или ржаветь на полке, то этот «дюйм» не представляет ничего кроме куска дерева или железа. Однако, если мы возьмём ⬩**умственную**⬩ ценность дюйма, эту единицу одной из мер пространства, и воспользуемся ей с другими количествами в размышлении над небесами в целях решения астрономической задачи, он даёт прогнозирующий ответ, что в определённом месте существует звезда, которую, возможно, придётся тщетно искать годами.

    Мы допустили ошибку в расчётах?

    Нет, потому что поискав дальше при помощи более эффективных телескопов, мы найдём звезду и сверим свои расчёты.

    Мы ясно видим, что «единица» – дюйм – сама по себе не имеет ценности, но обретает очень высокую ценность как единица измерения явления длины, которую она точно представляет. Именно поэтому мы её и придумали.

    Тем же образом дела обстоят с деньгами, если понимать этот термин правильно. Деньги представляют собой меру и представление богатства – меру и представление труда умерших людей. Богатство практически полностью составляет результат деятельности ушедших поколений. Главным фактором этого результата, как мы убедились, работает время. За счёт этого мы выявляем, при должном понимании, в какой связи деньги состоят со временем. Главная функция денег заключается в том, чтобы измерять и представлять накопленные результаты труда прошлых поколений. Скопленные деньги не отличаются от железного «дюйма», лежащего на полке – бесполезной болванки. Когда же ими пользуются, чтобы измерять и представлять должным образом понятое богатство, деньги выполняют бесценную функцию, потому что служат мерой и представлением живых результатов труда умерших.

    По этой причине споры о важности капиталистов, владеющих большей частью материальных результатов труда, или трудящихся, владеющих мизерной их частью, не несут пользы. В трудящемся мы не смотрим на ⬩**один**⬩ только мышечный труд, потому что его мы заменяем животным и машинным, когда это представляется возможным. Ценность в трудящемся представляет и продолжит представлять его ⬩**мозг**⬩ – ⬩**его время-связующая мощь**⬩.

    Мы можем разделить население мира на разные классы. Мы не станем здесь перечислять традиционные классы, потому что людей следует классифицировать настолько чётко, насколько мы можем, согласно их «значению мощности». Я не утверждаю, что привожу идеальную классификацию, но если кто-то пожелает заметить:

    ⬩⸗⬩  
    Какое глупое и ненаучное разделение!  
    ⬩⸗⬩

    – я отвечу, сказав, –

    ⬩⸗⬩  
    Я сам назову это разделение глупым и ненаучным, но ⬩**никакое другое разделение не СОГЛАСУЕТСЯ С ФАКТАМИ в жизни**⬩, и не стоит искать в этом вину автора. Такой ‘глупостью’ удастся осуществить что-то толковое.  
    ⬩⸗⬩

    С инженерной точки зрения, мы разделим человечество на три класса:

    1\. мыслящие,  
    2\. богатые,  
    3\. бедные.

    Это разделение, как может показаться, противоречит всем правилам логики, но оно соответствует фактам. Конечно, некоторые индивидуумы относятся к двум классам или даже ко всем трём, – к этому привела война – но в сущности, они относятся к одному классу по ⬩**соотношению**⬩ наиболее выдающихся характеристик в их жизни, иными словами, в смысле социальных классов – ⬩основанных на множестве значений ⁅ценностей⁆⬩.

    ⬩1⬩ К мыслящим относятся мужчины и женщины, владеющие знаниями, обретёнными трудом ушедших поколений, но не владеющие материальным богатством, произведённым таким образом. В овладении и применении этого наследия знания они направляют свои время-связующие энергии и позволяют труду умерших жить в настоящем и для будущего.

    ⬩2⬩ К богатым относятся те, кто владеют и контролируют большую часть ·_материального_· богатства, произведённого трудом ушедших поколений – мёртвого богатства, если его не оживлять и не преобразовывать время-связующим трудом живых.

    ⬩3⬩ К бедным относятся те, кто не владеют ни знаниями мыслящих, ни материальным богатством богатых. В силу того, что практически все их усилия в настоящих условиях ограничиваются борьбой за существование, они имеют мало или совсем не имеют возможности применять свою время-связующую способность.

    Теперь давайте определим роль время-связующего класса жизни в целом. Нам придётся вернуться к началу – к дикарю. Мы видели условия его работы и прогресса. Мы видели, что для каждого последующего достижения ему часто приходилось испытывать трудности с большим числом безуспешных достижений, и в силу сильной ограниченности его срока жизни, итог его успешных достижений тоже сильно ограничивался. Он мог передать своему ребёнку лишь несколько полезных предметов и свой общий опыт. Говоря в общем, каждый потомок не начинал жизнь там, где её начинал предок. Он начинал где-то ближе к тому, где предок остановился. Его предок отдал, скажем, пятьдесят лет, чтобы выявить две истины в природе и успешно создал два или три простых предмета. Его потомку не придётся отдавать пятьдесят лет, чтобы выявить и создать те же достижения – он владеет временем на достижение чего-то ·_нового_·. Таким образом он добавляет собственные достижения к достижениям своего предка инструментами и опытом. Математически это эквивалентно сложению годов жизни его предка с его.

    Выдающийся факт заключается в определяющем признаке человечности – способности непрерывно добавлять достижения слой за слоем в каждом следующем поколении. Мы убедились, что эта время-связующая способность представляет собой экспоненциальную мощь или функцию времени. Время течёт, растёт арифметически; одно поколение добавляется к другому, но результаты человеческих энергий, функционирующие во времени, растут не арифметически. Они наслаиваются с растущей скоростью, увеличиваясь согласно закону с ускорением растущей геометрической прогрессии. Мы обозначаем эту прогрессию ·_PRᵀ_·, где ·_PR_· означает конечный достигнутый прогресс за поколение, с которого мы можем решить начать наш расчёт. ·_R_· означает рост соотношения, а ·_T_· означает число поколений после выбранного «начала». Величина, ·_PRᵀ_· прогресса, достигнутого в поколении ·_T_·, содержит ·_T_· как экспоненту, и поэтому величина, варьирующаяся по мере прохода времени ·_T_·, называется экспоненциальной функцией времени.

    Вся энергия проистекает из природы. Растения – низшая форма жизни – играют определённую роль в экономике природы. Они выполняют функцию формирования альбуминоидов и других веществ для высших целей. Все их нитраты относятся к сильным или слабым взрывчатым веществам. Они служат мощными источниками какой-то новой энергии.

    Животная жизнь употребляет эти «взрывчатые вещества» в пищу, и соответственно действует более динамически, однако, в животной жизни время не играет роли, какую оно играет в человеческой жизни. Животных перманентно ограничивает смерть. Если животные и прогрессируют от одного поколения к другому, их прогресс составляет так мало, что им мы можем пренебречь. Бобры умеют строить плотины, но не прогрессируют путём изобретений или дальнейшего развития. Бобровая плотина остаётся бобровой плотиной.

    Наконец, человечество – самый высокий из известных класс жизни – обладает характерной, отличительной, определяющей время-связующей способностью. Мы плохо осознаём, что у этого высшего класса жизни ·_закон органического роста перерастает в закон энерго-роста – разума – время-связующей энергии – растущей экспоненциальной функции времени_·. Этому факту мы придаём основательную важность в науке и искусстве Человеческой инженерии. Мы хорошо знаем формулу из механики
    
""".trimIndent()

val chapter_5_text_2 = """

    Мы видели, что согласно закону геометрической прогрессии ·_PRᵀ_· означает достигнутый прогресс – проделанную работу – в поколении ·_T_· (мы считаем ·_T_· с поколения, которое взяли в качестве начальной точки для расчётов). Этот прогресс, достижение или ·_работу_·, проделанную в ·_одном_· поколении мы получаем с помощью (1).
    
""".trimIndent()

val chapter_5_text_3 = """
    
    Иными словами, ·_PRᵀ=Мощность_·; что означает, что число ·_PRᵀ_·, которым мы измеряем проделанную работу в данном поколении, также служит мерой мощности, за счёт которой работа выполняется. Полная работа, ·_W_· ⁅Work⁆, проделанная за ·_T_· поколений составляет

    (3) ·_W=PR¹+PR²+PR³+ … +PRᵀ_·;

    что означает
    
""".trimIndent()

val chapter_5_text_4 = """
    
    Стоит заметить, что, учитывая (2), это выражение для ·_W_· мы можем считать суммой ·_T_· разных мощностей ·_PR_·, ·_PR²_· и т. д., каждая из которых работает во время одного и только одного поколения. Если разделить сумму на ·_T_·, коэффициент составит мощность, требуемую ·_T_· поколениям, чтобы произвести ·_W_·. Читатель заметит, что выражением (4) для ·_W_· мы обозначаем совокупно осуществлённый прогресс, проделанную работу и произведённое богатство в ходе ·_T_· поколений, а также то, что в выражении присутствует экспоненциальная функция времени (·_T_·), а именно ·_PRᵀ_·.

    Эта формула математически наглядно показывает время-связующую мощь, характерную для человеческого класса жизни. Должным образом понятое ·_богатство_· составляют результаты или продукты этой время-связующей мощи человека. Животные не производят богатство; его производит человек и только человек. Предшествующая базовая формулировка поведёт к дальнейшим подобным разработкам, которыми удастся пролить свет на процесс цивилизации и поспособствовать исключению «личного мнения» из понимания человеческих отношений.

    (В этой работе я не считаю важным рассматривать предложенные ряды подробнее. Фактом остаётся то, что ·_P_·, как и ·_R_·, представляют собой особым образом растущие ряды геометрического характера. Точную форму я разберу в другой работе.)

    Человеческие достижения и прогресс, в силу их накопления, преодолевают барьеры времени. В этом факте заключается критически важная динамическая разница между животной и человеческой жизнью. Подобно тому, как растения собирают солнечную энергию в пучки для применения и роста животного и человека, люди собирают и связывают знание прошлого в пучки для применения и развития ещё не рождённых поколений.

    Мы увидели, что термин «богатство», при должном его понимании, означает результат время-связующей работы человечества. Богатство мы делим на два вида: материал и знания. Оба несут практическую ценность. Первый вид разрушается – продукты, из которых оно состоит, распадаются и становятся бесполезными. Второй остаётся перманентным по характеру и не может разрушиться. Его могут утратить или забыть, но он не изнашивается.

    Один вид ограничивается во времени, другой не ограничивается. Первый я называю ⬩_потенциальной практической ценностью_⬩, а второй ⬩_кинетической практической ценностью_⬩. Я объясню эти названия.

    Энергию, которой обладает тело в связи со своим положением, мы называем потенциальной энергией. Энергию тела в связи с его движением мы называем кинетической энергией. Материальная практическая ценность становится таковой за счёт своего положения, формы и так далее; если её не применять, она остаётся неподвижной и неспособной развиваться. Умственные практические ценности не стоят на месте, а ведут себя динамически. Одна мысль, одно открытие служит импульсом другим. Они следуют законам растущей ·_потенциальной_· функции времени. Именно поэтому я назвал их именами двух упомянутых классов энергии.

    Здесь мне следует вернуться к нынешней концепции богатства и капитала, приведённой выше.

    ⬩«⬩  
    Богатство  
    ⬩»⬩

    – нам говорят, –

    ⬩«⬩  
    составляют полезные или пригодные вещи, обладающие ·_об_·мено·_способной_· ценностью.  
    ⬩»⬩

    Нам также говорят:

    ⬩«⬩  
    Капитал представляет собой ту часть богатства, которой мы пользуемся, чтобы получать больше богатства.  
    ⬩»⬩

    Я назвал такие концепции – такие определения – богатства и капитала детскими, и сказал, что они относятся к периоду человеческого детства. Читатель сам, поразмыслив, сможет увидеть их таковыми, особенно, если сравнит их с научной концепцией, согласно которой богатство состоит из того, – материальных продуктов или форм знания и понимания – что произвели время-связующие энергии человечности; и, согласно которой ·_практически всё богатство мира в данное время_· представляет собой ·_накопленные результаты тяжкого труда прошлых поколений_· – живущую работу умерших.

    Я не вижу необходимости предостерегать читателя о спутывании «·_делания_·» денег всеми честными и нечестными путями с ·_созданием_· богатства трудом. Называя старые концепции детскими, я не имею в виду, что в них не найдётся ничего истинного. Я говорю об их поверхностном характере, научной скудности, узком взгляде и ошибочности уклона. Я считаю их немыми и слепыми в отношении того, что богатство представляет собой естественный результат действия времени и человеческого труда. В старых концепциях, стоит признать, подразумевается, что богатство и капитал влекут за собой как потенциальную, так и кинетическую практические ценности, и в этом я с ними согласен.

    Однако каким образом такие практические ценности возникают?

    Потенциальные практические ценности в богатстве создаются человеческой работой во времени над сырым материалом, данным природой. Эти практические ценности производятся требующими времени преобразованиями сырых материалов. Эти преобразования выполняются трудом человеческого мозга и трудом человеческих мышц, которые мозг направляет, действуя во времени. Кинетические практические ценности богатства тоже создаются человеческим трудом – большей частью интеллектуальным трудом наблюдений, экспериментов, воображения, дедукции и изобретения, и на всё это уходит драгоценное время короткой человеческой жизни. Мы чётко видим, что в создании практических ценностей, потенциальных или кинетических, составляющая ·_времени_· действует как совершенно необходимый фактор.

    Фундаментальную важность времени как фактора в производстве богатства – тот факт, что богатство и практические ценности богатства в буквальном смысле происходят от духовного единения времени с трудом – мы полностью упускали не только в экономике, но и в этике, и юриспруденции и в других областях мышления догадками на протяжении длительного периода человеческого детства. Веками шли «разговоры» о времени, но никто не признавал базовую значимость времени как неотъемлемой составляющей концепции и самого устройства человеческих ценностей.

    Мы часто говорим:

    ⬩‹⬩  
    Время есть деньги.  
    ⬩›⬩

    Это высказывание часто оказывается ложным, однако, пропозиция, что деньги есть время всегда остаётся истинной. Она остаётся истинной в том важном смысле, что деньги служат мерой и символом богатства – результата времени и труда – кристаллизации время-связующей способности человека. В свете этого истинным становится то, что ⬩**деньги представляют значительную ценность, меру и символ работы – частично работы живущих, но, главным образом, живущей работы умерших**⬩.

    Законы природы стоят превыше всего. Мы не можем их изменить. Мы можем отклоняться от них до некоторой меры, но это не приводит ни к чему хорошему. Именно этот урок нам следует усвоить из истории человеческого детства. Ложные концепции Человека – незнание законов человеческой природы – принесли нам ненаучные экономики, ненаучные этики, ненаучные законы, ненаучные политики, ненаучное правительство. Они сделали из человеческой истории историю социальных катаклизмов – восстаний, войн, революций – печальных признаков не столько человеческих стремлений, сколько человеческого невежества о законах человеческой природы. Остаётся одно средство, одна надежда – наука и искусство Человеческой инженерии, основанной на правильной концепции человечества как время-связующего класса жизни и согласованной с законами природы, включая законы человеческой природы.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/aPByBb3nTpC#j40R)Отсылка к Томасу Карлайлу [⬀](https://en.wikipedia.org/wiki/The_dismal_science).

    * * *

""".trimIndent()