package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_4(modifier: Modifier) {
    MarkdownText(
        markdown = chapter_4_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val chapter_4_text = """
    # Глава Ⅳ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Человек всегда представлял для человека загадку. Тому существует много важных причин. В этой книге я не занимаюсь теоретическими исследованиями человека. Таких написали уже слишком много, поэтому я не стану перечислять причины, а вместо этого ограничусь своей задачей, которая состоит в том чтобы указать путь к науке и искусству Человеческой инженерии.

    Нам придётся начать с двух фактов, которые сильнее остальных сдерживают человеческий прогресс:

    1\. До сих пор никто не приводил правильного определения человека и не разрабатывал концепции его роли в разворачивающихся в мире событиях. В связи с этим мы не могли найти подходящего принципа или отправной точки для науки человечности. Мы не осознавали, что человек представляет собой существо измерения или типа, отличного от животных, из-за чего не понимали характерную природу человека;

    2\. Человека всегда считали либо животным, либо сверхъестественным явлением. По фактам мы не находим в человеке ничего животного или ·_сверх_·ъестественного, а видим его как буквально часть природы. Мы убедились, что животных характеризует их автономная способность перемещаться, – их пространство-связующая способность – и отнесли их к пространство-связующим. Мы также убедились, что людей характеризуют их творческая способность; способность делать так, чтобы прошлое жило в настоящем, а настоящее для будущего – способность связывать время. Мы отнесли людей ко время-связующим. К этим широким концепциям мы пришли беспристрастно и математически; мы построили их математически корректно.

    То, ·_как_· появился первый человек, – первый время-связующий – не имеет значения; мы знаем по факту, что он где-то каким-то образом появился. Чтобы узнать что-то основательно нас интересующее о человеке, нам придётся анализировать человека по трём координатам – трём способностям: по его химии, его деятельности в пространстве и особенно его деятельности во времени, тогда как в изучении животных нам приходится учитывать только два фактора: их химию и их деятельность в пространстве.

    Представим первобытных – первых появившихся – людей двумя братьями обезьянами, – пространство-связующими животными – ·_A_· и ·_B_·, похожими друг на друга во всех отношениях. Предположим, что с ·_B_· случилось что-то странное, от чего он стал первым время-связующим, человеком. То, как это «что-то» осуществило его подъём к более высокому измерению, не имеет значения; нам хватает предположения, что каким-то образом к его животной способности связывать пространство добавилась новая, более высокая, чудесная способность связывать время.

    Так он вышел в новое измерение, но, конечно, этого не осознал. Благодаря этой новой способности он смог проанализировать своего брата «·_A_·». Он подметил:

    ⬩⸗⬩  
    ·_A_· есть мой брат; он есть животное, но он есть мой брат; следовательно, ·_я_· ⬩**есть животное**⬩.  
    ⬩⸗⬩

    Этот первый роковой вывод, сделанный по ложной аналогии и от пренебрежения фактом, стал главным фактором человеческого несчастья, и через миллионы лет он до сих пор живёт. Способность ко время-связыванию, впервые проявившаяся у ·_B_·, продолжала развиваться с каждым поколением, и постепенно человек начал всё больше ощущать себя каким-то образом отличным от животного, но этого пока не мог объяснить. Он сказал себе:

    ⬩⸗⬩  
    Если я есть животное, то во мне есть что-то выше; искра чего-то ·_сверх_·ъестественного.  
    ⬩⸗⬩

    Этим выводом он оградился от природы, завёл себя в безвыходное положение и заставил себя жить двойной жизнью. Он не поступал сообразно «сверхъестественному», потому что не мог его постичь и, следовательно, не мог на него равняться. Не поступал он и сообразно «животному», которое презирал. Поставив себя вне «законов природы», он на деле не вёл свою жизнь ни по каким законам. Ему пришлось основать искусственные, неестественные законы на собственных домыслах и тем самым обречь себя на жизнь в притворстве.

    ⬩«⬩  
    Как слепят нас наши привычные предположения! Среди животных человек, по меньшей мере, давно проявляет склонность считать себя существом, непричастным к окружающему его космосу. От этого он отделился мысленно, овеществил мир, сделал его себе чуждым и лишился чувства принадлежности ему. Эту вековую привычку и точку зрения, которая оформляет его жизнь и контролирует мышление, сказываясь на всей его философии, творчестве и обучении, он до сих пор поддерживает, частично из удобства, частично силой инерции и чистейшим консерватизмом, невзирая на высочайшие вероятности, выявленные биологическими науками. Пожалуй, ни одна другая гипотеза не имеет меньше оснований, и тем не менее, ни одна другая не преобладает настолько в разуме человека.  
    ⬩»⬩  
    Кассий Дж. Кайзер, ук. соч.

    Эта чудовищная концепция действует по сей день. Миллионы людей по-прежнему смотрят на человека как на смесь животного с чем-то сверхъестественным.

    Несомненно, инженерия человеческого общества представляется трудной и сложной задачей, которая требует огромной моральной ответственности, потому что в нём мы имеем дело с благополучием человечества на протяжении нескончаемой последовательности поколений. Науку Человеческой инженерии не удастся построить на ложных концепциях человеческой природы. Её не получится построить ни на концепции человека как какого-то животного, ни на концепции человека как смеси естественного ⁅природного⁆ и сверхъестественного. Её следует строить на концепции человека как естественного существа более высокой размерности, чем животные. Её следует строить на научной концепции человечества, характеризуемого его время-связующей способностью и функцией. Эта концепция радикально преобразует наш взгляд на человеческую жизнь, человеческое общество и мир.

    Любой увидит ясно, что время-связывание служит единственным естественным ⁅природным⁆ критерием и стандартом для время-связующего класса жизни. Этим действенным термином, если его всецело осмыслить, удастся охватить ⬩**целое**⬩ естественных законов, естественной этики, естественной философии, естественной социологии, естественной экономики, естественного управления, которым следует учиться время-связующим. Тогда начнётся действительно мирная и прогрессивная цивилизация без периодических развалов и насильственных перестроек – не раньше.

    Всё, что относится ко «время-связыванию» ·_действует в_· ⬩**человеческом измерении**⬩; следовательно оно представляет каждое качество, которое мы подразумеваем под такими словами как «хорошо», «справедливо», «правильно», «красиво». Всё, что относится к лишь пространство-связыванию, мы классифицируем как «животное» и тем самым оцениваем по его надлежащим значениям ⁅ценностям⁆. Невежественных «хозяев судеб», которые считают людей животными или чудовищными гибридами естественного и сверхъестественного, следует свергнуть с престола научным образованием.

    Ложные идеи и учения действуют на человека буквально как яд. Многих людей пугает одна только мысль о том, что в их чае или кофе окажется яд, но им не удаётся осознать, что, когда они учат ложным идеям и ложным доктринам, они отравляют время-связующую мощь своих собратьев мужчин и женщин. Следует остановиться и подумать!

    Не стоит видеть что-то мистическое в том, что идеи и слова представляют собой энергии, которые в значительной мере воздействуют на физико-химическую основу нашей время-связующей деятельности. Из-за этого люди рассогласуются с «человеческой природой».

    Мы знаем о гипнотизме как о факте. Мы видели свидетельства тому, что человека получается загипнотизировать, чтобы он в определённое время совершил убийство, поджог или воровство; что под внушением личная мораль индивидуума оказывает лишь незначительное влияние на его поведение. Субъект подчиняется любым, сколь угодно аморальным гипнотическим внушениям. Концепция человека как смеси животного и сверхъестественного веками внушает людям, что животный эгоизм и животная алчность составляют неотъемлемые аспекты их характера; это внушение подавляет их ⬩**действительную человеческую природу**⬩ и не даёт им выражать себя естественно и свободно.

    Если же с помощью образования человек осознаёт, что по ·_природе_· представляет собой время-связующее существо, он спонтанно начинает жить согласно своей время-связующей природе, которая, как я сказал, служит источником и поддержкой высших идеалов.

    Чего мы добиваемся, обвиняя человека в эгоизме и алчности, когда он поступает под влиянием своей социальной среды и образования, которое учит его принимать себя за эгоистичное и алчное по своей природе животное?

    Даже знаменитый философ и психолог ⁅Герберт⁆ Спенсер говорит нам:

    ⬩«⬩  
    Интерес для нас представляет очевидная истина, что существу приходится жить прежде, чем оно может действовать…. В своей этике нам следует признать истину, что эгоизм стоит выше альтруизма.  
    ⬩»⬩

    Это мы считаем истинным в отношении ⬩**животных**⬩, потому что животные вымирают от нехватки пищи, когда иссякает её естественный запас в силу их ⬩**недостатка способности производить искусственно**⬩. Это не истинно для ⬩**человеческого измерения**⬩.

    Почему не истинно?

    Потому что люди благодаря своей время-связующей мощи прежде всего ·_создают_·, и их число зависит не от естественного достатка, а от искусственной производительности – ⬩**материализации их время-связующей мощи**⬩.

    Следовательно, человек, по своему естественному характеру, ⬩**должен действовать прежде, чтобы жить**⬩ (за счёт действий родителей или общества); у животных так не происходит.

    Не понимая эту простую истину, мы допускаем зло в наших этических и экономических системах, или допускаем недостаток систем. В действительности, если бы человечество жило ·_полностью_· сообразно животной концепции человека, искусственное производство – время-связующее производство – прекратилось бы, и девяносто процентов человечества вымерло бы от голода. Люди могут жить в таких числах, потому что они не животные, а время-связующие. Они не просто находят, а создают пищу и кров.

    Теперь даже слепой увидит следствие высшей размерности. Это следствие, в свою очередь, становится причиной других следствий, которые создают другие причины и так далее по бесконечной цепи.

    ⬩**Мы живём, потому что производим, потому что действуем во времени, а не только в пространстве, потому что Человек не есть какое-то животное.**⬩

    Всё это оказывается очень простым, если применить немного разумной логики в нашем мышлении о человеческой природе и человеческих отношениях. Если мы хотим сделать человеческую этику человечной, – поместить её в человеческое измерение – то нам придётся поменять постулаты этики, ⬩**потому что человечество, чтобы жить, сначала должно действовать**⬩.

    Законы этики – законы правильной жизни – происходят ·_естественно_· ⁅·_природно_·⁆ – законы человеческой природы – от время-связующей мощи и время-связующей деятельности, характерных для человека. Совершенствование Человека осуществляется время-связыванием, и его следует мерить и вознаграждать по время-связующим стандартам ценностей.

    Человечество, чтобы жить, должно творчески производить и, следовательно, должно ориентироваться с помощью прикладной науки, технологии. Это означает, что так называемые социальные науки этики, юриспруденции, психологии, экономики, социологии, политики и управления следует освободить от средневековой метафизики, сделать научными, ·_технологизовать_· и обеспечить, чтобы они развивалась и функционировали в должном измерении – в человеческом измерении, а не в животном; их следует сделать время-связующими науками.

    Справимся ли мы?

    Я не сомневаюсь, что справимся.

    Иначе, на что нам человеческая жизнь?

    Для генерала на поле сражения человеческая жизнь служит фактором, который при надлежащем применении может уничтожить врага. Для инженера человеческая жизнь становится эквивалентом энергии или способности выполнять работу, умственную или физическую. По обнаружению чего-то, что служит источником энергии и обладает способностью выполнять работу, инженер первым делом анализирует этот генератор в поисках наилучшего способа его сберечь, улучшить и извлечь максимум производительности.

    Люди представляют собой очень сложные энергопроизводящие батареи, качество и производительная сила которых широко варьируется. Опыт показывает, что эти батареи, прежде всего, работают химически, производя таинственную энергию. Если не обеспечивать их периодически более или менее постоянным количеством определённых химических элементов, называемых пищей и воздухом, они прекратят функционировать – умрут.

    Изучив структуру этих батарей, мы выявляем, что их химическая основа проявляется в них очень чётко. Этот химический генератор делится на ветви, каждая из которых играет свою уникальную роль, делая это в гармонии с остальными. Механические части структуры выстраиваются согласно правилам механики, автоматически снабжаются смазкой и химическими веществами для восстановления изношенных частей. Химические процессы не только хранят частицы массы для структуры генератора, но и производят очень сильные неизвестные виды энергий или вибраций, за счёт которых функционируют все химические части. Мы также выявляем таинственное устройство с комплексом проводов, которое называем мозгом, железами и нервами. Наконец, эти человеческие батареи обладают удивительной способностью к размножению.

    Об этих функциях знают все. Из знания о других физических, механических и химических природных явлениях нам следует сделать вывод, что человеческая батарея представляет собой самый совершенный пример сложного двигателя. Он обладает всеми особенностями химической батареи в сочетании с генератором особой энергии, называемой жизнью. Важнее всего, он обладает умственными или духовными способностями, и тем самым владеет как умственными, так и механическими средствами производства.

    Части и функции этого чудесного двигателя стали предметом обширных исследований в различных специальных научных дисциплинах. Стоит особенно отметить факт, что как физическая, так и умственная работа этого человеческого двигателя всегда сопровождается как физическими, так и химическими изменениями в структуре его механизмов, что согласуется с износом неживых двигателей. Мы также наблюдаем определённые сексуальные и духовные явления, в которых видим разительное сходство с беспроводными электрическими явлениями и с радием.

    Этот человеческий двигатель-батарея представляется необычайно сильным, выносливым и совершенным, но одновременно с этим, если не обращаться с ним должным образом, он легко подвергается повреждениям и даже поломкам. Факторы контроля тонки и чувствительны, поэтому двигатель требует особого к себе отношения. Чтобы им управлять, обязательно требуется особое обучение и понимание.

    Читатель, возможно, захочет спросить:

    ⬩⸗⬩  
    Что есть сущность время-связующей способности?  
    ⬩⸗⬩

    Разговоры о сущности мы ведём метафизически, а не научно. Я объясню на примере.

    Что есть электричество?

    Научно мы ответим:

    ⬩⸗⬩  
    Электричество есть то, в чём мы наблюдаем такие-то явления.  
    ⬩⸗⬩

    Под электричеством мы не имеем в виду ничего, кроме определённой группы наблюдаемых явлений, которые называем электрическими. Изучая эти явления, мы изучаем электричество. Так мы поступаем в физике – мы не говорим о сущностях. Подобным образом, в Человеческой инженерии мы не станем говорить о сущности время-связывания, а только о его явлениях и законах.

    К разработке электрических приборов привело знание электрических явлений, а не метафизические разговоры об электрической сущности. К науке и искусству Человеческой инженерии нас поведёт знание о время-связующих явлениях, а не пустой трёп о какой-то ·_сущности_· время-связующих способностей.

    Не следует видеть в слове «время-связывание» ничего таинственного. Нам понадобился описательный термин, чтобы обозначить человеческую способность, которая отличает людей от животных и характеризует человечность человека. При таком применении, если хорошо над этим поразмыслить, целесообразность термина «время-связывание» становится очевидной.

    Какие условия жизни даёт эта земля?  
    Живём ли мы свои повседневные жизни в войне или в мире?

    Всем живым существам требуется пища, из-за чего ·_естественная_· производительность почвы постепенно становится неадекватной. Тенденция возрастать по геометрическому знаменателю наблюдается у всякой жизни, – у овощей, животных, людей – однако, эту тенденцию сдерживают различные противодействующие влияния, естественные и искусственные.

    Не так давно эти сдерживающие факторы сводили действие закона роста практически к нулю, не давая человеческому населению расти. Эти сдерживающие факторы удалось преодолеть только благодаря время-связующей мощи человека – благодаря научному прогрессу и технологическим изобретениям. За последний век население Европы возросло больше, чем за несколько предыдущих веков. Истощённая почва, высокие или низкие температуры, избыточная влага, недостаток осадков и многие другие факторы угрожают жизни. Становится очевидным, что человеческой жизни особенно приходится безостановочно участвовать в борьбе за существование и самосохранение. Если в нашей повседневной жизни без конца идёт война, нам следует применять военные методы.

    Мы только что прошли масштабную всемирную войну ·_для военных_·, в ходе которой разработали особые способы производства мощей, чтобы превзойти врага. Нам пришлось найти ранее скрытые источники энергии и поменять все наши привычки и идеи в интересах военных методов и военных технологий. Война повседневной жизни против враждебных стихий ведётся за покорение физической природы, а не за завоевание людей. Эта война ведётся время-связующими мощами людей против естественных препятствий, и её прогрессивный триумф означает прогрессивное развитие человеческого блага.

    Не проанализировав Мировую войну, мы не усвоим её урок. Воюя народами против народов, мы прерываем нормальную повседневную войну миллионов индивидуумов за покорение природных ресурсов на человеческие нужды, чем уничтожаем результаты тяжёлой, длительной работы. В мирной же войне – войне за покорение природы – мы применяем методы технологии и, что намного важнее, технологической философии, закона и этики.

    В этой небольшой книге я хочу подчеркнуть необходимость тщательного пересмотра наших идей. Чтобы согласовать наши идеи с фактами, этот пересмотр следует осуществлять умами инженеров. Когда мы болеем, мы обращаемся к врачу, а не к шарлатану. Нам следует усвоить, что, когда мы испытываем проблемы с производством энергии в мире, нам следует обращаться к инженеру – эксперту по энергии. Политики, дипломаты и юристы не понимают этих проблем. Нам следует научиться обращаться к тем, кто знает, как производить, а не к тем, кто занимается борьбой за разделение продуктов, произведённых природой или другими людьми.

    На деле наша цивилизация долгое время пребывает в дезорганизации вплоть до болезни, и лишь недавно в свете меняющихся условий, благодаря высвобождению мощи становлением новых технологий мы начали замечать эту дезорганизацию. Больной человек редко знает, чем ему стоит лечиться. Если мы хотим долгосрочных эффектов лечения, нам следует направиться к источникам, а это не может сделать никто, кроме людей, знакомых не только со следствиями, но и с причинами.

    Богатство народа составляют не деньги, а производство. Следовательно, задачей человечества становится ·_упорядоченное производство_·. Однако, чтобы организовать максимальное производство, это необходимо делать на разумной основе. Простые проповеди о братской любви или классовой ненависти не произведут ни единого кирпича для строительства будущего храма человеческой победы – храма ·_человеческой_· цивилизации. Упорядоченное производство требует анализа основных фактов.

    Мы живём в сущности в промышленный период. Чтобы производить нам требуется:

    1\. сырьё или почва;  
    2\. орудия для производства – инструменты и механизмы; и  
    3\. применение энергии.

    Мы можем охарактеризовать эти три требования следующим образом:

    ⬩1⬩ Сырьё и почву даёт нам природа; человечество просто берёт их и пользуется ими, потому что мы не можем назвать благодарственную (или любую другую) молитву «создателю» платой богам или людям. Однако сырьё и почва в условиях, в которых их производит природа, несут человечеству мало прямой пользы, потому что невозделанная почва производит очень мало пищи для человека, а сырьё, такое как дерево, уголь, нефть, железо, медь и т. д. остаются вовсе бесполезными, пока человек не поработал над ними. Чтобы получить лесоматериалы, придётся спилить дерево; минералы приходится выкапывать, и даже тогда, чтобы человек мог их как-то применять, над ними требуется поработать.

    Мы видим, что сырые материалы в той форме, в которой их произвела природа, большей частью не несут практической пользы, если их не ·_пере_·рабатывать через процесс «человеческого творческого производства». Следовательно, нам стоит разделить «сырьё» на два разных класса:

    a. сырьё, произведённое природой, – безвозмездный дар природы – которое в своей изначальной форме и месте почти не несёт практической ценности и не подходит для применения; и

    b. сырьё, переработанное человеческой умственной и мышечной деятельностью – его «время-связующими» способностями.

    Сырые материалы второго класса несут огромную ценность и потенциал применения; они, более того, делают возможным существование человечества.

    ⬩2⬩ Инструменты и механизмы, – второе требование для производства – очевидно, создаются из сырья человеческим трудом, умственным и мышечным.

    ⬩3⬩ Применение энергии. Мы знаем о различных источниках природной энергии. Наиболее важным доступным источником энергии для этой земли видится солнце – солнечное тепло. Это солнечное тепло служит источником энергии воды, ветра, энергии, заключённой в угле, энергии химии, роста и преобразующей способности растений.[¹](https://teletype.in/@czoc/XYNKP3poMI_#5B7o)

    Вся пища, которую употребляют животные и люди, существует как результат действия солнечной энергии, преобразованной в то, что мы можем назвать химической энергией. Жизнь строится на преобразованиях энергий.

    Стоит чётко увидеть, что единственным источником энергии, который удаётся напрямую употреблять человеку или животному, служит растительная пища в дикой природе; никаких иных источников ·_прямого_· употребления не существует; только те, которыми человеку приходится овладеть и направить человеческим мозгом. Это же мы можем сказать о пище животного происхождения, о создании водяной или ветряной мельницы, парового двигателя, о применении лошадей в упряжи, бушеля пшеницы. Ничего из этого не может существовать, кроме как благодаря человеческой «время-связующей» мощи.

    Этот краткий обзор всем известных фактов, приводит нас к заключению, что все проблемы производства сводятся в конечном счёте к анализу

    1\. Природных ресурсов сырья и естественных источников энергии, которые мы получаем от природы; они, как мы убедились, в той форме, в которой их создаёт одна только природа, несут низкую или никакую ценность для человечества;

    2\. Деятельности человеческого мозга (потому что человеческие мышцы направляются мозгом), который даёт ценность в ином случае бесполезному сырью и энергиям.

    Следовательно, нам не удастся понять процессы производства, не осознав, что человечество выживает только благодаря способности эксплуатировать природные ресурсы – перерабатывать продукты природы в формы, доступные человеческим нуждам. Если бы люди обладали только способностями обезьян и полагались исключительно на дикие фрукты и подобное, они бы оставались привязанными к сравнительно малым территориям с благоприятным климатом и плодородной почвой. Однако в этом гипотетическом случае люди были бы не людьми, – не время-связующими – а животными – пространство-связующими.

    Следует учитывать и другие факты. Один из них заключается в том, что в мире, в котором мы живём, действуют естественные законы как неорганических, так и органических явлений. Другой факт состоит в том, что, как мы сказали ранее, человеческий класс жизни обладает уникальной способностью устанавливать социальные законы и обычаи, которые регулируют и влияют на его судьбы, которые способствуют или препятствуют процессам производства, от которого основательно зависят жизнь и счастье человечества.

    В связи с этим нам не стоит упускать, что человеческий класс жизни представляет собой часть и результат природы, и что, следовательно, должны существовать ·_фундаментальные законы, естественные для данного класса жизни_·. Камень подчиняется естественным законам камней; жидкость подчиняется естественным законам жидкостей; растение – естественным законам растений; животное – естественным законам животных; отсюда неизбежно следует, что ·_должны_· существовать естественные законы для людей.

    Однако проблема усложняется тем, что камень, растение и животное не обладают интеллектуальной способностью создавать и приводить в действие, из-за чего ·_слепо_· подчиняются своим естественным законам. Они не имеют свободы определять свои судьбы. Человек, в отличие от них, обладает этой способностью и может своим невежеством, пренебрежением или злым умыслом отклоняться и ошибочно толковать естественные законы человеческого класса жизни. Именно в этом заключается секрет и источник человеческого хаоса и невзгод – факт такой огромной важности, что нам не удастся его переоценить и продолжать его избегать. Открытие природы Человека и законов этой ·_природы_· отмечает достижение вершины человеческих инициатив. Решение этой ·_задачи открывает путь ко всему, что может оказаться важным для человечества_· – к человеческому благополучию и счастью.

    Эта великая задача служила импульсом на протяжении веков человеческих стремлений, потому что во все времена мыслители ясно видели, что от правильного решения этой задачи зависит благополучие человечества. Они предлагали много «решений». Все они друг от друга отличались, но сходились в одном – в том, что оказались ошибочными.

    В связи с чем?

    В каждом случае в связи с радикальным непониманием того, что человек собой на деле представляет. Задача состоит в том чтобы выявить естественные законы человеческого класса жизни. Все «решения», предложенные в ходе истории, включая те, которые применяются сейчас, сводятся лишь к двум видам: ·_зоологическому_· и ·_мифологическому_·. Зоологические решения относятся к тем, к которым мы приходим на основе концепции, согласно которой люди есть животные. Если люди есть животные, то законы человеческой природы есть законы животной природы. Следовательно, социальные «науки» этики, права, политики, экономики, управления становятся ничем иным, как зоологическими дисциплинами. Как науки они представляют изучение животных. Как искусства ⁅ремёсла⁆ они представляют хозяйство и управление животными. Согласно зоологической философии, человеческая мудрость о человеке представляет животную мудрость о животных.

    Мифологические «решения» начинаются с чудовищной концепции, согласно которой людям не находится места в природе, и они представляют собой смеси естественного ⁅природного⁆ и ·_сверх_·ъестественного – единства или сочетания животности и божественности. В таких решениях не предполагается концепций ·_естественного_· закона. С научной точки зрения, они представляют собой мифологические нелепости, бестолковые слова голой и безответственной метафизики, несомненно, обусловленные благими намерениями, но глупые и смертельно опасные своими эффектами на интересах человечества. Они делают бесполезными этику, право, экономику, политику и управление.

    Такими остаются царствующие философии человеческой природы.

    Как это исправить?  
    Как выявить законы человеческой природы?

    Мы ясно видим, что инициативу, как все научные инициативы, следует основывать и направлять действительностью. Следует обязательно осознать, что великая, центральная, главенствующая, всеохватывающая действительность заключается в действительности ·_человеческой природы_·. Если мы составим ошибочное представление об этом основательном деле, мы потерпим неудачу в своей инициативе. Мы видим это ясно, как логически, так и в свете нашей печальной истории.

    Однако, если мы составим верное представление, мы сможем уверенно ожидать, что преуспеем в своей инициативе. Именно поэтому в Главе «Классы жизни» я так подчеркнул абсолютную необходимость осмысления человека тем, что он на деле есть, а не чем-то другим; и мы выяснили, что человек есть. Мы выяснили, что человек характеризуется способностью связывать время, и ·_определили_· человечество как время-связующий класс жизни. Мы получили основательную концепцию, которая содержит зачаток науки и искусства Человеческой инженерии. Задача выявления и применения «законов человеческой природы» состоит в том, чтобы выявить и применить к образу жизни законы время-связывания, время-связующей деятельности, время-связующей ·_энергии_·. Этот факт следует чётко усвоить и никогда о нём не забывать.

    Энергия, как мы отметили, составляет способность выполнять работу. В человеческой экономике мы можем условно разделить работу на

    1\. «полезную»,  
    2\. «нейтральную» и  
    3\. «вредную».

    Эти слова не имеют значения, кроме как в человеческой экономике. Энергия человеческого интеллекта представляет время-связующую энергию, с помощью которой мы можем направлять, применять и преобразовывать другие энергии. Эта время-связующая энергия стоит выше классом и обладает большей размерностью в сравнении с другими естественными энергиями, которые мы с её помощью направляем, контролируем, применяем и преобразуем. Эта высокая энергия – которую мы обычно называем умственной или духовной силой – ·_осуществляется_· время-связыванием, потому что позволяет достижениям прошлого жить в настоящем, а деятельности в настоящем жить в грядущем. Этой энергией мы осуществляем всякое приведение в действие, создаём, исторически понимаем прошлое и пророчески прогнозируем будущее, наполняем ·_абстрактное_· время – транспорт для событий – постоянно возрастающим количеством умственных достижений, духовного благополучия, предназначенных для цивилизации потомков.

    Как работает этот природный закон роста?  
    Как работает природный закон развития во всех сферах человеческой деятельности?

    Этот вопрос играет важнейшую, как теоретическую, так и практическую роль, потому что закон – каким бы он ни оказался – действует ·_естественно_· ⁅·_природно_·⁆, как закон человеческой природы, как закон время-связующей энергии человека.

    В чём он заключается?

    Мы уже отметили законы арифметической и геометрической прогрессий, отметили в них значительные отличия и увидели, что естественный закон человеческого прогресса в каждой кардинально важной сфере действует как закон, подобный таковому стремительно возрастающей геометрической прогрессии. Иными словами, естественный закон человеческого прогресса, естественный закон окультуривания человеческих отношений, основной закон человеческой природы, фундаментальный закон уникальной для человека время-связующей энергии представляет собой логарифмический закон – закон логарифмического роста.

    Я прошу читателя не дать себе смутиться этим термином, и принять его. Его не составит труда понять, а его значимость окажется великой и долговечной. Его математическую формулировку могут понять даже дети. Давайте взглянем на неё.

    Обозначим количество прогресса, достигнутого в какой-либо важной сфере данным поколением, которое мы можем назвать «первым» поколением, ·_PR_·.

    ·_R_· означает знаменатель – соотношение улучшения; число, на которое умножается прогресс одного поколения, чтобы получить количество прогресса, достигнутого следующим поколением.

    Количество прогресса, достигнутого вторым поколением составит ·_PR²_·, третьим поколением – ·_PR³_· и так далее.

    Теперь обозначим число поколений, считая первое и все дальнейшие в бесконечной последовательности, ·_T_·. Следующий ряд покажет закон человеческого прогресса в данной сфере:

    ·_PR, PR², PR³, PR⁴, PR⁵, …, PRᵀ, PRᵀ⁺¹, …_·.

    Обратите внимание как он идёт:

    *   первое поколение ·_заканчивает_· на ·_PR_·;
    *   второе поколение начинает с ·_PR_·, добавляет ·_PR²_· и заканчивает на ·_PR+PR²_·;
    *   третье поколение начинает с ·_PR+PR²_·, добавляет ·_PR³_· и заканчивает на ·_PR+PR²+PR³_·
    *   и так далее, и так далее.

    ·_Прирост_·, достигнутый поколением ·_T_· составит ·_PRᵀ_·; ·_общий прирост_· за ·T· поколений составит

    ·_PR+PR²+PR³+ … +PRᵀ_·.

    Этот общий прирост за ·_T_· поколений мы получаем по следующей формуле:

    Если мы присвоим ·_R_· значение 2 (очень маленький знаменатель, по которому прогресс каждого поколения лишь удвоится в сравнении с предыдущим) и присвоим ·_T_· значение, например, 10, то увидим, что прогресс, достигнутый одним десятым поколением составит ·_P×2¹⁰_· – в 1024 раза больше прогресса, достигнутого «первым» поколением. Мы можем посчитать, что общий прирост за 10 поколений составляет количество в 2046 больше количества прогресса, достигнутого за «первое» поколение.

    Чтобы приблизительно представить потенциал этого закона, читателю стоит поразмыслить над тем, что он работает не только в одной сфере, а во всех сферах человеческого интереса. Сейчас я могу лишь сказать: «Работает во всех сферах»; на деле, как мы ранее отметили, он не работает так ·_сейчас_· во ·_всех_· сферах и никогда не работал. Он ·_начнёт_· работать, как только мы в должной мере поумнеем, чтобы позволить ему это делать. Поумнеем мы тогда и только тогда, когда выясним, что по природе мы представляем собой время-связующих, и что ·_эффективность_· нашей время-связующей способности представляет собой не просто функцию времени, но и, как я объяснил, логарифмическую или экспоненциальную функцию времени – функцию, в которой время (·_T_·) действует как ·_экспонента_·, как в выражении ·_PRᵀ_·, что означает, что мы, люди, в отличие от животных, обладаем естественной способностью не только прогрессировать, а прогрессировать с нарастающей скоростью – с постоянно ·_ускоряющимся ускорением_· по смене поколений.

    Этот важный факт служит одновременно основой, регулятором и направляющей в науке и искусстве Человеческой инженерии. То, что согласуется с этим законом время-связующей человеческой энергии, способствует благу; то, что его нарушает, приводит к несчастьям.

    В связи с этим я повторю, что мир сможет непрерывно, мирно прогрессировать тогда и только тогда, когда так называемые социальные «науки» – жизне-регулирующие «науки» этики, права, философии, экономики, религии, политики и управления – технологизуются; тогда и только тогда, когда мы сделаем их действительно научными по духу и методу. Тогда и только тогда они смогут совершенствоваться как естественные, математические и технологические науки согласно базовому экспоненциальному закону время-связующей природы человека; тогда и только тогда, за счёт равных темпов прогресса во всех важнейших делах, получится стабильно поддерживать равновесие социальных институтов и прекратить социальные катаклизмы.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/XYNKP3poMI_#dn4H) Здесь стоит вспомнить, что наш мир в первую очередь представляет собой динамическое скопление материи и энергии, которая сегодня, как и в первый период примитивной органической жизни, принимала и принимает различные известные и неизвестные формы. Например, химическая энергия с её склонностью к соединениям и обменам. Разные элементы ведут себя по-разному. История Земли и жизни на ней представляет собой историю разных химических периодов, в которые происходили разные преобразования энергии.

    Стоит заметить один необычный факт об азоте. Азот химически проявляет исключительную инертность в отношении большинства других веществ, но как только он становится составляющей вещества, почти все соединения служат мощным источником энергии и сильно воздействуют на органическую жизнь. Азотная кислота действует окислением; вещества сгорают за счёт кислорода, выделяемого кислотой. Азотная кислота встречается в природе в соединениях, называемых нитратами. Нитраты переходят из почвы в растение. Нитрит амила наносит серьёзный ущерб органам и вызывает сильные спазмы. Оксид азота мы называем веселящим газом.

    Алкалоиды – соединения растительного происхождения сложного состава – могут производить значительные эффекты на животных. Они все содержат азот. Взрывчатые вещества – химические средства хранения огромных количеств энергии – представляют собой азотсодержащие соединения.

    Альбумин представляет собой органическое соединение, которое играет очень важную роль в жизни; он содержится в яичном белке, изобилует в сыворотке крови и составляет важную часть мышц и мозга. Альбуминоиды играют важнейшую роль в растительной жизни и представляют обширный класс органических тел в растениях и животных; они формируют основные составляющие крови, нервов. Все альбуминоиды, которые мы находим у животных, создаются процессами, выполняемыми в растениях. Мы не знаем их точный состав; анализ показывает содержание 50–55% углерода, 6,9–7,5% водорода, 15–19% азота, 20–24% кислорода, 0,3–2,0% серы. В 100 единицах объёма венозной крови содержится 13 азота, 71,6 угольной кислоты, 15,3 кислорода; артериальной крови 14,5 азота, 62,3 угольной кислоты, 23,2 кислорода.

    ⬩«⬩  
    В азотсодержащих соединениях мы наблюдаем крайнюю склонность к распаду, который часто сопровождается внезапным нарастанием силы. Все вещества, которые мы относим к ферментам,…. содержат азот, … и даже в организмах и частях организмов, где происходит меньше всего деятельности, те изменения, которые имеют место, инициируются веществом, содержащим азот….

    Органическая материя имеет такой состав, что малые случайные действия могут приводить в действие значительную реакцию и высвобождать большие количества энергии…. Семена растений содержат азотсодержащие вещества в гораздо больших количествах в сравнении с остальным растением. Семена отличаются от остального растения своей способностью провоцировать … существенные важные изменения – изменения, которые составляют прорастание. Подобным образом в телах животных … в какой-то части каждой вегетативной клетки содержится азот. Эта часть инициирует изменения, которые составляют развитие клетки….

    Стоит заметить любопытный и значимый факт, что в технологии мы не только применяем тот же принцип запуска процесса значительных изменений в сравнительно стабильных соединениях с помощью гораздо менее стабильных соединений, но также задействуем с этой целью соединения того же общего класса. Нам удаётся произвести выстрел из современного оружия, поместив вблизи пороха, который мы хотим подвергнуть распаду или взрыву, малое количество детонирующего пороха, обладающего необычайной способностью к распаду или взрыву; распадаясь, детонирующий порох передаёт последующие молекулярные колебания менее подверженному распаду пороху. Этот детонирующий порох состоит из азотсодержащей соли.  
    ⬩»⬩  
    — Спенсер

    * * *

""".trimIndent()