package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_2(modifier: Modifier) {
        MarkdownText(
            markdown = chapter_2_text,
            color = MaterialTheme.colorScheme.onSurface,
            style = MaterialTheme.typography.bodyLarge,
            modifier = modifier.padding(horizontal = 15.dp),
        )
}

val chapter_2_text = """
    # Глава Ⅱ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Завершение мировой войны стало концом периода детства человечества. Это детство, как любое детство, мы можем охарактеризовать как лишённое какого-либо понимания ценностей; ребёнок может пользоваться дорогостоящим хронометром для колки орехов.

    Это детство продлилось слишком долго, но мы, к счастью, приближаемся к его концу, потому что человечество, испытавшее эту войну, приходит в чувства и вскоре достигнет зрелости – периода великих достижений и результатов с новым, адекватным пониманием ценностей.

    Нам следует позаботиться о том, чтобы умершие не умерли напрасно. «Красное вино молодости», бесцельная растрата жизни показали нам цену жизни. Нам придётся выполнить свою клятву и сделать будущее достойным их усилий и страданий.

    Первые идеи не всегда оказываются истинными.

    Существуют разные толкования истории и разные философские школы. Все они внесли какой-то вклад в человеческий прогресс, но никто из них не смог дать миру базовую философию, которая бы охватывала целое прогресса науки и объясняла жизнь человека фактами.

    Наша жизнь неизбежно развивается по явным или скрытым законам природы. Явные законы природы стали вдохновением для настоящей науки на начальных этапах её развития, а по их интерпретациям мы с самого начала формировали системы права, этики и философии.

    Своим человеческим интеллектом – говорим мы о таковом индивидуума или расы – мы приходим к выводам, которые приходится часто пересматривать, чтобы привести их в приблизительную согласованность с фактами. То, что мы называем прогрессом, мы осуществляем с помощью координации идей с реальностью. Мировая война всех чему-то научила. Нам пришлось испытать её как реальность и научиться мыслить, основываясь на реальности, а не на иллюзорных догадках.

    Нам удалось выявить неоспоримые истины. Значение имели факты и сила. Силу пришлось производить, чтобы уничтожить силу врага. Мы выяснили, что старые политические и экономические системы не годились для выполнения поставленных перед ними задач. Миру пришлось создавать новые экономические условия, заменять старые системы назначением специальных советов по пище, углю, железным дорогам, транспорту, труду и т. д. Безотлагательность мировой войны заставила народы организоваться для создания силы, которая превзошла бы уже существующую великую силу.

    Если ничего иного война не доказала, то она доказала неоспоримо, что ценнейшим ресурсом, которым располагает народ или индивидуум, служит способность «что-то делать».

    ⬩«⬩  
    Маки цветут на Фландрийских полях…  
    ⬩»⬩

    – лучше не скажешь;[¹](https://teletype.in/@czoc/SrAmb2OpdfB#daDk) красные, крепкие они цветут. Однако здесь мы хотим не чествовать поэзию, а раскрыть и правильно применить факты.

    В научных лабораториях используют для экспериментов и убивают тысячи кроликов и морских свинок. Эти эксперименты приносят много ощутимой пользы человечеству. В войне погибли миллионы людей, лишились здоровья и нормальной жизни десятки миллионов.

    Это мы называем кульминацией довоенной цивилизации, которую не заметим, кроме как стихами и удобрением полей сражений, чтобы «маки цвели» и крепчали?

    Сколько знаний мы обретаем, когда на поле сражений гибнет десять человек, и сколько обретаем, когда убиваем одного кролика для эксперимента?

    Не следует ли нам проанализировать эту великую жертву?

    Я не вижу никакого ответа, кроме как утвердительного. Однако, если мы хотим получить истину, анализ следует проводить научно.

    В науке «мнения» терпят только при нехватке фактов. В нашем случае мы располагаем всеми необходимыми фактами. Нам остаётся лишь собрать и проанализировать их, отвергнув ничего не стоящие «мнения». Усвоившие этот урок поймут, как действовать на благо всех.

    Сегодня будущее человечества выглядит мрачно.

    ⬩‹⬩  
    Остановись, осмотрись и прислушайся.  
    ⬩›⬩

    – гласит предупредительный знак на железнодорожном переезде. Его следует дополнить:

    ⬩‹⬩  
    Остановись, осмотрись, прислушайся и ⬩**подумай**⬩.  
    ⬩›⬩

    Не для того чтобы спасти несколько жизней от несчастных случаев на железной дороге, а для поддержания жизни человечества.

    Живые организмы низших и более простых типов, у которых дифференциация и интеграция жизненно-важных органов не зашла далеко, могут двигаться достаточно долго после того, как их лишили приспособлений, с помощью которых они накапливают и передают свои жизненные силы. Однако высшие организмы мгновенно умирают при удалении этих приспособлений, или даже при травмировании их малых частей. Ещё легче уничтожению подвергаются более развитые и сложные ·_социальные_· организации.

    Нас прежде всего интересует, какими научными методами мы сможем избавиться от всевозможных мнений и вероучений в анализе фактов и обеспечить надёжность основанных на них выводов. Краткий обзор фактов цивилизации поможет нам найти способ.

    Человечество в младенчестве не имело науки. Мы могли лишь наблюдать и строить догадки. В первое время мы много мыслили, основываясь на догадках без какого-либо подспорья из фактов. Теология и философия процветали. Их деятели часто спекулировали весьма умно, но в своих примитивных понятиях о фактах – о структуре небес, форме Земли, механических принципах, метеорологических и физиологических явлениях – почти всегда ошибались.

    Что есть история?  
    В чём состоит её значимость для человечества?

    Доктор Дж. Х. Робинсон даёт нам точный ответ:[²](https://teletype.in/@czoc/SrAmb2OpdfB#yBaL)

    ⬩«⬩  
    Безнадёжная зависимость человека от прошлого обусловливает ход истории. За наши убеждения, мнения, предрассудки, интеллектуальные предпочтения, знания, методы учения и поисков информации, за некоторыми исключениями, мы обязаны прошлому – нередко далёкому прошлому. История пополняет память; так же как памятью мы можем ей одной объяснить настоящее, и в этом заключается её неоспоримая ценность.  
    ⬩»⬩

    Дикарь думает, что любые удивительные явления случаются по некой воле, и с древнейших времён этот взгляд менялся лишь по мере выявления отношений между явлениями.[³](https://teletype.in/@czoc/SrAmb2OpdfB#Y8x0)

    Человек по своей природе всегда спрашивал «почему?», и в силу неспособности ответить на «почему», он находил свой ответ в другом факторе – «кто». Непознанное называли Богами или Богом. Однако с научным прогрессом «почему» становилось всё более явным, и вопрос преобразовался в «как». С первых дней человечества догматическая теология, право, этика и ранняя наука оставались монополиями одного класса и источником его власти.[⁴](https://teletype.in/@czoc/SrAmb2OpdfB#sOcz)

    Впервые эту власть пошатнули точные науки. Они развивались так быстро, что их не получилось удержать старыми, непонятными писаниями и предрассудками; они эффективно работали в сфере реальных вещей и жизни. Наука оттеснила всю софистику и стала реальностью. Учитывая фундаментальную важность этики как фактора цивилизации, она не может стоят на теологических или юридических оправданиях; её следует согласовывать с ·_естественными_· ⁅·_природными_·⁆ законами человеческой ·_природы_·.

    Законы и юридические идеи существуют с начала цивилизации. Юридические домыслы успешно развивались параллельно теологии и философии прежде, чем появились естественные и точные науки. Законы всегда писали небольшие группы людей, которые ставили себе общую цель поддерживать «существующий порядок» или восстанавливать старый порядок и наказывать тех, кто его нарушал.

    Догматическая теология по своей природе не меняется. То же стоит сказать и о духе закона. Закон защищает прошлый и настоящий статус общества; он выполняет консервативную, если не реакционную, функцию. Как теология, так и закон характеризуются статичностью.[⁵](https://teletype.in/@czoc/SrAmb2OpdfB#lnyc)

    Чтобы применять философию, законы и этику в динамическом мире, их следует делать динамическими; им следует придавать такую важность, чтобы их прогресс поспевал за прогрессом жизни и науки. В силу того, что цивилизация оставалась под контролем статических теологии и закона, у нас не получалось должным образом повлиять на динамический, революционный прогресс техники и постепенно меняющиеся условия жизни. Из-за этого мы теперь наблюдаем стремительное падение нравов в политике и бизнесе. Жизнь развивается быстрее наших идей, и поэтому мы постоянно применяем средневековые методы и суждения к условиям и проблемам современной жизни.

    В связи с этими расхождениями между идеями и фактами современное общество разделяется на разные враждующие, не понимающие друг друга классы. Средневековая приверженность закону и средневековые моральные устои, – фундаментальные составляющие старой ·_социальной_· структуры – по своей природе консервативные, реакционные и противостоящие переменам, постепенно утрачивают способность поддерживать тяжёлую социальную нагрузку современного мира. В связи с этим, их следует рассматривать как факторы, значительно обусловливающие обстоятельства, которые неизбежно привели к мировой войне.

    Работу этих устаревших идей разоблачили вспышки взрывов. Мировая война в корне поменяла экономические условия и заставила нас построить новые стандарты ценностей. Нам придётся осознать, что эволюция через преобразование происходит как космический процесс, и что сопротивление может его замедлить, но не полностью остановить.[⁶](https://teletype.in/@czoc/SrAmb2OpdfB#YzgY)

    В идеи о том, что органические особи появились в результате особого создания, не учитывается никакой научный стандарт. Не существует ни одного факта, который бы подкрепил особое или отдельное создание; все свидетельства, коих имеется огромное количество, указывают на обратное. Гипотеза особого создания представляется ископаемым прошлого. Только теория эволюции гармонирует с фактами во всех научных дисциплинах. Жизнь происходит динамически, а не стоит статически на месте.

    Фихте в своём определении философии назвал её «наукой наук». Её цель состояла в решении мировых проблем. В прошлом, когда все точные науки только появились, философы работали лишь с догадками без оглядки на реальные вещи. Если же рассмотреть философию как мать-науку, состоящую из множества дисциплин, мы увидим, что эти дисциплины так выросли в размерах и многообразии, что мать-наука выглядит как утка, которая не может уследить за своими утятами в пруду.

    Тем временем, прогресс жизни и науки идёт независимо от того, о чём крякает метафизика. Философия не достигает поставленной цели свести результаты экспериментальных и точных наук вместе для решения мировых проблем. Научные дисциплины бесконечно множатся за счёт появления новых специализаций, и от недостатка их координации, возникают серьёзные мировые проблемы. Философы терпят неудачу в попытке выполнить задачу научной координации, от чего мир общего мышления приходит в хаос. Мир живёт без коллективных или организованных высоких идеалов и даже без чётко обозначенных общих целей. Жизнь становится игрой в случайности, личные или коллективные амбиции и алчность.[⁷](https://teletype.in/@czoc/SrAmb2OpdfB#O7Bh)

    Систематическое исследование химических и физических явлений шло поколениями, и эти две науки теперь включают:

    1\. Знание об огромном числе фактов;  
    2\. Совокупность законов природы;  
    3\. Множество плодородных рабочих гипотез о причинах и закономерностях природных явлений; и, наконец,  
    4\. Множество полезных теорий, подлежащих корректировке с помощью дальнейшей практической проверки гипотез, на основе которых их построили.

    Когда мы говорим о чём-то как о науке, мы понимаем, что включаем все упомянутые выше составляющие. Одни только факты представляют науку не больше, чем куча камней представляет дом. Не представляют науку и факты вместе с законами. Прежде чем мы можем обозначить обсуждаемую тему наукой, нам требуются факты, гипотезы, теории и законы.

    Свою основную функцию наука выполняет тем, что позволяет нам прогнозировать будущее в её области исследований. По этому стандарту ни философия, ни близкие ей так называемые социальные науки не работали эффективно. Например, нас не предупредили о грядущей мировой войне – величайшей катастрофе. Будущее не спрогнозировали, потому что политические философы не имели необходимой базы знаний.

    Справедливости ради, стоит признать, что философию мало поддерживали финансово, потому что её широко признают необязательной. Технические научные дисциплины получали существенную поддержку от тех, кому приносили прямую прибыль, благодаря чему они могли развиваться успешнее.

    Мифы и буква закона лишают этику убедительности и тем самым контролирующего воздействия. Оставаясь в своём детстве и мысля как дикари, мы смотрим на мировую войну как на творение какого-то «военачальника», потому что те, в чьих интересах эта война произошла, так нам сказали. Мы пренебрегли своим здравым смыслом и не вникли в причины войны. Мы не сделали для себя то, что по своему долгу политическая философия не сделала для нас. Мы не мыслили фактами вместо метафизических догадок. Знание фактов указало бы нам на то, что военачальники действовали только как представители правящих классов. Если система социального и экономического порядка, построенная исключительно на эгоизме, алчности, «выживании самого приспособленного» и безжалостной конкуренции, не прекратит существовать, то она продолжит существовать посредством войны. Представители этой системы хотят продолжать существовать, и война становится этому последствием. Правящие классы привели всю систему, в которой жили, к её логическому итогу и естественной проблеме.

    ⬩‹⬩  
    Хватай, что можешь.  
    ⬩›⬩

    Под этим девизом живёт не какая-то одна страна, а вся наша цивилизация. Он выражает неизбежный результат того, как мы со своей глупой философией относимся к характерной природе человека и потенциалам человеческой жизни.

    Где нам искать истинные доктрины?  
    Где искать истинную философию?

    Взглянув на историю цивилизации, мы видим, что во всех «науках», кроме точных, личные мнения и теории формировали наши убеждения, влияли на наши умственные процессы и контролировали наши судьбы. Мы противопоставляем, например, пессимизм оптимизму, материализм духовности, реализм идеализму, капитализм социализму и так далее без конца. Каждая непримиримая система собирает множество последователей и каждая группа смотрит на остальных как на лишённых истины, здравого смысла и знаний. Все они играют словами «закон природы», невежественно предполагая, что их доктрина на нём стоит.

    Подобное происходит и в религиях. В мире живёт приблизительно

    291 миллион конфуцианцев или даосистов,  
    261 миллион католиков,  
    211 миллионов мусульман,  
    209 миллионов индуистов,  
    177 миллионов протестантов,  
    157 миллионов анимистов,  
    137 миллионов буддистов,  
    115 миллионов православных христиан,

    и здесь я привожу лишь самые популярные религии. Каждая группа считает свою теорию или веру непогрешимой, а все остальные ложными.

    Я не соглашусь с Бэконом во всём, но он умело описал идолов и средневековые фетиши, которым люди поклоняются по сей день.

    (·_Новый органон_·, Фрэнсис Бэкон)  
    ⬩«⬩  
    34 Четыре вида идолов одолевают человеческий разум, которым (для чёткого различия) мы дали имена, назвав первых идолами рода, вторых идолами пещеры, третьих идолами площади и четвёртых идолами театра.

    40 Отринуть этих идолов мы можем лишь формированием понятий и аксиом на основе истинной индукции. Нам, однако, обязательно следует на них указать, потому что доктрина идолов играет такую же роль в объяснении природных явлений, какую опровержение софизмов играет в логике.

    41 Идолы рода кроются в человеческой природе, в его роде или расе. Мы ошибочно утверждаем человека мерой вещей, тогда как все восприятия, как чувств, так и разума, мерят человека, а не вселенную. Человеческий разум подобно кривому зеркалу отражает – искажает и обезображивает – всякий объект по-своему.

    42 Идолы пещеры разнятся от одного индивидуума к другому. Каждый живёт (в придачу к расхожим ошибкам человеческой расы) в своей индивидуальной пещере, загораживающей и портящей свет природы. Это происходит от его единственной особенной позиции, от его образования и взаимодействия с другими, от того, что он прочёл, от авторитета тех, кого он почитает, кем восхищается, от различных впечатлений, произведённых на его погружённый в раздумья, уязвимый, или спокойный, или ещё какой-либо разум. Дух человека разнится, путается и поддаётся шансу. Гераклит верно подметил, что человек ищет знание в малых мирах, но не в великом общем мире.

    43 Существуют ещё идолы, сформированные взаимодействием, обменом и общением одного человека с другим; их мы называем идолами площади. Люди общаются с помощью языка, но слова складываются по воле большинства, и от неумелого и непригодного словосложения сдерживается разум. Никакие определения и объяснения, которыми учёные мужи обычно защищаются, не служат полноценным средством от проблем; слова принуждают к пониманию, приводят всё в беспорядок и ведут человечество к бесчисленным безрезультатным скандалам и заблуждениям.

    44 Наконец, существуют идолы, которые прокрались в человеческий разум посредством всяческих догм определённых философских систем и порочных правил доказательства; их мы называем идолами театра. На все философские системы до сегодняшнего дня, какие мы унаследовали или воображали, мы смотрим как на поставленные пьесы, в которых создаются вымышленные, театральные миры. К ним относятся не только нынешние системы, или древние философские секты, потому что множество подобной природы пьес удастся сочинить и привести к согласию друг с другом, притом ошибки противоположного характера продолжат совершаться по одним причинам. Сюда также относятся не только общие системы, но и многие элементы и аксиомы наук, которые укоренились в традиции, вере и пренебрежении.  
    ⬩»⬩[⁸](https://teletype.in/@czoc/SrAmb2OpdfB#wAQX)

    Метафизические догадки и порождённые ими многочисленные слепые и эгоистичные политические философии, личные мнения, личные «истины», личные доктрины, сектантские мнения, сектантские «истины» и сектантские доктрины, полные жалоб, путанные и слепые характеризуют ·_детство_· человечности. Период ·_зрелости_· человечности, я не сомневаюсь, станет научным периодом – периодом, в который мы увидим как научный метод охватит все интересы человечества; периодом, в который человек откроет природу человека и построит науку и искусство направления человеческих энергий и мощей на развитие человеческого блага согласно законам человеческой природы.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#6iSg)Первая строчка стихотворения Джона Маккрея ([⬀](https://ru.wikipedia.org/wiki/%D0%9D%D0%B0_%D0%BF%D0%BE%D0%BB%D1%8F%D1%85_%D0%A4%D0%BB%D0%B0%D0%BD%D0%B4%D1%80%D0%B8%D0%B8)).

    2\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#9XP4)·_An Outline of the History of the Western European Mind_·, James Harvey Robinson. The New School for Social Research, New York, 1919. В этом небольшом томе автор сжато излагает историческое развитие человеческого разума и приводит список самых содержательных современных книг по историческим вопросам. Все последующие цитаты в связи с историей я приведу из этой небольшой, но исключительно ценной книги; для удобства я отмечу их инициалами – Дж. Х. Р.

    3\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#Chad)(Дж. Х. Р.)

    ⬩«⬩  
    Позднее появление чёткой теории прогресса. Излишняя традиционность примитивных народов. Греки строили догадки о возможности бесконечного прогресса … Прогресс человека с самых ранних времён до начала ⅩⅦ века практически полностью шёл неосознанно….

    Фундаментальная слабость эллинистического учения. Оно состояло из внушительного набора домыслов, мнений и догадок, которые при своей искусности и оригинальности, основывались на очень слабом своде точных знаний, и в нём не учитывалась базовая необходимость тщательных научных исследований с применением инструментов. Знания не накапливали устойчиво, чтобы сгладить нарастающее эмоциональное недоверие разума….

    Невыполненное обещание эллинистического учения. Влияние рабства в контроле развития науки…. Недостатки средневековой культуры. Все слабости эллинистических рассуждений в сочетании со слабостями отцов христианства легли в основу того, что казалось самой логически проработанной системой мышления.

    Дефекты университетского образования…. Слишком мало истории естественных наук, в нашем смысле слова, преподаётся в университетах….

    Коперник, „О вращении небесных сфер“. Книга Ⅵ, 1543…. Коперник включил в своё введение признание долга перед древними философами, но по-прежнему верил в звёздную сферу. Его открытие произвело слабый эффект на преобладающие идеи.

    Джордано Бруно (1548–1600) поставил себе задачу осмыслить и представить на латинском и итальянском языках то, что означало открытие Коперника…. Инквизиция сожгла Бруно в Риме….

    Кеплер (1571–1630) и его открытие эллиптических орбит планет. Галилей (1564–1642). Он быстро доработал свой телескоп до увеличения в 32 раза. Его отношение к теории Коперника, которую римская инквизиция осудила в 1616 году…. Свои главные открытия Галилей сделал в физике и механике. Исаак Ньютон (1642–1727) утвердил применимость законов падающих тел к небесам, чем произвёл глубокое впечатление и, наконец, началась популяризация новых концепций вселенной….

    Фрэнсис Бэкон (1561–1626), популяризатор современных экспериментальных и прикладных наук…. С энтузиазмом относился к препятствиям на пути научного прогресса; идолы рода, пещеры, площади и театра….

    Потребность в уходе от схоластических методов „одобрения и не-одобрения наших причин и мнений“ и в изучении мира вокруг нас. Невообразимые достижения, если следовать правильному методу исследования … недоверие к древним авторитетам….

    Декарт (1596–1650),… он предложил искать истину с помощью анализа и ясных идей, положившись на предположение, что Бог не обманет…. Его глубокий интерес к математике…. Его заявления об оригинальности и отвержение авторитетов….

    Препятствия научному прогрессу; прежнее преобладание Аристотеля в университетах; теологические факультеты; цензура прессы церковью и государством; ….  
    ⬩»⬩

    4\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#aJXh)(Дж. Х. Р.)

    ⬩«⬩  
    Фазы религиозного комплекса. „Религиозный“, неоднозначный и широкий термин, который применяют к:

    1 Определённым классам эмоций (благоговения, зависимости, недоверия к себе, амбиций и т. д.);

    2 Поведению, которое может принимать форму характерно религиозных поступков (церемоний, жертвоприношений, молитв, „добрых дел“) или соблюдению того, что в примитивных условиях считается „табу“;

    3 Священническим или церковническим организациям;

    4 Вере в сверхъестественных существ и отношению человека к ним; второе может принять форму откровения, перерасти в вероучение и стать предметом подробных теологических обоснований, построенных на догадках.

    Ассоциация религии со сверхъестественным; своей главной целью религия всегда ставила приемлемую приспособленность к, или успешный контроль над сверхъестественным….

    Культурный разум как результат длительного, опасного процесса накопления….

    Спонтанное формирование предрассудков. Преобладание символизма, маны, анимизма, магии, фетишизма, тотемизма; табу (ср. с нашей современной идеей „принципа“), священное чистое и нечистое; „мечтательная логика“ – спонтанные рационализации или „скачки к выводам“, … Книга 16 Кодекса Феодосия содержит эдикты, указывающие на Церковь, учреждённую римскими императорами в ходе Ⅳ и Ⅴ веков. Несогласие с Церковью объявляется в них преступлением; в них предусматриваются суровые наказания за еретические учения и писания, и привилегии правоверного духовенства (освобождение от уплаты налогов и другие выгоды)….

    Христианство становится монополией под защитой государства….

    Психологическое влияние и привлечение с помощью изощрённого символизма и ритуалов церкви….

    Аллегория ставит крест на всей литературной критике….

    Процветание чудесного; любое необычное или пугающее событие приписывается вмешательству либо Бога, либо Дьявола…. Старые понятия о болезнях, якобы вызванных Дьяволом…. Юридическое выражение ⁅дословно⁆ „Божий промысел“, указывающее не непредвиденные стихийные бедствия.

    С растущим признанием закона природы и охладеванием к волшебству, чудеса стали превращаться в источник интеллектуальных затруднений и недоумений…. Протестанты и католики разделили ужас „рационалистов“ и „свободомыслящих“. Лидеры обеих сторон сошлись в желаниях мешать и осуждать научные открытия….

    Чародейство в своей современной форме определённо возникло в ⅩⅤ веке…. Чародейство преобладало в ходе ⅩⅥ и ⅩⅦ веков как в протестантских, так и католических странах…. Подозреваемых в колдовских практиках подвергали суду, пыткам в целях выбить признание. Ведьмовские метки. Наказания, сожжения живьём на кострах, удушения, повешения. Смерти десятков тысяч невинных людей…. Тех, кто пытался дискредитировать чародейство объявляли „саддукеями“ и атеистами…. Психология нетерпимости.

    Страх, интересы организованных групп, удобство традиционного и привычного. Трудности в принятии новых идей…. Нетерпимость Католической Церкви – естественный результат её государство-подобной организации и заявлений…. Её доктрина исключительного спасения и концепция ереси, санкционированные государством. Сомнения и ошибки объявляются греховными….

    Начало цензуры прессы после введения лицензирования печати церковных и гражданских властей…. Протестанты ⅩⅥ века принимают теорию нетерпимости.  
    ⬩»⬩

    5\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#YXKn)(Дж. Х. Р.)

    ⬩«⬩  
    Социопсихологические основания консервативности: примитивное естественное уважение знакомого и привычного, подкрепляемое религией и законом. Естественная консервативность во всех сферах деятельности. Те, кто больше остальных страдают от действующих институтов, обычно беспомощно принимают ситуацию как неизбежную. Позиция консерватора: настойчивость на невозможности изменить „человеческую природу“ и предостережения о катастрофах революции.

    Консервативность в исторической перспективе: история, по-видимому, показывает полную несостоятельность консервативности как рабочего принципа с точки зрения недавних достижений человечества и возможностей, которые перед нами открылись….

    Тщетность попыток назвать природу человека препятствием на пути прогресса….

    Мы не передаём культуру по наследству, а накапливаем её с помощью образования и преобразуем её до бесконечности.  
    ⬩»⬩

    6\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#AeJ3)(Дж. Х. Р.)

    ⬩«⬩  
    Формулировка и выдвижение эволюционной гипотезы. Открытие возраста Земли; … постепенная разработка эволюционной теории…. „Происхождение видов“ Дарвина, 1859 г. Герберт Спенсер (1820–1903)…. Геккель (1834–1919) и другие проясняют, защищают и популяризуют новую доктрину. Последующая разработка эволюционной доктрины Менделем, Де Фризом и другими. Ослабевание теории особого создания за счёт археологических свидетельств и критики библии. Значимость доктрины для интеллектуальной истории. Характер оппозиции эволюционной теории. Расхожее спутывание „Дарвинизма“ с „эволюцией“. Революционные эффекты новой точки зрения. Остаётся концепция не-развивающихся видов (платонические идеи), прежде преобладавшая в догадках. Генетический метод, принятый всеми органическими науками, включая новые социальные науки. Проблема адаптации истории к открытиям последних пятидесяти лет. Влияние эволюции на теорию прогресса. Органическая эволюция и социальная эволюция.  
    ⬩»⬩

    7\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#zjhA)(Дж. Х. Р.)

    ⬩«⬩  
    Деисты и философы уничтожают старую теологическую антропологию и утверждают достоинство человека. Рост критики и либерализма умеряет опасность анализа социальных институтов. Общее развитие знания стимулирует науки общества. Значительный рост числа, сложности и остроты социальных проблем становится мощным стимулом для социальных наук. Дарвинистские гипотезы привели к непринятию концепций полностью статических социальных систем. Однако современные социальные науки в нашем капиталистическом режиме встречают сопротивление „корыстных интересов“, во многом подобное тому, с которым столкнулся теологический радикализм в средневековье, от чего социальная наука никак не приблизилась к объективности и прогрессивности сегодняшних естественных наук ….

    Губительные последствия действий привилегированных групп – торможение экспериментов и корректировок….

    Священные традиции препятствуют корректировкам….

    Влияние современного коммерциализма в беспорядочном развитии организации и регламентации нашей нынешней образовательной системы. Психологические недостатки традиционной системы проверки знаний. До сих пор мы не привели наше образование в близкие отношения с преобладающими условиями постоянно растущего знания….

    Отличные цели и несущественные практические результаты социологии. (·_Из-за полного отсутствия научных оснований._· Автор.) Общая природа проблемы социальных реформ: психологические проблемы в движениях за социальные реформы; насильственное сопротивление критике существующих институтов, неизбежно предшествующей любой эффективной социальной реформе….  
    ⬩»⬩

    8\. [⇧](https://teletype.in/@czoc/SrAmb2OpdfB#G3HE)(Дж. Х. Р.)

    ⬩«⬩  
    За последние два века применение научных открытий к повседневной жизни произвело революцию в методах обеспечения экономических потребностей, социальной и интеллектуальной жизни, и многих других отношений человечества. Изобретения, железо, уголь и пар значительно ускорили развитие машиностроения в широких масштабах, что привело к современным заводам, организации труда, современному городу и, наконец, к почти совершенным средствам человеческой коммуникации. Значительный рост производства блага привёл к широкому обсуждению совершенствования человечества, прекращения или снижения уровня бедности, невежества, болезней и войн….

    Человек перешёл от применения инструментов к управлению машиной. Становление фабричной системы; концентрация и локализация промышленности; разделение труда и специализация промышленных процессов. Рост капитала и капиталовложений; разделение капитала и труда, развитие обезличенных экономических отношений. Проблемы капитала и труда; безработица, женский и детский труд; профсоюзы. Рост производительности и коммерческое расширение. Промышленные процессы становятся динамичными и переменчивыми – полное обращение старой стабильности, повторений и изоляции.  
    ⬩»⬩
    
        * * *
        
""".trimIndent()