package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_10(modifier: Modifier) {
    MarkdownText(
        markdown = chapter_10_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val chapter_10_text = """
    # Глава Ⅹ
    · Зрелость человечност _·, 2-е издание, А. Коржибски

    * * *

    ⬩«⬩  
    В Европе мы знаем, что умирает эпоха. Сейчас признаки грядущих перемен ускользают от внимания, но я едва ли сомневаюсь, что они настанут. Умы миллионов охватило осознание ·_бесцельности_· жизни, прожитой, чтобы трудиться до самой смерти, не достигнув ничего, кроме заработка на кусок хлеба, и чтобы родить детей, тоже обречённых двигать изнуряющий топчак.  
    ⬩«⬩

    ·_Сэр Окланд Геддес, Британский посол в США 1920_·

    В заключение, позвольте мне сказать кратко, как я сказал в начале, что целью этой скромной книги я поставил предоставить набросок. Проблема жизни существует давно. Я попытался подойти к ней по-новому, с новым методом, новым духом, взглянуть на неё с новой точки зрения. По данной теме найдётся много литературы. Она показывает отличные знания и навыки. Многое из неё подходит для того чтобы проинформировать и вдохновить тех, кто действительно читает – с искренним желанием понять.

    В ней недостаёт фундаментальной, центральной мысли, – истинной концепции того, что человеческие существа собой представляют – и я постарался её предоставить. Если мне это удалось, то мне нечего тревожиться – остальное последует скоро, неизбежно, естественно. Фундаментальная концепция, стоит её сформировать и выразить, приобретает странную силу – силу побуждения мысли и сотрудничества множества умов; и никакая концепция не может иметь большей силы, чем ·_истинная_· концепция природы человека. Для этой важнейшей из истин настали подходящие времена.

    В мире царят печаль, мрак, дурные предчувствия и страх. Без истины в этом деле, мы не можем позволить себе рациональной надежды – история пойдёт по своему ужасающему пути. Однако ·_при_· истине, мы можем позволить себе не только надежду, но и уверенность в том, что старый порядок прошёл, и что человеческая зрелость начинается сегодня. В том, что я представил истину для этого дела – истинную концепцию человеческого класса жизни – я лично не испытываю сомнений, как не испытываю сомнений в том, что эта концепция должна стать основой, ориентиром, источником света новой цивилизации. Ошибаюсь я или нет, покажет время. Мне кажется, я испытываю что-то, подобное тому, что испытывал Бокль, когда писал свою ·_Историю цивилизации_·:

    ⬩«⬩  
    Удалось мне осуществить что-то ценное, или нет … решать компетентным судьям. Уверенно я могу, по меньшей мере, сказать, что любые выявленные несовершенства я допустил не из-за предложенного метода, а из-за крайних трудностей, для любого одного человека, попыток организовать все части такой большой системы. Только относительно этого и ничего иного я прошу отнестись ко мне снисходительно.

    Что же касается самого плана, я не испытываю опасений. Я осознаю потенциальные проблемы его выполнения. В оправдание я могу лишь вновь привести масштабность темы, короткий век одной жизни и несовершенства любой единичной попытки. В связи с этим я желаю, чтобы эту работу оценивали не по завершённости её отдельных частей, а по способу, которым я эти части организовал в завершённое и симметрическое целое. Этого, учитывая новизну и величину попытки, я имею право ожидать, и хочу добавить, что, если читатель встречал мнения, противоположные своему, ему стоит помнить, что его взглядов когда-то придерживался я, но оставил их, потому что после более широких исследований, не обнаружил твёрдых свидетельств в их пользу, пагубных для человека и фатальных для развития его знания.

    Рассмотрение понятий, которым нас научили и отречение от тех, что не выдерживают проверки, оказывается настолько болезненным, что тем, кто избегает этих страданий, стоит задуматься, прежде чем упрекать тех, кто уже страдает….

    Выводы, к которым удалось прийти таким способом, не опровергаются заявлениями о том, что они угрожают каким-то другим выводам, и не поддаются обвинениям в их предполагаемых тенденциях. Принципы, которые я защищаю, основываются на чётких доводах, подкреплённых твёрдо установленными фактами. Следовательно, остаётся выяснить лишь правомерность доводов и достоверность фактов. Если соблюсти эти два условия, то принципы следуют неизбежными заключениями.  
    ⬩«⬩

    Почему на протяжении этой книги я старался следовать духу математики?

    Потому я работал с идеями и хотел, прежде всего, подать их правильно и ясно. Идеи обладают своим характером – они оказываются правильными или неправильными, независимо от наших надежд, пристрастий и воли. Идеи связываются неразрывной нитью судьбы. В связи с этим профессор Кайзер верно отметил в своей ·_Математической философии_· (с. 136):

    ⬩«⬩  
    В математике мы изучаем судьбу. Судьбу не в физическом смысле, а в смысле нити, связующей одну мысль с другой и выводы с их положениями.

    Где же тогда искать свободу?  
    Что вы любите?  
    Рисовать?  
    Писать стихи?  
    Музыку?

    Музами им становятся судьбы. Кто бы ни любил их, свободен. Логика служит музой мысли.  
    ⬩»⬩

    Несомненно, математику как метод мы применяем беспристрастно; возможно, слишком беспристрастно, чтобы угодить сентиментальному человеку, прежде чем он возьмётся подумать. Математическим анализом жизненных явлений мы поднимаем свою точку зрения выше пристрастий, выше всякого эгоизма, и, следовательно, только этим методом мы можем вывести настоящие истины о самих себе. Спиноза даже ⅩⅦ веке хорошо осознавал этот факт, и, несмотря на несовершенства в его попытках, он предпринял их в правильном направлении. Его заключение ниже может послужить заключением и нам в ⅩⅩ веке:

    ⬩«⬩  
    Истина могла навечно остаться скрытой от человеческой расы, если бы математика, с помощью которой мы смотрим не на конечную причину чисел, а на их сущность и её качества, не представила нам новый тип знания….

    Когда я взялся обдумывать эту тему, я не ставил себе какую-либо новую или необычную цель, кроме как продемонстрировать определённым и явным объяснением то, что ближайшим образом согласуется с практикой. И, с тем чтобы исследовать вопросы науки с той же свободой разума, с какой мы привычно обращаемся с линиями и поверхностями в математике, я дал себе установку не смеяться и не плакать по поводу людских поступков, а лишь понимать их, рассматривать их чувствия и пристрастия, такие как любовь, ненависть, злость, зависть, высокомерие, сожаление и другие сотрясания души не как пороки человеческой природы, а как присущие им качества, подобно тому, как тепло, холод, грозы проявляются присуще природе атмосферы. Ведь они, невзирая на их проблематичность, происходят неизбежно и имеют определённые причины, за счёт которых мы можем научиться их понимать, и таким образом, – созерцая их в собственной истине – радовать свой разум знанием о вещах, приятных чувствам.  
    ⬩»⬩

    Если эта скромная книга ·_инициирует_· научные исследования человека, я стану счастливым, потому что только в этом случае мы можем уверенно ожидать науку и искусство, в которых мы знаем, как направлять энергии человека к развитию человеческого благополучия.

    Что ещё?

    Многие темы мы вовсе не подняли.

    Время-связующая энергия – чего ей не удастся достичь в грядущие эпохи?  
    На какие фундаментальные явления, такие как ·_Пространство_·, ·_Время_·, ·_Бесконечность_· и так далее ей не получится пролить свет?  
    Каковы пределы Время-связывания, если они существуют?

    В нём каким-то образом фигурируют все высшие функции разума.

    Представляет ли собой Время нечто тождественное Разуму?  
    Служит ли одно другому причиной?  
    Пребывает ли Время в Космосе, или наоборот?  
    Проявляет ли Космос разумность?

    Многие из этих областей откроет для исследований научное изучение человека.

    * * *

""".trimIndent()