package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.Divider
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun chapter_1(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp).padding(top = 0.dp)
    ) {
        item {
            MarkdownText(
                markdown = chapter_1_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.progressions),
                contentDescription = "арифметическая и геометрическая прогрессии",
                contentScale = ContentScale.Fit,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_1_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.progressions),
                contentDescription = "арифметическая и геометрическая прогрессии",
                contentScale = ContentScale.Fit,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_1_text_3,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier
            )
        }
        item {
            Spacer(modifier = Modifier.height(20.dp))
            Image(
                painter = painterResource(R.drawable.evolutions),
                contentDescription = "Эволюция. Мирный прогресс и не-мирный прогресс",
                contentScale = ContentScale.Fit,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = chapter_1_text_4,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier
            )
        }
    }
}

val chapter_1_text_1 = """
    # Глава Ⅰ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *
   

    ⬩**МЕТОД И ПРОЦЕССЫ ПОДХОДА К НОВОЙ КОНЦЕПЦИИ ЖИЗНИ**⬩

    ⬩«⬩  
    Какое-то время он безнаказанно топтал законы человеческие и божьи, но от одержимости бредовой идеей, что два и два равняется пять, он, наконец, пал жертвой непреложных правил простейшей арифметики.

    Запомни, незнакомец, арифметика первична из всех наук и мать надёжности.  
    ⬩»⬩  
    — Брандис

    Этой небольшой книгой я хочу показать путь к новой науке и искусству – науке и искусству Человеческой инженерии. Под «Человеческой инженерией» я имею в виду науку и искусство направления энергий и способностей людей на развитие человеческого блага. В наше время не приходится спорить о том, что построение такой науки – науки человеческого блага – представляется задачей неизмеримой важности. Любой увидит её первостепенность.

    Начинать построение такой науки следует с установленных фактов, согласовывать её с уникальными характеристиками Человека, основывать на проверенной концепции того, что Человек собой представляет – на правильном понимании места Человека в системе природы.

    Никому не приходится рассказывать о незаменимости истинных идей, проверенных концепций, правильных понятий о вещах, с которыми нам, людям, приходится иметь дело. Каждый знает, например, что, путая площадь с пространством, мы не сможем применять науку и искусство геометрии; путая дроби с целыми числами, мы не сможем применять науку и искусство арифметики; принимая мираж в пустыне за озеро, обессиливший путешественник ведёт себя к ужасному разочарованию или смерти; принимая злодеяние за добродетель, мы игнорируем основания этики.

    Важнейшим из всего, с чем нам, людям, приходится иметь дело, мы видим самого Человека – человечество: мужчин, женщин и детей. Отсюда следует, что для нас, людей, ничто не может играть роли важнее, чем ясная, истинная, проверенная концепция Человека – правильное понимание того, что мы как люди есть. Мы не нуждаемся в великой мудрости, – хватает лишь некоторых раздумий – чтобы увидеть, что, если мы составляем радикально неверное представление о природе человека и видим человека тем, что он не есть, – что-то выше или ниже человека – мы тем самым допускаем ошибку, основательную и масштабную настолько, что вызываем всевозможные смятения и катастрофы в жизни индивидуума, в жизни сообщества и в жизни расы.

    Следовательно, нам прежде всего придётся основательно рассмотреть вопрос:

    Что есть Человек?  
    Что есть человек?  
    Что есть человеческое существо?  
    В чём заключается определяющая характеристика человечности?

    На этот вопрос на протяжении веков давали, и продолжают давать сегодня, два, и только два, ответа.

    Отвечая на этот вопрос с биологической точки зрения, мы называем человека животным в принципе или животным какой-то разновидности. Вторым ответом мы представляем человека смесью из чего-то биологического и мифологического, или биологического и философского – сочетанием или ·_единением_· чего-то животного и сверхъестественного. Важная часть моей задачи состоит в том, чтобы показать, что мы радикально ошибаемся в этих ответах, и что в связи с этими ответами в жизни и истории человечества происходят ужасные, печальные события.

    Вопрос остаётся:

    Что есть Человек?

    Я рассчитываю чётко и убедительно показать, что ответ мы найдём в очевидном факте, что люди в разной степени обладают определённым даром или способностью, которая даёт им должное человеческое достоинство и отличает их не только от минералов и растений, но и от животных. Эту особенную или характерную человеческую способность я называю ·_время-связующей_· способностью или ·_время-связующей_· мощью. Я объясню, что имею в виду под «время-связыванием», в дальнейшем обсуждении, и, прояснив это, я надеюсь ответить на вопрос, сказав, что Человек представляет собой существо, от природы наделённое время-связующей способностью, что человек есть время-связующий, и что мужчины, женщины и дети составляют время-связующий класс жизни.

    Тогда останется тяжёлая задача указать и в определённой мере обрисовать некоторые важные способы, которыми адекватная концепция человека как человека могла бы преобразовать наши взгляды на человеческое общество и мир, повлиять на наше поведение и дать нам растущую базу научных знаний о благе человечества, включая все будущие поколения.

    В этой вводной главе я рассмотрю некоторые общие вопросы, чтобы задать дух этого начинания, кратко изложить порядок подхода и подготовиться к действиям.

    Рассмотрим два часто избираемых способа легко идти по жизни:

    *   верить всему или
    *   сомневаться во всём.

    Ни тот, ни другой способ не обременяют нас мышлением. Большинство выбирает путь наименьшего сопротивления, предпочитая, чтобы кто-то мыслил за них. Они принимают уже существующие индивидуальные, личные доктрины как свои собственные и следуют им более-менее слепо. Каждое поколение видит свои вероучения истинными и неизменными, и с высокомерной жалостливостью смеётся над предрассудками прошлого. За двести или более поколений нашей истории мы повторили это отношение двести или более раз, и если мы не проявим должную осторожность, наши дети с высокой вероятностью отнесутся так же к нам.

    Я не вижу повода для сомнений, что человечество относится к классу жизни, способному в значительной мере определять собственные судьбы, устанавливать свои правила образования и поведения, чем влияет на каждый свободный шаг в структуре своей социальной системы. Однако на способность людей определять собственные судьбы накладывает ограничения естественный закон – закон Природы. Выявляя законы природы, включая законы человеческой природы, чтобы жить по ним, мы обретаем мудрость. Поступать наоборот – неразумно.

    Фермеру следует знать естественные законы, властвующие над его пшеницей, кукурузой, коровами, и, если он не знает, то не соберёт достаточно урожая и не надоит молока в желаемом качестве и количестве. Знание этих законов позволяет ему создать наиболее подходящие условия для своих растений и животных, за счёт чего получить желаемые результаты.

    Человечеству следует знать естественные законы для людей, иначе люди не создадут условия и уклады для регуляции человеческой деятельности, которая обеспечила бы наиболее предпочтительные обстоятельства для полноценного развития. В таком развитии предполагается высвобождение максимума естественной творческой энергии и умственное, моральное, материальное, духовное и другие человеческие выражения, ведущие к счастью в жизни и в работе, коллективно и индивидуально, потому что условия обеспечения жизни влияют и задают все наши умственные процессы, качества и формы человеческих взаимоотношений.

    Любое человеческое достижение, – научное открытие, полотно, скульптура, храм, жилой дом или мост – прежде чем его удастся воплотить, требуется замыслить или спланировать. Любое предприятие с участием любого количества индивидуумов требует рассмотрения методов координации – методов, которые по результатам практической проверки оказались бы наиболее подходящими такому предприятию – инженерных методов, позволяющих разрабатывать и проектировать ·_идею_· до её полного ·_осуществления_·.

    Каждому инженеру требуется знать материалы, с которыми он работает, и естественные законы этих материалов, выявленные наблюдениями, экспериментами, и сформулированные с помощью математики и механики. В противном случае он не может рассчитать силы в его распоряжении, прочность материалов, определить мощность и требования электростанции. Кратко, он не может воспользоваться своими ресурсами наиболее полезным образом.

    Недавно во всех отраслях промышленности, особенно в поздний период мировой войны, которая сама стала гигантским промышленным процессом, образовался новый чрезвычайно важный фактор – человеческий фактор, который относится не к материальным, а к умственным, моральным, психологическим. Выявилось, что максимальной выработки получается достичь, только когда производство осуществляется согласно определённым психологическим законам, приблизительно определённым с помощью анализа человеческой природы.

    Не считая плодотворного человеческого труда, Земли не хватит, чтобы поддерживать население. Человечеству следует производить или исчезнуть.

    Производство в сущности составляет задачу инженеров. Её решение зависит от выявления и применения естественных законов, включая законы человеческой природы. Следовательно, эта задача решается не старомодными философскими догадками и не пустыми метафизическими рассуждениями ·_в вакууме_·. Над ней следует работать научно, что требует координации и сотрудничества всех наук. Именно поэтому я считаю это инженерной задачей.

    Инженерия, при должном её понимании, составляет координированную совокупность человеческого знания, собранного за века при помощи математики как основного инструмента и ориентира. Человеческая инженерия воплотит теорию и практику – науку и искусство – всех инженерных дисциплин, объединённых общей целью: понимание и благо человечества.

    Я хочу сразу чётко прояснить, что математика представляет собой совсем не то, что многие думают. Она не сводится просто к формулам и теоремам. По красивому определению профессора Кассия Дж. Кайзера в книге ·_The Human Worth of Rigorous Thinking_· ⁅·_Человеческое достоинство строгого мышления_·⁆[¹] математика представляет собой науку

    ⬩«⬩  
    точной мысли или строгого мышления  
    ⬩»⬩

    и уникально характеризуется

    ⬩«⬩  
    точностью, чёткостью, полнотой определений.  
    ⬩»⬩

    Одних только этих качеств хватает, чтобы объяснить, почему людям в целом не нравится математика, и почему даже некоторые учёные впрямую отказываются иметь дело с проблемами, для решения которых требуется математика.

    Тем временем, математическая философия мало как, если вообще, относится к простым вычислениям, к числам как таковым или к формулам. Эта философия не обходится без точного, чёткого и строгого мышления. Те, кто намеренно отказываются мыслить «строго», – а именно математически – когда такое мышление удаётся применить, совершают грех предпочтения худшего лучшему; они умышленно нарушают закон интеллектуальной честности.

    Я также проясню, что, учитывая цели Человеческой инженерии, старых концепций материи, пространства и времени для начала хватает; их хватает так же как их хватало в старой науке механике. Образно выражаясь, Человеческая инженерия представляет собой более высокий порядок мостостроения ⁅инженерии мостов⁆. Её цель состоит в том чтобы соединять пропасти в практической жизни и в знании. Старых значений материи, пространства и времени хватало, чтобы предотвратить обрушение моста, и такое же понимание пространства и времени, какое я учитываю в этой книге, поможет защитить общество и человечество от периодических развалов. Старая механика напрямую ведёт к такому знанию естественных законов вселенной, которое даёт основания для новой механики. Человеческой инженерией удастся пролить новый свет на многие старые концепции и поспособствовать изучению и пониманию материи, пространства и времени в их относительных значениях, и, возможно, в конечном счёте прийти к пониманию их абсолютных значений.

    Философия своей старой формой могла существовать только в отсутствие инженерии, но теперь, когда инженерия существует, набирает темпы и расширяется с каждым днём, старая словесная философия и метафизика утратили основания своего существования. Они не давали лучшей возможности понять «производство» вселенной и жизни, чем позволяют сейчас понять или попытаться освоить «производство» как средство обеспечения счастья в существовании человечества. Мы терпели с ними неудачи, потому что их уважаемым методом «догадок» не получается ·_производить_·, и поэтому этот метод следует сменить математическим мышлением. Математическим мышлением мы отправляем метафизическое мышление в отставку. Инженерия прекращает существование словесной философии, и благодаря этому человечество получает пользу. Лишь нескольких паразитов и «мыслителей» расстроит уход их старых товарищей «догадок». Мир производителей – преобладающее большинство людей – поприветствует философию упорядоченного мышления и производства.

    Все учёные, несомненно, занимаются своим делом, но они не применяют своё образование в полной мере, если не стараются расширить своё чувство ответственности в отношении всего человечества, вместо того чтобы замыкаться в узкой специализации, которую предпочли. Ни инженеры, ни люди от науки не имеют права предпочитать собственный комфорт счастью человечества. Им следует занять своё место на передовой человеческой борьбы, а не в рядах тех, кто равнодушно отчуждает себя от жизни. Если они проявляют равнодушие или испытывают недостаток мотивации, потому что считают ситуацию безнадёжной, то это служит свидетельством не меньшей опасности «религиозного» пессимизма в сравнении с любым другим вероучением. Средневековый фанатизм священной инквизиции мало чем отличается от современной непереносимости новых идей.

    Всем видам интеллекта следует собираться, потому что, пока мы априори считаем ситуацию безнадёжной, она останется безнадёжной. Дух Человеческой инженерии не знает слова «безнадёжность». Инженеры знают, что к катастрофическим результатам приводят только неправильные методы, и что с каждой ситуацией получится успешно справиться подходящими средствами.

    Задача инженерии ⁅прикладной науки⁆ состоит не только в том чтобы знать, но и в том чтобы знать, как. Большинство учёных и инженеров пока не осознают, что сообща они могут выводит несокрушимые суждения, которые никакая система или класс не смог бы проигнорировать. Своими знаниями они поддерживают жизнь человечества. Если учёные и инженеры до сих пор не нашли основание для объединения, то его следует обеспечить. Давящие обстоятельства сегодняшнего дня складываются так, что мы не можем идти вперёд без их координирующего направления. Однако начинать следует с желания действовать. Одной из целей этой книги я ставлю задать необходимый стимул, показав, что с помощью Человеческой инженерии нам удастся выпутаться из хитросплетений личных мнений и начать работать со всеми проблемами жизни и человеческого общества на научной основе.

    Если те, кто знают, почему и как, бездействуют, то действовать будут те, кто не знают, и мир продолжит топтаться на месте. Вся история человечества и особенно сегодняшняя неутешительная ситуация в мире показывают чрезвычайно печальную картину опасности и расточительности, когда миром правят те, кто не знают.

    Дорого заплатив за эту войну, нам пришлось осознать, что даже отдельные индивидуумы не могут позволить себе жить в комфорте своей личной жизни, не принимая при этом участия в обществе. Им придётся научиться принимать свою долю ответственности перед обществом. Это означает, что следует проделать очень много очень простой работы, которая, в свою очередь, указывает на ещё больше работы в образовании, – не только инженеров и людей от науки, но и широкой общественности – способствующем сотрудничеству во внедрении практики Человеческой инженерии во всех делах человеческого общества и жизни.

    В ходе написания этой книги мне пришлось бороться с серьёзными трудностями, чтобы выразить новые мысли и показать новые методы. Читатель, желающий посудить, нравятся или не нравятся ему слова и выражения, упустит весь смысл работы. Я рекомендую читать её, обращая внимание на то, что нового удастся в ней найти, и что затем получится доработать, чтобы оформить лучше. Это предприятие представляется слишком трудным и слишком обширным для труда одного человека без посторонней помощи. Жизни не хватает.

    Метод, которым я пользуюсь в этой книге, чтобы анализировать явления жизни, представляет собой в сущности инженерный метод, и как исследования в физике и механике указывают математикам на новые области для анализа, я не исключаю, что Человеческой инженерией тоже получится указать математикам на новые и интересные области для исследований. Самую скромную роль математиков в Человеческой инженерии я могу назвать ролью «общественных бухгалтеров», которые приводят ·_в порядок_· хозяйственные дела.

    В отношении математики Бертран Рассел сказал:

    ⬩«⬩  
    Логика – это математика в молодости, а математика – это логика в зрелости.  
    ⬩»⬩

    Я считаю это блестящее выражение выдающегося математического философа несомненно правильным и глубоко значимым. Оно может научить нас, по меньшей мере, что поиски черты, отделяющей логику от математики, не принесут пользы, потому что такой черты не существует. Попытки искать таковую указывают на незнание о математической философии. В другом месте мистер Рассел говорит:

    ⬩«⬩  
    Надежде исполниться нашим более человеческим желаниям, надежде продемонстрировать, что мир обладает той или иной этической характеристикой, насколько я могу судить, философия никак сбыться не поможет.  
    ⬩»⬩

    Под «философией» он имеет в виду математическую философию – основанную на строгой науке, а не на туманных догадках. Я ни коим образом не могу с ним согласиться, что такой философией не получится внести вклад в этику. Напротив, я считаю и надеюсь этой книгой показать, что математической философией, строго научным мышлением мы можем прийти к истинной концепции того, что человек на деле есть, и, выявив таким образом характерную природу человека, раскрыть тайну и отыскать источник этики. С помощью этики как науки мы сможем исследовать и объяснить природу человека и обязательства, которые природа человека на него налагает. Мы увидим, что жить праведно, жить этично означает жить по законам человеческой природы. Когда станет ясно, что человек представляет собой естественное ⁅природное⁆ существо, – буквально, часть природы – мы увидим, что законы человеческой природы – единственные возможные правила этического поведения – работают не более ·_сверх_·ъестественно и создаются ·_человеком_· не в большей мере, чем, например, закон тяготения или какой-либо другой естественный закон.

    Я не вижу причин удивляться, что математическое мышление приведёт к такому результату, потому что Человек есть ·_естественное_· ⁅·_природное_·⁆ существо, человеческий разум есть ·_естественный действующий фактор_·, а результаты строгого мышления есть отнюдь не искусственные выдумки, а естественные факты – природные изъявления природного закона.

    Я надеюсь, что своими многократными упоминаниями математических наук не произвёл впечатления об этой книге как о в каком-либо техническом смысле математическом трактате. Я лишь посчитал нужным указать, что поставил и приступил к разбору задачи в математическом духе, – путеводном духе Человеческой инженерии – потому что никакой мысли в не-математическом духе доверять не следует, и несмотря на то, что математики иногда допускают ошибки, математический дух всегда остаётся правильным и разумным.

    Я не стану утруждать читателя узкоспециальными математическими рассуждениями, а лишь приведу несколько простых математических соображений, которые сможет понять любой в меру образованный человек. Я прошу читателя отнестись к ним максимально внимательно в связи с их чрезвычайной важностью в наших целях. Я затрону понятия ·_арифметической прогрессии_· и ·_геометрической прогрессии_·. Ни то, ни другое понятие не потребует больше простого знания арифметики из курса средней школы и бухгалтерской деятельности, но они позволят пролить свет на многие важнейшие интересующие человека вопросы.

    Всех нас, людей, интересует то, что мы называем прогрессом: прогрессом в законодательстве, в правительстве, в юриспруденции, в этике, в философии, в естественных науках, в экономике, в изящных искусствах, в ремёслах, в производстве и распределении благ – во всех делах, касающихся блага человечества.

    Мы знаем по фактам, что все эти важные составляющие реализуются в связи друг с другом и друг от друга зависят. Следовательно, мы знаем по фактам, что прогресс каждой из этих важных составляющих обязательно следует поддерживать на уровне прогресса остальных важных составляющих, чтобы сохранять должное равновесие, баланс и тем самым целостность, устойчивость и благополучие всего комплекса нашей социальной жизни.

    Мы знаем по фактам, – по фактам наблюдений – что в некоторых из этих важных составляющих прогресс идёт по одному закону и одними темпами развития, тогда как в других он идёт по совсем другому закону и другими темпами.

    Мы знаем по фактам наблюдений и печального опыта, засвидетельствованных всей историей и очевидных разуму, что, если законы и темпы прогресса важных, неотъемлемых составляющих человечества так сильно отличаются, то баланс смещается, нагрузка растёт, пока не происходит надрыв в форме социальных конфликтов, восстаний, революций и войн.

    Мы знаем по фактам, что следующей за ними реорганизацией, устанавливается некоторое новое равновесие, которое, однако, происходит как результат насилия, в связи с чем оно неизбежно нарушается и продолжает нарушаться вновь и вновь, если с помощью некоторой науки и искусства Человеческой инженерии не получится продолжать двигать прогресс всех важных составляющих человеческого блага по единственному закону, обоснованному природой человека.

    В сочетании вышеперечисленные факты представляются настолько важными, что я считаю нужным подчеркнуть и высказать их максимально ясно. В этих целях я прошу читателя внимательно рассмотреть два нижеследующих ряда чисел. 
    
    Первый ряд – обозначенный · GP · – представляет простую геометрическую прогрессию ⁅geometrical progression⁆;
    
    второй – обозначенный · AP · – представляет арифметическую прогрессию ⁅arithmetical progression⁆:
    
""".trimIndent()

val chapter_1_text_2 = """
    
    Для удобства сравнения я начал оба ряда с одинакового числа и для простоты взял 2 начальным членом. Обратите внимание, что в ряде ·_GP_· каждый член получается путём ·_умножения_· предшествующего члена на 2, а в ряде ·_AP_· каждый член получается путём увеличения предшествующего члена на 2. В первом ряду множитель 2 называется ·_знаменателем_·, а во втором ряду слагаемое 2 называется ·_разностью_·. Повторю, что я выбрал одно число в качестве знаменателя и разности для удобства сравнения и взял простое число 2, чтобы не усложнять пример. Логически здесь подошли бы любые другие выбранные значения.

    Зачем я привёл эти два ряда?

    Чтобы чётко и наглядно показать два сильно отличных ·_закона прогресса_· – два закона, которые представляют очень разные ·_скорости_· роста или ·_развития_·.

    Не упустите следующие два факта.

    Во-первых, величина членов любой геометрической прогрессии со знаменателем (независимо, насколько малым) 2 или больше превзойдёт величину соответствующих членов любой арифметической прогрессии, независимо, с какой большой разностью.

    Во-вторых, чем выше задаётся знаменатель геометрической прогрессии, тем быстрее возрастает значение её последующих членов. Значения членов одной геометрической прогрессии могут увеличиваться в тысячу, миллион или миллиард раз быстрее, чем значения соответствующих членов другой геометрической прогрессии. Как любая геометрическая прогрессия (со знаменателем 2 или больше), независимо, насколько медлительная, превысит каждую арифметическую прогрессию, независимо, насколько быструю, так и одна геометрическая прогрессия может шагать дальше, чем другая такого же типа.

    Каждый чётко увидит, что эти две прогрессии отличаются шагом, и что разница между их соответствующими членами с каждым шагом возрастает. Например, сумма первых шести членов геометрической прогрессии составляет 126, а сумма первых шести членов арифметической прогрессии лишь 52; разница между суммами составляет 84. Сложив первые восемь членов ·_GP_· и ·_AP_·, мы получаем 510 и 72 соответственно; разница между этими суммами (только при 8 членах в каждой) составляет 438 – уже намного больше, чем раньше. Сопоставив суммы первых 10 членов, – 2046 и 110 – мы получим разницу 1936 и т. д., и т. д.
""".trimIndent()

val chapter_1_text_3 = """
    
    Теперь рассмотрите любые две важные составляющие человеческого блага; например, юриспруденцию и естественные науки, или любые другие два главных вопроса человечества. Вы чётко увидите, что, если прогресс одной составляющей идёт по закону геометрической прогрессии, а прогресс другой по закону арифметической прогрессии, то прогресс первой очень быстро и с возрастающей скоростью обгонит прогресс второй. Учитывая их (всегда присущую) взаимозависимость, на человеческие дела оказывается постепенно усиливающееся давление, за счёт чего социальное равновесие полностью нарушается. Затем следует период вынужденной перестройки посредством насилия.

    Не стоит думать, что речь здесь идёт о чем-то лишь гипотетическом. Вся история человечества и особенно прежнее состояние мира демонстрируют, что это предполагаемое, отнюдь не гипотетическое развитие всегда происходило на деле и на деле же происходит сегодня в масштабах шире, чем когда-либо.

    Я считаю, что пока прогресс какой-то значимой для человека составляющей давно идёт по закону стремительно растущей геометрической прогрессии, прогресс других не менее важных составляющих тем временем движется темпами арифметической прогрессии, или, в лучшем случае, темпами какой-нибудь медленно растущей геометрической прогрессии. Чтобы это увидеть и понять, нам следует лишь немного понаблюдать и поразмыслить.

    Создаётся какое-нибудь технологическое изобретение, например, паровой двигатель, печатный станок; осуществляется научная разработка, такая как аналитическая геометрия или математический анализ; совершается открытие какого-нибудь естественного закона, например, о падении тел или закона тяготения Ньютона.

    Что происходит?

    Какой эффект производится на прогресс знания и изобретения?

    Стимуляция. Каждое изобретение ведёт к новым изобретениям, каждое открытие к новым открытиям; изобретение плодит изобретение, наука порождает науку, дети знания плодят всё бо́льшие семьи себе подобных. Этот процесс идёт десятилетие за десятилетием, от поколения к поколению, а мы наблюдаем совершенствование научного знания и технологической мощи, идущее законами и темпами стремительно возрастающей геометрической прогрессии или логарифмической функции.

    Что мы можем сказать о так называемых науках – псевдонауках – этики, юриспруденции и экономики?

    Ответ на этот вопрос потребует больше, чем только открыть глаза и взглянуть на мир.

    Благодаря развитию, давно идущему постоянно ускоряющимися логарифмическими темпами в изобретении, математике, физике, химии, биологии, астрономии и в их применении, мы уже покорили время, пространство и материю в такой мере, что наша Земля, когда-то казавшаяся такой обширной, сжалась до размеров древней провинции. Теперь многообразию народов всевозможных языков, традиций, обычаев и учреждений приходится тесниться в одном сообществе, что требует нового этического, правового, экономического, политического и управленческого знания. Наши тяжёлые времена во весь голос требуют новых взглядов, но в ответ слышат лишь эхо, смешанное с пустыми словами общественников, которые не имеют понятия, что делать.

    В связи с чем?  
    Как это объяснить?  
    Каким образом мы заболели?  
    Почему не знаем, как лечиться?

    Мы даём один ответ. Так называемые науки этики, юриспруденции, экономики, политики и управления не поспевают за стремительным прогрессом в других важных делах человека. Они отстают, и поэтому мир пришёл в такое бедственное положение. Именно из-за их отставания нам не хватает знания, чтобы осуществить лечение.

    Вы знаете, почему так получается, что «социальные» науки – так называемые науки этики и т. д. – отстают?

    Ответ не придётся ни далеко искать, ни прилагать особых усилий, чтобы его понять.

    Они не могут продвигаться быстрее, отчасти потому что им мешают традиции и привычки былого мира – мы смотрим ими назад, нежели вперёд.

    Они отстают, отчасти потому что в них мы полагаемся на малоуспешные методы словесной философии – мы действуем в них метафизически, нежели научно.

    Они отстают, отчасти потому что ими занимаются изворотливые «политики» вместо просвещённых государственных деятелей.

    Они отстают, отчасти потому что их деятели в первую очередь заботятся о защите своих корыстных интересов, от которых главным образом зависит их поддержка.

    Однако ·_фундаментальная_· причина их отставания заключается в ошеломляющем факте, что, несмотря на то, что по самой природе этих наук нас ·_ближайшим_· образом интересуют дела человечества, мы так и не выяснили, что человек на самом деле есть, вместо чего с незапамятных времён ошибочно считали людей либо животными, либо сочетаниями животного и чего-то сверхъестественного. Эти две чудовищные концепции человеческой сущности я рассмотрю далее в этой работе.

    Сейчас я хочу донести факт, что именно значительная ·_несогласованность_· между стремительным прогрессом естественных и технологических наук и медлительным прогрессом метафизических, так называемых социальных «наук» рано или поздно нарушает равновесие человеческих отношений до такой степени, что происходят социальные катаклизмы, которые мы называем восстаниями, революциями и войнами. Читателю стоит обратить внимание, что такие перемены, – мы можем назвать их «прыжками» – такие насильственные перестройки в человеческих делах и отношениях описывали на протяжении истории человечества. Это даст читателю ясно увидеть, что из-за того, что ·_несогласованность_·, которая ведёт к этим переменам, растёт с каждым поколением, – с каждым членом наших прогрессий – эти «прыжки» происходят не только с усугубляющимся насилием, но и с нарастающей частотой. Этот значимый факт мы можем наглядно проиллюстрировать следующим образом:
""".trimIndent()

val chapter_1_text_4 = """
    · a'2 ·, · 2a ·, · ab ·, · bc ·, · cd · представляют геометрический закон прогрессии в естественных и технологических науках (мирная эволюция).

    · A'2 ·, · 2A ·, · AB ·, · CD ·, · EF · представляют отстающий арифметический закон прогрессии в так называемых социальных науках (мирная эволюция).

    И те, и другие события происходят в один период времени.

    · BC ·, · DE ·, · FG · представляют революции или войны, ведущие к революциям идей, – «прыжок» – насильственной, движимой событиями перестройке идей согласно фактам.

    · ab ·, · bc ·, · cd · и · AB ·, · CD ·, · EF · занимают одинаковое количество времени, однако, учитывая медлительность второй прогрессии в сравнении с первой, «прыжки» или революции с течением времени происходят в более короткие интервалы, чем чаще заставляют нас координировать свои идеи, чтобы приспособить их к фактам. Периоды мира, или кажущегося мира, с нарастающей частотой сменяются периодами насилия. Вышеупомянутая ·_несогласованность_· прогресса в мирные времена задаёт условия и гарантирует будущее насилие.[²](https://teletype.in/@czoc/htCTCz2zU12#fjsW)

    Эти несколько математических соображений едва ли получится назвать математикой или математической философией. Тем не менее, если не привлечь внимание к этим очень простым математическим идеям, то нам не удастся продвинуться дальше, чем в прошлом.

    Наши жизненные проблемы всегда «решали» любители метафизического словоблудия и риторики, которые хитро играли неясными формулировками и не обращали внимания на важнейшую проблему измерений, потому что не знали о ней. Они не допускали возможности прийти к согласию в отношении значения слов или даже их понимания.

    Взять, к примеру, такие слова как «хорошо», «плохо» или «истина». О них написали стеллажи томов, но никто не достиг широко приемлемых результатов. Получилось лишь наплодить фанатичных, враждующих философских школ. Тем временем ·_что-то_·, соответствующее каждому из этих терминов существует на деле, но что это что-то собой представляет, пока не установили научно. Если бы этим словам удалось дать научное определение, то философия, право, этика и психология ушли бы от «личных теорий» и словоблудия и стали достойными науками.

    Здесь я приведу цитату о характеристике жизни из книги моего уважаемого друга Харви О’Хиггинса ·_From the Life, Imaginary Portraits of Some Distinguished Americans_· ⁅·_Из жизни; воображаемые портреты некоторых выдающихся американцев_·⁆ (Harper, N. Y.).

    ⬩«⬩  
    Уоррен никогда не философствовал; он обращался с фактами как ремесленник со своими инструментами. ·_Если бы_· он философствовал, то сформулировал бы свою теорию жизни примерно так:

    ⬩⸗⬩  
    Справедливости и морали не существует в природе или в её законах. Справедливость и мораль становятся законами лишь в человеческом обществе. Однако общество, естественная жизнь и вся цивилизация своими основными аспектами подвергаются воздействию законов природы, – которые идут против морали и справедливости – а государственным деятелям приходится следовать этим законам и направлять ими людей, невзирая на менее важные законы морали и справедливости.  
    ⬩⸗⬩  
    ⬩»⬩

    Если таких вероучений придерживаются «выдающиеся люди», то можем ли мы ожидать чего-то лучше, что мы уже видели в истории человечества?

    Тот факт, что старой философией, правом, этикой, психологией, политикой и социологией не получится решить практические проблемы человечности, не стоит считать поводом впадать в отчаяние. Эти проблемы удастся решить.

    Чтобы последовать рассуждениям в этой книге, становиться высококвалифицированным специалистом не придётся; требуется лишь чистосердечность, открытость, свобода от предрассудков, серьёзный подход, желание искать истину и достаточно здравого смысла, чтобы отличить три кварты молока от трёх четвертей мили.

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/htCTCz2zU12#Efjz)Columbia University Press, 1916.

    2\. [⇧](https://teletype.in/@czoc/htCTCz2zU12#PLHg)Немного отходя от темы, я добавлю, что население и потребности людей возрастают в геометрической прогрессии. Рост индивидуумов ограничивается тем, что им приходится усваивать свою пищу через поверхности, которые по мере роста увеличиваются как ·_квадратные_· величины, тогда как тела, требующие питания, представляя собой объёмы, увеличиваются в размерах как ·_кубические_· величины. Учитывая, что кубические величины данных оснований возрастают быстрее квадратных величин: 2²=4, 2³=8, 3²=9, 3³=27 и так далее, представляется очевидным, что на ранних этапах развития организма только часть пищи тратится на поддержание жизни; бо́льшая часть уходит на рост. Когда организм становится больше, его поглощающие поверхности растут пропорционально квадрату, а пища тратится на построение массы объёма тела пропорционально кубу.

    Предположим, что организм вырос в два раза от данного значения; его поглощающая способность увеличилась в четыре раза, а его объём в восемь раз. Если организм вырос в три раза, то разница составит 9 и 27. Очевидно, к какому-то моменту вся поглощённая пища истратится на поддержание жизни, на рост ничего не останется, и он остановится. Это служит ещё одним примером, которым объясняется важность теории размерности в жизни и демонстрируется абсолютная необходимость учёта измерений в исследовании проблем жизни.

    * * *
""".trimIndent()

