package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun appendix_5(modifier: Modifier) {
    MarkdownText(
        markdown = appendix_5_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val appendix_5_text = """
    # Приложение Ⅴ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    НАУКА И ЗДРАВОМЫСЛИЕ,  
    ИЗБРАННЫЕ МАТЕРИАЛЫ[¹](https://teletype.in/@czoc/-FLY4pnUPj_#KZNP)  
    АЛЬФРЕДА КОРЖИБСКИ  
    —  
    ЗАМЕТКА АВТОРА

    Эти выборочные материалы из книги ·_Наука и здравомыслие: введение в не-аристотелевы системы и Общую семантику_· составили по просьбам нескольких преподавателей Общей семантики и ведущих образовательных кружков. Некоторые учащиеся сочли книгу слишком громоздкой или слишком дорогой, но им требовался базовый учебник, написанный с физико-математическим подходом.

    Изначально я писал ·_Науку и здравомыслие_· для учёных, преподавателей и других лидеров нашей цивилизации. Насколько я могу судить, весь представленный материал обязательно понадобился бы им, но не в той же мере необходимости начинающим студентам.

    К задаче выборки материалов из ·_Науки и здравомыслия_· я бы подошёл предвзято, поэтому пришлось положиться на преподавателя с опытом работы в колледжах и университетах. Один такой преподаватель, Гатри Джансен, взял на себя трудную задачу составить избранные материалы.

    После выпуска из Института штата Илиной в 1938 году мистер Джансен провёл шесть лет, работая преподавателем английского и истории в американских школах Египта, в частности в Американском университете в Каире, где он пользовался ·_Наукой и здравомыслием_· в качестве учебника для студентов третьего курса. Следующие два года мистер Джансен работал военным корреспондентом и диктором в Национальной широковещательной компании ⁅NBC⁆, и некоторое время работал при Стратегических воздушных силах США (в экипаже B-29). Он побывал в около двадцати семи стран; вещал из Каира, Афин, Лондона, Манилы, Токио, Шанхая и с самолёта над Нагасаки. Он был первым из десяти американцев, увидевших последствия бомбардировки Хиросимы.

    По возвращению в эту страну (при содействии Роберта Штрауса) он получил стипендию на год обучения в Институте Общей семантики. Он составил эти ·_Избранные материалы_· в рамках своей практики в ходе 1946–1947 годов.

    Я благодарю Гатри Джансена за скрупулёзную работу, которую он проделал. Я также благодарю сотрудников Института и всех, кто оказал поддержку в составлении. Особенно я ценю вклад М. Кендиг, образовательного директора Института; она побуждала сделать выборку для публикации много лет и посодействовала в осуществлении.

    Я включу предостережение для преподавателей и учащихся, которые воспользуются этой книгой, в избежание путаницы в том, что представляют термины «семантика» и «·_Общая семантика_·».[²](https://teletype.in/@czoc/-FLY4pnUPj_#yVud)

    Первым французский термин ·_sémantique_· в литературу ввёл Мишель Бреаль в 1897 году в своей работе ·_Essai de sémantique; science des significations_·, которую перевели на английский в 1900 году под названием ·_Semantics: Studies in the Science of Meaning_· ⁅·_Семантика, исследования в науке значения_·⁆. Эти термины не употребляются эквивалентно носителями разных языков, что привело к путанице среди англоговорящих в применении терминов «семантический» и «семантика»; эта путаница продолжается по сей день.

    ·_Sémantique_· относится к ветви филологии; в ней рассматривают исторические изменения ‘значений’ слов. Леди Уэлби заметила отличия в подоплёках и сформулировала более организменную теорию под названием «сигнифика» ⁅significs⁆. Международное общество сигнифики в Недерладнах продолжает свою работу; его ведут математики, такие как Лёйтзен Брауэр (основатель Школы интуитивной математики), эпистемологи, логики, психо-логики и т. д.

    Обе дисциплины, обозначаемые этими терминами, оказались недостаточно не-элементалистическими, поэтому разные исследовали пытались раскрыть и обобщить их под различными старыми и новыми обозначениями, такими как «семасиология», «семиозис», «семиотика» и т. д.

    Об отношениях между теми дисциплинами Леди Уэлби написала в одиннадцатом издании ·_Британской энциклопедии_·:

    ⬩«⬩  
    Семантику мы можем … описать как применение сигнифики в строго филологических рамках.  
    ⬩»⬩

    На девятой странице своего ·_Введения в семантику_· ⁅·_Introduction to Semantics_·⁆ Рудольф Карнап сообщает:

    ⬩«⬩  
    Если в исследовании открыто упоминают … носителя языка \[с деловой, практической точки зрения\], то мы относим его к области прагматики \[от греческого πραγματικός – поступок, дело, акт и т. д.\] …

    Если мы не принимаем во внимание носителя языка \[не учитываем человека\] и анализируем только выражения и их десигнаты \[означаемые\], то мы переходим в область семантики. Наконец, если мы не принимаем во внимание десигнаты тоже и анализируем только отношения между выражениями, то мы попадаем в (логический) синтаксис. Совокупная наука языка, состоящая из трёх упомянутых частей, называется „семиотика“.  
    ⬩»⬩  
    См. сноску [³](https://teletype.in/@czoc/-FLY4pnUPj_#xXAx)

    Очевидно, в такой «совокупной науке языка», состоящей из «прагматики», «семантики» упускают внутренние реакции индивидуального человека, чем исключают ·_возможность оценки_· как живой проблемы живого индивидуума, что мы ставим главной целью ·_Общей семантики_·.

    Чарльз Морис открыто говорит, что

    ⬩«⬩  
    Семиотика, следовательно, не является „теорией значения“.  
    ⬩»⬩

    О семантике он пишет:

    ⬩«⬩  
    Та ветвь семиотики, в которой изучают значение знаков.  
    ⬩»⬩  
    (·_Signs, Language and Behavior_·, сс. 80 и 353)

    О моей работе он говорит:

    ⬩»⬩  
    Альфред Коржибски и его последователи подходят к своей работе с психо-биологической точки зрения … они ставят целью защитить индивидуума от эксплуатации другими и им самим.  
    ⬩»⬩  
    (с. 283)

    Иными словами, мы имеем дело со внутренней жизнью индивидуума на немых (не-словесных) уровнях.

    Из сказанного здесь следует очевидное: моя работа в Общей семантике не имеет отношения к вышеупомянутым дисциплинам, невзирая на то, что я знаю и уважаю работы соответствующих исследователей в их областях при указанных ограничениях.

    Даже в алфавитном указателе ·_Науки и здравомыслия_· вы не найдёте слово «семантика», кроме как в сочетании «семантика, Общая».[⁴](https://teletype.in/@czoc/-FLY4pnUPj_#qGsH) Я употребляю слово «семантический» только в качестве определения для других слов в смысле «оценочный»; например, «семантическая афазия», «семантическая блокада», «семантические реакции» и т. д. Я взял термин «Общая семантика», чтобы обозначить эмпирическую естественную науку не-элементалистической ·_оценки_·, теории ·_значений_· ⁅·_ценностей_·⁆.

    Если бы я не знал о работе, проделанной в области ·_sémantique_·, сигнифики и т. д., я бы назвал свою работу иначе, но моя система от этого бы в основе не изменилась. Своими докладами на Математическом съезде в Торонто в 1924 году, на собрании Вашингтонского сообщества неврологов и психиатров в 1925 году и на собрании Вашингтонского психиатрического сообщества в 1926 году я обрисовал практически всю систему ·_до того_· как познакомился с работами Бреаля, Леди Уэлби и других. В тех докладах я не употребляю слово «семантический», а свою работу я называю «Время-связывание, общая теория», которая остаётся важной по сей день.

    Я также, насколько знаю, впервые, ввёл термин «Человеческая инженерия». К сожалению, со дня публикации моей книги ·_Зрелость человечности, наука и искусство Человеческой инженерии_· в 1921 году, этим термином стали сильно злоупотреблять. Мне пришлось прекратить им пользоваться и искать новый.

    «Семантика», «сигнифика» и т. д. не подходили, потому что ими обозначали дисциплины, которые даже не соприкасались с моей областью исследований. С перспективы время-связывания и с учётом усилий других я ввёл термин «·_Общая семантика_·», предположив, что разумные люди смогут отличить «семантику» от «Общей семантики», как математики отличают декартову систему и векторное, тензорное и т. д. исчисления как отдельные дисциплины в процессе математической эволюции.[⁵](https://teletype.in/@czoc/-FLY4pnUPj_#pj5x)

    Я также выбрал этот термин, чтобы соблюсти историческую традицию, потому что проблемы на не-словесных уровнях вне и под нашей кожей действительно существуют, и мы с ними живём, независимо от того, удалось моим предшественникам или современникам разобраться с их отношениями к словесным уровням или нет. Термин «Общая семантика» я счёл наиболее подходящим, потому что он произошёл от греческого σημαίνειν – «означать», «обозначать». Теория оценки последовала и развивалась естественно от

    1) ‘значения’ к  
    2) ‘сигнификации’ к  
    3) ·_оценке, принимая в рассмотрение индивидуума_·, не отделяя его от его реакций и от его ·_невро_·-языковых и ·_невро_·-семантических сред.

    Таким образом, мы определяем его как неизбежно пребывающего в ·_пленуме_· некоторых ценностей и ·_пленуме_· языка, который может применяться в целях информации или дезинформации с помощью ·_лжи_· или-и ·_сокрытий_·, приводя самого индивидуума или других в заблуждения. При таких проблемах, без исключения, индивидууму с трудом приходится не просто с чем-то справляться, а, в принципе, оставаться человеком. Это я выяснил с помощью теории время-связывания, и это постарался передать остальным через Общую семантику и психо-биологические не-аристотелевы соображения.

    Я показал несколько лет назад, что теорий ‘значения’ у человека построить не получится, потому что в них не учитываются ·_не-определённые_· термины, которыми мы обозначаем только не-словесные опыты и т. д.[⁶](https://teletype.in/@czoc/-FLY4pnUPj_#TodR) Спутывание немых уровней со словесными в связи с недостатком осознанности абстрагирования неизбежно ведёт к незаметным, пагубным отождествлениям (ошибочным оценкам) этих разных уровней. Примитивизм, инфантилизм, формализм, академическое слабоумие и другие типы патологических реакций ожидаемо следуют.

    Слова «семантический» и «семантика» сегодня употребляются широко, даже в газетах и журналах, в большинстве случаев в смысле ‘значения’. Важные учёные, включая математиков и физиков, тоже употребляют эти слова, в основном, в этом же смысле. Многие из них что-то знают об Общей семантике и, если упоминают мою работу, то открыто говорят, что пользуются термином «семантический» в ином смысле, совершенно отличном от того, в котором я пользуюсь термином «Общая семантика», и они говорят правильно.

    По мере продвижения моих исследований всё более очевидной становилась необходимость более глубокого изучения многих научных дисциплин. Мне пришлось исследовать более скрытые немые предположения. Наконец, стало ясно, что для общей теории ·_ценностей_· требовался, по меньшей мере, ·_методологический синтез_· математики и современных эмпирических наук. Этот синтез (незапланировано) превратился в не-аристотелеву систему, первую до сих пор сформулированную. Сегодня не получится отделить Общую семантику от не-аритсотелевой системы. Одна следует из другой и ·_наоборот_·; Общая семантика служит ·_modus operandi_· и основанием системы.

    Институт Общей семантики учредили в Чикаго в 1938 году как центр обучения этим не-аристотелевым методам. Летом 1946 года Институт переехал в Лэйквил, шт. Коннектикут, где мы работаем по оригинальной программе.[⁷](https://teletype.in/@czoc/-FLY4pnUPj_#RNho) Быстро растущий интерес к нашей работе – к этому моменту на всех континентах – потребовал внедрения новых методов.

    Мне следует подчеркнуть, что Общая семантика не даёт панацей, но опыт показывает, что по ·_применению_· методов общей семантики, результаты обычно оказываются полезными, будь то в области права, медицины, бизнеса и т. д., в образовании на всех уровнях, или в личных взаимоотношениях с семьёй, сообществом, в народных или международных. Если методы не применять, а только говорить о них, результатов ожидать не стоит.

    Пожалуй, наиболее показательным применение получилось на полях сражений Второй мировой войны, о которых сообщили представители вооружённых сил, включая психиатров на всех фронтах, среди которых следует выделить доктора Дагласа М. Келли, бывшего подполковника военно-медицинской службы.[⁸](https://teletype.in/@czoc/-FLY4pnUPj_#z2fJ) Он сообщил следующее:

    ⬩«⬩  
    Общая семантика как современный научный метод даёт исключительно ценные техники как профилактики, так и лечения подобных \[патологических\] сценариев реакций. В Европейском театре военных действий, где я проработал с более чем с семью тысячами пациентов, эти базовые принципы применялись ежедневно в качестве групповой терапии и психиатрической профилактики. Чем раньше начиналось лечение пациента, тем лучше были его прогнозы. Впоследствии сотни хирургов из батальонных медпунктов обучились принципам Общей семантики. Эти принципы применялись (индивидуально и в группах) на каждом уровне лечения, в медицинских центрах на линии фронта и в общих госпиталях. Об успешности их применения свидетельствует то, что из психиатрического отделения в Европейском театре приходилось эвакуировать меньше всего людей.  
    ⬩»⬩[⁹](https://teletype.in/@czoc/-FLY4pnUPj_#o2uh)

    Нам не хватает широкого осознания, что по мере человеческого прогресса сложности и трудности в мире растут по экспоненциальной функции ‘времени’ с неопределённо ускоряющимися ускорениями. Я глубоко убеждён, что эти проблемы никак не получится решить, если мы не возьмёмся за поиски и пересмотр наших устаревших понятий о ‘природе человека’ и не применим современные экстенсиональные методы точных наук вне национальных границ, чтобы эти экстенсиональные методы и приёмы Общей семантики удалось применять ко всем существующим языкам, производя тем самым глубокие психо-логические эффекты на практикующих, которые бы передавались их согражданам. За счёт этого мир ·_может_· установить международный общий знаменатель коммуникации, взаимопонимания и, в конечном счёте, согласия.

    ·_А. К._·  
    ·_Лэйквил, шт. Коннектикут_·  
    ·_февраль 1948 г._·

    ⬩**Дополнение**⬩: На момент, когда эту книгу готовили к печати, моё внимание привлекла статья Алена Уокера Рида из Нью-Йорка, которую скоро опубликуют. В одном абзаце он особенно ёмко подаёт события, которые привели меня к термину «Общая семантика». Мистер Рид любезно разрешил мне воспроизвести его здесь:

    ⬩«⬩  
    Моду на слово „семантика“ можно отследить к работам Альфреда Коржибски. В 1928 году в первой рукописи ·_Науки и здравомыслия_· он совсем не употреблял термины „семантика“, „Общая семантика“ или „семантическая реакция“. Он, однако, следил за деятельностью польских математиков, которую смог оценить как впечатляющую на съезде Congrés des mathématiciens des pays Slaves 1929 года в Варшаве. В 1931 году в Новом Орлеане он представил Американскому сообществу математиков доклад об

    ⬩„⬩  
    ·_ограниченной семантической_· школе, представленной Хвистеком и его учениками, которая характеризуется преимущественно семантическим подходом.  
    ⬩“⬩

    [¹⁰](https://teletype.in/@czoc/-FLY4pnUPj_#T6IX)

    Он объявил, что пользовался термином „Общая семантика“ для своего исследования (прежде он называл свою работу „Время-связывание, общая теория“), и что это исследование привело к  
    (Там же, с. 749.)

    ⬩„⬩  
    выявлению общего семантического механизма в основе человеческого поведения, многих новых взаимосвязей и формулировок, результатом чего стала \[не-аристотелева\] система.  
    ⬩“⬩  
    (Там же, с. 750.)

    Терминология Коржибски некоторыми своими корнями уходит к польским логикам, тогда как некоторые его последователи по ошибке отнесли её к антикварным делам Бреаля, Эрнеста Уикли и популярных писателей о „гламурном исследовании слов“.  
    ⬩»⬩

    · А. К. ·

    Сноски
    ------

    1\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#KlQn)Институт Общей семантики, Бруклин, шт. Нью-Йорк, 1948.

    2\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#U8ry)Например, в словаре ·_Dictionary of World Literature_· «Общая семантика» объясняется в статье по термину «семантика». Эти две дисциплины путают. Даже «экстенсиональные приёмы» называют семантическими приёмами, каких не существует. В Томе Ⅲ, № 4 журнала ·_ETC_.· приводится пятистраничный глоссарий терминов, применяемых в Общей семантике, все из которых я подробно объяснил в ·_Науке и здравомыслии_·. Практически в каждом определении упускается суть и направление моей работы. Например, написанное в глоссарии о применении термина «семантический» в ·_Общей_· семантике – новой теории ·_значений_· ⁅ценностей, величин⁆ – всецело дезинформирует читателей, и я не преувеличиваю. Такие ошибки в азах автоматически ведут к дальнейшим гораздо более серьёзным недо-пониманиям и недо-толкованиям.  
    Самым недавним примером служит статья в публикации ·_Ten Eventful Years_· от ·_Британской энциклопедии_·, которая ещё больше усугубила путаницу между терминами «семантика» и «Общая семантика». В ней даже не упоминают, что семантика относится к филологии, и не указывают на отличия существительного «семантика» от прилагательного «семантический». К этому, статья изобилует ложными заявлениями о моей работе и работах других авторов, и попытками выдать за них что-то другое, не говоря уже о вовсе бессмысленных высказываниях.

    3\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#v7E4)Карнап известен как важный практический работник в сфере ‘логики’, где представляет венскую школу. Он, однако, усугубляет путаницу между «семантикой» и «Общей семантикой». Карнап принял в оборот термин «семантика», обусловив это тем, что он, по-видимому, работает с филологией логического и математического языков. Он, по всей видимости, ознакомлся с моей книгой ·_Наука и здравомыслие: введение в не-аристотелевы системы и Общую семантику_·, опубликованную в 1933 году, однако, в своей книге 1942 года употребляет термин «общая семантика», когда по контексту говорит об обобщённой семантике, чем ведёт путаницу к языковому хаосу. Мы видим, как этот хаос продолжит разрастаться и множиться по объявлению Карнапа на странице ⅸ о серии книг под названием «Ислледования в семантике».  
    Термин «Общая семантика» я ввёл в 1933 году для применения в эмпирической естественной науке оценки, в которой мы имеем дело с живыми человеческими реакциями. Этот термин не имеет отношения к ‘логике’ или к математике ·_как таковым_·.

    4\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#SZ3r)\[Это изменилось со включением нового, расширенного алфавитного указателя в 5-м издании. — Ред.\]

    5\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#DMMg)В исторической перспективе интересно заметить, что первая рукопись ·_Науки и здравомыслия_· не содержала слов «семантика» или «семантический».

    6\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#sgQP)См. Альфред Коржибски и М. Кендиг, «Предисловие» к ·_Анализу теории значения_·, Монографии по Общей семантике № Ⅲ, Институт Общей семантики, 1942.

    7\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#zXjX)\[Ныне (2001) Институт Общей семантики находится в Бруклине, Нью-Йорк. — Ред.\]

    8\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#velV)Главный консультант по клинической психологии и помощник консультанта по психиатрии в Европейском театре военных действий; также главный психиатр, ответственный за заключённых в Нюрнберге. Автор книги ·_22 Cells in Nuremberg_·, Greenberg, New York, 1947.

    9\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#gPQ2)См. также Saunders, Captain James, USN (Ret.). Memorandum. ·_Training of Officers for the Naval Service: Hearings Before the Committee on Naval Affairs, United States Senate_·, June 12 and 13, 1946, pp. 55–57 . U .S . Government Printing Office, Washington, D. C., 1946.

    10\. [⇧](https://teletype.in/@czoc/-FLY4pnUPj_#Kseh)«Не-аристотелева система и её необходимость для строгости в математике и физике», напечатано в ·_Науке и здравомыслии_·, сс. 747–761; цитировано со страницы 748.
    
""".trimIndent()