package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun appendix_4(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp).padding(top = 0.dp)
    ) {
        item {
            MarkdownText(
                markdown = appendix_4_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_5),
                contentDescription = "Диаграмма5",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_4_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.formula_8),
                contentDescription = "Формула8",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_4_text_3,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_6),
                contentDescription = "Диаграмма6",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_4_text_4,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
    }
}

val appendix_4_text_1 = """
    # Приложение Ⅳ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Резюме работы Грайкунаса, приведённое в конце этого приложения практически без изменений, предоставил в 1934 лично Вальтер Поляков, выдающийся инженер и промышленный диагност в США. Он его написал для работников Администрации долины реки Теннесси, которые в то время испытывали острые трудности в управлении в связи с путаницей между функцией и контролем. Мистер Поляков в своём письме о проекте А.Д.Т., оценил ситуацию следующим образом:

    ⬩«⬩  
    Новый А.Д.Т. унаследовал язык и метафизику ушедшей эпохи. Они сталкиваются с беспрецедентными трудностями в попытках выразить новые отношения терминами старых причуд. По ночам они по-прежнему боятся призраков….

    Затруднения в строительстве А.Д.Т. без помощи языка, согласованного с реальностью, характеризуют не только этот проект. Мы видим в них знамения времени – своего рода опасную эпидемию, которая вспыхнула в связи с нашей медленной адаптацией ко в корне изменившейся среде.  
    ⬩»⬩

    В своей работе со студентами я пользовался резюме мистера Полякова вместе с его диаграммой из материалов по «диапазону внимания» или «диапазону контроля» и по связанным положениям, сформулированным в моих собственных работах. Я выяснил эмпирическим путём, что они помогают избавиться от неспособности справится с ·_личными_· жизненными ситуациями адекватно.

    В корне этой проблемы лежит значительная основательная разница в ·_скорости роста_· между арифметической прогрессией, которая возрастает сложением, – например, 2, 4, 6, 8, 10 и т. д. – и геометрической прогрессией, которая возрастает умножением – например, 2, 4, 8, 16, 32 и т. д.

    Нам следует упомянуть перестановки и сочетания, и даже сочетания более высокого порядка, которые тоже следуют экспоненциальному закону. Разные порядки, в которые мы можем привести какие-либо вещи, называются их ·_перестановками_·. Разные множества, которые мы можем сформировать из каких-либо вещей без учёта порядка, в который их приводим, называются их ·_сочетаниями_·. Например, из четырёх букв ·_a_·, ·_e_·, ·_m_·, ·_n_· мы можем сформировать только одно сочетание, но в английском языке они приводятся в нескольких перестановках, таких как ·_name_·, ·_amen_·, ·_mean_·, ·_mane_·.

    Вопрос:  
    Сколько уникальных перезвонов мы можем произвести десятью колокольчиками, используя по семь за раз?

    Ответ:  
    604,800 – достойное число для такой, на первый взгляд, простой задачи.

    Грайкунас, Уруик и другие основывали свою работу на эмпирических данных, полученных своими военными и управленческими опытами – в условиях, где осложнения ·_в связи с человеческими реакциями_· растут геометрически. Пренебрежение вышеупомянутыми соображениями привело ко многим военным и управленческим катастрофам. Я подчеркну, ·_те же принципы действуют в наших личных жизненных трудностях_·.

    Например, в том, что психиатры называют ‘привязанностью к семье’ (в инфантильной зависимости от ‘мамы’ и ‘папы’), в дурных заключениях тёщ и свекровей или в трагедиях брачных треугольников проблемы не возникают просто от ‘добавленного’ фактора, а формируются накопительно по какому-то геометрическому знаменателю. Похожим образом, когда бездетная пара ‘прибавляет’ ребёнка к семье, осложнения растут, следуя некоторому экспоненциальному закону. То, что организм не отвечает аддитивно на ‘ещё один стакан виски’, сомнений не вызывает. Последователям Шикльгрубера-Гитлера, вероятно, уже пришлось узнать, что ‘прибавление’ ещё одной страны, создаёт не-аддитивные сложные организации, которые не входят в представления наивного дурака о силой отобранном рае. Так происходит во всей жизни в более основательных отношениях.

    Если в личной жизни нам приходится брать на себя слишком много задач, интересов, много в чём участвовать и т. д., осложнения часто разрастаются до степени, при которой мозг ·_одного_· человека не может справляться с ними адекватно. Следуют человеческие трагедии, расстройства и т. д., которые часто заканчиваются дезадаптациями и даже неврозами или психозами.

    Во многих случаях одно болезненное событие в детстве, или даже позднее в жизни, продолжает искажать взгляды и восприятия всю оставшуюся жизнь. Таким образом ‘прибавление’ одного фактора приводит к нежелательным сложным организациям, что определённо не случается аддитивно, а длится всю жизнь по некоторому геометрическому знаменателю.

    От некоторых учёных мы слышим замечания:

    ⬩«⬩  
    Выразить поведение целого животного алгебраической суммой рефлексов его отдельных сегментов не представляется возможным.  
    ⬩»⬩

    Однако далее тот же автор сообщает:

    ⬩«⬩  
    Индивидуум представляет наследственность ·_плюс_· среду.  
    ⬩»⬩

    Другой автор пишет:

    ⬩«⬩  
    Заводной механизм представляет собой лишь ·_сумму_· своих шестерней; подобно, человек представляет собой ·_сумму_· своих клеток и молекул.  
    ⬩»⬩

    Затем он пишет:

    ⬩«⬩  
    точнее, эго состоит из энграмм всех наших опытов ·_плюс_· собственно психизм.  
    ⬩»⬩

    Я привожу эти два примера, – из множества других – чтобы показать, как в работу даже тех учёных, которые признают ошибочность аддитивности, прокрадываются очевидно ложные по фактам ‘плюсы’. Это демонстрирует глубоко укоренившуюся аддитивную наклонность, присущую аристотелевому до-научному ориентированию.

    К счастью, некоторые современные психиатры, осведомлённые о последних шагах в научном развитии, осознают эти заблуждения об аддитивности и не допускают необоснованный ‘плюс’.

    Один из них пишет:[¹](https://teletype.in/@czoc/UQa0bQ8fX8M#3pnn)

    ⬩«⬩  
    Прежде чем переходить к обсуждению и применению терапии, следует чётко уяснить три базовых концепции:

    1 · природу и характеристики невротических симптомов;  
    2 · формулу „Конституция ·_умножить на_· Среду ·_умножить на_· Стресс“; и  
    3 · роль, которую „взгляды“ играют в формировании симптомов.  
    ⬩»⬩

    Несмотря на заметно не-аддитивное отношение доктора Крэйниса, он своим ‘умножить на’ не представляет ситуацию корректно. Корректно мы можем представить её функционально:

    ·_N=f(x₁, x₂, x₃… xₙ)_·, где

    ·_N_· означает невроз,  
    ·_f_· означает функцию:  
    ·_x₁_·, – конституции –  
    ·_x₂_·, – среды –  
    ·_x₃_·, – стресса –  
    а ·_и т. д._· (·_…xₙ_·) указывает на особенные функциональные факторы у данного пациента; и все они состоят во взаимоотношениях.

    Такие психотерапевтические подходы позволяют нам увидеть, почему в «терапии ·_взглядов_·» следует переходить от аристотелевого к общему не-аристотелевому взгляду, и не только в психиатрии, но и с целью профилактики ошибочных оценок в жизни каждого.

    На деле бóльшая часть психиатрии зависит от попыток врача устранить, посредством переосмысления в лечении, те факторы, которые изначально вызвали страхи, тревоги и другие дезорганизации. В силу экспоненциальных законов, эти факторы создали огромные количества искусственных осложнений, жизнь от которых затруднилась или вовсе стала невозможной. В моём личном опыте и в опыте многих моих студентов – врачей, преподавателей и т. д. – объяснения вышеприведённых не-аристотелевых принципов приносит значительную пользу, потому что пациенты или студенты приходят к осознанию, что при старых взглядах им приходится иметь дело с невозможностями. Они приходят к осознанию механизмов функционирования трудностей; иного способа сделать решения возможными не существует.

    Математики, в своей часто нарочитой отстранённости от жизни, к сожалению, не предупредили нас о таких методологических ловушках и, более того, студентов отталкивает безжизненность их учений. Математики спешат называть своих студентов ‘математическими имбецилами’. Я иной раз задумываюсь, правда ли это, или ответственность следует по честному возложить на математиков, которые оказываются ‘жизненными имбецилами’. Если бы, прежде чем браться за преподавание, они прошли обучение в больницах для ‘умственно’ больных и проанализировали ‘труды’ пациентов, они бы стали лучше как преподаватели и как исследователи, потому что поняли бы, что означает отстранённость от жизни.

    Проблема аддитивности в жизни, как и в математике, где её называют «линейность», существует со стародавних времён, потому что относится к ·_простейшим_·. В математике аддитивность формулируют как ·_f(x+y)=f(x)+f(y)_·. Одно из самых удивительных следствий аддитивности мы видим в прогнозируемости по характеристикам элементов таковых у результатов. Иными словами, отсутствующие в элементах характеристики мы не находим в результатах. Становится очевидным, что, когда мы сочетаем элементы, а в результатах находим ·_новые_· характеристики, которые в изначальных элементах отсутствуют, это означает, что новые проблемы структурно уже не носят аддитивный характер, и синтез отличается.

    Если мы ·_ограничиваем_· свои взгляды ·_одним только_· принципом аддитивности, в самых основательных вопросах науки и жизни мы ведём себя к неизбежно ложным по фактам результатам. Например, один килограмм ·_плюс_· один килограмм веса даёт два килограмма, однако, ‘сложив’ один литр воды с одним литром спирта, мы получаем меньше двух литров жидкости, потому что действуют глубокие межмолекулярные не-аддитивные факторы, и в этом случае 1+1≠2. Схожим образом, один атом ртути ‘минус’ один электрон становится одним атомом золота.

    Мы не можем прогнозировать результаты, руководствуясь принципом аддитивности. Как показал Грайкунас, ‘добавив’ себе шестого помощника, руководитель может добавить 20 процентов к своему кадровому потенциалу, но тем же добавляет приблизительно 100 процентов к сложности и трудности координации задачами.

    Современной наукой мы выявили, что мир и жизнь в своих фундаментальных аспектах не-аддитивны. Даже эпохальная работа Эйнштейна, основателя не-ньютоновой системы, обусловилась преобразованием линейных (аддитивных) уравнений в не-линейные (не-аддитивные), более сложные уравнения.

    Однако структура привычного нам субъектно-предикатного языка и соответствующие взгляды остаются аристотелевыми и, следовательно, большей частью аддитивными. К сожалению, мало кто из нас, даже среди моих читателей и студентов, осознаёт фундаментальные отличия аддитивных отношений и взглядов от не-аддитивных.

    Работу всей своей жизни, в частности с 1921 года, я основываю на ·_жизненных подоплёках_· пренебрежения дифференциацией законов арифметической и геометрической прогрессий. Этим пренебрежением мы в своей мере вызвали большинство таких судорог цивилизации как войны и революции, а также множество трагедий в личных жизнях. Это следует подчеркнуть особенно.

    За счёт того, что Грайкунас, Уруик и другие имеют дело с ·_человеческими отношениями_·, не пренебрегая при этом математическими вопросами, их работа стоит на тех же принципах, в которых автоматически учитываются перестановки и сочетания. Заинтересованному читателю следует обратиться к начальной алгебре за информацией об арифметическом и геометрическом росте и за простейшими формулировками перестановки и сочетания.

    К сожалению, сочетания более высокого порядка обычно не упоминают в учебниках и относят их к математическим диковинам, применения которым не найти. К сожалению же, факты жизни и осложнения, в основе, на электронном и электро-коллоидном уровнях, принципиально следуют этим сочетаниям высокого порядка. Вычисления как таковые несут мало, или совсем не несут, практической ценности; однако, методологические подоплёки для ориентирования в жизни, которые математики игнорируют, играют первостепенную роль. За подробностями читателю следует обратиться к работам Джевонса и моей.[²](https://teletype.in/@czoc/UQa0bQ8fX8M#j4ZC)

    В человеческой жизни одну из трудностей составляет то, что мы, как говорит Каррель, “и мрамор, и скульпторы”, управляем и подвергаемся собственному управлению, ко-ординируем и ко-ординируемся ⁅со-упорядочиваем и со-упорядочиваемся⁆. Главные источники множества дезадаптаций мы видим в само-рефлексивности и цикличности, с которыми не умеем справляться, потому что не знаем, что для этого существуют не-аристотелевы методы.

    В таком коротком докладе я не могу вдаваться в подробности, которых хватит, чтобы написать книгу. Книг о современной науке написали много, но применить написанное в них получиться только очень ограничено, потому что проблемы не сформулировали методологически. Отсутствует общее понимание того, что с развитием науки старая аристотелева методология, по которой большинство из нас по-прежнему живёт, всецело устарела и к сегодняшнему дню утратила работоспособность. Она вредит человеческой адаптации.

    Я написал этот “эпилог”, чтобы подчеркнуть и в некоторых мерах объяснить необходимость перехода от аристотелева ориентирования к не-аристотелеву, функциональному ориентированию, и чтобы обратить особое внимание на применение в повседневной жизни. Эта не-аристотелева система открыто строится на физико-математических методах, которые, как показано в этом томе, мы можем широко применять в жизни человека, даже на уровне ясельного образования. Она не подлежит догадкам, словесным доводам или дебатам; её следует проверять эмпирически – применением. Я написал этот доклад по опыту того, как эта не-аристотелева система ·_работает_· на практике. Устраивают ли формулировки теоретических вопросов всех, или самого автора, не имеет значения.

    В настоящем беспрецедентном мировом кризисе мы имеем дело не с «новым порядком», а наблюдаем предсмертную агонию и скорую неизбежную смерть старой аристотелевой системы, применяя которую, мы зашли в тупик. Я лично не сомневаюсь, что по окончанию этого мирового кризиса и похорон умерших, будущее человечества придётся строить на каких-то новых не-аристотелевых системах, основанных открыто на научных экстенсиональных принципах и, в конечном счёте, на физико-математических методах. Я подчёркиваю, что названием своей книги «Наука и здравомыслие: введение в не-аристотелавы системы и Общую семантику» я указываю на взаимоотношения между наукой и здравомыслием, что я считаю естественным. Читателю следует заметить, что я говорю «не-аристотелевы системы» во множественном числе, потому что не-аристотелева система, которую произвёл я, не ·_единственная возможная_·, а ·_одна помимо_· многих других возможных.

    Исследуя цепь мировых трагедий, происходящих накопительно с ускоряющимся ускорением и растущей серьёзностью последствий, мы естественно ищем факторы, вызывающие эти катаклизмы. Эту проблему мы можем анализировать множеством разных способов, но здесь, в первой не-аристотелевой системе, мы открыто и честно принимаем инженерную точку зрения. Мы не ‘философствуем’ ради ‘философии’, не говорим о науке во имя науки и не занимаемся математикой ради математики. Мы рассматриваем все эти деятельности как продукты человеческой нервной системы, которые следует ·_применять_· для её оптимальной эффективности. По методологической формулировке, взаимоотношения между наукой и здравомыслием становятся очевидными, а новые по-детски простые методы удаётся применять для более эффективного ведения как наших личных жизней, так и жизни общества, в частности для ·_предотвращения_· дезадаптаций – неадекватных оценок в жизни.

    С этой новой точки зрения нам следует честно призвать к ответственности ‘философов’ за их научное невежество, их ‘превосходство’, равнодушие к не-аристотелевым вопросам и, следовательно, их ·_неспособность_· серьёзно рассмотреть и учесть наши ·_невро_·-семантические и ·_невро_·-языковые ·_среды как среды_·. ‘Философы’ по произвольным заслугам ставят себя ‘выше’ экспериментальных методов. Они без устали приводят доводы на словесных уровнях, но не берутся проверять новые экстенсиональные методы. Я повторю, что новые методы не подлежат доводам или дебатам; они требуют эмпирических исследований того, как они работают.

    ‘Философам’ следовало давно выяснить, что максимально эффективное обучение осуществляется ·_методом_·; в нашем случае, в основе, физико-математическим методом, даже на уровне яслей. Бездействующие ‘философы’ несут значительную часть ответственности за стерильность нашего образования, как начального, так и университетского, и за ‘изоляционизм’ в науке или-и в жизни. Собрания университетских факультетов представляют собой жалкое зрелище, потому что им не хватает общего метода, которым удалось бы сплотить участников. В таких условиях эффективность учёного как человека падает, от чего падает и уважение к нему со стороны не-учёных, которые не понимают ограниченностей специализации в отсутствие общего метода.

    На мои занятия приходят люди, которые работают и обучаются в далеко друг от друга практикуемых областях таких как медицина, математическая физика, образование, работа в социальной области, языкознание, право и т. д., и за несколько дней они становятся всё более сплочённой командой, потому что усваивают ·_общий метод_·, применимый в профессиях и в повседневных жизнях каждого из них. Сегодняшний изоляционизм парализует самих изоляционистов, не давая им выработать общие экстенсиональные взгляды.

    Нам следует осознать и поддерживать осознанность того, что научная работа, как и наши личные реакции в жизни, представляют собой результат электро-коллоидных процессов, происходящих в наших нервных системах. Опыт показывает, что эти процессы подвергаются всяческим глубоким воздействиям зависимо от применения интенсиональных или экстенсиональных ·_методов_·. Эта согласованность и близкие взаимоотношения между неврологическими процессами и применяемым ·_методом_· составляют ключевую проблему в переходе от одной системы к другой; в этом случае, от аристотелевой к не-аристотелевой системе. Эмпирическая демонстрация вышеприведённых фактов с помощью собственно применения экстенсионального метода представляет собой что-то совершенно новое и составляет «терапию взглядов».

    Можем ли мы свалить всю вину на учёных или простых людей?

    Нет. При старом аристотелевом, дву-значном ориентировании человек никак не может просто взять и начать в должной мере практиковать современное бесконечно-значное не-аристотелево процессуальное ориентирование и, следовательно, не может ‘мыслить’ о себе с электро-коллоидной неврологической точки зрения. Вновь, ответственность нести ‘философам’, которые пренебрегли этой важнейшей ·_невро_·-методологической областью, из-за чего не предоставили преподавателям, учёным и т. д. и простым людям почвы для сотрудничества. Это соображение ведёт к весьма тяжёлому осознанию, что бесполезность ‘философов’, о которой мы говорим как об исторически задокументированной, помешала многим людям ско-ординировать свои усилия с целью оптимальной адаптации. ‘Философы’, конечно, постараются от этого отговориться, но это не поможет, потому что эту работу проделали не они; им придётся исследовать, ·_проверять_· и выяснять. Многие ‘философы’ испытают шок и сочтут святотатством одно только предложение сделать ‘философию’ экспериментальной, подобно любой научной теории.

    Ситуация с политиками, дипломатами, правителями и т. д. выглядит безнадёжной из-за их невежества, несобранности перед своим человеческим долгом и отказа принимать профессиональную помощь, когда её предлагают. Я не стану вдаваться в подробности, потому что изобличения непробиваемой тупости и некомпетентности тех, кто должен направлять наши судьбы, насчитывают сотни написанных томов. Благодаря их деятельности мы стали начисто дизорганизованными и неподготовленными к тому, что нас ожидает.

    В истории науки и цивилизации жизненные необходимости вынуждали нас, вопреки ‘философам’, находить решения более эффективной адаптации к жизни. К настоящему моменту это удалось сделать таким людям как Грайкунас, Уруик, Поляков и т. д., которые применяли в своей работе математические методы к эмпирическим данным об ограничениях способностей нервной системы. Они работали в промышленных и военных сферах, где недостаток эффективности приводит к очевидным катастрофам.

    В своей работе я счёл, что математические методы следует применять шире, в частности в повседневной жизни, потому что даже малейшей организационной единице, которую мы называем семьёй, тоже требуется метод поддержания оптимальной человеческой эффективности, основанный на понимании человеческой природы и ограничений способностей человеческого мозга. В отсутствие метода неизбежно следуют разной степени катастрофы, которые могут закончится дезадаптацией, неврозом или психозом.

    Я не представляю себе как кто-то, кому приходится иметь дело с человеческими отношениями, будь то ответственный член семьи, преподаватель, врач, или политик, и т. д., может компетентно работать над своими задачами при полном незнании о проблемах, озвученных в этом докладе, включая следующее ниже резюме Полякова, составленное по работам Грайкунаса и Уруика. Оригиналы опубликовали за рубежом в 1933 году. В 1937 году Институт общественного управления при Колумбийском университете в Нью-Йорке перепечатали два главных доклада, которые я упомянул, добавив новых материалов, под названием ·_Доклады по науке управления_· под редакцией Лютера Гулика и Л. Уруика. Я рекомендую всем своим читателям изучить эту книгу.

    ⬦⬦⬦⬦ Резюме диапазона внимания ⬦⬦⬦⬦
    -----------------------------------

    ⬩**составил В. Н. Поляков**⬩
    
""".trimIndent()

val appendix_4_text_2 = """

    За полным изложением теории мистера В. А. Грайкунаса см. ·_Bulletin of International Management Institute_·, Том Ⅶ, № 3, март, 1933, статья под названием «Отношения в организации». Ссылки на эту теорию также приведены в докладе Отдела промышленного сотрудничества британской ассоциации за развитие науки в Лестере, от 7 сентября 1933 года майора Л. Уруика, члена ордена Британской империи, сотрудника военно-медицинской службы, магистра гуманитарных наук, под названием «Организация как техническая задача».

    Цитата из последнего материала:

    ⬩«⬩  
    Работники и учащиеся сферы управления давно знают, что на практике никакому человеческому мозгу не следует пытаться прямо руководить более чем пятью, или, максимально, шестью, другими индивидуумами, которым по своей работе приходится взаимодействовать. Мистер В. А. Грайкунас из Парижа недавно продемонстрировал, почему так обстоят дела. \[Он второй, кто с 1930 года своей работой внёс важный вклад в техники организации.\]

    Индивидуум, координирующий работу других, чьи обязанности взаимосвязываются, принимая решения, должен учитывать не только реакции каждого человека как индивидуума, но и свои реакции как участника любой возможной группы человек, которая может по обстоятельствам сформироваться в ходе работы.

    Психологическая концепция «диапазона внимания» ставит строгие ограничения на число отдельных факторов, которые человеческий разум может охватить одновременно. Дополняет её то, что мы можем назвать ·_диапазоном контроля_·. Если руководитель с пятью напрямую ему подотчётными подчинёнными добавит шестого, он повышает свой кадровый потенциал на 20 процентов, но с этим добавляет приблизительно 100 процентов к сложности и трудности ко-ординированию задачами. Количество отношений, которые ему приходится учитывать, растёт не по арифметической, а по геометрической прогрессии…. Пренебрежение этими ограничениями, налагаемыми диапазоном контроля, ведёт к неразрешимым проблемам в ко-ординации.

    Для получения числа прямых отношений в группе автор предлагает применять следующую формулу:
""".trimIndent()

val appendix_4_text_3 = """
    где  
    ·_R=a+b+c_· означает общее число прямых и пересекающихся отношений;  
    ·_n_· = числу руководимых людей;  
    ·_a_· = числу прямых одиночных отношений;  
    ·_b_· = числу пересекающихся отношений;  
    ·_c_· = числу прямых групповых отношений.

    По вычислению на ·_максимальной_· основе, количества прямых и пересекающихся отношений, формирующихся у данного числа руководимых, составляют:
""".trimIndent()

val appendix_4_text_4 = """
    КоП/Ф – Количество помощников или функций  
    КоО/З – Количество формирующихся отношений или возникающих задач  
    КоО/З\* – Результаты вычисления на ·_минимальной основе_·

    Сноски
    ------

    * * *

    1\. [⇧](https://teletype.in/@czoc/UQa0bQ8fX8M#kQ68)S. H. Kranes, “Brief Psychotherapy”, ·_Mental Hygene_· ⅩⅩⅦ (Jan. 1943), 70–79.

    2\. [⇧](https://teletype.in/@czoc/UQa0bQ8fX8M#IvoC)W. Stanley Jevons, ·_The Principles of Science_· (London: Macmillan and Co., Ltd., 1920), Гл. ⅠⅩ. ·_Низ_· с. 340.

    * * *

""".trimIndent()