package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun appendix_3(modifier: Modifier) {
    MarkdownText(
        markdown = appendix_3_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val appendix_3_text = """
    # Приложение Ⅲ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Мастерство инженерии естественно формируется на работе умерших и служит не только настоящему, но и будущему. Оно меньше, чем любая другая человеческая деятельность, подвержено ошибкам смешивания измерений и заблуждениям об индивидуализме достижений и гордости. Простая структура моста, знакомая нам в повседневной жизни, служит напоминанием о мастерстве Гефеста и о связанных знаниях бесчисленных поколений кузнецов и механиков, металлургов и химиков, математиков и строителей, преподавателей и инженеров, которые трудились многие тысячи лет, чтобы стальные балки современной структуры стали возможными.

    Эти структуры не обрушиваются, только если не нарушаются естественные законы их строения. Такое происходит редко, потому что до такой работы допускают только тех, кто связал в своих знаниях накопленный опыт прошлого. Нарушителей этих естественных законов наказывают по полной строгости общего права ⁅закона⁆. Когда мост открывают и проверяют, писаные законы в одних странах, неписаные в других, гордость и чувство ответственности проектировщика и строителя моста требуют, чтобы он, как создатель, зашёл на него первым и ушёл с него последним. Если мост обрушится, ему сразу придётся испытать последствия пренебрежения время-связующими законами.

    Инженерные дела редко мотивируются одним только желанием скорой корыстной выгоды, и даже, когда оно прослеживается, эту никчёмную мысль рассеивает свет достижения. Месье Эйфель возвёл свою башню не для того чтобы наводить страх на Париж видом стального скелета, возвышающегося над городом смелых идей. Башня стоит сегодня механическим свидетельством математических формул, выражающих возможность возведения высоких самонесущих конструкций, служащих будущему человечества.

    Своей человеческой время-связующей способностью мы создаём и формулируем новые ценности службы человечеству. Вновь, никакой ученик инженерного ремесла не зазнаётся до такой степени, что приписывает заслуги за достижение – неважно, насколько чудесное – единолично себе. Ни удивительное открытие современного электричества, ни даже возможность говорить друг с другом, находясь в разных полушариях, мы не можем правомерно объявить достижениями какого-то одного человека, потому что можем отследить их происхождение до дней босоногого пастуха Магнуса, впервые наблюдавшего явление магнетизма.

    В попытке отследить и оценить время-связующие способности, воплощённые в ремёслах инженерии мы поражаемся и приходим в замешательство от путаницы и противоречий, не распознанных в массе свидетельств, и от того, как жалко и плачевно выглядят труд и творчество сотен тысяч работников в сфере инженерии, которые неосознанно потворствуют деградации, в немом согласии наблюдая, как их чудесные коллективные достижения сковывают пространство-связующими целями.

    По завершению работы над этой книгой я с удивлением узнал, как мало встречается инженеров, которые интуитивно понимают величину ресурсов в своём распоряжении и серьёзность своего долга перед человечеством. К этому времени Генри Л. Ганта уже не стало, поэтому я обратился к Вальтеру Полякову, доктору технических наук, промышленному консультанту, председателю комитета услуг и информации, топливный отдел, члена АОИМ ⁅Американского общества инженеров-механиков⁆ и к Роберту Б. Вулфу, вице-президенту АОИМ. Они проявили понимание, которое я оценил выше по мере знакомства с характером их работы и достижений. Оба они проделали выдающуюся работу в своих областях. Я не преувеличу, назвав их работы, вместе работами позднего Г. Л. Ганта и Чарльза Штейнмеца, первыми – известными мне – краеугольными камнями науки и искусства Человеческой инженерии и первыми письменными трудами новой библиотеки зрелости человечности. Эти книги и доклады писали на основе научно анализированных фактов, знаменуя освобождение инженерной мысли от метафизики.

    Из всех чистых и прикладных наук, одна только инженерия отличается ·_правильным_· глубоким пониманием человеческой проблемы. Инженеры ставили себе задачу преобразовать знания – работу мозга, «связанное время» – в насущный хлеб за счёт экономии времени и усилий. Эта концепция представляет собой ничто иное, как проработку несовершенной формулировки принципа время-связывания. Ожидаемо, некоторые инженеры уже проложили путь в правильном направлении. То, насколько прямо и далеко за счёт этого чувства размерности удалось зайти некоторым из них в своей практической деятельности, можно увидеть в работе Вальтера Полякова ·_Mastering Power Production_· ⁅·_Мастерство энергетики_·⁆ (Engineering Magazine, N. Y., 1921).

    ⬩«⬩  
    Я не имел намерений составлять учебник по энергетическому машиностроению. Скорее, я хотел избежать такого изложения материала на какую-либо техническую тему, который уже можно найти в другой инженерной литературе. Я, однако, не смог не зайти в соседствующие области психологии и экономики, потому что не ознакомившись с этими науками, овладеть энергетикой не получится.

    Я не считаю, что принципы, по которым я изложил метод, допускают выбор или мнения, потому что я основывал их на фактах. Тем не менее, работу такого характера не получится завершить, или же найдутся неподходящие примеры, потому что в ней я имею дело с живыми и постоянно преобразующимися отношениями и применяю её к процессам в развитии.

    Если этой работой и лежащей в её основе идеей мне удастся поспособствовать решению некоторых задач в нынешнем стремительном ходе развития наших промышленных отношений, я сочту, что не потратил своё время и время своих читателей зря.  
    ⬩»⬩  
    (с. ⅺ)

    Читатели, действительно, не потратят время зря. В этой книге приводится инженерный, научный – и при этом практический – анализ всех человеческих проблем. Она читается как глубокий практический трактат обо всех серьёзных вопросах о современной промышленной системе и так называемых экономических проблемах, и служит основой для новой научной промышленной философии.

    Ещё один обзор Поляков провёл в своём докладе ·_Принципы промышленной философии_·, который представил на ежегодном собрании Американского общества инженеров-механиков (7–10 декабря 1920 года). Любой, кто хоть как-то относится к промышленным или экономическим проблемам, не сможет не увидеть важность и основательность работы, положенной в эту книгу.

    Очевидно, что научное знание фактов играет важнейшую роль в серьёзном подходе к любой проблеме. В связи с этим первостепенную важность приобретает актуальная статистика. Я удостоился привилегии прочесть рукопись ·_Quo Vadis America_·, готовящейся к изданию книги Полякова, в которой он составляет полезнейшую статистическую картину фактов современной Америки, по которой удастся прийти к самым удивительным заключениям. Очень жаль, что в Европе мы не записывали подобные данные о своих условиях. Если бы писали – а общественность ·_читала_· – больше таких книг, многих кризисов и катастроф удалось бы избежать.

    Мистер Роберт Вулф внёс выдающийся вклад своими исследованиями в физиологии, биологии, психологии и философии, применимых к инженерии.

    ⬩«⬩  
    Любому, кто задаётся вопросами о силах, ведущих индивидуальное развитие человечества, я рекомендую в безмерно полезных практических целях окунуться прямиком в область психологии и ментальной философии.

    Я приведу пять важных фактов по теме:

    1-й: Человеческое тело представляет собой такую удивительную организацию, потому что оно стало результатом действия сил созидания на протяжении миллионов лет эволюции.

    2-й: Его способности к прогрессу зависят от поддержания единства вследствие творческой эволюции и от осознанного признания этого единства.

    3-й: Это единство не стало бы возможным без развития нервной системы.

    4-й: Осознанный разумный прогресс, ведомый человечеством, не достиг бы своего нынешнего уровня до тех пор, пока процессом эволюции в нервной системе не развился механизм, дающий способность записывать то, что получают чувства.

    5-й: Без способности записывать события прошлого, обращаться к записям с целью решения возникающих задач человек не может развиваться.

    В связи с этим я хочу отметить, что, поскольку прогресс человека зависит от совершенного координирования его сил в целях добиться единства действия, мы не можем правомерно ожидать, чтобы промышленная организация должным образом развивалась, если мы не установили осознанно координирующий механизм, схожий с таковым в человеческой нервной системе.  
    ⬩»⬩  
    ·_Individuality in Industry_·, Robert B. Wolf

    Доктор Чарльз П. Штейнмец в своём труде ·_America and the New Epoch_· ⁅·_Америка и новая эпоха_·⁆ показал наиболее чёткую инженерную перспективу политической ситуации в мире, снабдив её точными описаниями психологических особенностей разных народов. Эту книгу он написал в 1916 году, – до окончания мировой войны – но, благодаря глубокому психологическому анализу народов и их общественных организаций, которые, в конечном счёте, задают ход развитию любой нации и не меняются победами или поражениями, ценной эта книга останется надолго.

    ⬩«⬩  
    Я хочу воздать уважение памяти Ганта не только как друг и почитатель. Я хочу представить строгие доказательства научной истинности его философии.

    Слово service ⁅„служба“, „услуга“⁆ относится к таким словам, значения которых меняются на прямо противоположные за счёт слов по соседству – give ⁅„давать“⁆ или take ⁅„брать“⁆. Гант принимал rendering service ⁅„оказывать услуги“, „служить“⁆ как аксиому. Я, как многие другие, вижу, что человечество живёт по совершенно иной аксиоме: мы проповедуем give, а практикуем take. Я задался вопросом о том, каким способом мы могли бы раз и навсегда освободиться от этого противоречия. Если одно в нём истинно и составляет естественный человеческий закон, значит другое нет; если наши слова истинны, значит не истинны наши поступки, или, если наши поступки истинны, значит словами мы их скрываем. Решение я нашёл в применении математически строгого мышления. Математика, благодаря её точной концепции измерений, дала мне метод.

    В исследовании явлений мы применяем метод анализа, или, говоря математически, дифференциации. Я вскоре выяснил, что методы дифференциации оказались большей частью правильными, однако, в нашем синтезе, или процессе интеграции, выявились проблемы. Дифференциацией удалось правильно понизить измерения, но нашей дефектной интеграцией не получилось восстановить изначальные измерения. Исследование пришлось проводить с начала – с определения явления жизни таким способом, чтобы не допустить грубых ошибок с измерениями.

    Я определил классы жизни по их неоспоримым размерностным характеристикам: химио-связующие – растения, пространство-связующие – животные, время-связующий – человек.

    Эти определения делают очевидным следующее:

    1 · Классы жизни относятся к разным измерениям. Смешивание измерений, как в математике, делает правильное решение невозможным, так и в жизни, результаты таких элементарных ошибок ведут к трагическим последствиям.

    2 · Старая формула, по которой мы строим свою цивилизацию – ЧЕЛОВЕК равняется ЖИВОТНОЕ плюс или умножить на ИСКРУ БОЖЕСТВЕННОСТИ – базово, элементарно неверна и математически представляет собой бессмыслицу, как ·_x_· квадратных дюймов равняется ·_y_· линейных дюймов плюс или умножить на ·_z_· кубических дюймов.

    3 · Эта в основе неправильная формула, на которой стоит наша цивилизация, вызывает все периодические коллапсы, войны и революции.

    4 · Старую систему строили по пространство-связующим стандартам, а человеческие время-связующие порывы постоянно этому сопротивлялись.

    5 · Как теория гравитации и математический анализ сделали инженеров и математиков хозяевами неодушевлённой природы, так и эти действенные и неоспоримые определения дают им положительное основание, которое позволит находить подходы и решения живых человеческих проблем с помощью констатации математического факта, что человек есть человек – не животное.

    6 · Все, кто слепо следуют традициям и отказываются исследовать или познавать эти математические истины, несут человечеству опасность тем, что способствуют поддержанию дефектной структуры, которая, как в прошлом, обречена обрушиваться вновь и вновь в будущем.

    7 · Задача математически мыслящих людей состоит в том чтобы освещать эту проблему так, чтобы останавливать глупых, или умышленно деструктивных, и показывать, работают они за или против человечества.

    8 · Время-связующий класс жизни видит, что это измерение, время-связывание, представляет собой естественный закон, и, если его понять и проанализировать, он становится высшей человеческой целью.

    9 · Такие „естественные законы“ как „выживание самого приспособленного“ для животных, который означает „выживание самого приспособленного в пространстве“, приводят к вражде, или выживанию сильнейшего. Чтобы сделать такой закон ЕСТЕСТВЕННЫМ ЗАКОНОМ ДЛЯ ЧЕЛОВЕКА, следует соблюдать его в человеческом измерении, где он способствует, очевидно, „выживанию самого приспособленного во ВРЕМЕНИ“ – выживанию лучшего.

    10 · Все известные факты требуется осветить, свести в удобные обобщения и соотнести математиками и инженерами со строжайшим вниманием к размерности.

    11 · Все наши идеи следует пересмотреть. Мы должны отбросить животные пространство-связующие стандарты как опасные и разрушительные, и заменить их время-связующими стандартами, согласованными с естественными порывами и ЕСТЕСТВЕННЫМИ ЗАКОНАМИ для людей.

    12 · Умы математиков и инженеров, благодаря их образованию, оказались первыми свидетелями масштабной важности фактов, выявленных этими определениями. Это осознание повлечёт приведение ценностей к порядку жизни в человеческом измерении, где надвигающиеся революции и войны удаётся обращать в эволюции, разрушение в построение, разлад в единство общей цели.

    Мы владеем своими судьбами. Мы несём ответственность за исправление ошибок наших предков и за основание научной философии, научно истинных законов, научно истинной этики и научной социологии, которые объединятся в одну науку человека и его функции во вселенной. Я предлагаю назвать эту науку Человеческой инженерией. Методы Ганта могли бы стать первым практическим применением в этих целях.

    Концепция службы Ганта научно истинна, потому что она время-связующа, следовательно, истинна для человеческого класса жизни и человеческого измерения. Именно поэтому концепции Ганта затрагивали так много, и именно поэтому они выживут ВО ВРЕМЕНИ.  
    ⬩»⬩  
    — Обсуждение Альфредом Коржибски доклада В. Н. Полякова «Принципы промышленной философии», представленного на ежегодном собрании Американского общества инженеров-механиков, Нью-Йорк, 7–10 декабря, 1920.

    ⬦⬦⬦⬦ Литература ⬦⬦⬦⬦
    --------------------

    ⬩**Гант Генри Лоренс**⬩:

    ·_Work, Wages, and Profits_·. The Engineering Magazine Co., 1913. N. Y.

    ·_Industrial Leadership_·. Yale University Press. 1916.

    Выборочное содержание:  
    · Инженер как промышленный лидер  
    · Экономика и демократия  
    · Демократия в производстве  
    · Демократия в цехе  
    · Демократия в менеджменте  
    · “Религия демократии”

    ⬩**Поляков Вальтер Николаевич**⬩:

    ·_Mastering Power Production_·. The Engineering Magazine Co. 1921. N. Y.

    Выборочное содержание:  
    · Происхождение принципа производства для применения  
    · Электроэнергетическая промышленность как экономический фактор  
    · Преодоление проблем труда. (Условия) Автономное сотрудничество  
    · Цели труда  
    · Право на лень и право на трудоустройство  
    · Квалификация кадров  
    · Рабочий день  
    · Утомление  
    · ·_УНИВЕРСАЛЬНЫЙ ТРУД (в точности согласованный с время связыванием — Автор)_·  
    · Должность инженера  
    · Компенсация  
    · Социальный аспект  
    · Экономический аспект  
    · Основа выплат  
    · Поощрительные выплаты  
    · Участие в прибылях  
    · Премии  
    · Вознаграждение индивидуальных усилий  
    · Двухставочные выплаты  
    · Энергия как товар

    “Principles of Industrial Philosophy.” Доклад на ежегодном собрании АОИМ, декабрь 1920.

    ·_Organization and Machinery_·. Y.M.C.A. Association Press. 1921. N. Y.

    ·_Quo Vadis America?_· Готовится к изданию.

    ⬩**Штейнмец Чарльз Протеус**⬩

    ·_America and the New Epoch_·. Harper & Brothers. 1916. N. Y.

    Выборочное содержание:  
    · Индивидуалистическая эра: от конкуренции к сотрудничеству  
    · Англия в индивидуалистическую эру  
    · Германия в индивидуалистическую эру  
    · Другие Европейские нации в индивидуалистическую эру  
    · Америка в индивидуалистическую эру  
    · Эволюция: промышленное правительство

    ·_Incentive and Initiative_·. Y.M.C.A. Association Press. 1921. N. Y.

    ⬩**Вулф Роберт Б.**⬩: Буклеты.

    “Individuality in Industry.” Bulletin of the Society to promote the Science of Management. Vol. I. No. 4. August, 1915.

    “The Creative Workman.” Technical Association of the Pulp and Paper Industry. 1918. N. Y.

    “Non-Financial Incentives.” Доклад на ежегодном собрании АОИМ, декабрь 1918. N. Y.

    “Modern Industry and the Individual.” A. W. Shaw & Co. 1919. N. Y.

    “Securing the Initiative of the Workman.” American Economic Association. 1919. N. Y.

    “Creative Spirit in Industry.” Y.M.C.A. Association Press. 1921. N. Y.

    ### ⬦⬦⬦ Прочие книги ⬦⬦⬦

    ⬩**Von Bernhardi**⬩, General F.: ·_Germany and the Next War_·. E. Arnold, London. 1912.

    ⬩**Brandeis, Louis**⬩: ·_Other People’s Money and How the Bankers Use it_·. F. A. Stokes, N. Y. 1914.

    ⬩**Thomas Farrow and Walter Crotch**⬩: ·_The Coming Trade War_·. Chapman & Hall, London. 1916.

    ⬩**Hueffer, Ford Maddox**⬩: ·_When Blood is Their Argument_·. Hodder & Stoughton. 1915. N. Y.

    ⬩**Hauser, Henry**⬩: ·_Germany’s Commercial Grip on the World, Her Business Methods Explained_·. E. Nash Co., London. 1917.

    ⬩**Laughlin, J. L.**⬩: ·_Credit of the Nations_·. Scribner’s Sons, N. Y. 1918.

    ⬩**Maetzu, Ramiro de**⬩: ·_Authority, Liberty and Function in the Light of War_·. Geo. Allen and Unwin.

    ⬩**Delash, Francis**⬩: взгляд француза, ·_The Inevitable War_·. Small, Maynard & Co., Boston. 1915.

    ⬩**Neilson, Francis**⬩: взгляд англичанина, ·_How Diplomats Make War_·. B. W. Hucbsch. 1916.

    ⬩**Немецкий автор**⬩ (взляд немца). ·_J’Accuse!_· Hodder & Stoughton, London. 1915.

    * * *

""".trimIndent()