package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.timebinding.manhoodofhumanity.R
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun appendix_2(modifier: Modifier) {
    LazyColumn(
        verticalArrangement = Arrangement.spacedBy(40.dp),
        modifier = modifier.padding(horizontal = 15.dp).padding(top = 0.dp)
    ) {
        item {
            MarkdownText(
                markdown = appendix_2_text_1,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_1),
                contentDescription = "Диаграмма1",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_2,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.formula_6),
                contentDescription = "формула6",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_3,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.formula_7),
                contentDescription = "формула7",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_4,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_2),
                contentDescription = "диаграмма2",
                contentScale = ContentScale.Fit,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_5,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_3),
                contentDescription = "диаграмма3",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_6,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
        item {
            Image(
                painter = painterResource(R.drawable.diagram_4),
                contentDescription = "диаграмма4",
                contentScale = ContentScale.Crop,
                modifier = Modifier.fillMaxSize()
            )
        }
        item {
            MarkdownText(
                markdown = appendix_2_text_7,
                color = MaterialTheme.colorScheme.onSurface,
                style = MaterialTheme.typography.bodyLarge,
                modifier = modifier,
            )
        }
    }
}

val appendix_2_text_1 = """
    # Приложение Ⅱ
    · Зрелость человечности ·, 2-е издание, А. Коржибски

    * * *

    Жизнь одного человека коротка, и мало кто получает возможность достичь многого за свой срок. Масштабные достижения осуществляются практически всецело за счёт того, что множество людей ведут работу, проделанную первооткрывателем. В таком случае мы приходим к ·_полномерной_· «истине» благодаря тому, что произвёл не один человек, а ряд людей. Однако, первооткрытие требуется не только совершить, но и правильно определить прежде, чем им удастся воспользоваться. Мы не осознаём, сколько умственной работы расходуется попусту из-за неправильного применения слов.

    Важнее всего, человеческая мысль – уникальное, тонкое, но самое энергичное явление природы – бессмысленно растрачивается от того, что мы не применяем, или не прилагаем усилий, чтобы применять подходящий язык. Тем временем, ложные определения ведут не только к расточению, но и к ущербу. Когда мы ложно определяем идеи и факты, они ведут нас к ложным заключениям, а с этими ложными заключениями мы идём в неправильных направлениях, в следствие чего страдает жизнь и знания. Наш прогресс не идёт стройным порядком поиска истины, потому что чистые случайности играют в нём слишком важную роль.

    До недавнего времени мы считали логику наукой правильного мышления, однако, современная мысль развилась настолько, что старой логикой не удаётся справляться с накопленным объёмом, – с огромной, сложно организованной массой существующих идей и фактов – поэтому нам придётся искать новый инструмент, более целесообразный и эффективный. Нам не понадобится создавать новую науку на замену логике; нам следует лишь внимательнее всмотреться в имеющиеся науки и осознать факт, с которым мы жили всё это время, конкретно тот факт, что математика и математическое мышление представляет собой ничто иное как настоящую логику природы – универсальный язык природы – и одно средство выражения, одинаковое для всех народов.

    Я не выражаюсь иносказательно, а высказываю факт, который по должному исследованию, должен признать каждый. Любой желающий мыслить логически, должен либо мыслить математически, либо оставить попытки мыслить правильно. Избежать этого не получится, и всякий, кто отказывается исследовать правомерность этого высказывания, ставит себя вне поля логически мыслящих людей. Применение строгого мышления к жизни произведёт революцию научных методов внедрением правильных определений, правильных классификаций, правильного языка и тем самым поведёт к надёжным результатам. Скорее всего, все наши доктрины и вероучения придётся пересмотреть; некоторые отбросить, некоторые исправить, некоторые расширить, чтобы добиться единогласия во всех науках, значительно повысив этим эффективность поисков истины. Такое применение математики к жизни произведёт революцию даже в самой математике. В Приложении Ⅰ ([Ⱉ](https://teletype.in/@czoc/K5djgs3fhAL)) я кратко подал идеи того, как этого удалось бы достичь.

    Учитывая, что, по-видимому, высшей экспериментально известной энергией становится человеческая время-связующая энергия, эта новая концепция может привести к изменениям в наших нынешних концепциях материи, пространства и времени, подобно тому как на них повлияло открытие радия. Эту проблему получится решить только ·_научными_· экспериментами со ·_время_·-связующей энергией.

    Во многих, даже в большинстве, случаев анализ этих явлений составляет техническую трудность, но зачем путать себя в страхе, или в рабстве, у слов?

    Если бы мы называли вино не вином, а его химической формулой, изменило бы это каким-либо образом качество вина?

    Конечно, нет. Все «качества» остаются, потому что представляют факты, и не поддаются изменениям с помощью слов.

    Самую жалкую картину разрушения и хаоса, которые неправильное применение слов несут в жизнь и науку, мы наблюдаем во всех сферах мыслительной деятельности на примерах бесконечных ожесточённых споров о плохо определённых словах. Математикой удалось осуществить самые выдающиеся достижения благодаря её методу точного анализа континуума, измерений, классов, отношений, функций, трансфинитных чисел и т. д., а также пространства и времени. По сей день не все эти концепции в своей чётко определённой форме применяются прямо к нашей повседневной жизни или к нашей концепции мира. Мысли, которыми я поделился в Приложении Ⅰ, могут указать на это «недостающее звено» – соединяющее математику с жизнью.

    В современной науке мы знаем, что все энергии могут каким-то образом преобразовываться из одного типа в другой, и что все они представляют один тип энергетических явлений, независимо от источника каждого. Например, гальваническая или химическая батарея производит такое же электричество, какое производит механический процесс трения или взаимодействие космических законов как в генераторе. В некоторых случаях, когда мы адаптировали системы должным образом, преобразования удаётся обратить, иными словами, энергия становится химическим процессом – аккумулятор; химический процесс становится электричеством – генератор; электричество приводит к движению – электродвигатель и т. д. Мы знаем, что все энергии состоят друг с другом в каких-то отношениях, потому что они могут преобразовываться. Эффекты, производимые одинаковым типом энергии, не отличаются – независимо от её источника. Чудо электрической лампы составляет то же чудо, когда электричество имеет химическое, механическое или космическое, как в генераторе, происхождение.

    Эксперименты в научной биологии показывают, что это же происходит у живых организмов, и в этом заключается колоссальная важность открытий в научной биологии. Свет и другие энергии воздействуют на организмы так же как химические реакции, и эти явления поддаются обращению. К этому, удалось произвести живые сложные организмы, которые полностью развивались, с помощью химических или механических воздействий на яйцо, и это удалось осуществить на самых ранних этапах развития научной биологии. (См. ·_Организм как целое_· Жака Лёба.)

    Все явления в природе ·_естественны_· ⁅·_природны_·⁆, и к ним следует относится как к ·_таковым_·. Человеческий разум составляет, по меньшей мере, энергию, которая может направлять другие энергии. Мы ошибаемся и ведём себя по ложным путям, называя его ·_сверх_·ъестественным. Мы, конечно, не понимаем природу человеческого разума полностью; мы научимся её понимать тогда и только тогда, когда наберёмся здравого смысла, чтобы осознать его ·_естественность_·. Если мы настаиваем на том, что «духовные ⁅умственные⁆ свидетельства нельзя объяснить на материальных основаниях», то это утверждение должно быть в равной степени применимым к электричеству или радию. Если это высказывание ложно по отношению к этим явлениям, то оно равно ложно по отношению к разуму и к так называемой духовной силе или силе воли.

    Научное понимание этих явлений не «испортит» их, ·_потому что это невозможно_·. ·_Факты остаются фактами, и никаким научным объяснением явления нельзя низвести то, что есть факт_·. Электричество есть электричество и ничего больше, независимо от его происхождения. Человеческие время-связующие энергии (охватывающие все способности) представляют собой высшие из всех известных энергий, независимо от их основания. Их научное понимание только ·_укрепит_· наше уважение к ним и к самим себе. Оно, вне всяких сомнений, поможет развивать их неограниченно с помощью математического анализа. «Основание» не есть явление – серная кислота и цинк ·_не есть_· электричество; время-связующие энергии ·_не есть_· полкило жареной говядины, хотя полкило жареной говядины может помочь спасти жизнь, ·_стать одним из факторов_· написания стихотворения или сонаты, однако никоим образом мы не можем принять эту говядину за тот или другой случай.

    Я попытался – думаю, с некоторым успехом – решить эти проблемы в науке и жизни. Результаты поражают, потому что ведут нас к гораздо более высокой этике более широкого охвата, чем мы когда-либо практиковали в обществе. Этим анализом я подтверждаю, что понимание этого колоссального, но ⬩**природного**⬩ явления человеческой жизни ведёт нас к научному источнику этики, и что так называемые «высшие идеалы человечества» не содержат в себе ничего «сентиментального» или «·_сверх_·ъестественного», а составляют ·_осуществление естественных законов человеческого класса жизни_·. Признание того, что явления человеческого разума естественны, и что они следуют естественному закону, даёт и другое преимущество в сравнении со взглядом на них как на «сверхъестественное» относительно того, что мы не можем обойти закон человеческой природы, как не можем обойти закон притяжения; иными словами, человеческая этика получит силу закона природы.

    Фактор сверхъестественного во взгядах позволял легко убежать от решения жизненных проблем, лишь сказав:

    ⬩‹⬩  
    Я не верю.  
    ⬩›⬩

    Этого хватало, чтобы освободиться от оков «сверхъестественной морали». Однако убежать от «естественной морали», и при этом ·_остаться_· ⬩**человеком**⬩ – ⬩**невозможно**⬩. В условиях искусственно сформулированной морали, от неё получалось уйти, просто умственно порассуждав, оставаясь довольным, покуда удавалось избегать тюрьмы. С моралью, прояснённой как ⬩**естественный закон**⬩ ⁅⬩**закон природы**⬩⁆ человеческого класса жизни, завеса софистики и догадок рассеится, и каждый, ушедший от ⬩**естественного закона для людей, будет сам знать, что он вне закона – для людей**⬩.

    Инженеры не поступают как метафизики. Они действуют в среде не острых доводов, а подтверждённых фактов. Они работают не для того, чтобы заполнить воздух клубами словесных выражений или софистики, а для того чтобы производить. Они руководствуются научным методом и применяют математику.

    Мы знаем, что в далёкие времена в некоторых храмах электрическими явлениями пользовались, чтобы удерживать невежественную толпу в благоговейном страхе и послушании.

    Последуем ли мы методам тех фокусников, или взглянем прямо на факты?

    Посмотрим ли мы на жизнь и на то, что мы привычно называем умственными, духовными явлениями и т. д. как на ·_сверх_·ъестественные, просто потому что не понимаем их?

    Видится ясным, что всё ·_существующее в природе_· – ·_естественно_· ⁅·_природно_·⁆, независимо от простоты или сложности явления; и никогда так называемое «·_сверх_·ъестественное» не может быть чем-то иным, чем всецело естественным законом, несмотря на то, что на данный момент мы можем его не понимать. Признание ·_сверх_·ъестественного слепит взгляд и препятствует любой попытке анализа. Непредвзятый анализ так называемого «сверхъестественного» никак не ·_меняет_· его странные и высокие функции. Явления человеческой время-связующей энергии есть и останутся самыми ценными, тонкими и высшими из известных функций, независимо от их происхождения. ·_Факты_· не получится ·_отрицать_· или ·_искажать_·, если анализом удалось прийти к правильным заключениям. Высокая размерность человеческого разума, так называемые силы духа и воли ·_представляют собой факты_· и как таковые их следует ·_принимать_·. Нам пора построить точную науку, чтобы с ними работать.

    Мы подходим к проблемам животной жизни без предрассудков; никакая «искра» сверхъестественного нас не тревожила в нашем анализе – мы смотрели на животное как на животное, мы не смешивали измерения, и тем видели, что «социальная структура» животных на ферме не разрушается, потому что с ними обращаются на научных основаниях, с должным пониманием ·_их_· стандартов. Сегодня животные живут счастливее людей. Мы не позволяем животным практиковать слишком разрушительное «выживание наиболее приспособленного» или «конкуренцию». Наша нынешняя социальная система налагает эти катастрофические методы только на человека, в результате чего пословица Homo homini lupus становится реальностью.

    Мы не испытываем недостатка фактов в современной науке. С ними остаётся лишь ознакомиться. Если взять, например, серную кислоту и цинк, и сделать то, что мы называем гальванической батареей, мы увидим, что из двух химических веществ образуется третье, – соль – в придачу к которому производится особенная энергия, называемая электричеством.

    Кто не знает чудесных свойств этого явления?

    В научной биологии мы далеко продвинулись за последнее время. Инженеры не могут позволить себе игнорировать факты, установленные в лабораторных исследованиях. Проблему «жизни» и других энергий, до сего времени считавшихся «·_сверх_·ъестественными», мы видим чётко. Она поражает, несмотря на свою всецелую естественность. Учёные по всему миру работают над этой проблемой, а научные факты, которые они констатировали, и которые теперь не получится отрицать, перешли сегодня в сферы практической жизни. Инженерам, конечно, следует знать эти факты; математикам следует установить правильные измерения в изучении всех этих наук; а людям придётся изучать математическую философию – только тогда процесс внедрения на каком-либо этапе мышления удастся осуществить без ошибок. Если мы хотим ·_истины_·, избежать этого не получится.

    Здесь, однако, может возникнуть возражение, к которому некоторые отнесутся очень серьёзно.

    Конкретно, что займёт место прежней философии, права и этики, если мы примем человеческую жизнь как не более чем физико-химический процесс?

    Ответом послужит цитата из Механистической концепции жизни Жака Лёба:

    ⬩«⬩  
    Если на основании серьёзного исследования, на этот вопрос (·_о том, что все явления жизни получится однозначно объяснить с физико-химической точки зрения_· – автор) мы можем ответить утвердительно, то нашу социальную и этическую жизнь придётся поставить на научное основание, а наши правила поведения привести в гармонию с результатами научной биологии.  
    ⬩»⬩  
    (с. 3)

    ⬩«⬩  
    Механистическая концепция жизни видится не просто совместимой с этикой, а единственной концепцией жизни, которая может привести к пониманию источника этики.  
    ⬩»⬩  
    (с. 31)

    Я надеюсь, что показал в этой книге, что ·_научная_· этика основывается на естественных законах человеческого класса жизни – на экспериментально подтверждённом факте, что человек есть время-связующий: естественно действующий, будучи таковым, во времени – и что эту концепцию или определение человека мы формулируем строго научно, и объясняем ей высшие функции человека – высшие умственные и духовные совершенства – без необходимости прибегать к гипотезам о «·_сверх_·ъестественном».

    Научной биологией подтверждается факт, что жизнь и все её явления представляют собой результаты некоторых физико-химических процессов, которые проявляются какими-то особыми энергиями, из которых человеческий разум мы знаем как наивысшую форму. Мы знаем, что эти процессы поддаются обращению. Некоторые из этих особых энергий вызывают физико-химические изменения в собственном основании. Происходящий процесс я предлагаю назвать биолизом, а производимое вещество биолитом.

    У этих процессов существует параллельный аналог в неорганической химии, – в электричестве – который отличается только масштабом или измерением. Если пропустить электрический ток через специальную батарею, называемую «аккумулятор» или «обратимая батарея», происходят химические изменения, при которых формируются новые соединения, обладающие способностью к обращению; конкретно, к воспроизводству прежних материалов – то есть, генерируется электричество. Этот процесс формирования химических веществ называется «электролиз», а произведённое таким спобом вещество «электролит».

    Вместе с этим, мы знаем, что в органической химии всё происходит бесконечно сложнее и разнообразнее, чем в неорганической. Следовательно, энергия, производимая реакциями каких-либо органических химических групп происходит сложнее и относится к иному измерению. Одна из этих энергий органической химии, которая не так давно попала под научный анализ, называется жизнью. Её физико-химической основой служит протоплазма, ·_результат_· которой я называю «время-сцепляющей» способностью или энергией. Этому названию следует придать важность, учитывая последствия, к которым оно позднее приведёт.

    Время-связующая способность или энергия человека (независимо от того, что время есть, и есть ли оно), уникальная для него, представляет собой самую тонкую сложную организацию. Мы знаем о ней как о наивысшей энергии. Она, вероятно, обладает множеством подразделений.

    Уши проявляют чувствительность к колебаниям воздуха. Глаза проявляют чувствительность к более тонким колебаниям света. Подобным образом, время-связующее устройство проявляет чувствительность к самым тонким энергиям, и помимо этого обладает способностью распознавать не только все наши чувства, но и время-связующие энергии других людей. Оно также, по всей видимости, обладает способностью распознавать энергии вселенной.

    Здесь мы видим ту же последовательность явлений: протоплазма как сложное органическое физико-химическое целое, которая провляет особенность «жить», расти и размножаться «автономно». Этой же автономной особенностью ·_проявляется время-связующая энергия_·; она растёт и размножается «автономно» в собственном измерении. Время-связующая энергия представляет собой сложную лучистую энергию, подобную излучению радия, которая тоже, вероятно, обладает множеством разных подразделений.

    ·_Следует заметить, что преобразование атома_· или преобразование ·_радиоактивных веществ по прохождению разных стадий не завершается, а останавливается на свинце, тогда как преобразование, которое происходит при производстве время-связующей энергии, завершается или почти завершается, и представляет собой то, что я называю время-связующей энергией_·. (·_См. Приложение Ⅰ_·.)

    Все высшие характеристики человека, которые мы привычно называем «силами разума, духа и воли» и т. д., охватываются этим точным определением энергии – способностью ко время-связыванию. Лушим образом последовательность, эволюцию и механизм этой время-связующей энергии поможет объяснить диаграмма.
""".trimIndent()

val appendix_2_text_2 = """
    ·_C₁_· обозначает физико-химическое основание (для простоты я представляю весь комплекс как одно основание) человеческой время-связующей энергии.

    ·_T₁_· обозначает мысль, произведённую физико-химическим процессом (соответствующим – только ради примера – электричеству, производимому гальванической батареей).

    Мысль ·_T₁_·, в свою очередь, производит физико-химический эффект ·_E₁_· на основании ·_C₁_· (соответствующий – по той же причине – электролизу и электролиту в электричестве).

    ·_C₁_· и ·_E₁_· вместе или ·_C₂_· производят ·_T₂_·, которая, в свою очередь, вновь воздействует на основание и производит физико химический эффект ·_E₂_·.

    Это новое сочетание производит ·_T₃_· и так далее … теоретически без предела, покуда остаётся ·_какой-либо источник_· энергии, из которого эта особая энергия может черпать. В этой теории, которую я называю спиральной теорией, я представляю предположительный механизм время-связующей энергии. Она согласуется с новейшими научными открытиями. Она объясняет процессы всех умственных и так называемых духовных энергий, которые оставались для человечества загадкой. Она также объясняет другие явления, которым до настоящего момента не находили научных объяснений.

    Животные ·_не_· связывают время. Они ·_не_· обладают способностью «спирали». Следовательно, они не прогрессируют автономно. Вместе с этим, мы видим, что, если мы учим человека ложным идеям, мы серьёзно воздействуем на его время-связующие способности и энергии тем, что неправильно воздействуем на физико-химическое-основание. Эта энергия отличается тем, что она принимает – я позволю себе старое выражение – высшие идеалы (когда нормальной работе время-связующей энергии ничего не препятствует), но также самые преступные идеи (когда время-связующей энергии препятствуют ложные учения, от чего она работает ненормально). Мы не можем сделать животных моральными или аморальными, потому что они не обладают время-связующей способностью, тогда как человеческий прогресс поддаётся серьёзному воздействию; иными словами, биолит ложных учений в животном измерении сильно отличается от биолита правильных идей в человеческом измерении.

    Природу или законы природы, к счастью, не получится обойти или нарушить полностью – время-связующую энергию не удастся полностью подавить во время-связующем классе жизни. Ложные учения о том, что мы есть животные и в сущности ведём себя по-зверски и эгоистично, конечно, низводят человеческую природу не просто на уровень животного, но даже ниже.

    К счастью, наукой мы можем объяснить и показать основательно зловредные эффекты этих учений в жизни и развитии человека. Те, кто преподают, проповедуют и практикуют животные стандарты и на том же дыхании противоречат себе в любых разговорах о «бессмертии» и «спасении», сильно удивятся. Много раздумий не требуется, чтобы стало ясно как день, что «животные стандарты» и «спасение», или «бессмертие», попросту друг друга исключают. Осознав закон время-связывания, мы откроем себе путь к научной работе над проблемой бессмертия. Время-связующие энергии, как и «жизнь», следуют экспоненциальной функции одного типа.

    ⬩«⬩  
    Постоянный синтез конкретного материала из простых соединений не-конкретного характера составляет главное свойство, которым живая материя отличается от неживой….  
    (с. 29)

    Эта проблема синтеза ведёт к предположению о бессмертии живой клетки, потому что мы не видим ·_a priori_· причины, по которой этот синтез мог бы сам по себе остановится, покуда доступным остаётся достаточно пищи, и внешние физические условия не обещают меняться….  
    (с. 30)

    Идея о естественном бессмертии клетки, которая умирает только от серьёзных травм, таких как длительный недостаток кислорода или слишком высокая температура, позволяет сделать такую проблему более различимой.

    Медицинский исследователь, который впервые осознаёт, что жизнь зависит от одного органа, – сердца – выполняющего свою функцию безостановочно на протяжении приблизительно семидесяти лет, отведённых человеку, поражается опасной неопределённости нашего существования. Я тоже нахожу поразительным то, что такому тонкому механизму приходится работать таким регулярным образом столько лет. Загадочность в связи с этим и другими явлениями адаптации, исчезла бы, если бы мы могли позволить себе достоверно заключить, что все клетки бессмертны, и что факт, требующий объяснения, представляет собой не продолжительную деятельность, а прекращение деятельности смертью.

    Таким образом, мы видим, что идея о бессмертии клетки тела, если мы можем её обобщить, может стать одной из главных опор для полного анализа явления жизни, потому что она делает живучесть организмов различимой….  
    (сс. 32–33)  
    ⬩»⬩  
    — Жак Лёб, ·_Организм как целое_·

    Перспективы тех, кто живёт, принимая эгоистичные, алчные, «пространство-связующие животные стандарты», не обещают многого, что мы видим на «спирали», но мы, к сожалению, не можем им помочь. Только время-связыванием – только выполнением естественных для человека законов – они могут извлечь пользу из своих естественных способностей, чем стать выше животных и их судьбы.

    Результаты, полученные в научных биологических исследованиях, растут стремительно, и каждый шаг вперёд в познании, подкрепляет эту теорию. Они расходятся в частностях не потому что мы ошибаемся в принципах этой теории, а потому что в них смешивают измерения и пользуются не определёнными должным образом словами, что всегда ведёт к путанице и сдерживает развитие науки.

    Обсуждение с математической точки зрения большинства вопросов в этом приложении основывается на лабораторных фактах. Стоит их собрать, и нам не понадобится воображение, чтобы увидеть их широкую значимость. Благодаря тому, что мы выяснили, что человек связывает время (независимо от того, что время есть), и внедрили фактор размерности в исследование общих явлений жизни, множество ранее неясных фактов сейчас проясняется.

    Я написал эту книгу на ферме без книг под рукой, и на тот момент отстал от научного прогресса на пять лет, проведённых на войне. Мой друг доктор Гроув-Корски, ранее работавший в Университете Бёркли, обратил моё внимание на книги доктора Жака Лёба. Я нашёл в них сокровищницу лабораторных фактов, которые как ничто другое наглядно демонстрируют правильность моей теории. Я узнал, к своей радости, что новая «научная биология» действительно научна, потому что в ней применяются математические методы с ощутимым учётом размерности – они не «доят автомобиль».

    Для математика и для инженера «теория тропизма в поведении животных», основанная Жаком Лёбом, представляет огромный интерес, потому что в этой теории анализируются функции и реакции организма ·_как целого_·, что исключает шанс спутывания идей или смешивания измерений.

    ⬩«⬩  
    Психологи по старым привычкам изучают реакции не всего организма, а отдельных сегментов; так называемых рефлексов. Построение реакций организма как целого из отдельных рефлексов может показаться оправданным, но такая попытка ведёт верно к неудаче, потому что реакций, вызываемых в изолированном элементе нельзя ожидать, когда тот же элемент приходится частью целому в силу того, что разные части организма взаимно воздействуют друг на друга торможениями в органической связи. Следовательно, выразить поведение целого животного алгебраической суммой рефлексов его отдельных сегментов не представляется возможным….  
    (сс. 21–22)

    Говорить о тропизме как о рефлексах – это ошибка, потому что тропизмы представляют собой реакции организма как целого, тогда как рефлексы относятся к реакциям изолированных сегментов. Рефлексы и тропизмы, тем не менее, согласуются, по меньшей мере, в одном – в том, что и первые и вторые, очевидно, носят чисто физико-химический характер.  
    (с. 23)  
    ⬩»⬩  
    — Жак Лёб, ·_Forced Movements – Tropism and Animal Conduct_·

    Я процитирую здесь всего несколько отрывков, но эти книги настолько важны, что каждому математику и инженеру следует их прочесть. Они представляют, если я могу так выразиться, «математическую биологию» – обзор длительного исследования «тропизмов», коими мы называем «невольные движения» организмов. Эти книги содержат квинтэссенцию лабораторных экспериментов, свидетельствующих об эффектах различных энергий, таких как свет (гелиотропизм), электричество (гальванотропизм), гравитация (геотропизм) и т. д., производимых на движения и действия живых организмов. Эти эксперименты демонстрируют это очень чётко, и заключения не получится упустить или проигнорировать. Значительных практических результатов такими научными методами удалось достичь, основываясь на двух принципах, конкретно:

    1 · Учёные должны мыслить математически, их исследования явлений должны состоять в «системах» как сложное целое, и им нельзя смешивать измерения.

    2 · Они должны видеть опасность и не бояться старых слов с неправильными значениями. Они должны применять чёткое и строгое мышление, чтобы избавиться от предрассудков в науке – от яда метафизических словесных догадок.

    В этих книгах приводится более чем достаточно свидетельств тому, как применяемые слова, которыми мы пользуемся, вводят в заблуждение и мешают видеть, и как учёные ошибаются в своих выводах, к которым пришли, применяя антропоморфические или теологические методы анализа. Если скептически настроенный или преисполненный сомнениями читатель хочет увидеть подробные свидетельства фатальности эффекта, который неправильные или не-математические способы мышления производят на науке и жизни, ему тоже стоит ознакомиться с этими книгами.

    Следующие цитаты служат свидетельствами того, что человек относится к совершенно иному измерению – представляет собой совершенно иное существо, в корне отличное от животного.

    Цитаты доктора Конклина я приведу только из его книги ·_Heredity and Environment_·; чтобы не повторять название книги, я укажу только его имя.

    (Весь ·_курсив_· добавил А. К.)

    ⬩«⬩  
    Я считаю крайне важным прямо показать, что ·_гомологические белки разных биологических видов отличаются_·. ·_Это уже сделали_· Райхарт и Браун. Кристаллографическими измерениями они показали, что гемоглобины любого биологического вида представляют собой определённые вещества, уникальные для этого вида….  
    (с. 64)

    Следующие высказывания Райхарта и Брауна, по-видимому, указывают, что это же мы можем заключить в отношении кристаллов гемоглобина:

    ⬩„⬩  
    ·_Гемоглобины любого биологического вида представляют собой вещества, уникальные для данного вида_·. Однако по сравнению соответствующих веществ у разных видов данного рода, мы обычно обнаруживаем, что они отличаются друг от друга в большей или меньшей степени. Отличия заключаются в том, что, когда мы имеем полные кристаллографические данные, мы ·_можем отличить_· разные ·_виды_· по этим ·_отличиям в их гемоглобинах_·….  
    ⬩“⬩  
    (с. 65)

    Факты, о которых сообщили до сего момента, наводят на заключение, что наследственность рода определяется белками определённого состава, отличными от белков других родов. Следовательно, этот состав белков, предположительно, обусловливает наследственность рода. Разные виды данного рода носят одинаковые родовые белки, но белки каждого вида одного и того же рода, по-видимому, вновь, отличаются по химическому составу. Из этого следует, что они могут вызывать определённые биологические или имунные реакции.  
    (с. 68)  
    ⬩»⬩  
    — Жак Лёб, ·_Организм как целое_·

    ⬩«⬩  
    ·_Все особенности, характерные для расы, биологического вида, рода, класса, типа, конечно, передаются наследственно_·, иначе не существовало бы постоянных характеристик этих групп, а мы бы не имели возможности классифицировать организмы. Основные характеристики каждого живого существа остаются неизменными в силу наследственности. Человек не собирает ни виноград в терниях, ни фиги в волчцах. Каждое живое существо производит себе подобное потомство: человек, лошади, скот, птицы, рептилии, рыбы; насекомые, моллюски, черви; полипы, губки, микро-организмы – все миллионы известных видов животных и растений отличаются друг от друга унаследованными особенностями, ·_потому что все они пришли от разных зародышевых клеток_·.  
    ⬩»⬩  
    — Эдвин Конклин, с. 65

    ⬩«⬩  
    Весь организм, состоящий из структур и функций, тела и разума, развивается из зародыша ⁅бактерии⁆, а организация данного зародыша определяет все возможности развития разума не в меньшей мере, чем тела, хотя действительная реализация какой-либо возможности также зависит от средовых стимулов. …  
    ⬩»⬩  
    — Конклин, с. 72

    ⬩«⬩  
    Разум развивается ·_параллельно телу_·, в каких бы отношениях ·_разум_· с телом ни состоял; разумных ·_сомнений_· в том, что они развиваются вместе из зародыша, мы не испытываем. Я нахожу любопытным то, что многие люди, которых серьёзно тревожит научное учение в отношении эволюции или постепенного развития человеческой расы, спокойно принимают универсальное наблюдение развития человеческого индивидуума – как тела, так и разума. Животное происхождение расы не тревожит религиозно верующих сильнее, чем происхождение индивидуума от зародыша, однако, последнее представляет собой универсально наблюдаемый факт, который не получится низвести в гипотезу или теорию, или успешно отрицать….  
    (сс. 32–33)

    Теперь мы знаем, что ребёнок происходит из клетки зародыша, не произведённой телами родителей, а появившейся в результате деления клетки-предка. ·_Каждая клетка происходит от существовавшей до неё клетки_· через процесс деления, а ·_каждая клетка зародыша происходит от существовавшей до неё клетки зародыша_·. Следовательно, мы не можем твёрдо заключить, что тело генерирует клетки зародыша, как не можем заключить и то, что душа генерирует души. Единственной возможной научной позицией видится то, что ·_разум_· или душа, как и тело, развиваются из ·_зародыша_·….

    Ни о каком факте в человеческом опыте мы не можем говорить более достоверно, чем о том, что разум развивается постепенными и естественными процессами из простого состояния, которое едва ли удастся вообще назвать разумом. Никакой факт в человеческом опыте не несёт большей практической и философской значимости, чем этот, и никаким же фактом обычно не пренебрегают чаще.  
    (сс. 33–34)  
    ⬩»⬩  
    — Конклин

    ⬩«⬩  
    Несомненно, элементы, из которых развивается ·_сознание_·, ·_присутствуют в зародышевых клетках_·, в том же смысле, в котором элементы других психических процессов или органов там присутствуют – не как миниатюры взрослого состояния, а скорее в форме элементов или факторов, которые длинной последовательностью соединений и преобразований от взаимодействия друг с другом и со средой дают начало полностью развитому состоянию….

    Я нахожу интересным то, что у человека, а также у некоторых животных, которые, как мы можем предположить, обладают чувством идентичности, нервные клетки, особенно клетки ·_мозга_·, ·_прекращают делиться_· в раннем возрасте; эти идентичные клетки остаются до конца жизни. …  
    (сс. 53–54)

    Не курица производит яйцо, а яйцо производит курицу, а так же другие яйца. Индивидуальные характеристики не передаются курицей яйцу, а развиваются из зародышевых факторов, которые передаются ·_клетками клеткам и из поколения в поколение_·….

    Зародыш представляет собой неразвитый организм, формирующий связь между следующими друг за другом поколениями. Человек представляет собой развитый организм, который вырастает из зародыша под влиянием условий среды; человек развивается и умирает в каждом поколении. Зародышевая плазма функционирует как непрерывный поток живого вещества, соединяющего поколения. Человек питает и защищает зародыш и в этом смысле выполняет роль носителя зародышевой плазмы – ·_смертного попечителя_· бессмертного вещества.  
    (с. 125)  
    ⬩»⬩  
    — Конклин

    Вот это я называю время-сцеплением. (Автор.)

    ⬩«⬩  
    За счёт интеллекта и социального сотрудничества он может контролировать среду в своих целях, что у других организмов не представляется возможным….

    Другие животные развиваются значительно быстрее человека но их развитие подходит к концу раньше. Дети низших рас человека развиваются быстрее детей высших рас, но в таких случаях они тоже прекращают развиваться в раннем возрасте. Увеличение длительности периода младенчества и незрелости у человеческой расы значительно повышает важность среды и обучения как ·_факторов развития_·.  
    ⬩»⬩  
    — Конклин (с. 250)

    Дополнительные сведения о «спиральной теории». (Автор.)

    ⬩«⬩  
    В образовании нам странным образом не удаётся разглядеть цели и методы. Любое образование, ведущее к формированию привычек праздности, безответственности, неудачи, нежели трудолюбия, строгости и успеха, вредит. Любой религиозный или социальный институт, ведущий к привычкам набожных выдумок, притворства, рабского отношения к авторитету и пренебрежения свидетельствами, нежели искренности, открытости и независимости, вредит….  
    (с. 252)

    Всем, что человек собой представляет сейчас, он стал без человеческого руководства. Учтя, что эволюция от амёбы до человека прошла без вмешательства человека, и что обезьяно-подобные люди развились в самые высоко-цивилизованные расы без осознанного человеческого контроля, мы можем задать вопрос:

    Можем ли мы усовершенствовать естественный метод эволюции?

    Возможно, мы не можем усовершенствовать метод эволюции, но разумными действиями можем этот метод обеспечить. ·_Человек не может изменить ни один закон природы, но может поставить себя в такие отношения с природными законами, за счёт которых ему удастся извлечь из них пользу_·.  
    (с. 292)  
    ⬩»⬩  
    — Конклин

    Это подкрепляет важность ⬩**знания естественных законов**⬩ и осознания естественных время-связующих импульсов для человеческого класса жизни, потому что только тогда спираль даст логарифмическое накопление правильного типа; в ином случае, биолит останется «животным» как по веществу, так и по эффекту. Как появился первый «время-связующий», здесь не играет существенной роли; важнейшую роль играет то, что он относится к другому измерению.

    ⬩«⬩  
    От песков до звёзд, от масштабности вселенной до мизерности электрона в живых существах, не меньше, чем в безжизненных, мы научно выявляем всюду неизбежную последовательность причины и следствия, универсальность естественных процессов, господство закона природы. ·_Человек тоже есть часть природы, часть великого механизма_· вселенной, и всё, чем он является и что ·_делает, ограничивают и предписывают законы природы_·. Каждое человеческое существо обретает существование через процесс развития, каждый шаг которого определяется предшествующими причинами….

    Наши анатомические, физиологические, психологические возможности предопределили ·_зародышевые клетки_·, из которых мы пришли.  
    ⬩»⬩  
    — Конклин (с. 321)

    Это показывает важность того, что, исследуя человека, мы должны придерживаться его размерности, а также важность выявления ⬩**беспристрастных естественных законов**⬩ для человеческого класса жизни. Теперь мы можем осознать, что так называемые человеческие идеалы представляют собой ничто иное, как непрерывно растущее осуществление ⬩**естественных «время-связующих» законов**⬩. Это понимание позволит человеку открыть новые «время-связующие» законы для своего поведения, своих деловых отношений, своего государства, не противоречащие настоящим, ⬩**естественным законам**⬩, а согласованные с ними. Тогда и только тогда человеческий прогресс получит шанс идти мирно.

    ⬩«⬩  
    Взрослые характеристики потенциальны, нежели действительны в зародыше, а их действительное появление зависит от многих сложных реакций зародышевых единиц друг с другом и со средой. Говоря кратко, наши личности не предопределяются в зародышевых клетках, но в них предопределяются наши возможные личности….  
    (с. 324)

    Среда оказывает особенно значительное влияние на умы и моральные устои людей. Наши привычки, слова, мысли; наши стремления, идеалы, радости; наша ответственность, мораль, религия в значительной мере становятся результатами среды и образования наших ранних лет….  
    (сс. 326–327)

    Благодаря этим гораздо более развитым способностям памяти, рефлексов и торможений человек становится значительно более свободным в сравнении с любым животным. Животные, которые мало чему учатся на опыте, обладают скудной свободой, и чем большему они учатся, тем свободнее становятся….  
    (с. 330)  
    ⬩»⬩  
    — Конклин

    Здесь мы можем добавить, что «спиральная теория» объясняет, как мы самостоятельно можем ускорять и развивать свои реакции, и как мы в действительности можем управлять своими судьбами.

    ⬩«⬩  
    Раз мы не можем подыскать места в нашей философии и логике для самостоятельности, следует ли нам прекратить вести себя научно и отвернуться от свидетельств?

    Первая задача науки состоит в том чтобы указывать на факты, и только потом разбираться с логикой и философией….  
    ⬩»⬩  
    — Конклин (сс. 337–338)

    Разбирать факты в рамках новой философии «Человеческой инженерии» не придётся с трудом.

    ⬩«⬩  
    Анализ инстинкта с чисто физиологической точки зрения, в конечном счёте обеспечивает нас данными для научной этики. Человеческое счастье обусловливается возможностью естественного, гармоничного удовлетворения инстинктов….  
    (сс. 196–197)

    Я нахожу удивительным, что нам до сих пор приходится подвергаться влиянию этики, в рамках которой мы считаем сами по себе инстинкты низостью, а их удовлетворение пороком. Мы можем понять то, что такая этика произвела успокаивающий эффект на жителей востока, инстинкты которых сдерживались или извращались сочетанием изнуряющего климата, деспотизма, тяжёлых экономических условий, и, вероятно, именно в силу неудовлетворительных экономических условий эта этика по-прежнему в некоторой степени преобладает….  
    (с. 197, сноска 1)

    Юристы, криминологи и философы нередко представляют, что человека заставляет работать только недостаток чего-то. Они ошибаются. Мы инстинктивно стремимся к деятельности подобно муравьям или пчёлам. Инстинкт трудовой деятельности служил бы богатейшим источником счастья, но наша нынешняя экономическая и социальная организация позволяет реализовать этот инстинкт только меньшинству.

    Роберт Мейер отметил, что любая успешная демонстрация или высвобождение энергии служит нам источником радости. Именно поэтому осуществление инстинкта трудовой деятельности играет такую важную роль в экономике жизни, в играх и обучении детей, а также в научной и коммерческой работе человека….  
    (с. 197)

    Мы можем по желанию преобразовывать инстинкты животных. Некоторых животных … которые избегают света, мы можем заставить двигаться к свету, во-первых, понизив температуру, и, во-вторых, повысив насыщенность морской воды, за счёт чего клетки животных теряют воду. Этот инстинкт удаётся обратить повышением температуры и понижением насыщенности морской воды.  
    (сс. 198–199)

    Я неоднократно выявлял, что инстинкты поддаются контролю с помощью тех же условий, которыми контролируются явления роста и организации. Это указывает на то, что оба класса явлений жизни имеют общее основание. Этим общим основанием служит физический и химический характер смеси веществ, которую мы называем протоплазмой….  
    (с. 199, сноска 1)

    ·_Высшего счастья в жизни_· получается добиться, только если ·_все инстинкты_·, включая инстинкт трудовой деятельности, удаётся поддерживать на определённой ·_оптимальной частоте_·. О том, что индивидуум может лишить ценности свою жизнь однобоким развитием, например, беспутным образом жизни, мы давно знаем. Теперь мы можем уверенно сказать, что ·э_кономические и социальные условия могут лишить ценности жизни большого числа индивидуумов_·.  
    (с. 233)

    Мы можем не сомневаться, что в наших нынешних социальных и экономических условиях более девяноста процентов человеческих существ ведут существование, ценность которого видится значительно ниже должной. Они вынужденно жертвуют некоторыми инстинктами, особенно самым ценным из них, – инстинктом трудовой деятельности – ради спасения самого низменного и насущного – питания.

    Если бы те, кто непомерно накапливает богатства, могли вывести свои жизни на должную частоту за счёт своего достатка, то, возможно, мы бы сочли рациональным позволять страдать большинству ради истинного счастья хотя бы некоторых. Однако для повышения уровня счастья нужно лишь столько денег, сколько их нужно для гармоничного развития и реализации унаследованных инстинктов. Для этого понадобится немного. Остальное пригодится человеку не больше, чем избыток кислорода в атмосфере. На деле удовлетворение мультимиллионер может получить от приумножения своего состояния, только за счёт реализации инстинкта трудовой деятельности или радости в связи с успешной демонстрацией энергии. Учёный получает это удовлетворение, не лишая ценности жизни других, и так должно быть и в случае бизнесмена….  
    (сс. 233–234, сноска 1)

    Мы не признаём метафизическую свободу воли, но не отказываемся от индивидуальной ответственности. Мы можем внедрить в память молодого поколения такие ассоциации, которые предотвратят дурные поступки и беспутный образ жизни….

    Жестокость уголовного кодекса и склонность к ужесточению наказаний чётко свидетельствуют о низкой цивилизации и о несовершенной системе образования….  
    (с. 234)

    Мне кажется, что мы можем ожидать, что нам удастся объяснить механизм ассоциативной памяти гистологическими методами или морфологическими методами, не более уверенно, чем того, что мы сможем объяснить динамику электрических явлений, изучая под микроскопом поперечные сечения телеграфного провода или пересчитывая и распределяя телефонные соединения в крупном городе.

    Если нам не терпится выработать подход к различным явлениям жизни, нам следует помнить, что коллоидные вещества представляют собой машины, которые их производят, однако, физика этих веществ пока остаётся наукой будущего….  
    (сс. 289–290)

    Физиология не даёт нам ответа на второй вопрос. Идею о конкретной энергии всегда считали конечной целью исследования органов чувств. Мах выразил мнение, что химические условия лежат в основе ощущений в целом….  
    (с. 291)  
    ⬩»⬩  
    — Жак Лёб, ·_Comparative Physiology of the Brain_·

    Здесь мы можем добавить, что «инстинкт трудовой деятельности» у животного класса становится инстинктом ·_созидания_· у класса время-связующего, и представляет он собой ничто иное, как выражение естественного импульса «время-связующей» энергии. В нынешней социальной и экономической системе очень немногие имеют возможность реализовать этот инстинкт. Научное управление отвечает, или может отвечать, требованиям реализации животного инстинкта трудовой деятельности, но не инстинкта созидания. «Время-связывание, в конечном счёте, и есть созидание, и человеку – время-связующему – подойдёт только такая социальная и экономическая система, которая восполнит этот недостаток – позволит осуществить этот естественный импульс – и даст ему расти в полную меру в работе и счастье.

    ⬩**Законы роста**⬩ (из книги доктора Луиса Карпински ·_Unified Mathematics_·).

    ⬩«⬩  
    ·_Функция сложных процентов_· – функция ·_S=P(1+i)ⁿ_· играет основательную роль в иных сферах, не только в финансовых. Рост древесины в большом участке леса мы можем выразить функцией такого типа, учтя предположение, что в большом участке скорость роста остаётся постоянной из года в год.

    В случае бактерий, растущих в культуре с идеальными условиями, ·_т. е._· при неограниченной пище, рост числа присутствующих бактерий в данный интервал времени идёт пропорционально числу бактерий, присутствующих в начале этого интервала.

    Любая функция, в которой скорость изменения или скорость роста в любой момент ·_t_· прямо пропорциональна значению функции в момент ·_t_·, следует тому, что мы называем законом органического роста, и можем выразить следующей формулой:

    ·_y=ceᵏᵗ_·

    где ·_c_· и ·_k_· участвуют как константы, определяемые действующими физическими фактами, а ·_e_· участвует как константа природы аналогичной π. Константа ·_k_· служит константой пропорциональности и становится отрицательной, когда данное количество уменьшается; ·_c_· обычно остаётся положительной;

    ·_e=2,178…_·.

    Значения функции от ·_x_·, ·_ceˣᵏ_·, ·_возрастают по членам геометрической прогрессии по мере того как переменная ·x· возрастает по арифметической прогрессии_·….  
    (с.423)

    Проще всего применить функцию, в которой рост пропорционален самой функции, удастся к воздуху. Понижение давления воздуха на расстоянии ·_h_· от поверхности земли пропорционален ·_h_·.

    В выражении
""".trimIndent()

val appendix_2_text_3 = """

    числовое значение давления приводится в миллиметрах ртути при ·_h_· измеряемой в метрах. Отрицательная экспонента указывает, что давление понижается по мере возрастания ·_h_·. Если измерять ртутный столб дюймами, а ·_h_· в футах, то
""".trimIndent()

val appendix_2_text_4 = """

    Об этом мы знаем как о законе Галлея.

    Рост фасоли в ограниченных интервалах и рост детей, так же в достаточно ограниченных пределах, приблизительно следуют закону органического роста. Распад радия следует тому же закону; скорость спада в любой момент остаётся пропорциональной количеству. В случае колеблющихся тел, таких как маятник, скорость снижения амплитуды согласуется с этим законом. Подобным образом, в случае стихание звука, а также в определённых электрических явлениях, скорость спада в любой момент остаётся пропорциональной значению функции в этот момент….  
    (сс. 426–427)

    ·_Кривая заживления раны_·

    Не так давно открыли закон, близко родственный формулам, выражающим закон органического роста, ·_y=eᵏᵗ_·, и закон ‘органического распада’, ·_y=e⁻ᵏᵗ_·. Он алгебраически уравнением и графически кривой соединяет площадь поверхностной раны со временем, выраженным днями, измеряемую с момента обеззараженного или стерильного состояния раны. По достижению этого обеззараженного состояния путём постоянного промывания обеззараживающими растворами, данные двух наблюдений в обычно четырёхдневный интервал дают нам „индекс индивидуума“. Этот индекс и два замера площади поверхностной раны позволяют врачу-учёному установить нормальный прогресс и ожидаемое сокращение её площади у данного индивидуума. Площадь раны тщательно отслеживается на кальке и подсчитывается на планиметре.

    Значения площадей раны наносятся на ось ординат, а соответствующие значения времени наблюдений, измеряемые днями, на ось абсцисс. После каждого наблюдения и вычисления площади, полученная таким образом точка наносится на ту же плоскость, и получается идеальная или прогнозированная кривая заживления.

    Когда измеренная площадь оказывается заметно больше, чем определённая идеальной кривой, это указывает на то, что в ране осталась инфекция…. Часто происходят удивительные ситуации, которым пока не находится объяснений, когда рана заживает быстрее, чем прогнозирует идеальная кривая; в этих случаях образуются вторичные изъявления, которые возвращают кривую к норме….

    Мы применяем математику в медицине во многом благодаря Алексису Каррелю из Рокфеллеровского института медицинских исследований. Он отметил, что чем больше составляет площадь раны, тем быстрее она заживает, и что скорость заживления состоит в пропорциональных отношениях с площадью. Константа пропорциональности не одинакова для всех значений поверхности, иначе у нас бы получилось следующее уравнение

    ·_S=S₁⁻ᵏᵗ_·

    где ·_S_· обозначает площадь в момент когда рану обеззаразили и начали замеры….

    Приведённые данные я взял из ·_Журнала экспериментальной медицины_· ⁅·_Journal of Experimental Medicine_·⁆; перепечатки предоставил майор Джордж Стюарт из Рокфеллеровского института. Диаграммы перепечатывали из выпуска от 1 фев. 1918, сс. 171 и 172. Статью написали доктор Т. Таффиер и Р. Десмаррес из больницы при учреждении 75, Париж….  
    (сс. 429–431)
""".trimIndent()

val appendix_2_text_5 = """
    Прогресс заживления поверхностной раны на правой ноге 31-летнего пациента. Кривая наблюдений колеблется относительно более плавной кривой вычислений.  
    (с. 429)

    ⬩_Волновое движение_⬩ Общие сведения — В природе существует два типа повторяющегося движения, определённым образом близко связанных математически, при которых повторение движения происходит на регулярных интервалах.

    При одном типе этого движения – мы можем сказать „циклическом“ – движение повторяется в одном месте, и осуществляется, в определённом смысле, стационарно. Камертон в движении снова и снова перемещается через одно и то же пространство; подобное перемещение мы наблюдаем в движении вибрирующей струны. Мы можем также вспомнить сердцебиение, пульс, дыхание, приливы, вращение колеса вокруг своей оси.

    Второй тип повторяющегося движения передаёт или несёт колебательный импульс через пространственный и, вместе с ним, временной диапазон. Подобный характер носят волны в море. Звуковые волны, электрические колебания или волны и колебания лучистой энергии передаются процессом, схожим с таковым перемещения волн в море.

    Оба эти типа движения мы можем представить математически с помощью уравнений с последовательностью тригонометрических функций. Мы обратим внимание на базовую функцию – ·_y=sin x_· – в следующем параграфе, а на простые применения в других параграфах этой главы….  
    (с. 407)

    Звуковые волны. — Свободный стержень камертона ноты До, приведённый в вибрацию, производит 129 полных перемещений туда-обратно за одну секунду. Перо, закреплённое на конце стержня, оставляет синусоидную кривую на равномерно передвигаемой закоптевшей бумаге. Эта кривая получается от стержня, вибрирующего 50 раз за 1 секунду.
""".trimIndent()

val appendix_2_text_6 = """
    Кривая ·_y=sin(50⨯2πt)_·.  
    Вибрация камертона, записанные на закоптевшей бумаге….  
    (с. 412)

    Согласованно с каждым перемещением вибрирующего стержня происходит перемещение воздуха. Когда стержень перемещается вправо, он сжимает слой воздуха справа от себя, и это ·_сжатие_· незамедлительно передаётся слою воздуха справа. Когда стержень перемещается обратно влево давление на находящийся рядом воздух ослабевает и происходит ·_разрежение_·. За ¹/₅₀ одной секунды прилегающий к стержню воздух ·_сжимается_·, возвращается к нормальному состоянию и ·_разряжается_·. В ходе этого соседствующий воздух подвергается воздействию, а сжатие передаётся на расстояние, которое составляет ·_длину волны_· данной звуковой волны. За 1 секунду это колебание передаётся на 1100 футов при температуре 44 °F. Таким образом, длина волны этой звуковой волны составляет ¹¹⁰⁰/₅₀=22 фута.

    Длину волны обычно обозначают буквой λ. Если ·_V_· обозначает скорость, а ·_t_· время одной вибрации, то ·_λ=Vt_·.
""".trimIndent()

val appendix_2_text_7 = """
    Записи вибраций, произведённых голосом: ā как в слове ate ⁅eɪ~эй⁆, aʊ как в слове about ⁅~áу⁆, r как в слове relay, ē как в слове be ⁅i~и⁆, ä как в слове father ⁅ɑ~а⁆. Запись камертона с частотой 50 в секунду даёт частоты вибраций….  
    (с. 413)

    Последний рисунок позволяет зрительно представить факт того, каким образом неправильные выражения и ложные учения препятствуют естественному прогрессу человечества. Каждое слово действует своей энергией и производит некоторые физико-химические эффекты во время-связующем устройстве, зависящие от идей, которые мы ассоциируем со звуком слова. Обучая ложным идеям, мы производим ненадлежащие физико-химические эффекты – иными словами, человек ⬩**не функционирует надлежащим образом**⬩; он не функционирует ·_естественно_· или ·_нормально_·, или сообразно человеческому измерению.

    Мы живём в цивилизации таких низких стандартов, потому что отравили – в прямом смысле – свои умы физико-химическими эффектами ошибочных идей. Этот правильный ⬩**естественный подход**⬩ ко время-связующим энергиям позволит чётко увидеть неизмеримую важность того, как мы обращаемся с этим тонким механизмом. Отравление ошибочными идеями, неосторожными или неправильными словами никак не отличается своими последствиями от отравления иным приводящим в ступор или неправильно стимулирующим ядом.

    ⬦⬦⬦ Монографии по экспериментальной биологии и физиологии ⬦⬦⬦
    -------------------------------------------------------------

    ⬩**Лёб Ж.**⬩ ·_Comparative Physiology of the Brain and Comparative Psychology_·. New York, 1900.

    ⬩**Лёб Ж.**⬩ ·_Studies in General Physiology_·. Chicago, 1905.

    ⬩**Лёб Ж.**⬩ ·_The Dynamics of Living Matter_·. New York, 1906.

    ⬩**Лёб Ж.**⬩ ·_The Mechanistic Conception of Life_·. Chicago, 1912.

    ⬩**Содержание**⬩  
    Ⅰ · Механистическая концепция жизни  
    Ⅱ · Значимость тропизмов для психологии  
    Ⅲ · Некоторые базовые факты и концепции в связи со сравнительной физиологией центральной нервной системы  
    Ⅳ · Паттерновая адаптация у рыб и механизм зрения  
    Ⅴ · О некоторых фактах и принципах физиологической морфологии  
    Ⅵ · О природе процесса оплодотворения  
    Ⅶ · О природе формативного обусловливания (искусственного партаногенеза)  
    Ⅸ · Предотвращение смерти яйца с помощью оплодотворения  
    Ⅹ · Роль солей в поддержании жизни  
    Ⅺ · Экспериментальные исследования влияния среды на животных

    ⬩**Лёб Ж.**⬩ ·_The Organism as a Whole_·. G. P. Putnam's Sons. New York, 1916.

    ⬩**Содержание**⬩  
    Ⅰ · Вступительные замечания  
    Ⅱ · Конкретное отличие живой материи от неживой и вопрос происхождения жизни  
    Ⅲ · Химическая осова рода и вида:  
    1 · Несовместимость родственных видов  
    2 · Химическая основа рода и вида, и специфики видов  
    Ⅳ · Специфика в оплодотворении  
    Ⅴ · Искусственный партаногенез  
    Ⅵ · Предопределённость в формировании организма из яйца  
    Ⅶ · Регенерация  
    Ⅷ · Определение пола, вторичные половые признаки и половые инстинкты:  
    1 · Цитологическая основа определения пола  
    2 · Физиологическая основа определения пола  
    Ⅸ · Менделевская наследственность и её механизм  
    Ⅹ · Животные инстинкты и тропизмы  
    Ⅺ · Влияние среды  
    Ⅻ · Адаптация к среде  
    ⅩⅢ · Эволюция  
    ⅩⅣ · Смерть и распад организма

    ⬩**Лёб Ж.**⬩ ·_Forced Movements, Tropisms, and Animal Conduct_·. J. B. Lippincott, Philadelphia, 1918.

    ⬩**Содержание**⬩  
    Ⅰ · Введение  
    Ⅱ · Отношения симметрии тела животного как отправная точка теории поведения животного  
    Ⅲ · Принуждённые движения  
    Ⅳ · Гальванотропизм  
    Ⅴ · Гелиотропизм; Влияние одного источника света  
    1 · Общие факты  
    2 · Прямое доказательство теории мышечного напряжения при гелиотропизме у подвижных животных  
    3 · Гелинтропизм одноклеточных организмов  
    4 · Гелиотропизм прикреплённых животных  
    Ⅵ · Аппарат исскусственного гелиотропизма  
    Ⅶ · Асимметрические животные  
    Ⅷ · Два источника света разной силы  
    Ⅸ · Обоснованность закона Бансена-Роско для гелиотропных реакций животных и растений  
    Ⅹ · Эффект быстрых изменений силы света  
    Ⅺ · Относительная гелиотропическая эффективность света разных длин волн  
    Ⅻ · Изменения в чувстве гелиотропизма  
    ⅩⅢ · Геотропизм  
    ⅩⅣ · Невольные движения вызванные движением изображений сетчатки: Реотропизм; Анемотропизм  
    ⅩⅤ · Стереотропизм  
    ⅩⅥ · Химиотропизм  
    ⅩⅦ · Термотропизм  
    ⅩⅧ · Инстинкты  
    ⅩⅨ · Образы памяти и тропизмы  
    · Список, включающий ·_554 книги по этой теме_·, в котором любой заинтересованный читатель найдёт кладезь точных знаний по данному направлению. Автор.

    ⬩**Конклин, Эдвин Грант**⬩: ·_Heredity and Environment in the Development of Men_·. Princeton University Press, 1915.

    ⬩**Содержание**⬩  
    Ⅰ · Факты и факторы развития  
    Введение  
    A · Явления развития  
    B · Факторы развития  
    Ⅱ · Клеточная основа наследственности и развития  
    A · Вводная информация  
    B · Зародыш  
    C · Механизм наследственности  
    D · Механизм развития  
    Ⅲ · Явления наследственности  
    A · Наблюдения наследственности  
    B · Статистическое исследование наследственности  
    C · Экспериментальное исследование наследственности  
    Ⅳ · Влияние среды  
    A · Относительная важность наследственности и среды  
    B · Экспериментальные модификации развития  
    C · Функциональная деятельность как фактор развития  
    D · Наследование или не-наследование приобретённых признаков  
    E · Применение в человеческом развитии: эвтеника  
    Ⅴ · Контроль наследственности: евгеника  
    A · Одомашненные животные и культивированные растения  
    B · Контроль человеческой наследственности  
    Ⅵ · Генетика и этика  
    · Глоссарий книг для тех, кто желает наиболее полно ознакомиться с темами наследственности и развития. Автор.

    ⬩**Morgan, T. H.**⬩, ·_Physical Basis of Heredity_·

    ⬩**East, E. M.**⬩, и ⬩**Jones, D. F.**⬩, ·_Inbreeding and Outbreeding_·, и т. д.

    ⬩**Parker, G. H.**⬩, ·_The Elementary Nervous System_·

    ⬩**Harvey, E. N.**⬩, ·_The Nature of Animal Light_·

    * * *

""".trimIndent()