package com.timebinding.manhoodofhumanity.book.data.local.markdown

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import dev.jeziellago.compose.markdowntext.MarkdownText

@Composable
fun appendix_1(modifier: Modifier) {
    MarkdownText(
        markdown = appendix_1_text,
        color = MaterialTheme.colorScheme.onSurface,
        style = MaterialTheme.typography.bodyLarge,
        modifier = modifier.padding(horizontal = 15.dp),
    )
}

val appendix_1_text = """
    # Приложение Ⅰ
    · Зрелость человечности ·, 2-е издание, А. Коржибски
    
    * * *
    
    Целью этого приложения я ставлю выразить несколько новых идей, исходящих напрямую из факта, что человек относится к классу время-связующих. Эти идеи могут послужить отправными точками основания ·_научной психологии_·. Выражение этой проблемы в той или иной форме представляет значительные трудности, и ещё сложнее её удастся выразить в какой-либо точной или корректной форме, поэтому я прошу читателя проявить терпение в отношении задействованного языка, потому что некоторые идеи сами по себе корректны и очень работоспособны, невзирая на язык.
    
    Мне особенно хотелось бы, чтобы математики, физики и метафизики прочли это приложение внимательно, снисходительно отнеслись к форме выражения и рассмотрели предложения, потому что научная психология – если такая наука появится – неизбежно станет дисциплиной физики. Я настоятельно прошу математиков и физиков не пропускать это приложение в поспешном суждении: ‹Ох, метафизика!›, – метафизиков не делать то же в не менее поспешном суждении: ‹Ох, математика!›. Если отнестись к этому приложению с пониманием, то математики и физики захотят исследовать обозначенную проблему. Если математики и физики отнесутся с большей терпимостью к метафизике, и, если метафизиков удастся побудить изучать математику, и те, и другие найдут для себя обширные области для работы.
    
    Некоторые учёные ведут себя очень педантично и в связи с своей педантичностью проявляют нетерпимость, говоря:
    
    ⬩‹⬩  
    Сначала следует научиться выражаться, а уже потом просить внимания.  
    ⬩›⬩
    
    Я отвечу, что мы имеем дело со слишком насущными, жизненно важными и фундаментальными для человечества проблемами, чтобы позволять себе откладывать обсуждение, – вероятно, на долгие годы – прежде чем я смогу представить тему в корректной и удовлетворительной форме, а также, что рассматриваемые проблемы охватывают слишком обширную область, в которой один человек не сможет произвести полноценных наработок. Наиболее подходящим видится представить эти новые идеи общественности, чтобы направить больше людей к более полной работе над ними.
    
    Старое слово «метафизика» видится незаконнорождённым ребёнком невежества; я считаю это слово ненужным в научном исследовании природы. Каждое явление природы удаётся систематизовать и изучить физикой, химией или математикой. Следовательно, проблема ни коим образом не состоит в чём-то ·_сверх_·ъестественном или ·_сверх_·физическом, а, скорее, относится к пока неизвестной или неразработанной физической дисциплине. Следовательно же, эта проблема может относится не к какой-то ·_новой_· науке, а к новой дисциплине математики, физике, химии и т. д., или ко всем вместе.
    
    Мне кажется плачевным то, что лишь после вечности человеческого существования удалось выявить размерность человека и присвоить ему должный статус в ·_природе_·, определив его как «время-связующего». Старой метафизикой, невзирая на её неточность, получилось многое осуществить. Нам не удалось достичь большего с помощью метафизики, потому что мы применяли не-математические методы, или, говоря яснее, потому что мы не могли понять важность измерений. В метафизике мы пользовались словами и концепциями много-мерных значений, что неизбежно привело к безнадёжной путанице, к «разговору» о словах, к пустой болтовне.
    
    Проясним это примером.
    
    Если бы мы говорили о корове, человеке, автомобиле и о паровозе как о «тягачах», и не пользовались в связи с ними никакими другими названиями, то что бы случилось?
    
    Если бы мы характеризовали эти вещи или существа только одной общей характеристикой, в частности способностью тянуть, это сказалось бы разрушительно на наших концепциях и на практической жизни; мы бы пытались доить автомобиль, или заправлять бензином корову, или искали бы гайки и болты в человеке, или позволяли бы себе догадки обо всех этих вещах.
    
    Это очевидно кажется бредом, однако, то же самое, но гораздо менее явно, происходит, когда мы говорим такие вещи как «жизнь в кристалле» или «память у животных». Мы тем самым умственно допускаем ошибку не менее бредовую, чем если бы говорили о «доении автомобиля».
    
    Простых людей слово «измерение» озадачивает. Они представляют, что измерения относятся только к трёхмерному пространству. Они ошибаются; движущийся объект находится в четырёх измерениях. Это означает, что он обладает тремя измерениями, как любой покоящийся объект, но когда он движется, нам требуется четвёртое измерение, чтобы присвоить ему ·_позицию_· в любой момент времени. Следовательно, мы видим, что движущийся объект обладает четырьмя измерениями и так далее. В научной психологии нам обязательно понадобится математика – специальная ·_очеловеченная_· математика.
    
    Можем ли мы произвести что-то подобное?
    
    Я думаю, что можем.
    
    Мы знаем, что естественные науки заставляют нас смотреть в лица фактам, требующим дальнейших теоретических разработок. Таким образом, естественные науки служат математикам постоянным источником вдохновения, потому что новые факты влекут за собой потребность в новых методах анализа.
    
    В этой книге мы выявили и проанализировали новый естественный факт. Факт этот заключается в том, что человечество относится ко время-связующему классу жизни, время-связующая способность или ⬩**энергия**⬩ которого работает как высшая функция человечности, включая так называемые умственные, духовные, волевые и т. д. силы. Слова «умственные», «духовные» и «волевые силы» я намеренно принимаю и употребляю в популярном, обыкновенном смысле и не подвергаю их дальнейшему анализу.
    
    Как только появляется слово и концепция ·_Время_·, основание для анализа становится скользким. Математики, физики и т. д. могут счесть, что данное выражение просто «хорошо подходит», и не увидеть необходимости присмотреться к нему получше, чтобы проанализировать. Теологи и метафизики, вероятно, займутся туманными рассуждениями о нём, оперируя неопределёнными терминами, бессвязными идеями, чем придут к не менее бессвязным результатам. Это не приведёт нас к научному или правильному решению, напротив, это не даст нам подобраться к открытию истины.
    
    Тем временем, два факта остаются фактами, в частности практически все математики и физики согласились с Минковским в том, что
    
    ⬩‹⬩  
    пространство само по себе и время само по себе, не происходят; существует только их полноценное смешение.  
    ⬩›⬩
    
    Другой факт – психологический – заключается в том, что ·_время_· существует психологически само по себе, неопределённо и непонято. Одна из основных трудностей состоит в том, что человеку приходится разбирать собственные суждения. Психологическое время как таковое, представляет собой наше человеческое время. Научное время как таковое тоже представляет собой наше собственное человеческое время.
    
    Какая из этих концепций представляется лучше другой?  
    Какая ближе сходится с истиной «времени»?  
    Что вообще есть время (если оно существует)?
    
    До настоящего времени мы прошли путь от «космоса» к «биосу», от «биоса» к «логосу», а теперь перед нами стоит факт, что «логос» – разум – и время-связывание состоят друг с другом в опасном родстве, или, возможно, вовсе друг от друга не отличаются.
    
    Не возвращаемся ли мы таким образом обратно к «космосу»?
    
    Эти ключевые вопросы возникают в связи с новой концепцией человека.
    
    Следует учитывать факт, что «принципы динамики мы сначала познали как экспериментально проверенные истины, но нам приходилось пользоваться ими как определениями. Сила по определению равняется произведению массы на ускорение; действие по определению равняется противодействию». (·_The Foundation of Science_·, Анри Пуанкаре). Всё основание математики тоже стоит лишь на нескольких аксиомах – «очевидных», но ·_психологических фактах_·.
    
    Следует заметить, что время-связующая энергия – одна из более высоких или высших энергий человека (во всяком случае, одно из её направлений; назовём его ·_М_·, чтобы выделить), когда она работает должным образом, – а именно математически – она ·_не_· работает ·_психологически_·, а ⬩**абстрактно**⬩: чем выше абстракция, тем меньшее место имеет психологическая составляющая, и тем большее место имеет, так сказать, чистая, беспристрастная время-связующая энергия (·_М_·).
    
    Определение человека как время-связующего – определение, основанное на фактах – заставляет о многом задуматься. Например, задуматься о возможности, что одна из функций время-связующей энергии в её чистой форме, в высочайшей абстракции (·_М_·) работает автоматически – будто механизм ·_корректно_· формирует результат своей деятельности; ·_истинно_· ли, это уже другой вопрос.
    
    В математике мы не предполагаем истинность наших выводов, но утверждаем их корректность; в этом заключается бесценность математики. Если подойти и проанализировать математические процессы как некоторое направление (·_М_·) процесса время-связывания, – которым они являются – это становится широко охватывающим фактом. Этот процесс сразу становится беспристрастным и космическим в силу действующего в нём аспекта время-связывания, независимо от того, что ·_время_· есть (если такая вещь как время вообще существует).
    
    Возвращает ли нас последовательность космоса, биоса, логоса, время-связывания прямиком обратно к космосу?
    
    Если мы поместим ·_психологические_· аксиомы в устройство время-связывания, оно проработает результаты ·_корректно_·, но ·_истинно_· ли, это уже другой вопрос.
    
    Чтобы у нас получилось поговорить об этих проблемах, мне следует ввести три новых определения, что я делаю исключительно в практических целях. Возможно, после некоторых переформулировок эти определения станут научными.
    
    Я попытаюсь определить «истину» и с этой целью разделю концепцию «истина» на три типа:
    
    ⬩1⬩ Психологическая, или личная, или относительная истина, под которой я подразумеваю такие концепции истины, какие есть у любого человека, но отличные от других типов истины (·_α₁, α₂ … αₙ_·).
    
    ⬩2⬩ Научная истина (_·αₛ_·), под которой я имею в виду психологическую истину, одобренную время-связующими советами или органами нынешнего этапа нашего развития. Эта научная истина представляет «связанное время» в нашем нынешнем знании.
    
    ⬩3⬩ Абсолютная истина, которая станет «окончательным определением» данного явления, основанным на окончательном знании «первопричинности», «применимом в бесконечности» (·_α₋∞₋_·).
    
    Для простоты я воспользуюсь знаками ·_α₁, ₂ … ₙ_· для обозначения «психологической», «личной», или «относительной» истин, отличия между которыми я пока не учту. Знаками ·_αₛ₁, ₛ₂ … ₛₙ_· я обозначу научные истины. Знаком ·_α₋∞₋_· я обозначу абсолютную истину, применимую в бесконечности.
    
    Чтобы упростить объяснения, я покажу свои предложения на примере. Предположим, что человеческие время-связующие способности или энергии в ·_органической_· химии соответствуют радию в ·_неорганической_· химии; они, конечно, отличаются измерениями и характером. Возможно, и, вероятно, именно так, что сложная время-связующая энергия проходит множество разных этапов развития и разных типов «лучей»: ·_A, B, C, … M_· ….
    
    Предположим далее, что так называемые умственные способности представляют собой лучи ·_M_· время-связующей энергии; «духовные» способности – лучи ·_A_·; «волевые» мощи – лучи ·_B_·; и так далее. Психологические истины, следовательно, становятся функцией всех вместе взятых лучей, а именно ·_A, B, C, … M …_· или ·_f (A, B, C, … M …)_·. Характер какой-либо «истины» под вопросом зависит от того, какая из этих стихий преобладает.
    
    Если бы мы могли полностью обособить «умственный» процесс – «логос» – лучи ·_M_· – и получить полную абстракцию (что сейчас мы можем сделать только в математике), то мы могли бы сравнить работу ·_M_· с работой беспристрастной машины, которая всегда выдаёт один и тот же ·_правильно_· оформленный продукт, ·_независимо_· от того, ·_какой_· материал в неё поместили.
    
    Мы знаем по факту, что математику применяют правильно, беспристрастно. По факту же, все аксиомы, лежащие в основе математики представляют собой «психологические аксиомы». Следовательно, возможно, эти «аксиомы» относятся не к типу ·_α₋∞₋_·, а к личному типу ·_f (A B C …)_·, и, возможно, поэтому математикой не получается объяснять психологические факты. Если мы хотим сделать психологию ·_точной наукой_·, нам следует сделать её математической в принципе. Следовательно, мы должны найти способ принять психологию в математику. Здесь я попытаюсь приблизительно описать способ это сделать.
    
    Я предупрежу, что выразить его правильно представляется очень трудной задачей, и попрошу математически осведомлённого читателя потерпеть формы и образы ради смысла или даже чувств в том, что я пытаюсь выразить. Чтобы уберечь чистых математиков от шока, я также предупрежу, что заменю слово «инфинитезимальные» словами «очень маленькие числа», слово «целые» словами «обычные числа», а слово «трансфинитные» словами «очень большие числа». Вместо слова «число» я по случаю воспользуюсь словом «величина», а под словом «бесконечность» буду иметь в виду «неограниченное».
    
    Математика основалась как целое или, скорее, началась с «психологических истин», аксиом об обычных числах и величинах, постижимых для чувств. Здесь, на мой взгляд, находится ядро всей проблемы. ·_Основой_· математики стала ·_f (A B C …)_·; ·_работой_·, или развитием, математики стала ·_f (M)_·; это служит причиной «призраков» в тени математики.
    
    ·_f (M)_· развилась из ·_основы f (A B C … M …)_· в чудесную абстрактную теорию, абсолютно правильную для обычных, очень маленьких и очень больших чисел. Однако правила, главенствующие над маленькими, обычными – или психологическими – и большими числами, отличаются. По факту, физический мир – психологический мир – состоит из очень больших чисел и из очень маленьких величин (атомов, электронов и так далее). Мне кажется, что, если мы хотим действительно понять мир и человека, нам придётся начать с начала, – с ·_0_· – после чего взять следующее очень маленькое число в качестве первого ·_целого_· или «обычного числа». Тогда старые целые, или обычные числа стали бы очень большими числами, а старые очень большие числа стали бы очень большими числами второго порядка и так далее. Такая пере-упорядоченная математика стала бы психологической математикой, а математическая философия стала бы философской математикой. В первую очередь – в первую же по важности – это бы произвело эффект ·_начала_· не где-то посреди величин, а в начале, или с предела «ноль», с «·_0_·» – с присущего «быть или не быть» – а рядом с ним находилась бы самая первая малая величина – физический и, следовательно, психологический континуум (я употребляю слова «физический континуум» так же как их употреблял Пуанкаре) стал бы математическим континуумом в новой философской математике.
    
    Эта новая дисциплина – философская, психологическая математика – стала бы всецело строгой, правильной и ·_истинной_· в придачу к тому, что, возможно, с её помощью мы смогли бы изменить или расширить концепции чисел, континуума, бесконечности, пространства, времени и так далее, чтобы они стали постижимыми для простых людей. Такая математика стала бы математикой для время-связующей психологии.
    
    Выше, чем математическая, философии не существует; тем не менее, мы можем перенести её на ещё более высокий порядок предложенным здесь способом и сделать её философской или психологической математикой. Эта новая наука, конечно, не поменяла бы обычную математику обычного назначения. Она стала бы специальной математикой для изучения человека, в которой мы бы работали только с «естественными целыми числами» (старыми инфинитезимальными) и большими числами разных порядков (включая обычные числа), но начинали бы с настоящего общего основания – с ·_0_·, и очень малого числа рядом с ним, которое бы послужило общим ·_постижимым_· основанием ·_психологическим_· и ·_аналитическим_· истинам.
    
    Этой новой философской математикой мы бы исключили концепцию «инфинитезимальных чисел» как таковых – ·_искусственную_· концепцию и как ·_концепцию_· не представляющую собой стихию ·_Природы_·. Так называемые ·_инфинитезимальные числа представляют собой настоящие целые числа Природы_·.
    
    В математике инфинитезимальные числа стали аналитической – «·_M_·» – время-связующей – необходимостью в силу нашей отправной точки. Я повторю, что такая перестановка нашей отправной точки не скажется на обычной математике обычного назначения; скорее, мы сможем построить новую философскую математику, строго правильную, в которой аналитические факты согласуются с психологическими фактами. Новой математикой мы придём не только к правильным результатам, но и к ·_истинным_· результатам. Учтя ·_обе_· концепции времени – научное время и психологическое время – мы сможем увидеть высокий потенциал практической применимости человеческой способности ко «время-связыванию» и распознать её как ·_функциональное_· название и определение того, что мы широко подразумеваем под человеческим «интеллектом».
    
    За счёт этого становится очевидным, что время (при любом понимании этого термина) каким-то образом состоит в близких отношениях с интеллектом – умственной и духовной деятельностью человека. ·_Всем, что мы знаем о «времени» мы объясним очень многое о Человеке, а всем, что мы знаем о Человеке, мы объясним очень многое о времени_·, если рассмотрим одни только ·_факты_·.
    
    В философской математике «призраки» в тени быстро преобразятся в доступные для осмысления факты. Самым важным, однако, представляется то, что, взяв ноль в качестве предела и следующую за ним очень маленькую величину в качестве настоящей отправной точки, мы получим математическую науку на естественной основе, в которой ·_правильные_· формулы станут также истинными формулами, и согласуются с психологическими истинами.
    
    Мы выяснили, что человек представляет собой экспоненциальную функцию, в которой время действует как экспонента. Если сравнить формулу органического роста ·_y=eᵏⁱ_· с формулой ·_PRᵀ_·, мы увидим, что они относятся к одному типу и что ·_закон органического роста_· применим к человеческой ·_время-связующей энергии_·.
    
    Мы также видим, что время-связующая энергия «·_живёт_·» и множится всё большими и большими родственными структурами. Формула распада радия указывает на то же, только с отрицательной, нежели положительной экспонентой. Этот факт вызывает любопытство и наводит на мысли. Размножение, органический рост, тоже представляет собой некую функцию времени. Я называю её «время-сцеплением» в целях различения.
    
    Можем ли мы объяснить энергию размножения или «время-сцепления» единицами химической энергии, принятой в пище, я не знаю. Я знаю о разуме – о «время-связующей» высшей экспоненциальной энергии, «способной направлять базовые мощи». Если мы проанализируем эту энергию, не позволяя себе догадок, мы обнаружим, что эта высшая энергия, каким-то прямым образом связанная со «временем» – независимо от того, что время есть – может ·_производить_· за счёт преобразований или черпая из других источников энергии новые неизвестные природе энергии. Таким образом, солнечная энергия, преобразованная в уголь, преобразуется, например, в энергию движения поршня или во вращательную энергию в паровом двигателе и так далее.
    
    Мы понимаем, что никакое количество ·_химической_· энергии в пище не может обусловить такую энергию как время-связующую энергию. Осталось одно предположение – о том, что источником своей колоссальной энергии время-связующему устройству служит ·_преобразование органических атомов_·, и – что очень характерно – результатами становятся ·_время_·-связующие энергии.
    
    Это предположение видится практически достоверным, потому что, по-видимому, только этим предположением получается объяснить эту энергию. Это предположение – при видимом отсутствии других – заставит нас взглянуть в лицо поразительным фактам; конкретно, на преобразование органических атомов, под которым предполагается черпание космической энергии. Эта космическая энергия – время – и разум каким-то образом связываются – если не приходятся друг другу эквивалентами.
    
    К счастью, мы можем проверить эти вещи в научных лабораториях. Радий открыли лишь несколько лет назад и его пока мало, однако, результатов науки и жизни у нас хватает, потому что научные методы мы применяли с пониманием применения. Мы пользовались не какими-то зоологическими или теологическими методами, а только прямыми, правильными научными методами. Мы не испытываем недостатка «человеческого радия», но, насколько я знаю, физики никогда не пробовали изучать эту энергию с такой точки зрения. Я уверен, что, стоит им начать, они получат результаты, которые позволят им научно осмыслить и осознанно применять все так называемые явления «сверхъестественного, духовного, экстрасенсорного» – исключая ложные заявления о таковых. Сейчас мы растрачиваем их без пользы или просто играемся с ними. Возможно, наукой человека – как наукой время-связывания – мы сможем открыть конечные тайны, конечную истину природы, применимую в бесконечности.
    
    Представляется трудным в такой книге как эта привести подходящий список литературы, с помощью которой читатель смог бы сориентироваться в развитии науки за последние несколько лет. Этой книгой, в своём роде, я прокладываю путь, поэтому пока книг конкретно на эту тему не существует. Фундаментальными для дальнейшего развития я вижу две научные дисциплины и одно искусство ⁅одну прикладную дисциплину⁆:
    
    1 математическую философию и  
    2 научную биологию
    
    Фундаментальным искусством я считаю творческую инженерию.
    
    В области математической философии я знаю только четверых выдающихся писателей, которые обращаются с этой темой как с чётко определённой наукой. Среди них двое английских учёных:
    
    Бертран Рассел и А. Н. Уайтхед;
    
    один француз –
    
    Анри Пуанкаре (покойный);
    
    и один американец –
    
    профессор К. Дж. Кайзер.
    
    Сообща Рассел и Уайтхед подходят к проблемам с чисто логической точки зрения, и в этом заключается ценность их работы. Анри Пуанкаре как физик (а также математик) подходил к этим вопросам в некоторой степени с точки зрения физика, что в силу обстоятельств делало его философию ценной по-особенному. Профессор Кайзер подходит к этим вопросам с логической и тёплой человеческой точек зрения, и в этом состоит значительная человеческая и практическая ценность его работы.
    
    Каждый из этих четверых учёных подходит к объяснениям и проработке математической философии уникально. Я не стану советовать, какие книги выбирать, потому что для основательного знания темы, читателю следует прочесть их все. Не все читатели пожелают вложить усилия в шаги на пути к ясному мышлению (что, между тем, останется ·_высшим_· приоритетом в науке). Кому-то захочется выбрать самому, и чтобы поспособствовать этому выбору, я приведу «меню» этого интеллектуального пиршества.
    
    По множеству временных причин, перед отправкой этой книги в печать, я не смог привести более полный список письменных трудов этих четырёх уникальных человек, но я считаю, что внимательно читать следует всякую бумагу, которой коснулось их перо, и, помимо этого, читать ценные труды, написанные об их работе.
    
    ⬩1⬩ Чисто математическое основание:
    
    ⬩**Рассел Бертран**⬩
    
    ·_The Principles of Mathematics_·. Cambridge University, 1903.
    
    (Я не привожу никаких выдержек из оглавления этой книги, потому что её, вне всяких сомнений, следует прочесть каждому заинтересованному в мамематической философии.)
    
    ·_The Problems of Philosophy_·. H. Holt & Co., N. Y., 1912.
    
    ·_Our Knowledge of External World, as a Field for Scientific Method in Philosophy_·. Chicago, 1914.
    
    ·_Introduction to Mathematical Philosophy_·. Macmillan, N. Y.
    
    Выдержки из оглавления:
    
    Определение числа  
    Определение порядка  
    Типы отношений  
    Бесконечные кардинальные числа  
    Бесконечные ряды и порядковые числа  
    Пределы и непрерывность  
    Аксиома бесконечности и логические типы  
    Классы  
    Математика и логика
    
    ·_Mysticism and Logic_·. Longmans Green & Co. 1919. N. Y.
    
    Выдержки из оглавления:
    
    Математика и метафизики  
    О научном методе в философии  
    Конечные составляющие материи  
    О понятии причины
    
    ⬩**Уайтхед, Альфред Н.**⬩
    
    ·_An Introduction to Mathematics_·. Henry Holt & Co. 1911. N. Y.
    
    ·_The Organization of Thought Educational and Scientific_·. London, 1917.
    
    Выдержки из оглавления:
    
    Принципы математики в преподавании основ  
    Организация мышления  
    Анатомия научных идей  
    Пространство, время и относительность
    
    ·_An Enquiry Concerning the Principles of Natural Knowledge_·. Cambridge, 1919.
    
    Выдержки из оглавления:
    
    Традиции науки.  
    Данные науки.  
    Методы широкого абстрагирования.  
    Теория объектов.
    
    ·_The Concept of Nature_·. Cambridge, 1920.
    
    Выдержки из оглавления:
    
    Природа и мышление  
    Время  
    Метод широкого абстрагирования  
    Пространство и движение  
    Объекты  
    Конечные физические концепции
    
    ·_Principia Mathematica_· в соавторстве с Бертраном Расселом. Cambridge, 1910–1913.
    
    Эта монументальная работа выдаётся среди остальных.
    
    ⬩«⬩  
    Как конструктивную критику этот труд пока никто не превзошёл. Для каждого, особенно для философов и исследователей в естественных науках, он станет удивительным открытием того, как знакомые термины, которые они рассматривают, укореняются глубоко во тьму под поверхностью здравого смысла. Он служит прекрасным примером действия критического духа науки и идеализма нашего времени.  
    ⬩»⬩  
    ·_Human Worth of Rigorous Thinking_·, с. 232. К. Дж. Кайзер.
    
    ⬩2⬩ Точка зрения физика:
    
    ⬩**Пуанкаре Анри**⬩
    
    ·_The Foundations of Science_·. The Science Press, N. Y., 1913.
    
    Выдержки из оглавления:
    
    Ⅰ Наука и гипотеза. Число и величина. Пространство. Сила. Природа.  
    Ⅱ Ценность науки. Математические науки. Физические науки. Объективная ценность науки.  
    Ⅲ Наука и метод. Наука и учёные. Математическое рассуждение. Новая математика. Астрономическая наука.
    
    ⬩3⬩ Человеческая, цивилизующая, практично-жизненная точка зрения:
    
    ⬩**Кайзер Кассий Дж.**⬩
    
    ·_Science and Religion: The Rational and the Super-rational_·. The Yale University Press.
    
    ·_The Human Worth of Rigorous Thinking_·. Эссе и обращения. Columbia University Press, 1916.
    
    Выдержки из оглавления:
    
    Человеческая ценность строгого мышления  
    Человеческая значимость математики  
    Стены мира – о форме и измерениях вселенной пространства  
    Вселенная и за её пределами  
    Существование гиперкосмического  
    Аксиома бесконечности: новая положение о мышлении  
    Исследования в американских университетах  
    Математическая результативность в Соединённых Штатах
    
    ·_Mathematical Philosophy, the Study of Fate and Freedom. Lectures for Educated Laymen_·. Книга готовится к выпуску.
    
    Выдержки из оглавления, представляющие общий интерес:
    
    Математический долг философии  
    Гуманистическое и промышленное образование  
    Логика как муза мышления  
    Светлые аспекты наземного мира  
    Подкрепляющее и опровергающее  
    Значимость и бессмыслица  
    Отличия логического от психологического  
    Проверка на подлинность гармонии  
    Отличия доктрины от метода  
    Теоретическое и практическое сомнения  
    Математическая философия в роли критика  
    Не критикованный мир – дьявольский сад  
    Мудрость «сверхпримата».  
    Автономные истинность и ложность  
    Другие виды истинности и ложности  
    Математика как исследование судьбы и свободы  
    Прототип разумного обсуждения, часто завуалированный, например, Провозглашение независимости, Конституция соединённых штатов, Происхождение видов, Нагорная проповедь.  
    Природа математического преобразования  
    Без преобразования нет мышления  
    В основе психологический закон преобразования  
    Отношение, функция и преобразование как три аспекта одной вещи  
    Исследование как общая инициатива науки  
    Статический и динамический миры  
    Проблемы времени и родственные ей  
    Импортация времени и супрессия времени как классические приёмы наук  
    Природа инвариантности  
    Вековая проблема перманентности и переменности  
    Завоевание подвержимого в мире волнений как связующая нить человеческой истории  
    Попытки товарищества среди инициатив человеческого духа  
    Концепция группы  
    Понятие, примеры которого приводятся во множестве дисциплин  
    «Разум» как группа  
    Философия космического года  
    Пределы и предельные процессы, вездесущие как идеалы и идеализация во всём мышлении и человеческом стремлении  
    Идеалы как кремень реальности  
    Математическая бесконечность; её динамические и статические аспекты.  
    Потребность в истории властной концепции.  
    Роль бесконечности в великой поэме  
    Значение размерности  
    Отличие воображения от концепции  
    Логическое существование и чувственное существование  
    Открытые пути в невообразимые миры  
    Теория логических типов  
    Её превосходное применение в определении человека и науки человеческого блага  
    Психология математики и математика психологии – обе в младенчестве  
    Последующее отставание науки  
    Симметрия мысли  
    Асимметрия воображения  
    Наука инженерии  
    Наука как подготовка инженерии  
    Инженерия как наука в действии  
    Математика как ориентир инженера  
    Инженерия как ориентир человечности  
    Человечество – цивилизующий или время-связующий класс жизни  
    Качества, необходимые в направлении инженерии  
    Этика искусства  
    Инженер как деятель образования, как учёный, как философ, как психолог, как экономист, как оратор, как мыслитель-математик – как Человек
    
    * * *

""".trimIndent()