The Manhood of Humanity, 2nd edition, A. Korzybski
=========
> **Materials on general semantics**  
<img src="graphics/icon.png" height="150">

---

<p align="center">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" height="500">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" height="500">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" height="500">
</p>

---

<a href="https://f-droid.org/packages/com.timebinding.manhoodofhumanity" target="_blank">
<img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="100"/></a>

## Materials

<a href="https://odysee.com/$/invite/@GS-RUS:f" target="_blank">Videos</a>

<a href="https://teletype.in/@czoc" target="_blank">Blog</a>

## Description

This work began with a functional definition of 'man', formulated in 1921, based on an analysis of uniquely human potentials; specifically, that each generation can start where the previous one left off. I called this characteristic the 'time-binding' capacity .... We no longer have to blind ourselves to the old dogmas about the 'immutability of human nature' because we have discovered that we can change it. We should realize our human potentials so that we can go to the future with some hope. Alfred Korzybski.

General Semantics (OS) was developed by Alfred Korzybski, a Polish engineer who settled in the United States after World War I. The death and destruction of war horrified him and prompted him to search for an answer to the question of how humans have been able to advance technologically so far, yet are unable to put their relationships in order. After researching this question for more than a decade, he formulated a general semantics, which he presented most fully in his book Science and Sanity (1933).

⬩"⬩"⬩ General semantics is not any kind of 'philosophy', 'psychology', or 'logic'. It is a new extensional discipline through which we explain and learn how to apply our nervous systems most effectively. ⬩"⬩"⬩ - A. Korzybski ⬩"⬩"⬩ In general semantics, we do not 'preach' 'morality' or 'ethics' per se, but teach students awareness of abstraction, awareness of multi-order evaluation mechanisms, relationship orientation, etc., which lead to cortico-thalamic integration, and as a result 'morality', 'ethics', awareness of social responsibility, etc., follow automatically. ⬩"⬩"⬩ - A. Korzybski

Alfred Korzybski was born in the late 19th century into a noble family living in the Russian-occupied part of politically divided Poland. "I was born silent," he wrote - an observer looking around with an interest in what was happening. From an early age, he realized his calling to "solve problems." His father, an engineer by profession, fostered in him a respect for math and physics, and their practical applications. (Alfred later studied engineering himself.) He grew up a Polish patriot under the oppression of the Tsarist dictatorship. While serving in Russian army intelligence, he witnessed the horrors of World War I on the eastern front. By then, having moved to North America, he had witnessed the reckless behavior of people (including himself) for half his life. "I was simply tired of human stupidity. I didn't care about anything else."

Korzybski spent the rest of his days in a purposeful search and attempt to realize his life's dream - to promote harmony among people by understanding and solving the problems of human stupidity (preventable inadequate evaluation) and its consequences. What is it that human beings possess that makes them make tremendous progress in some areas (math, science, applied technology), but come to such a decline in others? Could we find a way to prevent at least some of the human ills and societal problems that Korzybski has seen? Would we have been able to update our maps (both in the narrow and broad sense of the term), including maps of ourselves, to avoid unnecessary misunderstandings and conflicts between people in society? Experience convinced him that people should develop their thinking abilities (which for Korzybski did not exist separately from their emotional life). He was troubled by the lack of a way to help thinking in a purposeful and systematic way. ("Where are we taught how to think? Nowhere.") His knowledge of science and mathematics also convinced him to try to develop a method of thinking for everyday life based on these disciplines. Korzybski conducted research on the 'strange' hypothesis - unconscious factors of personal and social adaptation (sanity) are realized in the professional behavior - including language - of scientists and mathematicians. He also realized that scientists and mathematicians do not always understand these factors and apply them to their advantage both in their laboratories and in their daily lives. His search led him not only to investigate the behavior of scientists and mathematicians, but also the behavior of psychiatric patients. By linking these elements - science and sanity - Korzybski was able to adopt a unique perspective. For an engineer, such a strongly abstract theory was not enough. He wanted it to have a practical aspect. Without such an approach, as he jokingly noted - "We can lead a horse to a watering hole, but we can't make him drink. We can send a young man to college, but we won't teach him the ways of thinking. Why? Because there is not enough method."

He called the practical theory - the method formulated - "general semantics." It is suitable for application to the most profound personal problems as well as to the most sublime philosophical and scientific ones. Having formulated this theory, he devoted his life to its further development and to testing its workability. He was primarily interested in helping individuals, whom he called Smith1, Smith2, Smith3, etc. He considered himself to be one of the Smiths - perhaps Smithomp - and the primary "guinea pig" for testing his methods. This activity made him acquainted with at least a couple thousand 'Smiths' whom he trained in his methodology and its application. (Korzybski trained 1800 people at the Institute of General Semantics from 1938 onwards, and had taught classes for several years before that.) By the time of his death, he was able to allow himself the confidence that his system worked - for those who wanted to work with it. Half a century has passed since then, and there is still a lively interest in Korzybski's work. Critics have called his work "highly questionable." Some saw it as a useful activity for society, others considered it a significant contribution to human civilization. In these early years of the new millennium - a time of seemingly omnipresent terrorism, personal misfortune, problems of adaptation, and various social clashes - the life and work of Alfred Korzybski deserves attention. 

On the development of his work since his death, Charlot Reed wrote in 1988 - Many of the principles [of general semantics] have indeed permeated our culture, whether people knew they came from Korzybski and other pioneers or not. We are, so to speak, "catching up" on everything we missed in the 1933 formulations...Given the growing worldwide awakening, the search for ways to cope, the growing population, and the bigger dangers, I realize that what he suggested in the formulations of fifty years ago is now even more needed. In 2010 (2024) we still need what Korzybski started.
