# How to contribute #

## Reporting issues ##

We use the [GitHub issue tracker](https://github.com/google/ExoPlayer/issues)
to track bugs, feature requests and questions.

Before filing a new issue, please search the tracker to check if it's already
covered by an existing report. Avoiding duplicates helps us maximize the time we
can spend fixing bugs and adding new features.

When filing an issue, be sure to provide enough information for us to
efficiently diagnose and reproduce the problem. In particular, please include
all of the information requested in the issue template.

## Pull requests ##

We will also consider high quality pull requests. These should normally merge
into the `dev-v2` branch. Before a pull request can be accepted you must submit
a Contributor License Agreement, as described below.

[dev]: https://github.com/google/ExoPlayer/tree/dev

## Contributor license agreement ##

Contributions to any Google project must be accompanied by a Contributor
License Agreement. This is not a copyright **assignment**, it simply gives
Google permission to use and redistribute your contributions as part of the
project.

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an [individual
    CLA][].

  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a [corporate CLA][].

You generally only need to submit a CLA once, so if you've already submitted
one (even if it was for a different project), you probably don't need to do it
again.

[individual CLA]: https://developers.google.com/open-source/cla/individual
[corporate CLA]: https://developers.google.com/open-source/cla/corporate
