import { MetadataOptions, PlayerOptions, Event, Track, State, TrackMetadataBase, NowPlayingMetadata, RepeatMode } from './interfaces';
declare function setupPlayer(options?: PlayerOptions): Promise<void>;
declare function destroy(): any;
declare type ServiceHandler = () => Promise<void>;
declare function registerPlaybackService(factory: () => ServiceHandler): void;
declare function addEventListener(event: Event, listener: (data: any) => void): import("react-native").EmitterSubscription;
declare function add(tracks: Track | Track[], insertBeforeIndex?: number): Promise<void>;
declare function remove(tracks: number | number[]): Promise<void>;
declare function removeUpcomingTracks(): Promise<void>;
declare function skip(trackIndex: number): Promise<void>;
declare function skipToNext(): Promise<void>;
declare function skipToPrevious(): Promise<void>;
declare function updateOptions(options?: MetadataOptions): Promise<void>;
declare function updateMetadataForTrack(trackIndex: number, metadata: TrackMetadataBase): Promise<void>;
declare function clearNowPlayingMetadata(): Promise<void>;
declare function updateNowPlayingMetadata(metadata: NowPlayingMetadata): Promise<void>;
declare function reset(): Promise<void>;
declare function play(): Promise<void>;
declare function pause(): Promise<void>;
declare function stop(): Promise<void>;
declare function seekTo(position: number): Promise<void>;
declare function setVolume(level: number): Promise<void>;
declare function setRate(rate: number): Promise<void>;
declare function setRepeatMode(mode: RepeatMode): Promise<RepeatMode>;
declare function getVolume(): Promise<number>;
declare function getRate(): Promise<number>;
declare function getTrack(trackIndex: number): Promise<Track>;
declare function getQueue(): Promise<Track[]>;
declare function getCurrentTrack(): Promise<number>;
declare function getDuration(): Promise<number>;
declare function getBufferedPosition(): Promise<number>;
declare function getPosition(): Promise<number>;
declare function getState(): Promise<State>;
declare function getRepeatMode(): Promise<RepeatMode>;
export * from './hooks';
export * from './interfaces';
declare const _default: {
    setupPlayer: typeof setupPlayer;
    destroy: typeof destroy;
    registerPlaybackService: typeof registerPlaybackService;
    addEventListener: typeof addEventListener;
    add: typeof add;
    remove: typeof remove;
    removeUpcomingTracks: typeof removeUpcomingTracks;
    skip: typeof skip;
    skipToNext: typeof skipToNext;
    skipToPrevious: typeof skipToPrevious;
    updateOptions: typeof updateOptions;
    updateMetadataForTrack: typeof updateMetadataForTrack;
    clearNowPlayingMetadata: typeof clearNowPlayingMetadata;
    updateNowPlayingMetadata: typeof updateNowPlayingMetadata;
    reset: typeof reset;
    play: typeof play;
    pause: typeof pause;
    stop: typeof stop;
    seekTo: typeof seekTo;
    setVolume: typeof setVolume;
    setRate: typeof setRate;
    setRepeatMode: typeof setRepeatMode;
    getVolume: typeof getVolume;
    getRate: typeof getRate;
    getTrack: typeof getTrack;
    getQueue: typeof getQueue;
    getCurrentTrack: typeof getCurrentTrack;
    getDuration: typeof getDuration;
    getBufferedPosition: typeof getBufferedPosition;
    getPosition: typeof getPosition;
    getState: typeof getState;
    getRepeatMode: typeof getRepeatMode;
};
export default _default;
