import type { cache } from './cache';
export interface AndroidImageColors {
    dominant?: string;
    average?: string;
    vibrant?: string;
    darkVibrant?: string;
    lightVibrant?: string;
    darkMuted?: string;
    lightMuted?: string;
    muted?: string;
    platform: 'android';
}
export interface WebImageColors {
    dominant?: string;
    vibrant?: string;
    darkVibrant?: string;
    lightVibrant?: string;
    darkMuted?: string;
    lightMuted?: string;
    muted?: string;
    platform: 'web';
}
export interface IOSImageColors {
    background: string;
    primary: string;
    secondary: string;
    detail: string;
    quality: Config['quality'];
    platform: 'ios';
}
export interface Config {
    fallback?: string;
    pixelSpacing?: number;
    quality?: 'lowest' | 'low' | 'high' | 'highest';
    cache?: boolean;
    key?: string;
}
export declare type ImageColorsResult = AndroidImageColors | IOSImageColors | WebImageColors;
declare function GetColors<C extends Config>(url: string, config?: C): Promise<ImageColorsResult>;
export interface RNImageColorsModule {
    getColors: typeof GetColors;
    cache: typeof cache;
}
export {};
