import { Image } from 'react-native';
import { RNImageColors } from './module';
import { cache } from './cache';
const MAX_KEY_LEN = 500;

const resolveImageSource = source => {
  if (typeof source === 'string') {
    return source;
  } else {
    return Image.resolveAssetSource(source).uri;
  }
};

const getColors = async (source, config) => {
  const resolvedSrc = resolveImageSource(source);

  if (config !== null && config !== void 0 && config.cache) {
    const cachedResult = config.key ? cache.getItem(config.key) : cache.getItem(resolvedSrc);
    if (cachedResult) return cachedResult;
  }

  const result = await RNImageColors.getColors(resolvedSrc, config);

  if (config !== null && config !== void 0 && config.cache) {
    var _config$key;

    if (!config.key && resolvedSrc.length > MAX_KEY_LEN) {
      throw new Error(`You enabled caching, but you didn't pass a key. We fallback to using the image URI as the key. However the URI is longer than ${MAX_KEY_LEN}. Please pass a short unique key.`);
    }

    cache.setItem((_config$key = config.key) !== null && _config$key !== void 0 ? _config$key : resolvedSrc, result);
  }

  return result;
};

const ImageColors = {
  getColors,
  cache
};
export default ImageColors;
//# sourceMappingURL=index.js.map