"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RNImageColors = void 0;

var _nodeVibrant = _interopRequireDefault(require("node-vibrant"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getQuality = quality => {
  switch (quality) {
    case 'lowest':
      return 10;

    case 'low':
      return 5;

    case 'high':
      return 1.333;

    case 'highest':
      return 1;

    default:
      return getQuality('low');
  }
};

const getDominantSwatch = palette => {
  let dominant = palette[0];
  let highestPopulation = -1;
  const keys = Object.keys(palette);

  for (let index = 0; index < keys.length; index++) {
    const key = keys[index];
    const swatch = palette[key];

    if (swatch && (swatch === null || swatch === void 0 ? void 0 : swatch.population) > highestPopulation) {
      dominant = swatch;
    }
  }

  return dominant;
};

const RNImageColors = {
  getColors: async (src, config) => {
    var _getDominantSwatch$he, _getDominantSwatch, _palette$Vibrant$hex, _palette$Vibrant, _palette$DarkVibrant$, _palette$DarkVibrant, _palette$LightVibrant, _palette$LightVibrant2, _palette$DarkMuted$he, _palette$DarkMuted, _palette$LightMuted$h, _palette$LightMuted, _palette$Muted$hex, _palette$Muted;

    const {
      fallback
    } = config;
    let img = new Image();
    img.src = src;
    img.crossOrigin = 'Anonymous';
    const vibrant = new _nodeVibrant.default(img, {
      useWorker: true,
      quality: getQuality(config.quality)
    });
    const palette = await vibrant.getPalette();
    return {
      dominant: (_getDominantSwatch$he = (_getDominantSwatch = getDominantSwatch(palette)) === null || _getDominantSwatch === void 0 ? void 0 : _getDominantSwatch.hex) !== null && _getDominantSwatch$he !== void 0 ? _getDominantSwatch$he : fallback,
      vibrant: (_palette$Vibrant$hex = (_palette$Vibrant = palette.Vibrant) === null || _palette$Vibrant === void 0 ? void 0 : _palette$Vibrant.hex) !== null && _palette$Vibrant$hex !== void 0 ? _palette$Vibrant$hex : fallback,
      darkVibrant: (_palette$DarkVibrant$ = (_palette$DarkVibrant = palette.DarkVibrant) === null || _palette$DarkVibrant === void 0 ? void 0 : _palette$DarkVibrant.hex) !== null && _palette$DarkVibrant$ !== void 0 ? _palette$DarkVibrant$ : fallback,
      lightVibrant: (_palette$LightVibrant = (_palette$LightVibrant2 = palette.LightVibrant) === null || _palette$LightVibrant2 === void 0 ? void 0 : _palette$LightVibrant2.hex) !== null && _palette$LightVibrant !== void 0 ? _palette$LightVibrant : fallback,
      darkMuted: (_palette$DarkMuted$he = (_palette$DarkMuted = palette.DarkMuted) === null || _palette$DarkMuted === void 0 ? void 0 : _palette$DarkMuted.hex) !== null && _palette$DarkMuted$he !== void 0 ? _palette$DarkMuted$he : fallback,
      lightMuted: (_palette$LightMuted$h = (_palette$LightMuted = palette.LightMuted) === null || _palette$LightMuted === void 0 ? void 0 : _palette$LightMuted.hex) !== null && _palette$LightMuted$h !== void 0 ? _palette$LightMuted$h : fallback,
      muted: (_palette$Muted$hex = (_palette$Muted = palette.Muted) === null || _palette$Muted === void 0 ? void 0 : _palette$Muted.hex) !== null && _palette$Muted$hex !== void 0 ? _palette$Muted$hex : fallback,
      platform: 'web'
    };
  }
};
exports.RNImageColors = RNImageColors;
//# sourceMappingURL=module.web.js.map