"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cache = void 0;
let storage = {};

const getItem = key => {
  return storage[key];
};

const setItem = (key, value) => {
  storage[key] = value;
};

const removeItem = key => {
  return delete storage[key];
};

const clear = () => {
  storage = {};
  return true;
};

const cache = {
  getItem,
  setItem,
  removeItem,
  clear
};
exports.cache = cache;
//# sourceMappingURL=cache.js.map