import React from 'react';
import { GestureType, HandlerCallbacks } from './gesture';
import { SharedValue } from './reanimatedWrapper';
import { ComposedGesture } from './gestureComposition';
declare global {
    function isFormsStackingContext(node: unknown): boolean | null;
}
export declare type GestureConfigReference = {
    config: GestureType[];
    animatedEventHandler: unknown;
    animatedHandlers: SharedValue<HandlerCallbacks<Record<string, unknown>>[] | null> | null;
    firstExecution: boolean;
    useReanimatedHook: boolean;
};
interface GestureDetectorProps {
    gesture?: ComposedGesture | GestureType;
}
export declare const GestureDetector: React.FunctionComponent<GestureDetectorProps>;
export {};
