/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
'use strict';

function extendsForProp(prop, types) {
  if (!prop.argument) {
    console.log('null', prop);
  }

  const name = prop.argument.id.name;

  if (types[name] != null) {
    // This type is locally defined in the file
    return null;
  }

  switch (name) {
    case 'ViewProps':
      return {
        type: 'ReactNativeBuiltInType',
        knownTypeName: 'ReactNativeCoreViewProps',
      };

    default: {
      throw new Error(`Unable to handle prop spread: ${name}`);
    }
  }
}

function removeKnownExtends(typeDefinition, types) {
  return typeDefinition.filter(
    prop =>
      prop.type !== 'ObjectTypeSpreadProperty' ||
      extendsForProp(prop, types) === null,
  );
} // $FlowFixMe[unclear-type] there's no flowtype for ASTs

function getExtendsProps(typeDefinition, types) {
  return typeDefinition
    .filter(prop => prop.type === 'ObjectTypeSpreadProperty')
    .map(prop => extendsForProp(prop, types))
    .filter(Boolean);
}

module.exports = {
  getExtendsProps,
  removeKnownExtends,
};
