/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
'use strict';

// File path -> contents
const template = `
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * ${'@'}generated by codegen project: GenerateShadowNodeCpp.js
 */

#include <react/renderer/components/::_LIBRARY_::/ShadowNodes.h>

namespace facebook {
namespace react {

::_COMPONENT_NAMES_::

} // namespace react
} // namespace facebook
`;
const componentTemplate = `
extern const char ::_CLASSNAME_::ComponentName[] = "::_CLASSNAME_::";
`.trim();
module.exports = {
  generate(libraryName, schema, packageName, assumeNonnull = false) {
    const fileName = 'ShadowNodes.cpp';
    const componentNames = Object.keys(schema.modules)
      .map(moduleName => {
        const module = schema.modules[moduleName];

        if (module.type !== 'Component') {
          return;
        }

        const components = module.components; // No components in this module

        if (components == null) {
          return null;
        }

        return Object.keys(components)
          .map(componentName => {
            if (components[componentName].interfaceOnly === true) {
              return;
            }

            const replacedTemplate = componentTemplate.replace(
              /::_CLASSNAME_::/g,
              componentName,
            );
            return replacedTemplate;
          })
          .join('\n');
      })
      .filter(Boolean)
      .join('\n');
    const replacedTemplate = template
      .replace(/::_COMPONENT_NAMES_::/g, componentNames)
      .replace('::_LIBRARY_::', libraryName);
    return new Map([[fileName, replacedTemplate]]);
  },
};
