/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */
'use strict';

var HERMES_AST_VISITOR_KEYS = {};
var NODE_CHILD = 'Node';
var NODE_LIST_CHILD = 'NodeList';
HERMES_AST_VISITOR_KEYS['Empty'] = {};
HERMES_AST_VISITOR_KEYS['Metadata'] = {};
HERMES_AST_VISITOR_KEYS['Program'] = {
  body: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['FunctionExpression'] = {
  id: NODE_CHILD,
  params: NODE_LIST_CHILD,
  body: NODE_CHILD,
  typeParameters: NODE_CHILD,
  returnType: NODE_CHILD,
  predicate: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ArrowFunctionExpression'] = {
  id: NODE_CHILD,
  params: NODE_LIST_CHILD,
  body: NODE_CHILD,
  typeParameters: NODE_CHILD,
  returnType: NODE_CHILD,
  predicate: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['FunctionDeclaration'] = {
  id: NODE_CHILD,
  params: NODE_LIST_CHILD,
  body: NODE_CHILD,
  typeParameters: NODE_CHILD,
  returnType: NODE_CHILD,
  predicate: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['WhileStatement'] = {
  body: NODE_CHILD,
  test: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DoWhileStatement'] = {
  body: NODE_CHILD,
  test: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ForInStatement'] = {
  left: NODE_CHILD,
  right: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ForOfStatement'] = {
  left: NODE_CHILD,
  right: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ForStatement'] = {
  init: NODE_CHILD,
  test: NODE_CHILD,
  update: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DebuggerStatement'] = {};
HERMES_AST_VISITOR_KEYS['EmptyStatement'] = {};
HERMES_AST_VISITOR_KEYS['BlockStatement'] = {
  body: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['BreakStatement'] = {
  label: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ContinueStatement'] = {
  label: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ThrowStatement'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ReturnStatement'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['WithStatement'] = {
  object: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['SwitchStatement'] = {
  discriminant: NODE_CHILD,
  cases: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['LabeledStatement'] = {
  label: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExpressionStatement'] = {
  expression: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TryStatement'] = {
  block: NODE_CHILD,
  handler: NODE_CHILD,
  finalizer: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['IfStatement'] = {
  test: NODE_CHILD,
  consequent: NODE_CHILD,
  alternate: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['NullLiteral'] = {};
HERMES_AST_VISITOR_KEYS['BooleanLiteral'] = {};
HERMES_AST_VISITOR_KEYS['StringLiteral'] = {};
HERMES_AST_VISITOR_KEYS['NumericLiteral'] = {};
HERMES_AST_VISITOR_KEYS['RegExpLiteral'] = {};
HERMES_AST_VISITOR_KEYS['ThisExpression'] = {};
HERMES_AST_VISITOR_KEYS['Super'] = {};
HERMES_AST_VISITOR_KEYS['SequenceExpression'] = {
  expressions: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectExpression'] = {
  properties: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ArrayExpression'] = {
  elements: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['SpreadElement'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['NewExpression'] = {
  callee: NODE_CHILD,
  typeArguments: NODE_CHILD,
  arguments: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['YieldExpression'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['AwaitExpression'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportExpression'] = {
  source: NODE_CHILD,
  attributes: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['CallExpression'] = {
  callee: NODE_CHILD,
  typeArguments: NODE_CHILD,
  arguments: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['OptionalCallExpression'] = {
  callee: NODE_CHILD,
  typeArguments: NODE_CHILD,
  arguments: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['AssignmentExpression'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['UnaryExpression'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['UpdateExpression'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['MemberExpression'] = {
  object: NODE_CHILD,
  property: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['OptionalMemberExpression'] = {
  object: NODE_CHILD,
  property: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['LogicalExpression'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ConditionalExpression'] = {
  test: NODE_CHILD,
  alternate: NODE_CHILD,
  consequent: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['BinaryExpression'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['Directive'] = {
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DirectiveLiteral'] = {};
HERMES_AST_VISITOR_KEYS['Identifier'] = {
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['PrivateName'] = {
  id: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['MetaProperty'] = {
  meta: NODE_CHILD,
  property: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['SwitchCase'] = {
  test: NODE_CHILD,
  consequent: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['CatchClause'] = {
  param: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['VariableDeclarator'] = {
  init: NODE_CHILD,
  id: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['VariableDeclaration'] = {
  declarations: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TemplateLiteral'] = {
  quasis: NODE_LIST_CHILD,
  expressions: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TaggedTemplateExpression'] = {
  tag: NODE_CHILD,
  quasi: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TemplateElement'] = {};
HERMES_AST_VISITOR_KEYS['Property'] = {
  key: NODE_CHILD,
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassDeclaration'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  superClass: NODE_CHILD,
  superTypeParameters: NODE_CHILD,
  "implements": NODE_LIST_CHILD,
  decorators: NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassExpression'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  superClass: NODE_CHILD,
  superTypeParameters: NODE_CHILD,
  "implements": NODE_LIST_CHILD,
  decorators: NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassBody'] = {
  body: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassProperty'] = {
  key: NODE_CHILD,
  value: NODE_CHILD,
  variance: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassPrivateProperty'] = {
  key: NODE_CHILD,
  value: NODE_CHILD,
  variance: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['MethodDefinition'] = {
  key: NODE_CHILD,
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportDeclaration'] = {
  specifiers: NODE_LIST_CHILD,
  source: NODE_CHILD,
  attributes: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportSpecifier'] = {
  imported: NODE_CHILD,
  local: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportDefaultSpecifier'] = {
  local: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportNamespaceSpecifier'] = {
  local: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ImportAttribute'] = {
  key: NODE_CHILD,
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExportNamedDeclaration'] = {
  declaration: NODE_CHILD,
  specifiers: NODE_LIST_CHILD,
  source: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExportSpecifier'] = {
  exported: NODE_CHILD,
  local: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExportNamespaceSpecifier'] = {
  exported: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExportDefaultDeclaration'] = {
  declaration: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ExportAllDeclaration'] = {
  source: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectPattern'] = {
  properties: NODE_LIST_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ArrayPattern'] = {
  elements: NODE_LIST_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['RestElement'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['AssignmentPattern'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXIdentifier'] = {};
HERMES_AST_VISITOR_KEYS['JSXMemberExpression'] = {
  object: NODE_CHILD,
  property: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXNamespacedName'] = {
  namespace: NODE_CHILD,
  name: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXEmptyExpression'] = {};
HERMES_AST_VISITOR_KEYS['JSXExpressionContainer'] = {
  expression: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXSpreadChild'] = {
  expression: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXOpeningElement'] = {
  name: NODE_CHILD,
  attributes: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXClosingElement'] = {
  name: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXAttribute'] = {
  name: NODE_CHILD,
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXSpreadAttribute'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXText'] = {};
HERMES_AST_VISITOR_KEYS['JSXElement'] = {
  openingElement: NODE_CHILD,
  children: NODE_LIST_CHILD,
  closingElement: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXFragment'] = {
  openingFragment: NODE_CHILD,
  children: NODE_LIST_CHILD,
  closingFragment: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['JSXOpeningFragment'] = {};
HERMES_AST_VISITOR_KEYS['JSXClosingFragment'] = {};
HERMES_AST_VISITOR_KEYS['ExistsTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['EmptyTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['StringTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['NumberTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['StringLiteralTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['NumberLiteralTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['BooleanTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['BooleanLiteralTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['NullLiteralTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['SymbolTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['AnyTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['MixedTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['VoidTypeAnnotation'] = {};
HERMES_AST_VISITOR_KEYS['FunctionTypeAnnotation'] = {
  params: NODE_LIST_CHILD,
  "this": NODE_CHILD,
  returnType: NODE_CHILD,
  rest: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['FunctionTypeParam'] = {
  name: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['NullableTypeAnnotation'] = {
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['QualifiedTypeIdentifier'] = {
  qualification: NODE_CHILD,
  id: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeofTypeAnnotation'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TupleTypeAnnotation'] = {
  types: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ArrayTypeAnnotation'] = {
  elementType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['UnionTypeAnnotation'] = {
  types: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['IntersectionTypeAnnotation'] = {
  types: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['GenericTypeAnnotation'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['IndexedAccessType'] = {
  objectType: NODE_CHILD,
  indexType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['OptionalIndexedAccessType'] = {
  objectType: NODE_CHILD,
  indexType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['InterfaceTypeAnnotation'] = {
  "extends": NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeAlias'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['OpaqueType'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  impltype: NODE_CHILD,
  supertype: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['InterfaceDeclaration'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  "extends": NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareTypeAlias'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareOpaqueType'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  impltype: NODE_CHILD,
  supertype: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareInterface'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  "extends": NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareClass'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  "extends": NODE_LIST_CHILD,
  "implements": NODE_LIST_CHILD,
  mixins: NODE_LIST_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareFunction'] = {
  id: NODE_CHILD,
  predicate: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareVariable'] = {
  id: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareExportDeclaration'] = {
  declaration: NODE_CHILD,
  specifiers: NODE_LIST_CHILD,
  source: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareExportAllDeclaration'] = {
  source: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareModule'] = {
  id: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['DeclareModuleExports'] = {
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['InterfaceExtends'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ClassImplements'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeAnnotation'] = {
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeAnnotation'] = {
  properties: NODE_LIST_CHILD,
  indexers: NODE_LIST_CHILD,
  callProperties: NODE_LIST_CHILD,
  internalSlots: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeProperty'] = {
  key: NODE_CHILD,
  value: NODE_CHILD,
  variance: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeSpreadProperty'] = {
  argument: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeInternalSlot'] = {
  id: NODE_CHILD,
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeCallProperty'] = {
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['ObjectTypeIndexer'] = {
  id: NODE_CHILD,
  key: NODE_CHILD,
  value: NODE_CHILD,
  variance: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['Variance'] = {};
HERMES_AST_VISITOR_KEYS['TypeParameterDeclaration'] = {
  params: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeParameter'] = {
  bound: NODE_CHILD,
  variance: NODE_CHILD,
  "default": NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeParameterInstantiation'] = {
  params: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TypeCastExpression'] = {
  expression: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['InferredPredicate'] = {};
HERMES_AST_VISITOR_KEYS['DeclaredPredicate'] = {
  value: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumDeclaration'] = {
  id: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumStringBody'] = {
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumNumberBody'] = {
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumBooleanBody'] = {
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumSymbolBody'] = {
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumDefaultedMember'] = {
  id: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumStringMember'] = {
  id: NODE_CHILD,
  init: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumNumberMember'] = {
  id: NODE_CHILD,
  init: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['EnumBooleanMember'] = {
  id: NODE_CHILD,
  init: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeAnnotation'] = {
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSAnyKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSNumberKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSBooleanKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSStringKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSSymbolKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSVoidKeyword'] = {};
HERMES_AST_VISITOR_KEYS['TSThisType'] = {};
HERMES_AST_VISITOR_KEYS['TSLiteralType'] = {
  literal: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSIndexedAccessType'] = {
  objectType: NODE_CHILD,
  indexType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSArrayType'] = {
  elementType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeReference'] = {
  typeName: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSQualifiedName'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSFunctionType'] = {
  params: NODE_LIST_CHILD,
  returnType: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSConstructorType'] = {
  params: NODE_LIST_CHILD,
  returnType: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypePredicate'] = {
  parameterName: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTupleType'] = {
  elementTypes: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeAssertion'] = {
  typeAnnotation: NODE_CHILD,
  expression: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSAsExpression'] = {
  expression: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSParameterProperty'] = {
  parameter: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeAliasDeclaration'] = {
  id: NODE_CHILD,
  typeParameters: NODE_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSInterfaceDeclaration'] = {
  id: NODE_CHILD,
  body: NODE_CHILD,
  "extends": NODE_LIST_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSInterfaceHeritage'] = {
  expression: NODE_CHILD,
  typeParameters: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSInterfaceBody'] = {
  body: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSEnumDeclaration'] = {
  id: NODE_CHILD,
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSEnumMember'] = {
  id: NODE_CHILD,
  initializer: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSModuleDeclaration'] = {
  id: NODE_CHILD,
  body: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSModuleBlock'] = {
  body: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSModuleMember'] = {
  id: NODE_CHILD,
  initializer: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeParameterDeclaration'] = {
  params: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeParameter'] = {
  name: NODE_CHILD,
  constraint: NODE_CHILD,
  "default": NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeParameterInstantiation'] = {
  params: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSUnionType'] = {
  types: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSIntersectionType'] = {
  types: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeQuery'] = {
  exprName: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSConditionalType'] = {
  extendsType: NODE_CHILD,
  checkType: NODE_CHILD,
  trueType: NODE_CHILD,
  falseTYpe: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSTypeLiteral'] = {
  members: NODE_LIST_CHILD
};
HERMES_AST_VISITOR_KEYS['TSPropertySignature'] = {
  key: NODE_CHILD,
  typeAnnotation: NODE_CHILD,
  initializer: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSMethodSignature'] = {
  key: NODE_CHILD,
  params: NODE_LIST_CHILD,
  returnType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSIndexSignature'] = {
  parameters: NODE_LIST_CHILD,
  typeAnnotation: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['TSCallSignatureDeclaration'] = {
  params: NODE_LIST_CHILD,
  returnType: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['CoverEmptyArgs'] = {};
HERMES_AST_VISITOR_KEYS['CoverTrailingComma'] = {};
HERMES_AST_VISITOR_KEYS['CoverInitializer'] = {
  init: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['CoverRestElement'] = {
  rest: NODE_CHILD
};
HERMES_AST_VISITOR_KEYS['CoverTypedIdentifier'] = {
  left: NODE_CHILD,
  right: NODE_CHILD
};
module.exports = {
  HERMES_AST_VISITOR_KEYS: HERMES_AST_VISITOR_KEYS,
  NODE_CHILD: NODE_CHILD,
  NODE_LIST_CHILD: NODE_LIST_CHILD
};