/// <reference types="react" />
import type { Route, ParamListBase, NavigationState, PartialState } from '@react-navigation/routers';
import type { NavigationProp, RouteConfig, EventMapBase } from './types';
declare type Props<State extends NavigationState, ScreenOptions extends {}, EventMap extends EventMapBase> = {
    screen: RouteConfig<ParamListBase, string, State, ScreenOptions, EventMap>;
    navigation: NavigationProp<ParamListBase, string, State, ScreenOptions>;
    route: Route<string>;
    routeState: NavigationState | PartialState<NavigationState> | undefined;
    getState: () => State;
    setState: (state: State) => void;
    options: object;
    clearOptions: () => void;
};
/**
 * Component which takes care of rendering the screen for a route.
 * It provides all required contexts and applies optimizations when applicable.
 */
export default function SceneView<State extends NavigationState, ScreenOptions extends {}, EventMap extends EventMapBase>({ screen, route, navigation, routeState, getState, setState, options, clearOptions, }: Props<State, ScreenOptions, EventMap>): JSX.Element;
export {};
