---
layout: page
title: General
---

<style>
    tab1 { padding-left: 4em; }
</style>

<h2>📚 General</h2>

<p style="text-align: justify;">
    <strong>Package Manager</strong> is a powerful, open-source Android app designed to help users manage system and user-installed apps with ease. It’s completely free and available for download via
    Google Play (<a href="https://play.google.com/store/apps/details?id=com.smartpack.packagemanager" target="_blank">Free</a> and <a href="https://play.google.com/store/apps/details?id=com.smartpack.packagemanager.pro" target="_blank">Pro</a>)
    or
    <a href="https://f-droid.org/packages/com.smartpack.packagemanager" target="_blank">F-Droid</a>.
    <br/><br/>
    This documentation is intended to help users make the most of both the basic features and advanced capabilities offered by the app.
</p>

<hr />

<h3>⚙️ Requirements</h3>

<p style="text-align: justify;">
    Before diving into the documentation, please note a few important requirements to fully utilize the features of Package Manager:
</p>

<ul>
    <li><strong>Root Access:</strong> While Package Manager works without root, certain advanced functions (like uninstalling system apps or enabling/disabling them) require root access. Due to Android's security model, apps without root are limited in their ability to manage system-level features.</li>

    <li><strong>Rooting Notice:</strong> Rooting provides more control over your device, but may void your warranty and is restricted by some OEMs. If you're interested in learning more, check out <a href="https://smartpack.github.io/android-rooting/" target="_blank">this article</a> or other trusted resources online.</li>

    <li><strong>Using Shizuku:</strong> As an alternative to root, enabling the <a href="https://shizuku.rikka.app/guide/setup/" target="_blank">Shizuku API</a> allows Package Manager to access some advanced features that normally require root access. It’s a safe and powerful bridge between system APIs and apps.</li>
</ul>

<hr />

<h3>📂 Documentation Categories</h3>

<p style="text-align: justify;">
    The documentation is organized into the following sections:
</p>

<ol>
    <li><a href="{{ site.github.url }}/ui/" target="_self">🖥️ User Interface</a></li>
    <li><a href="{{ site.github.url }}/batch/" target="_self">🗂️ Batch Options</a></li>
    <li><a href="{{ site.github.url }}/sai/" target="_self">📦 Installer (Split APKs)</a></li>
    <li><a href="{{ site.github.url }}/exports/" target="_self">📤 Exported Apps</a></li>
    <li><a href="{{ site.github.url }}/settings/" target="_self">⚙️ Settings</a></li>
</ol>

<hr />

<h3>🙏 A Note of Thanks</h3>

<p style="text-align: justify;">
    We — the <a href="https://play.google.com/store/apps/dev?id=5836199813143882901" target="_blank">developer</a>, translators, and all contributors — sincerely thank you for using <strong>Package Manager</strong>. Your support helps us keep this project alive and evolving!
</p>
