# 📦 Package Manager

<p style="text-align: center"><img src="https://raw.githubusercontent.com/SmartPack/PackageManager/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" alt="" width="250" height="450" /> <img src="https://raw.githubusercontent.com/SmartPack/PackageManager/master/fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" alt="" width="250" height="450" /> <img src="https://raw.githubusercontent.com/SmartPack/PackageManager/master/fastlane/metadata/android/en-US/images/phoneScreenshots/7.jpg" alt="" width="250" height="450" /></p>

[![](https://img.shields.io/badge/Package%20Manager-v7.6-green)](https://play.google.com/store/apps/details?id=com.smartpack.packagemanager.pro)
![](https://img.shields.io/github/languages/top/SmartPack/PackageManager)
![](https://img.shields.io/github/contributors/smartpack/PackageManager)
![](https://img.shields.io/github/license/smartpack/PackageManager)

A simple yet powerful Android app for managing both **system** and **user** applications — free, ad-free, and open source.

---
## 📥 Download

| Platform              | Link                                                                                                                    |
|-----------------------|-------------------------------------------------------------------------------------------------------------------------|
| 🟢 Google Play (Pro)  | [Download Pro version from Google Play](https://play.google.com/store/apps/details?id=com.smartpack.packagemanager.pro) |
| 🟢 Google Play (free) | [Download free version from Google Play](https://play.google.com/store/apps/details?id=com.smartpack.packagemanager)    |
| 🔵 F-Droid            | [Download from F-Droid](https://f-droid.org/packages/com.smartpack.packagemanager)                                      |

---

## 📱 Requirements

- 📲 Android device
- 🔓 **Root access** or **Shizuku integration** required for some advanced features  

---

## ✨ Features

- 🔹 Clean UI with separate views for **System** and **User** apps
- 🔹 Rich app details:
    - 📦 Package & app names
    - 🗂️ APK path (.apk/.apks/.apkm/.xapk)
    - 🔐 Permissions (granted/denied)
    - 📋 App manifest & certificate info
    - 🕒 Install/update dates
    - 📁 Data & native library paths
- 🔹 Common actions:
    - 🚀 Launch apps
    - 🛒 Open Play Store links
    - 🗑️ Uninstall (for user apps)
- 🔹 Advanced features:
    - 📦 Install app bundles / split APKs
    - 🔍 Explore APK contents (experimental)
    - 📤 Export apps (single or batch)
    - 🧹 Debloat (uninstall system apps) - requires root or Shizuku
    - 🚫 Disable/enable any app - requires root or Shizuku

---

## 💖 Support This Project
Maintaining this project takes time and dedication. If you'd like to help keep it alive:

### ☕ Donate


[<img src="https://raw.githubusercontent.com/SmartPack/SmartPack.github.io/master/assets/pic014.png"
alt=""
height="50">](https://github.com/sponsors/sunilpaulmathew)
[<img src="https://liberapay.com/assets/widgets/donate.svg"
alt=""
height="50">](https://liberapay.com/sunilpaulmathew/donate)
[<img src="https://raw.githubusercontent.com/SmartPack/SmartPack.github.io/master/assets/pic005.png"
alt=""
height="50">](https://www.paypal.me/menacherry/)
[<img src="https://raw.githubusercontent.com/SmartPack/SmartPack.github.io/master/assets/pic010.png"
alt=""
height="50">](https://ko-fi.com/sunilpaulmathew/)

---

## 🙌 Other Ways to Support

- ⭐ Leave a review or rating on [Google Play](https://play.google.com/store/apps/details?id=com.smartpack.packagemanager) — it's free and helps visibility!
- 🌐 Contribute to [translations](https://poeditor.com/join/project?hash=0CitpyI1Oc)
- 📢 Spread the word — share with friends, forums, or on social media

---

## 🌍 Translations

Help translate the app into more languages:

- 📝 [Join the POEditor project](https://poeditor.com/join/project?hash=0CitpyI1Oc)
- 📄 Or edit the [strings.xml](app/src/main/res/values/strings.xml) directly

---

## 👥 Contributors
See all [contributors](https://github.com/SmartPack/PackageManager/graphs/contributors) who helped build this project.

---

## License

    Copyright (C) 2020-2025 sunilpaulmathew <sunil.kde@gmail.com>

    Package Manager is a free softwares: you can redistribute it and/or
    modify it under the terms of the GNU General Public License as published
    by the Free Software Foundation, either version 3 of the License, or (at
    your option) any later version.

    Package Manager is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License along
    with Package Manager. If not, see <http://www.gnu.org/licenses/>.

---

Thank you for using Package Manager!