---
layout: page
title: Installer
---

<style>
    tab1 { padding-left: 4em; }
</style>

<h2 style="color: blue">⚙️ Installer</h2>

<p style="text-align: justify;">
    <tab1>
        Package Manager includes a powerful installer capable of handling APKs, Split APKs, and app bundles with ease.  
        This feature enables the installation of individual APKs, split APKs (multiple APKs sharing the same package ID and signature), and popular app bundle formats like <b>xapk</b>, <b>apkm</b>, and <b>apks</b>.  
        Since Google encourages distributing app bundles over traditional APKs, and few apps allow direct bundle installation, this is a significant advantage for Package Manager users.
    </tab1>
</p>

<p style="text-align: center;">
    <img src="https://raw.githubusercontent.com/SmartPack/PackageManager/master/fastlane/metadata/android/en-US/images/phoneScreenshots/7.jpg" alt="Split APK Installation session" width="250" height="500" />
</p>
<p style="text-align: center;"><em>Screenshot of a Split APK installation session</em></p>

### 📂 How to Install Multiple APKs or App Bundles

<ol>
    <li>Tap the <b>plus (+)</b> button on the main screen or the <b>Exported Apps</b> page.</li>
    <li>To install an app bundle (<b>xapk</b>, <b>apkm</b>, or <b>apks</b>), simply select the file and follow the on-screen instructions.</li>
    <li>For split APK installations, ensure the following:
        <ol type="a">
            <li>All required split APK files are placed in the same folder.</li>
            <li>When prompted, select <strong>all</strong> necessary split APKs to prevent installation failures.</li>
        </ol>
    </li>
</ol>
