---
layout: default
title: Documentation
permalink: /general/
---

<style>
    tab1 { padding-left: 4em; }
</style>

## Documentation

<p style="text-align: justify;"><tab1>Package Manager is a highly powerful application to manage apps installed on an android device. The application is free and opensource, and available to download via <a href="https://play.google.com/store/apps/details?id=com.smartpack.packagemanager" target="_blank">Google Play</a> or <a href="https://f-droid.org/packages/com.smartpack.packagemanager" target="_blank">F-Droid</a>.  The sole purpose of this article is to help the users to do the basic tasks as well as the advanced features offered by this app.</tab1></p>

<p style="text-align: justify;"><tab1>Before moving to the rest of this article, we would like to mention some important requirements to completely utilize the full potential of Package Manager. Although this application is available for non-rooted android users, please be noted that the restrictions imposed by the Android ecosystem don't allow userspace applications, like Package Manager, to manage many advanced features. As a result, Package Manager has little limited capabilities in a non-rooted environment than its rooted counterpart. Although rooting is considered an illegal activity by most OEM's, the process of rooting offers a user more control over the device. Unfortunately, more detailed information about rooting and its merits/demerits are beyond the scope of this article. Moreover, gaining root access requires different methods on different devices. For those who are interested to know more, we highly recommend checking out <a href="https://smartpack.github.io/android-rooting/" target="_blank">this</a> article as well as many other resources available on the web.</tab1></p>

<p style="text-align: justify;"><tab1>On the other hand, allowing access to <b>Shizuku API</b> will help Package Manager to do much more things that are otherwise possible only with root access. More details about configuring Shizuku can be found <a href="https://shizuku.rikka.app/guide/setup/" target="_blank">here</a>.</tab1></p>


This article is organized into a few categories and are
<ol>
    <li><a href="{{ site.github.url }}/ui/">User Interface</a></li>
    <li><a href="{{ site.github.url }}/batch/">Batch Options</a></li>
    <li><a href="{{ site.github.url }}/sai/">Installer</a></li>
    <li><a href="{{ site.github.url }}/exports/">Exported Apps</a></li>
    <li><a href="{{ site.github.url }}/settings/">Settings</a></li>
    <li><a href="{{ site.github.url }}/permissions/">Permissions</a></li>
    <li><a href="{{ site.github.url }}/privacy-policy/">Privacy Policy</a></li>
    <li><a href="{{ site.github.url }}/disclaimer/">Disclaimer</a></li>
</ol>

<p style="text-align: justify;"><tab1>We, the team behind Package Manager (the <a href="https://play.google.com/store/apps/dev?id=5836199813143882901" target="_blank">developer</a>, translators and other contributors) sincerely thank you for using our app!</tab1></p>
